/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicyTypeLoader;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.jaxws.policyset.PolicyTypeFileHelper;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class WSAPolicyTypeLoader
implements PolicyTypeLoader {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSAPolicyTypeLoader.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);

    public void destroy() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "destroy");
        }
    }

    public String getType() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getType", "WSAddressing");
        }
        return "WSAddressing";
    }

    public void init(Map map) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "init");
        }
    }

    public void load(ClassLoader classLoader, VariableExpander variableExpander, InputStream inputStream, PolicySetConfiguration policySetConfiguration) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "load", new Object[]{classLoader, variableExpander, inputStream, policySetConfiguration});
        }
        String string = "unspecified";
        Properties properties = PolicyTypeFileHelper.readPolicyType(inputStream);
        if (properties != null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "load", "Getting value from Properties object");
            }
            string = properties.getProperty("usingaddressing", "unspecified");
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "load", "Setting WSADDRESSING_FLAG value: " + string);
        }
        policySetConfiguration.setPolicyTypeConfiguration("WSADDRESSING_FLAG", string);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "load");
        }
    }
}

