/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.jaxws.policyset.jaxb.All;
import com.ibm.ws.wsaddressing.jaxws.policyset.jaxb.ExactlyOne;
import com.ibm.ws.wsaddressing.jaxws.policyset.jaxb.ObjectFactory;
import com.ibm.ws.wsaddressing.jaxws.policyset.jaxb.Policy;
import com.ibm.ws.wsaddressing.jaxws.policyset.jaxb.PreventWLM;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyTypeBndFileHelper {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(PolicyTypeBndFileHelper.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    private static final String CLASSNAME = PolicyTypeBndFileHelper.class.getCanonicalName();
    private static final String WSA_POLICY_TYPE_CONTEXT = "com.ibm.ws.wsaddressing.jaxws.policyset.jaxb";
    private static final String DEFAULT_VALUE = "false";

    static boolean writePolicyType(String string, Properties properties) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "writePolicyType", new Object[]{string, properties});
        }
        boolean bl = true;
        String string2 = DEFAULT_VALUE;
        if (properties != null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "writePolicyType", "Properties object not null. Getting value from object.");
            }
            if ((string2 = properties.getProperty("preventWLM")) == null && properties.size() > 0) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "writePolicyType", "Unrecognised attribute. Returning false");
                }
                return false;
            }
        }
        Policy policy = PolicyTypeBndFileHelper.createPolicyObjectForFlag(string2);
        try {
            final ClassLoader classLoader = PolicyTypeBndFileHelper.class.getClassLoader();
            JAXBContext jAXBContext = null;
            try {
                jAXBContext = AccessController.doPrivileged(new PrivilegedExceptionAction<JAXBContext>(){

                    @Override
                    public JAXBContext run() throws Exception {
                        return JAXBContext.newInstance(PolicyTypeBndFileHelper.WSA_POLICY_TYPE_CONTEXT, classLoader);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
            Marshaller marshaller = jAXBContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
            File file = new File(string);
            if (!file.exists() && TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "writePolicyType", "File does not exist. Will be created: " + string);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            marshaller.marshal((Object)policy, fileOutputStream);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, CLASSNAME, "1:1.8:135");
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "writePolicyType", "Exception caught during marshalling: " + exception);
            }
            bl = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "writePolicyType", bl);
        }
        return bl;
    }

    static Properties readPolicyType(String string) {
        Serializable serializable;
        FileInputStream fileInputStream;
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "readPolicyType", string);
            }
            fileInputStream = null;
            try {
                serializable = new File(string);
                if (!serializable.exists() && TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "readPolicyType", "File does not exist: " + string);
                }
                fileInputStream = new FileInputStream((File)serializable);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, CLASSNAME, "1:171:1.8");
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break block5;
                Tr.debug(TRACE_COMPONENT, "readPolicyType", "Exception caught during file load: " + exception);
            }
        }
        serializable = PolicyTypeBndFileHelper.readPolicyType(fileInputStream);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "readPolicyType", serializable);
        }
        return serializable;
    }

    public static Properties readPolicyType(InputStream inputStream) {
        List<All> list;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "readPolicyType", inputStream);
        }
        Properties properties = new Properties();
        String string = DEFAULT_VALUE;
        if (inputStream != null && (list = PolicyTypeBndFileHelper.getAlternativesFromFile(inputStream)) != null && list.size() == 1) {
            PreventWLM preventWLM;
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "readPolicyType", "Single alternative found.");
            }
            if ((preventWLM = list.get(0).getPreventWLM()) != null) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "readPolicyType", "preventWLM element found");
                }
                string = "true";
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "readPolicyType", "preventWLM value: " + string);
            }
        }
        properties.put("preventWLM", string);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "readPolicyType", string);
        }
        return properties;
    }

    private static List<All> getAlternativesFromFile(InputStream inputStream) {
        List<All> list;
        block10: {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "getAlternativesFromFile", inputStream);
            }
            list = null;
            try {
                JAXBContext jAXBContext = null;
                try {
                    jAXBContext = AccessController.doPrivileged(new PrivilegedExceptionAction<JAXBContext>(){

                        @Override
                        public JAXBContext run() throws Exception {
                            return JAXBContext.newInstance(Policy.class);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
                Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
                StreamSource streamSource = new StreamSource(inputStream);
                JAXBElement<Policy> jAXBElement = unmarshaller.unmarshal(streamSource, Policy.class);
                if (jAXBElement != null) {
                    Policy policy;
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "getAlternativesFromFile", "JAXBElement<Policy> unmarshalled: " + jAXBElement);
                    }
                    if ((policy = jAXBElement.getValue()) != null && policy.getExactlyOne() != null) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "getAlternativesFromFile", "An ExactlyOne element found.");
                        }
                        list = policy.getExactlyOne().getAll();
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, CLASSNAME, "1:1.8:286");
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) break block10;
                Tr.debug(TRACE_COMPONENT, "getAlternativesFromFile", "Exception caught during unmarshalling: " + exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAlternativesFromFile", list);
        }
        return list;
    }

    private static Policy createPolicyObjectForFlag(String string) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createPolicyObjectForFlag", string);
        }
        ObjectFactory objectFactory = new ObjectFactory();
        Policy policy = objectFactory.createPolicy();
        ExactlyOne exactlyOne = objectFactory.createExactlyOne();
        boolean bl = Boolean.valueOf(string);
        policy.setExactlyOne(exactlyOne);
        if (bl) {
            All all = objectFactory.createAll();
            PreventWLM preventWLM = objectFactory.createPreventWLM();
            all.setPreventWLM(preventWLM);
            exactlyOne.getAll().add(all);
        } else {
            All all = objectFactory.createAll();
            exactlyOne.getAll().add(all);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createPolicyObjectForFlag", policy);
        }
        return policy;
    }
}

