/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.jaxws.WSATargetResolver;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.AddressingFaultsHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.util.JavaUtils;

public class AddressingClusterSupportHandler
extends AbstractHandler
implements AddressingConstants {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(AddressingClusterSupportHandler.class, "WS-Addressing", "com.ibm.ws.wsaddressing.jaxws.CWWARMessages");

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "invoke", new Object[]{messageContext});
        }
        Object object = messageContext.getProperty("IsAddressingProcessed");
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "IS_ADDR_INFO_ALREADY_PROCESSED=" + object);
        }
        if (JavaUtils.isTrueExplicitly(object)) {
            this.checkClusterId(messageContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "invoke");
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void checkClusterId(MessageContext messageContext) throws AxisFault {
        SOAPHeader sOAPHeader;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "checkClusterId", new Object[]{messageContext});
        }
        if ((sOAPHeader = messageContext.getEnvelope().getHeader()) != null) {
            Object object;
            Object object2;
            OMElement oMElement = null;
            Iterator iterator = sOAPHeader.getChildElements();
            while (iterator.hasNext() && oMElement == null) {
                object2 = (OMElement)iterator.next();
                if (!"RoutingInformation".equals(object2.getLocalName()) || !"http://ucf.wsaddressing.ws.ibm.com".equals(object = object2.getNamespace().getNamespaceURI())) continue;
                oMElement = object2;
            }
            if (oMElement != null) {
                Object object3;
                Object object4;
                object2 = null;
                object = oMElement.getChildElements();
                while (object2 == null && object.hasNext()) {
                    object4 = object.next();
                    if (!(object4 instanceof OMElement)) continue;
                    object3 = (OMElement)object4;
                    object2 = WSATargetResolver.getClusterIdentityFromOMElementText((OMElement)object3);
                }
                if (object2 != null) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Cluster Identity found in reference parameter.");
                    }
                    try {
                        object4 = (ClusterMemberService)WsServiceRegistry.getService(this, ClusterMemberService.class);
                        boolean bl = object4.getServerClusterContextListener().validateClusterResidency((Identity)object2);
                        if (!bl) {
                            EndpointReference endpointReference;
                            String string = "This server is not a member of the cluster identified by the wsaucf:RoutingInformation";
                            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, string);
                            }
                            AddressingFaultsHelper.triggerDestinationUnreachableFault(messageContext, (endpointReference = messageContext.getTo()) != null ? endpointReference.getAddress() : null);
                        }
                    }
                    catch (AxisFault axisFault) {
                        throw axisFault;
                    }
                    catch (Exception exception) {
                        object3 = "An Exception occurred attempting to access the ClusterMemberService: " + exception;
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, (String)object3);
                        }
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.wsaddressing.jaxws.handlers.AddressingClusterSupportHandler.checkClusterId", "1:122:1.6", this);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "checkClusterId");
        }
    }
}

