/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.converters;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.jaxws.converters.LazyRelationshipImpl;
import com.ibm.ws.wsaddressing.jaxws.converters.RelationshipConverter;
import com.ibm.wsspi.wsaddressing.Relationship;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.soap.SOAPException;
import org.apache.axis2.addressing.RelatesTo;

public class RelationshipSetConverter {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(RelationshipSetConverter.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);

    protected static RelatesTo[] toAxis2(Set set) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "toAxis2", new Object[]{set});
        }
        RelatesTo[] relatesToArray = null;
        if (set != null) {
            int n = set.size();
            relatesToArray = new RelatesTo[n];
            Iterator iterator = set.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Relationship relationship = (Relationship)iterator.next();
                relatesToArray[n2] = RelationshipConverter.toAxis2(relationship);
                ++n2;
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "toAxis2", relatesToArray);
        }
        return relatesToArray;
    }

    protected static Set fromAxis2(RelatesTo[] relatesToArray) throws URISyntaxException, SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "fromAxis2", new Object[]{relatesToArray});
        }
        LinkedHashSet<Relationship> linkedHashSet = null;
        if (relatesToArray != null) {
            int n = relatesToArray.length;
            linkedHashSet = new LinkedHashSet<Relationship>(n << 1);
            for (int i = 0; i < n; ++i) {
                RelatesTo relatesTo = relatesToArray[i];
                Relationship relationship = RelationshipConverter.fromAxis2(relatesTo);
                linkedHashSet.add(relationship);
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "fromAxis2", linkedHashSet);
        }
        return linkedHashSet;
    }

    protected static Set fromAxis2Lazy(RelatesTo[] relatesToArray) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "fromAxis2Lazy", new Object[]{relatesToArray});
        }
        LinkedHashSet<LazyRelationshipImpl> linkedHashSet = null;
        if (relatesToArray != null) {
            int n = relatesToArray.length;
            linkedHashSet = new LinkedHashSet<LazyRelationshipImpl>(n << 1);
            for (int i = 0; i < n; ++i) {
                linkedHashSet.add(new LazyRelationshipImpl(relatesToArray[i]));
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "fromAxis2Lazy", linkedHashSet);
        }
        return linkedHashSet;
    }
}

