/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.converters;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.jaxws.converters.AttributedURIConverter;
import com.ibm.wsspi.wsaddressing.Relationship;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axis2.addressing.RelatesTo;

public class RelationshipConverter {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(RelationshipConverter.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);

    protected static RelatesTo toAxis2(Relationship relationship) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "toAxis2", new Object[]{relationship});
        }
        RelatesTo relatesTo = null;
        if (relationship != null) {
            URI uRI = relationship.getURI();
            URI uRI2 = relationship.getRelationshipType();
            String string = null;
            if (uRI != null) {
                string = uRI.toString();
            }
            String string2 = null;
            if (uRI2 != null) {
                string2 = uRI2.toString();
            }
            relatesTo = new RelatesTo(string, string2);
            ArrayList<OMAttribute> arrayList = AttributedURIConverter.getAxis2Attributes(relationship);
            if (!arrayList.isEmpty()) {
                relatesTo.setExtensibilityAttributes(arrayList);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "toAxis2", relatesTo);
        }
        return relatesTo;
    }

    protected static Relationship fromAxis2(RelatesTo relatesTo) throws SOAPException, URISyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "fromAxis2", new Object[]{relatesTo});
        }
        Relationship relationship = null;
        if (relatesTo != null) {
            String string = relatesTo.getValue();
            String string2 = relatesTo.getRelationshipType();
            URI uRI = null;
            if (string != null) {
                uRI = new URI(string);
            }
            URI uRI2 = null;
            if (string2 != null) {
                uRI2 = new URI(string2);
            }
            relationship = WSAddressingFactory.createRelationship(uRI);
            relationship.setRelationshipType(uRI2);
            ArrayList arrayList = relatesTo.getExtensibilityAttributes();
            HashMap<Name, String> hashMap = AttributedURIConverter.getIBMAttributes(arrayList);
            for (Name name : hashMap.keySet()) {
                relationship.addAttribute(name, hashMap.get(name));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "fromAxis2", relationship);
        }
        return relationship;
    }
}

