/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.converters;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.jaxws.converters.RelationshipConverter;
import com.ibm.wsspi.wsaddressing.Relationship;
import java.net.URI;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.addressing.RelatesTo;

public class LazyRelationshipImpl
implements Relationship {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private static final TraceComponent TRACE_COMPONENT = Tr.register(LazyRelationshipImpl.class, "WS-Addressing", "com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    RelatesTo _relatesTo;
    Relationship _relationship;
    boolean isConstructed = false;

    public LazyRelationshipImpl(RelatesTo relatesTo) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "LazyRelationshipImpl", relatesTo);
        }
        this._relatesTo = relatesTo;
        if (this._relatesTo == null) {
            throw new IllegalArgumentException("Null RelatesTo not permitted.");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "LazyRelationshipImpl");
        }
    }

    private void construct() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "construct");
        }
        try {
            this._relationship = RelationshipConverter.fromAxis2(this._relatesTo);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, this.getClass() + ".construct()", "1:63:1.1", this);
            if (TRACE_COMPONENT.isErrorEnabled()) {
                Tr.error(TRACE_COMPONENT, "A problem occurred during conversion from an Axis2 RelatesTo to an IBM Relationship.", exception);
            }
            throw new WebServiceException(nls.getString("URI_CONVERSION_ERROR_CWWAR0104"), exception);
        }
        this.isConstructed = true;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "construct");
        }
    }

    public URI getRelationshipType() {
        if (!this.isConstructed) {
            this.construct();
        }
        return this._relationship.getRelationshipType();
    }

    public URI getURI() {
        if (!this.isConstructed) {
            this.construct();
        }
        return this._relationship.getURI();
    }

    public void setRelationshipType(URI uRI) {
        if (!this.isConstructed) {
            this.construct();
        }
        this._relationship.setRelationshipType(uRI);
    }

    public void setURI(URI uRI) {
        if (!this.isConstructed) {
            this.construct();
        }
        this._relationship.setURI(uRI);
    }

    public void addAttribute(Name name, String string) {
        if (!this.isConstructed) {
            this.construct();
        }
        this._relationship.addAttribute(name, string);
    }

    public Iterator getAttributeNames() {
        if (!this.isConstructed) {
            this.construct();
        }
        return this._relationship.getAttributeNames();
    }

    public String getAttributeValue(Name name) {
        if (!this.isConstructed) {
            this.construct();
        }
        return this._relationship.getAttributeValue(name);
    }

    public Object clone() throws CloneNotSupportedException {
        return new LazyRelationshipImpl(this._relatesTo);
    }

    public boolean equals(Object object) {
        if (object instanceof LazyRelationshipImpl) {
            LazyRelationshipImpl lazyRelationshipImpl = (LazyRelationshipImpl)object;
            if (!this.isConstructed) {
                this.construct();
            }
            if (!lazyRelationshipImpl.isConstructed) {
                lazyRelationshipImpl.construct();
            }
            return this._relationship.equals(lazyRelationshipImpl._relationship);
        }
        if (object instanceof Relationship) {
            if (!this.isConstructed) {
                this.construct();
            }
            return this._relationship.equals(object);
        }
        return false;
    }
}

