/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.converters;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.AttributedURI;
import com.ibm.ws.wsaddressing.jaxws.converters.AttributedURIConverter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyAttributedURIImpl
implements AttributedURI {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private static final TraceComponent TRACE_COMPONENT = Tr.register(LazyAttributedURIImpl.class, "WS-Addressing", "com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    AttributedURI _auri;
    String _uriString;
    ArrayList<OMAttribute> _attributes;
    boolean isConstructed = false;

    public LazyAttributedURIImpl(String string, ArrayList<OMAttribute> arrayList) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "LazyAttributedURIImpl", new Object[]{string, arrayList});
        }
        this._uriString = string;
        this._attributes = arrayList;
        if (string == null) {
            throw new IllegalArgumentException("Null URI not permitted.");
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "LazyAttributedURIImpl");
        }
    }

    private void construct() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "construct", this);
        }
        try {
            this._auri = (AttributedURI)AttributedURIConverter.fromAxis2(this._uriString);
            if (this._attributes != null) {
                HashMap<Name, String> hashMap = AttributedURIConverter.getIBMAttributes(this._attributes);
                for (Map.Entry<Name, String> entry : hashMap.entrySet()) {
                    this._auri.addAttribute(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, this.getClass() + ".construct()", "1:72:1.1", this);
            if (TRACE_COMPONENT.isErrorEnabled()) {
                Tr.error(TRACE_COMPONENT, "A problem occurred during conversion from an Axis2 string to an IBM attributed URI.", exception);
            }
            throw new WebServiceException(nls.getString("URI_CONVERSION_ERROR_CWWAR0104"), exception);
        }
        this.isConstructed = true;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "construct");
        }
    }

    @Override
    public SOAPElement getSOAPElement(SOAPElement sOAPElement) throws SOAPException {
        if (!this.isConstructed) {
            this.construct();
        }
        return this._auri.getSOAPElement(sOAPElement);
    }

    @Override
    public URI getURI() {
        if (!this.isConstructed) {
            this.construct();
        }
        return this._auri.getURI();
    }

    @Override
    public void setURI(URI uRI) {
        if (!this.isConstructed) {
            this.construct();
        }
        this._auri.setURI(uRI);
    }

    @Override
    public void addAttribute(Name name, String string) {
        if (!this.isConstructed) {
            this.construct();
        }
        this._auri.addAttribute(name, string);
    }

    @Override
    public Iterator getAttributeNames() {
        if (!this.isConstructed) {
            this.construct();
        }
        return this._auri.getAttributeNames();
    }

    @Override
    public String getAttributeValue(Name name) {
        if (!this.isConstructed) {
            this.construct();
        }
        return this._auri.getAttributeValue(name);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new LazyAttributedURIImpl(this._uriString, this._attributes);
    }

    public boolean equals(Object object) {
        if (object instanceof LazyAttributedURIImpl) {
            LazyAttributedURIImpl lazyAttributedURIImpl = (LazyAttributedURIImpl)object;
            if (!this.isConstructed) {
                this.construct();
            }
            if (!lazyAttributedURIImpl.isConstructed) {
                lazyAttributedURIImpl.construct();
            }
            return this._auri.equals(lazyAttributedURIImpl._auri);
        }
        if (object instanceof AttributedURI) {
            if (!this.isConstructed) {
                this.construct();
            }
            return this._auri.equals(object);
        }
        return false;
    }
}

