/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.converters;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.wsspi.wsaddressing.AttributedType;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributedURIConverter {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(AttributedURIConverter.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    private static OMFactory omFactory = null;

    private AttributedURIConverter() {
    }

    protected static String toAxis2(AttributedURI attributedURI) {
        URI uRI;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "toAxis2", new Object[]{attributedURI});
        }
        String string = null;
        if (attributedURI != null && (uRI = attributedURI.getURI()) != null) {
            string = uRI.toString();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "toAxis2", string);
        }
        return string;
    }

    protected static ArrayList<OMAttribute> getAxis2Attributes(AttributedType attributedType) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getAxis2Attributes", new Object[]{attributedType});
        }
        ArrayList<OMAttribute> arrayList = new ArrayList<OMAttribute>();
        Iterator iterator = attributedType.getAttributeNames();
        while (iterator.hasNext()) {
            Name name = (Name)iterator.next();
            String string = attributedType.getAttributeValue(name);
            OMNamespace oMNamespace = omFactory.createOMNamespace(name.getURI(), name.getPrefix());
            OMAttribute oMAttribute = omFactory.createOMAttribute(name.getLocalName(), oMNamespace, string);
            arrayList.add(oMAttribute);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAxis2Attributes", arrayList);
        }
        return arrayList;
    }

    protected static HashMap<Name, String> getIBMAttributes(ArrayList<OMAttribute> arrayList) throws SOAPException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getAxis2Attributes", new Object[]{arrayList});
        }
        SOAPFactory sOAPFactory = new SOAPFactory();
        HashMap<Name, String> hashMap = new HashMap<Name, String>();
        if (arrayList != null && !arrayList.isEmpty()) {
            for (OMAttribute oMAttribute : arrayList) {
                Name name = null;
                OMNamespace oMNamespace = oMAttribute.getNamespace();
                name = oMNamespace != null ? sOAPFactory.createName(oMAttribute.getLocalName(), oMAttribute.getNamespace().getPrefix(), oMAttribute.getNamespace().getNamespaceURI()) : sOAPFactory.createName(oMAttribute.getLocalName());
                hashMap.put(name, oMAttribute.getAttributeValue());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAxis2Attributes", hashMap);
        }
        return hashMap;
    }

    protected static AttributedURI fromAxis2(String string) throws URISyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "fromAxis2", new Object[]{string});
        }
        AttributedURI attributedURI = null;
        if (string != null) {
            URI uRI = new URI(string);
            attributedURI = WSAddressingFactory.createAttributedURI(uRI);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "fromAxis2", attributedURI);
        }
        return attributedURI;
    }

    static {
        try {
            omFactory = OMAbstractFactory.getOMFactory();
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.wsaddressing.jaxws.converters.AttributedURIConverter.<static>", "1:150:1.7");
        }
    }
}

