/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.converters;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.wsaddressing.jaxws.JaxwsReferenceParameterReader;
import com.ibm.ws.wsaddressing.jaxws.converters.AttributedURIConverter;
import com.ibm.ws.wsaddressing.jaxws.converters.EndpointReferenceConverter;
import com.ibm.ws.wsaddressing.jaxws.converters.LazyAttributedURIImpl;
import com.ibm.ws.wsaddressing.jaxws.converters.LazyEndpointReferenceImpl;
import com.ibm.ws.wsaddressing.jaxws.converters.RelationshipSetConverter;
import com.ibm.ws.wsaddressing.jaxws.converters.WSAContextMigrator;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import java.util.ArrayList;
import java.util.Set;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.ThreadContextMigrator;
import org.apache.axis2.util.Utils;

public class AddressingPropertiesMigrator
implements ThreadContextMigrator {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private static final TraceComponent TRACE_COMPONENT = Tr.register(AddressingPropertiesMigrator.class, "WS-Addressing", "com.ibm.ws.wsaddressing.jaxws.CWWARMessages");

    public AddressingPropertiesMigrator() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "<init>");
            Tr.exit(TRACE_COMPONENT, "<init>", this);
        }
    }

    public void migrateContextToThread(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "migrateContextToThread", new Object[]{messageContext});
        }
        if (JavaUtils.isTrueExplicitly(messageContext.getProperty("IsAddressingProcessed"))) {
            this.convertAxis2ToIbm(messageContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "migrateContextToThread");
        }
    }

    public void cleanupThread(MessageContext messageContext) {
        AxisOperation axisOperation;
        String string;
        int n;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "cleanupThread", new Object[]{messageContext});
        }
        if ((n = Utils.getAxisSpecifMEPConstant(string = (axisOperation = messageContext.getAxisOperation()).getMessageExchangePattern())) == 10 || n == 12 || n == 13 || n == 11) {
            JaxwsReferenceParameterReader.removeThreadLocalMessageContext();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "cleanupThread");
        }
    }

    public void migrateThreadToContext(MessageContext messageContext) throws AxisFault {
        AxisOperation axisOperation;
        String string;
        int n;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "migrateThreadToContext", new Object[]{messageContext});
        }
        if ((n = Utils.getAxisSpecifMEPConstant(string = (axisOperation = messageContext.getAxisOperation()).getMessageExchangePattern())) == 12 || n == 13 || n == 11) {
            if (JavaUtils.isFalseExplicitly(messageContext.getProperty("disableAddressingForOutMessages"))) {
                WSAContextMigrator.WSAProperties wSAProperties = this.getServerSideProperties(messageContext);
                this.convertIbmToAxis2(messageContext, wSAProperties);
            }
        } else {
            WSAClientConfig wSAClientConfig = this.getWSAClientConfig(messageContext);
            if (wSAClientConfig.sendAddressing) {
                this.checkEPRRelatedProperties(messageContext, wSAClientConfig.properties, n);
                this.convertIbmToAxis2(messageContext, wSAClientConfig.properties);
            }
            messageContext.setProperty("disableAddressingForOutMessages", !wSAClientConfig.sendAddressing);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "migrateThreadToContext");
        }
    }

    private WSAContextMigrator.WSAProperties getServerSideProperties(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getServerSideProperties", new Object[]{messageContext, this});
        }
        MessageContext messageContext2 = messageContext.getOperationContext().getMessageContext("In");
        WSAContextMigrator.WSAProperties wSAProperties = new WSAContextMigrator.WSAProperties();
        if (messageContext2 != null) {
            wSAProperties.destinationEPR = (com.ibm.ws.wsaddressing.integration.EndpointReference)this.getProperty(messageContext2, "com.ibm.websphere.wsaddressing.destinationEPR", com.ibm.ws.wsaddressing.integration.EndpointReference.class);
            wSAProperties.fromEPR = (com.ibm.ws.wsaddressing.integration.EndpointReference)this.getProperty(messageContext2, "com.ibm.wsspi.wsaddressing.fromEPR", com.ibm.ws.wsaddressing.integration.EndpointReference.class);
            wSAProperties.replyToEPR = (com.ibm.ws.wsaddressing.integration.EndpointReference)this.getProperty(messageContext2, "com.ibm.wsspi.wsaddressing.replyToEPR", com.ibm.ws.wsaddressing.integration.EndpointReference.class);
            wSAProperties.faultToEPR = (com.ibm.ws.wsaddressing.integration.EndpointReference)this.getProperty(messageContext2, "com.ibm.wsspi.wsaddressing.faultToEPR", com.ibm.ws.wsaddressing.integration.EndpointReference.class);
            wSAProperties.action = (AttributedURI)this.getProperty(messageContext2, "com.ibm.wsspi.wsaddressing.action", AttributedURI.class);
            wSAProperties.messageID = (AttributedURI)this.getProperty(messageContext2, "com.ibm.wsspi.wsaddressing.messageId", AttributedURI.class);
            wSAProperties.version = (String)this.getProperty(messageContext2, "com.ibm.wsspi.wsaddressing.OutboundNamespace", String.class);
            wSAProperties.relationships = (Set)this.getProperty(messageContext2, "com.ibm.wsspi.wsaddressing.relationshipSet", Set.class);
            wSAProperties.addMustUnderstand = (Boolean)this.getProperty(messageContext2, "com.ibm.wsspi.wsaddressing.mustunderstand", Boolean.class);
        }
        if (wSAProperties.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getServerSideProperties", null);
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getServerSideProperties", wSAProperties);
        }
        return wSAProperties;
    }

    private Object getProperty(MessageContext messageContext, String string, Class clazz) {
        Object object = messageContext.getProperty(string);
        if (object != null && !clazz.isInstance(object)) {
            throw new WebServiceException(nls.getFormattedMessage("INCORRECT_IBM_TYPE_CWWAR0101", new Object[]{string, clazz, object.getClass()}, null));
        }
        return object;
    }

    public void cleanupContext(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "cleanupContext", new Object[]{messageContext});
            Tr.exit(TRACE_COMPONENT, "cleanupContext");
        }
    }

    private void convertAxis2EPRToIbmEPR(EndpointReference endpointReference, String string, MessageContext messageContext, String string2) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "convertAxis2EPRToIbmEPR", new Object[]{endpointReference, string, messageContext, string2});
        }
        if (endpointReference != null) {
            LazyEndpointReferenceImpl lazyEndpointReferenceImpl = new LazyEndpointReferenceImpl(endpointReference, string2);
            messageContext.setProperty(string, lazyEndpointReferenceImpl);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "convertAxis2EPRToIbmEPR");
        }
    }

    private void convertAxis2ActionToIbmAttributedURI(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "convertAxis2ActionToIbmAttributedURI", new Object[]{messageContext});
        }
        String string = messageContext.getWSAAction();
        ArrayList arrayList = (ArrayList)messageContext.getProperty("actionAttributes");
        if (string != null) {
            LazyAttributedURIImpl lazyAttributedURIImpl = new LazyAttributedURIImpl(string, arrayList);
            messageContext.setProperty("com.ibm.wsspi.wsaddressing.inbound.Action", lazyAttributedURIImpl);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "convertAxis2ActionToIbmAttributedURI");
        }
    }

    private void convertAxis2MessageIDToIbmAttributedURI(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "convertAxis2MessageIDToIbmAttributedURI", new Object[]{messageContext});
        }
        String string = messageContext.getMessageID();
        ArrayList arrayList = (ArrayList)messageContext.getProperty("messageidAttributes");
        if (string != null) {
            LazyAttributedURIImpl lazyAttributedURIImpl = new LazyAttributedURIImpl(string, arrayList);
            messageContext.setProperty("com.ibm.wsspi.wsaddressing.inbound.MessageID", lazyAttributedURIImpl);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "convertAxis2MessageIDToIbmAttributedURI");
        }
    }

    private void convertAxis2ToEPRToIbmAttributedURI(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "convertAxis2StringToIbmAttributedURI", new Object[]{messageContext});
        }
        String string = null;
        ArrayList arrayList = null;
        EndpointReference endpointReference = messageContext.getTo();
        if (endpointReference != null) {
            string = endpointReference.getAddress();
            arrayList = endpointReference.getAddressAttributes();
        }
        if (string != null) {
            LazyAttributedURIImpl lazyAttributedURIImpl = new LazyAttributedURIImpl(string, arrayList);
            messageContext.setProperty("com.ibm.wsspi.wsaddressing.inbound.To", lazyAttributedURIImpl);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "convertAxis2StringToIbmAttributedURI");
        }
    }

    private void convertAxis2RelatesToArrayToIbmRelationshipSet(String string, MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "convertAxis2RelatesToArrayToIbmRelationshipSet", new Object[]{string, messageContext});
        }
        RelatesTo[] relatesToArray = messageContext.getRelationships();
        Set set = null;
        if (relatesToArray != null) {
            try {
                set = RelationshipSetConverter.fromAxis2Lazy(relatesToArray);
                messageContext.setProperty(string, set);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, this.getClass() + ".convertAxis2RelatesToArrayToIbmRelationshipSet", "1:311:1.31.1.1", this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "A problem occurred during conversion from an Axis2 relateTo array to an IBM relationship set.", exception);
                }
                throw new AxisFault(nls.getString("RELATIONSHIP_CONVERSION_ERROR_CWWAR0106"), exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "convertAxis2RelatesToArrayToIbmRelationshipSet");
        }
    }

    private void convertAxis2ToIbm(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "convertAxis2ToIbm", new Object[]{messageContext});
        }
        Object object = messageContext.getProperty("WSAddressingVersion");
        String string = null;
        if (object != null && !(object instanceof String)) {
            throw new AxisFault(nls.getFormattedMessage("INCORRECT_AXIS2_TYPE_CWWAR0107", new Object[]{"WSAddressingVersion", String.class, object.getClass()}, null));
        }
        string = (String)object;
        messageContext.setProperty("com.ibm.ws.wsaddressing.InboundNamespace", object);
        this.convertAxis2EPRToIbmEPR(messageContext.getFrom(), "com.ibm.wsspi.wsaddressing.inbound.FromEPR", messageContext, string);
        this.convertAxis2EPRToIbmEPR(messageContext.getReplyTo(), "com.ibm.wsspi.wsaddressing.inbound.ReplyToEPR", messageContext, string);
        this.convertAxis2EPRToIbmEPR(messageContext.getFaultTo(), "com.ibm.wsspi.wsaddressing.inbound.FaultToEPR", messageContext, string);
        this.convertAxis2ActionToIbmAttributedURI(messageContext);
        this.convertAxis2MessageIDToIbmAttributedURI(messageContext);
        this.convertAxis2ToEPRToIbmAttributedURI(messageContext);
        this.convertAxis2RelatesToArrayToIbmRelationshipSet("com.ibm.wsspi.wsaddressing.inbound.RelationshipSet", messageContext);
        AxisOperation axisOperation = messageContext.getAxisOperation();
        String string2 = axisOperation.getMessageExchangePattern();
        int n = Utils.getAxisSpecifMEPConstant(string2);
        if (n == 10 || n == 12 || n == 13 || n == 11) {
            JaxwsReferenceParameterReader.setThreadLocalMessageContext(messageContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "convertAxis2ToIbm");
        }
    }

    private void convertIbmToAxis2(MessageContext messageContext, WSAContextMigrator.WSAProperties wSAProperties) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "convertIbmToAxis2", new Object[]{messageContext});
        }
        if (wSAProperties != null) {
            RelatesTo[] relatesToArray;
            try {
                relatesToArray = null;
                if (wSAProperties.destinationEPR != null) {
                    relatesToArray = EndpointReferenceConverter.toAxis2(wSAProperties.destinationEPR);
                    messageContext.setTo((EndpointReference)relatesToArray);
                    messageContext.setProperty("WSAddressingVersion", wSAProperties.destinationEPR.getNamespace());
                }
                if (wSAProperties.replyToEPR != null) {
                    relatesToArray = EndpointReferenceConverter.toAxis2(wSAProperties.replyToEPR);
                    messageContext.setReplyTo((EndpointReference)relatesToArray);
                }
                if (wSAProperties.faultToEPR != null) {
                    relatesToArray = EndpointReferenceConverter.toAxis2(wSAProperties.faultToEPR);
                    messageContext.setFaultTo((EndpointReference)relatesToArray);
                }
                if (wSAProperties.fromEPR != null) {
                    relatesToArray = EndpointReferenceConverter.toAxis2(wSAProperties.fromEPR);
                    messageContext.setFrom((EndpointReference)relatesToArray);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, this.getClass() + ".convertIbmToAxis2", "1:391:1.31.1.1", this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "A problem occurred during conversion from an IBM endpoint reference to an Axis2 endpoint reference.", exception);
                }
                throw new AxisFault(nls.getString("EPR_CONVERSION_ERROR_CWWAR0102"), exception);
            }
            try {
                ArrayList<OMAttribute> arrayList;
                if (wSAProperties.action != null) {
                    relatesToArray = AttributedURIConverter.toAxis2(wSAProperties.action);
                    arrayList = AttributedURIConverter.getAxis2Attributes(wSAProperties.action);
                    String string = null;
                    Boolean bl = (Boolean)messageContext.getProperty("javax.xml.ws.soap.http.soapaction.use");
                    if (bl != null && bl.booleanValue()) {
                        string = (String)messageContext.getProperty("javax.xml.ws.soap.http.soapaction.uri");
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "SOAPAction from MessageContext property: " + string);
                        }
                    }
                    if (string == null) {
                        string = messageContext.getSoapAction();
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "SOAPAction from MessageContext method: " + string);
                        }
                    }
                    if (!(string == null || "".equals(string.trim()) || relatesToArray == null || "".equals(relatesToArray.trim()) || relatesToArray.trim().equals(string.trim()))) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "SOAPAction and wsa:Action do not match. SOAPAction: " + string + ", wsa:Action: " + (String)relatesToArray);
                        }
                        throw new AxisFault(nls.getFormattedMessage("ACTION_MISMATCH_CWWAR0105", new Object[]{string, relatesToArray}, null));
                    }
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Setting wsa:Action: " + (String)relatesToArray);
                    }
                    messageContext.setWSAAction((String)relatesToArray);
                    messageContext.setProperty("actionAttributes", arrayList);
                }
                if (wSAProperties.messageID != null) {
                    relatesToArray = AttributedURIConverter.toAxis2(wSAProperties.messageID);
                    arrayList = AttributedURIConverter.getAxis2Attributes(wSAProperties.messageID);
                    messageContext.setMessageID((String)relatesToArray);
                    messageContext.setProperty("messageidAttributes", arrayList);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, this.getClass() + ".convertIbmToAxis2", "1:446:1.31.1.1", this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "A problem occurred during conversion from an IBM attributed URI to an Axis2 string.", exception);
                }
                throw new AxisFault(nls.getString("URI_CONVERSION_ERROR_CWWAR0104"), exception);
            }
            if (wSAProperties.relationships != null) {
                try {
                    relatesToArray = RelationshipSetConverter.toAxis2(wSAProperties.relationships);
                    messageContext.setRelationships(relatesToArray);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, this.getClass() + ".convertIbmToAxis2", "1:460:1.31.1.1", this);
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "A problem occurred during conversion from an IBM relationship set to an Axis2 relatesTo array.", exception);
                    }
                    throw new AxisFault(nls.getString("RELATIONSHIP_CONVERSION_ERROR_CWWAR0106"), exception);
                }
            }
            if ((relatesToArray = messageContext.getProperty("WSAddressingVersion")) != null && wSAProperties.version != null && !relatesToArray.equals(wSAProperties.version)) {
                throw new AxisFault(nls.getFormattedMessage("NAMESPACE_MISMATCH_CWWAR0108", new Object[]{wSAProperties.version, "com.ibm.wsspi.wsaddressing.OutboundNamespace", relatesToArray, "com.ibm.websphere.wsaddressing.destinationEPR"}, null));
            }
            if (wSAProperties.version != null) {
                messageContext.setProperty("WSAddressingVersion", wSAProperties.version);
            }
            if (wSAProperties.addMustUnderstand != null) {
                messageContext.setProperty("addMustUnderstandToAddressingHeaders", wSAProperties.addMustUnderstand);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "convertIbmToAxis2");
        }
    }

    private void checkEPRRelatedProperties(MessageContext messageContext, WSAContextMigrator.WSAProperties wSAProperties, int n) throws AxisFault {
        boolean bl;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "checkEPRRelatedProperties", new Object[]{messageContext});
        }
        boolean bl2 = bl = n == 16 || n == 17 || n == 15;
        if (wSAProperties != null && bl) {
            com.ibm.ws.wsaddressing.integration.EndpointReference endpointReference;
            com.ibm.ws.wsaddressing.integration.EndpointReference endpointReference2;
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Performing epr check on: ReplyTo");
            }
            if ((endpointReference2 = (com.ibm.ws.wsaddressing.integration.EndpointReference)wSAProperties.replyToEPR) != null) {
                if (messageContext.getOptions().isUseSeparateListener()) {
                    throw new AxisFault(nls.getFormattedMessage("UNAVAILABLE_PROPERTY_CWWAR0100", new Object[]{"com.ibm.wsspi.wsaddressing.replyToEPR"}, null));
                }
                if (!endpointReference2.validate()) {
                    throw new AxisFault(nls.getFormattedMessage("UNAVAILABLE_PROPERTY_CWWAR0100", new Object[]{"com.ibm.wsspi.wsaddressing.replyToEPR"}, null));
                }
                if (!endpointReference2.isAnonymousURI()) {
                    throw new AxisFault(nls.getFormattedMessage("UNAVAILABLE_PROPERTY_CWWAR0100", new Object[]{"com.ibm.wsspi.wsaddressing.replyToEPR"}, null));
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Performing epr check on: FaultTo");
            }
            if ((endpointReference = (com.ibm.ws.wsaddressing.integration.EndpointReference)wSAProperties.faultToEPR) != null) {
                if (messageContext.getOptions().isUseSeparateListener()) {
                    throw new AxisFault(nls.getFormattedMessage("UNAVAILABLE_PROPERTY_CWWAR0100", new Object[]{"com.ibm.wsspi.wsaddressing.faultToEPR"}, null));
                }
                if (!endpointReference.validate()) {
                    throw new AxisFault(nls.getFormattedMessage("UNAVAILABLE_PROPERTY_CWWAR0100", new Object[]{"com.ibm.wsspi.wsaddressing.faultToEPR"}, null));
                }
                if (!endpointReference.isAnonymousURI()) {
                    throw new AxisFault(nls.getFormattedMessage("UNAVAILABLE_PROPERTY_CWWAR0100", new Object[]{"com.ibm.wsspi.wsaddressing.faultToEPR"}, null));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "checkEPRRelatedProperties");
        }
    }

    private WSAClientConfig getWSAClientConfig(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getWSAClientConfig", new Object[]{messageContext, this});
        }
        WSAClientConfig wSAClientConfig = new WSAClientConfig();
        boolean bl = messageContext.getOptions().isUseSeparateListener();
        String string = messageContext.getAxisService().getWSAddressingFlag();
        String string2 = "unspecified";
        PolicySetConfiguration policySetConfiguration = this.getPolicySetConfiguration(messageContext);
        if (policySetConfiguration != null) {
            string2 = (String)policySetConfiguration.getPolicyTypeConfiguration("WSADDRESSING_FLAG");
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "addressingFlagFromWSDL=" + string + " wsaddressingFlagFromPolicySet=" + string2);
        }
        if (string == null) {
            string = "unspecified";
        }
        if (string2 == null) {
            string2 = "unspecified";
        }
        wSAClientConfig.properties = (WSAContextMigrator.WSAProperties)messageContext.getProperty(WSAContextMigrator.WSAProperties.WSA_PROPERTIES);
        boolean bl2 = wSAClientConfig.sendAddressing = bl || wSAClientConfig.properties != null || !"unspecified".equals(string) || !"unspecified".equals(string2);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getWSAClientConfig", wSAClientConfig);
        }
        return wSAClientConfig;
    }

    private PolicySetConfiguration getPolicySetConfiguration(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getPolicySetConfiguration", new Object[]{messageContext, this});
        }
        Parameter parameter = messageContext.getParameter("WASAxis2PolicySet");
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "PolicySet configParam: " + parameter);
        }
        PolicySetConfiguration policySetConfiguration = null;
        if (parameter != null && parameter.getValue() != null) {
            policySetConfiguration = (PolicySetConfiguration)parameter.getValue();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getPolicySetConfiguration", policySetConfiguration);
        }
        return policySetConfiguration;
    }

    private class WSAClientConfig {
        public boolean sendAddressing;
        public WSAContextMigrator.WSAProperties properties;

        private WSAClientConfig() {
        }

        public String toString() {
            return "sendAddressing=" + this.sendAddressing + " properties=" + this.properties;
        }
    }
}

