/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.integration.Registry;
import com.ibm.ws.wsaddressing.jaxws.JaxwsReferenceParameterReader;
import com.ibm.ws.wsaddressing.jaxws.urimap.EndpointMapImpl;
import com.ibm.ws.wsaddressing.jaxws.urimap.EndpointMappingListener;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.websvcs.WASAxis2Service;

public class WSAddressingComponentImpl
extends WsComponentImpl {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSAddressingComponentImpl.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    private static Server _server;
    private EndpointMapImpl endpointMap = null;

    public WSAddressingComponentImpl() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "WSAddressingComponentImpl<init>");
        }
        this.setName("WSAddressingComponentImpl");
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "WSAddressingComponentImpl<init>");
        }
    }

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        super.initialize(object);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "initialize");
        }
    }

    public void destroy() {
        super.destroy();
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "destroy");
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        super.start();
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "start");
        }
        try {
            this.endpointMap = new EndpointMapImpl();
            WASAxis2Service wASAxis2Service = (WASAxis2Service)WsServiceRegistry.getService(this, WASAxis2Service.class);
            wASAxis2Service.addJAXWSMetaDataListener(new EndpointMappingListener(this.endpointMap));
            Registry.addEndpointMap(this.endpointMap);
            JaxwsReferenceParameterReader jaxwsReferenceParameterReader = new JaxwsReferenceParameterReader();
            Registry.addReferenceParameterReader(jaxwsReferenceParameterReader);
            _server = (Server)WsServiceRegistry.getService(this, Server.class);
        }
        catch (Exception exception) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "start", exception);
            }
            throw new RuntimeException(exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "start");
        }
    }

    public void stop() {
        super.stop();
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "stop");
        }
        if (this.endpointMap != null) {
            Registry.removeEndpointMap(this.endpointMap);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "stop");
        }
    }

    public static Server getServer() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getServer", _server);
        }
        return _server;
    }
}

