/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.jaxws.Constants;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.TargetResolver;

public class WSATargetResolver
implements TargetResolver {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSATargetResolver.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);

    public WSATargetResolver() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "WSATargetResolver<init>");
        }
    }

    public void resolveTarget(MessageContext messageContext) {
        Object object;
        OMElement oMElement;
        EndpointReference endpointReference;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "resolveTarget", messageContext);
        }
        if ((endpointReference = messageContext.getTo()) == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "resolveTarget", "No wsa:To EPR found so no Routing Information");
            }
            return;
        }
        Map map = endpointReference.getAllReferenceParameters();
        if (map == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "resolveTarget", "No ReferenceParameters so no Routing Information");
            }
            return;
        }
        OMElement oMElement2 = (OMElement)map.get(Constants.INTERMEDIARY_PRESENT_QNAME);
        if (oMElement2 != null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "resolveTarget", "IntermediaryPresent element found. No properties added.");
            }
            return;
        }
        OMElement oMElement3 = (OMElement)map.get(Constants.ROUTING_INFORMATION_QNAME);
        if (oMElement3 != null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "resolveTarget", "RoutingInformation reference parameter found");
            }
            if ((oMElement = oMElement3.getFirstElement()) != null) {
                object = oMElement.getQName();
                String string = oMElement.getText();
                if (string != null) {
                    string = string.trim();
                }
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "resolveTarget", "Child of RoutingInformation reference parameter found: " + object + " " + string);
                }
                Identity identity = WSATargetResolver.getIdentityFromString(string);
                if (Constants.AFFINITY_ROUTING_KEY.equals(object)) {
                    if (identity != null) {
                        messageContext.setProperty("com.ibm.ws.wsaddressing.jaxws.destinationEPR.identity", identity);
                        messageContext.setProperty("com.ibm.ws.wsaddressing.jaxws.destinationEPR.routingType", "HA");
                    }
                } else if (Constants.WLM_ROUTING_KEY.equals(object)) {
                    if (identity != null) {
                        messageContext.setProperty("com.ibm.ws.wsaddressing.jaxws.destinationEPR.identity", identity);
                        messageContext.setProperty("com.ibm.ws.wsaddressing.jaxws.destinationEPR.routingType", "WLM");
                    }
                } else if (Constants.FRAGILE_ROUTING_KEY.equals(object)) {
                    if (identity != null) {
                        messageContext.setProperty("com.ibm.ws.wsaddressing.jaxws.destinationEPR.identity", identity);
                        messageContext.setProperty("com.ibm.ws.wsaddressing.jaxws.destinationEPR.routingType", "Fragile");
                    } else if ("Fragile".equals(string)) {
                        messageContext.setProperty("com.ibm.ws.wsaddressing.jaxws.destinationEPR.routingType", "Fragile");
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "resolveTarget", "Child of RoutingInformation reference parameter not recognised.");
                }
            }
        }
        if ((oMElement = (OMElement)map.get(Constants.VIRTUAL_HOST_QNAME)) != null) {
            object = oMElement.getText();
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "resolveTarget", "VirtualHostName ReferenceParameter found. Value: '" + (String)object + "'");
            }
            if (object != null && !"".equals(((String)object).trim())) {
                messageContext.setProperty("com.ibm.ws.wsaddressing.jaxws.destinationEPR.virtualHostName", ((String)object).trim());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "resolveTarget");
        }
    }

    private static Identity getIdentityFromString(String string) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getIdentityFromString", string);
        }
        if (string == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getIdentityFromString", "String parameter was null, so return null");
            }
            return null;
        }
        if (string.equals("Fragile")) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getIdentityFromString", "String parameter was Fragile, so return null");
            }
            return null;
        }
        Identity identity = null;
        ClusterService clusterService = ClusterServiceFactory.getClusterService();
        if (clusterService != null) {
            identity = clusterService.stringToIdentity(string);
            Set set = clusterService.getActiveClusterSet();
            boolean bl = set.contains(identity);
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getIdentityFromString", "isClusterCellLocal: " + bl);
            }
            if (!bl) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getIdentityFromString", "The detected Cluster Identity is not in the active clusters set so returning null");
                }
                return null;
            }
        } else {
            String string2 = "The ClusterService was not available in order to extract the clusterId for routing. ";
            Tr.error(TRACE_COMPONENT, string2);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getIdentityFromString", identity);
        }
        return identity;
    }

    public static Identity getClusterIdentityFromOMElementText(OMElement oMElement) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getClusterIdentityFromOMElementText", new Object[]{oMElement});
        }
        if (oMElement == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getClusterIdentityFromOMElementText", "OMElement parameter was null, so return null");
            }
            return null;
        }
        String string = oMElement.getText();
        Identity identity = WSATargetResolver.getIdentityFromString(string);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getClusterIdentityFromOMElementText", identity);
        }
        return identity;
    }
}

