/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.wsaddressing.ReferenceParameterCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.integration.ReferenceParameterReader;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.jaxws.message.factory.SAAJConverterFactory;
import org.apache.axis2.jaxws.message.util.SAAJConverter;
import org.apache.axis2.jaxws.registry.FactoryRegistry;

public class JaxwsReferenceParameterReader
implements ReferenceParameterReader {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private static final TraceComponent TRACE_COMPONENT = Tr.register(JaxwsReferenceParameterReader.class, "WS-Addressing", "com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.JaxwsReferenceParameterReader";
    private static ThreadLocal currentThreadMessageContext = new ThreadLocal();
    private static QName wsaIsRefParamQN = new QName("http://www.w3.org/2005/08/addressing", "IsReferenceParameter");
    private static SAAJConverterFactory f = (SAAJConverterFactory)FactoryRegistry.getFactory(SAAJConverterFactory.class);
    private static SAAJConverter converter = f.getSAAJConverter();

    public String getReferenceParameterFromMessageContext(QName qName) throws ReferenceParameterCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getReferenceParameterFromMessageContext", new Object[]{qName});
        }
        String string = null;
        MessageContext messageContext = JaxwsReferenceParameterReader.getCurrentThreadsContext();
        if (messageContext == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getReferenceParameterFromMessageContext", "MessageContext is null");
            }
        } else {
            OMElement oMElement = this.extractOMElementFromOMContext(messageContext, qName);
            if (oMElement != null) {
                string = oMElement.getText();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromMessageContext", string);
        }
        return string;
    }

    public SOAPElement getSOAPElementReferenceParameterFromMessageContext(QName qName) throws ReferenceParameterCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContext", new Object[]{qName});
        }
        SOAPElement sOAPElement = null;
        MessageContext messageContext = JaxwsReferenceParameterReader.getCurrentThreadsContext();
        if (messageContext == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContext", "MessageContext is null");
            }
        } else {
            OMElement oMElement = this.extractOMElementFromOMContext(messageContext, qName);
            if (oMElement != null) {
                try {
                    SOAPFactory sOAPFactory = SOAPFactory.newInstance();
                    SOAPElement sOAPElement2 = sOAPFactory.createElement("parent");
                    sOAPElement = converter.toSAAJ(oMElement, sOAPElement2, sOAPFactory);
                }
                catch (SOAPException sOAPException) {
                    String string = ((Object)oMElement).toString();
                    FFDCFilter.processException(sOAPException, CLASSNAME, "1:1.7:147");
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Unable to convert Axiom Element " + string, sOAPException);
                    }
                    throw new ReferenceParameterCreationException(nls.getFormattedMessage("SOAPELEMENT_CREATION_EXCEPTION_CWWAR0001", new Object[]{string}, null), sOAPException);
                }
                catch (WebServiceException webServiceException) {
                    String string = ((Object)oMElement).toString();
                    FFDCFilter.processException(webServiceException, CLASSNAME, "1:1.7:155");
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Unable to convert Axiom Element " + string, webServiceException);
                    }
                    throw new ReferenceParameterCreationException(nls.getFormattedMessage("SOAPELEMENT_CREATION_EXCEPTION_CWWAR0001", new Object[]{string}, null), webServiceException);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContext", sOAPElement);
        }
        return sOAPElement;
    }

    private static MessageContext getCurrentThreadsContext() {
        return (MessageContext)currentThreadMessageContext.get();
    }

    public static void setThreadLocalMessageContext(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setThreadLocalMessageContext", messageContext);
        }
        currentThreadMessageContext.set(messageContext);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setThreadLocalMessageContext");
        }
    }

    public static void removeThreadLocalMessageContext() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "removeThreadLocalMessageContext");
        }
        currentThreadMessageContext.set(null);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "removeThreadLocalMessageContext");
        }
    }

    private OMElement extractOMElementFromOMContext(MessageContext messageContext, QName qName) throws ReferenceParameterCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "extractOMElementFromOMContext", new Object[]{messageContext, qName});
        }
        if (messageContext == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "extractOMElementFromOMContext", "MessageContext is null. ");
            }
            return null;
        }
        if (qName == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "extractOMElementFromOMContext", "QName for ReferenceParameter is null.");
            }
            return null;
        }
        String string = (String)messageContext.getProperty("WSAddressingVersion");
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "extractOMElementFromOMContext", "WSANamespace retrieved from msgCtx " + string);
        }
        if (string == null) {
            string = "http://www.w3.org/2005/08/addressing";
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "extractOMElementFromOMContext", "Set default WSANamespace " + string);
            }
        } else if (!"http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(string) && !"http://www.w3.org/2005/08/addressing".equals(string)) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "extractOMElementFromOMContext", "Unable to recognize WSA Namespace " + string);
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "extractOMElementFromOMContext", "Unrecognizable WSA namespace.");
            }
            throw new ReferenceParameterCreationException(nls.getString("UNRECOGNIZED_WSA_NAMESPACE_CWWAR0002"));
        }
        SOAPHeader sOAPHeader = null;
        SOAPEnvelope sOAPEnvelope = messageContext.getEnvelope();
        if (sOAPEnvelope == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "extractOMElementFromOMContext", "Cannot find SOAPEnvelope in messageContext. Throwing ReferenceParameterCreationException");
            }
            throw new ReferenceParameterCreationException(nls.getString("MISSING_SOAP_ENVELOPE_CWWAR0003"));
        }
        sOAPHeader = sOAPEnvelope.getHeader();
        if (sOAPHeader == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "extractOMElementFromOMContext", "SOAP Header from Envelope is null.");
            }
            return null;
        }
        OMElement oMElement = null;
        Iterator iterator = sOAPHeader.getChildrenWithName(qName);
        if (iterator.hasNext()) {
            String string2;
            OMElement oMElement2 = (OMElement)iterator.next();
            boolean bl = false;
            bl = string.equals("http://www.w3.org/2005/08/addressing") ? ((string2 = oMElement2.getAttributeValue(wsaIsRefParamQN)) != null ? new Boolean(string2) : false) : true;
            if (bl) {
                if (oMElement2.getNamespace() != null) {
                    if (oMElement2.getNamespace().getNamespaceURI().equals(qName.getNamespaceURI())) {
                        oMElement = oMElement2;
                    } else if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "extractOMElementFromOMContext: Namespace of found ReferenceParameter does not match the search criteria: " + qName.getNamespaceURI() + ", " + oMElement2.getNamespace().getNamespaceURI(), qName);
                    }
                } else {
                    oMElement = oMElement2;
                }
            }
        }
        if (iterator.hasNext()) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "extractOMElementFromOMContext: Multiple reference parameters exist with the same name", qName);
            }
            throw new ReferenceParameterCreationException(nls.getString("PARAMETER_NAME_CLASH_CWWAR0004"));
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "extractOMElementFromOMContext", oMElement);
        }
        return oMElement;
    }
}

