/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMElement;

public abstract class EndpointReferenceConverter {
    private static EndpointReferenceConverter _delegatedHelper = null;
    private static final String CONCRETE_HELPER_CLASSNAME = "com.ibm.ws.wsaddressing.jaxws.converters.EndpointReferenceConverter";
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.jaxws.EndpointReferenceConverter";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(EndpointReferenceConverter.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);

    public static EndpointReference createEndpointReferenceFromOMElement(OMElement oMElement) throws EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createEndpointReferenceFromOMElement", oMElement);
        }
        EndpointReference endpointReference = _delegatedHelper.createEndpointReferenceFromOMElementImpl(oMElement);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createEndpointReferenceFromOMElement", endpointReference);
        }
        return endpointReference;
    }

    protected abstract EndpointReference createEndpointReferenceFromOMElementImpl(OMElement var1) throws EndpointReferenceCreationException;

    public static OMElement serializeEndpointReference(EndpointReference endpointReference, QName qName) throws WebServiceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "serializeEndpointReference", new Object[]{endpointReference, qName});
        }
        OMElement oMElement = _delegatedHelper.serializeEndpointReferenceImpl(endpointReference, qName);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "serializeEndpointReference", oMElement);
        }
        return oMElement;
    }

    protected abstract OMElement serializeEndpointReferenceImpl(EndpointReference var1, QName var2) throws WebServiceException;

    private static void traceAndFFDCException(Exception exception) {
        String string = exception.getClass().getName();
        String string2 = exception.getMessage();
        String string3 = "Caught a " + string + ": " + string2 + " when trying to create a new " + CONCRETE_HELPER_CLASSNAME + " instance within a static initializer";
        Tr.warning(TRACE_COMPONENT, string3);
        FFDCFilter.processException(exception, CLASSNAME, "1:401:1.12");
    }

    static {
        try {
            _delegatedHelper = (EndpointReferenceConverter)Class.forName(CONCRETE_HELPER_CLASSNAME).newInstance();
        }
        catch (InstantiationException instantiationException) {
            EndpointReferenceConverter.traceAndFFDCException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            EndpointReferenceConverter.traceAndFFDCException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            EndpointReferenceConverter.traceAndFFDCException(classNotFoundException);
        }
    }
}

