/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.integration;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.integration.EndpointMap;
import com.ibm.ws.wsaddressing.integration.ReferenceParameterReader;

public abstract class Registry {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.integration.Registry";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(Registry.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    protected static Registry _registry = null;
    private static final String IMPL_CLASSNAME = "com.ibm.ws.wsaddressing.integration.RegistryImpl";

    private static void traceAndFFDCException(Exception exception) {
        String string = exception.getClass().getName();
        String string2 = exception.getMessage();
        String string3 = "Caught a " + string + ": " + string2 + " when trying to create a new concrete Registry instance within a static initializer";
        Tr.warning(TRACE_COMPONENT, string3);
        FFDCFilter.processException(exception, CLASSNAME, "1:71:1.2");
    }

    public static ReferenceParameterReader getCombinedReferenceParameterReader() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getCombinedReferenceParameterReader");
        }
        ReferenceParameterReader referenceParameterReader = _registry.getCombinedReferenceParameterReaderImpl();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getCombinedReferenceParameterReader", referenceParameterReader);
        }
        return referenceParameterReader;
    }

    public static void addReferenceParameterReader(ReferenceParameterReader referenceParameterReader) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addReferenceParameterReader");
        }
        _registry.addReferenceParameterReaderImpl(referenceParameterReader);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addReferenceParameterReader");
        }
    }

    public static void removeReferenceParameterReader(ReferenceParameterReader referenceParameterReader) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "removeReferenceParameterReader");
        }
        _registry.removeReferenceParameterReaderImpl(referenceParameterReader);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "removeReferenceParameterReader");
        }
    }

    abstract ReferenceParameterReader getCombinedReferenceParameterReaderImpl();

    abstract void addReferenceParameterReaderImpl(ReferenceParameterReader var1);

    abstract void removeReferenceParameterReaderImpl(ReferenceParameterReader var1);

    public static EndpointMap getCombinedEndpointMap() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getCombinedEndpointMap");
        }
        EndpointMap endpointMap = _registry.getCombinedEndpointMapImpl();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getCombinedEndpointMap", endpointMap);
        }
        return endpointMap;
    }

    public static void addEndpointMap(EndpointMap endpointMap) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addEndpointMap");
        }
        _registry.addEndpointMapImpl(endpointMap);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addEndpointMap");
        }
    }

    public static void removeEndpointMap(EndpointMap endpointMap) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "removeEndpointMap");
        }
        _registry.removeEndpointMapImpl(endpointMap);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "removeEndpointMap");
        }
    }

    abstract EndpointMap getCombinedEndpointMapImpl();

    abstract void addEndpointMapImpl(EndpointMap var1);

    abstract void removeEndpointMapImpl(EndpointMap var1);

    static {
        try {
            _registry = (Registry)Class.forName(IMPL_CLASSNAME).newInstance();
        }
        catch (InstantiationException instantiationException) {
            Registry.traceAndFFDCException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Registry.traceAndFFDCException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Registry.traceAndFFDCException(classNotFoundException);
        }
    }
}

