/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.DestinationUnreachableException;
import com.ibm.ws.wsaddressing.InvalidMultipleElementException;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.handlers.ActionSpecifier;
import com.ibm.ws.wsaddressing.handlers.MAPReader;
import com.ibm.ws.wsaddressing.handlers.MAPWriter;
import com.ibm.ws.wsaddressing.handlers.ReplyHelper;
import com.ibm.ws.wsaddressing.handlers.UsingAddressingHelper;
import com.ibm.ws.wsaddressing.handlers.WSACommonHandler;
import com.ibm.ws.wsaddressing.handlers.WSAOutboundProperties;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.wsspi.webservices.rpc.handler.RPCContext;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.EndpointReferenceManager;
import com.ibm.wsspi.wsaddressing.NamespaceNotSupportedException;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;

public class WSAddressingClientHandler
extends WSACommonHandler {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.handlers.WSAddressingClientHandler";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSAddressingClientHandler.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    private boolean wsAddressingDisabled = false;

    public boolean handleRequest(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "handleRequest", messageContext);
        }
        if (this.isAddressingDisabled(messageContext)) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleRequest", "WSA Disabled, return true;");
            }
            return true;
        }
        SOAPMessageContext sOAPMessageContext = null;
        if (!(messageContext instanceof SOAPMessageContext)) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleRequest", "No SoapMessageContext, return true;");
            }
            return true;
        }
        sOAPMessageContext = (SOAPMessageContext)messageContext;
        WSAOutboundProperties wSAOutboundProperties = new WSAOutboundProperties();
        boolean bl = wSAOutboundProperties.setMessageContext(messageContext);
        boolean bl2 = UsingAddressingHelper.shouldSendWSAddressingBasedOnWSDL(messageContext);
        if (!bl && !bl2) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "handleRequest", "Addressing not mandated and no WSA properties set - WSA handler exiting early. ");
            }
            messageContext.setProperty("com.ibm.ws.wsaddressing.disabled", Boolean.TRUE);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleRequest: [true]");
            }
            return true;
        }
        wSAOutboundProperties.setupWSAProperties();
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "handleRequest", "WSAddressing handler determined that wsaPropertyExists = " + bl);
            Tr.debug(TRACE_COMPONENT, "handleRequest", "WSAddressing handler determined that shouldSendWSAddressingBasedOnWSDL = " + bl2);
            Tr.debug(TRACE_COMPONENT, "handleRequest", "WSAddressing handler determined that WSA is enabled for this message");
        }
        AttributedURI attributedURI = wSAOutboundProperties.getWsaddressingAction();
        RPCContext rPCContext = (RPCContext)((Object)messageContext);
        ActionSpecifier actionSpecifier = new ActionSpecifier(rPCContext);
        String string = rPCContext.getSOAPActionURI();
        if (attributedURI == null) {
            attributedURI = actionSpecifier.getActionForInputMessageFromWSDL();
            wSAOutboundProperties.setWsaddressingAction(attributedURI);
        }
        if (attributedURI == null) {
            throw new JAXRPCException("Unable to establish a value for the mandatory WS-Addressing [action] MAP. Either specify the [action]using the WSADDRESSING_ACTION property or configure the client DII using the service's WSDL");
        }
        String string2 = attributedURI.getURI().toString();
        actionSpecifier.soapActionMustMatch(string, string2);
        MAPWriter mAPWriter = new MAPWriter();
        SOAPHeader sOAPHeader = null;
        try {
            sOAPHeader = mAPWriter.getSOAPHeaderFromMessageContext(sOAPMessageContext);
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.wsaddressing.handlers.WSAddressingClientHandler.handleRequest", "1:220:1.92.1.3", sOAPException);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleRequest", "SOAPException whilst trying to retrieve or add a SOAPHeader to this SOAPMessage.");
            }
            throw new JAXRPCException(sOAPException);
        }
        this.optimiseReplyAndFaultIfPossible((com.ibm.ws.webservices.engine.MessageContext)messageContext, wSAOutboundProperties);
        NamespaceData namespaceData = wSAOutboundProperties.getNamespaceData();
        try {
            mAPWriter.addNamespaceDeclarationToSOAPEnvelope(sOAPMessageContext, namespaceData);
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.wsaddressing.handlers.WSAddressingClientHandler.handleRequest", "1:235:1.92.1.3", sOAPException);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleRequest", "SOAPException whilst trying to add namespace declaration to SOAPEnvelope.");
            }
            throw new JAXRPCException(sOAPException);
        }
        mAPWriter.addPropertiesToSoapHeader(sOAPHeader, wSAOutboundProperties);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "handleRequest", Boolean.TRUE);
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        if (this.isAddressingDisabled(messageContext)) {
            return true;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "handleResponse", messageContext);
        }
        this.processInboundMessage(messageContext);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "handleResponse");
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext) {
        if (this.isAddressingDisabled(messageContext)) {
            return true;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "handleFault", messageContext);
        }
        this.processInboundMessage(messageContext);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "handleFault");
        }
        return true;
    }

    public QName[] getHeaders() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.info(TRACE_COMPONENT, "getHeaders");
        }
        return null;
    }

    private void processInboundMessage(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "processInboundMessage", messageContext);
        }
        if (messageContext instanceof SOAPMessageContext) {
            SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
            MAPReader mAPReader = new MAPReader();
            try {
                if (mAPReader.setMessageContext(sOAPMessageContext)) {
                    mAPReader.addPropertiesToContext();
                }
            }
            catch (InvalidMultipleElementException invalidMultipleElementException) {
                String string = "Check the contents on the SOAPHeader.  An InvalidMultipleElementException was thrown.  This is invalid according to the WS-Addressing Specification." + invalidMultipleElementException.getMessage();
                Tr.warning(TRACE_COMPONENT, string);
                FFDCFilter.processException(invalidMultipleElementException, CLASSNAME, "1:329:1.92.1.3");
            }
            catch (DestinationUnreachableException destinationUnreachableException) {
                String string = "A DestinationUnreachableException was thrown. This occurs when the wsaucf:RoutingInformation relates to a cluster which the processing server is not a memebr of.";
                Tr.warning(TRACE_COMPONENT, string);
                FFDCFilter.processException(destinationUnreachableException, CLASSNAME, "1:334:1.92.1.3");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "processInboundMessage");
        }
    }

    private void optimiseReplyAndFaultIfPossible(com.ibm.ws.webservices.engine.MessageContext messageContext, WSAOutboundProperties wSAOutboundProperties) {
        Object[] objectArray;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            objectArray = new Object[]{messageContext, wSAOutboundProperties};
            Tr.entry(TRACE_COMPONENT, "optimiseReplyAndFaultIfPossible", objectArray);
        }
        objectArray = (Object[])wSAOutboundProperties.getWsaddressingReplyToEpr();
        NamespaceData namespaceData = wSAOutboundProperties.getNamespaceData();
        if (namespaceData != null) {
            Object object;
            Cloneable cloneable;
            block17: {
                if (namespaceData.getNamespace().equals("http://schemas.xmlsoap.org/ws/2004/08/addressing") && !messageContext.isOneWay()) {
                    if (objectArray == null) {
                        cloneable = WSAddressingFactory.createAttributedURI(namespaceData.getAnonymousURI());
                        try {
                            if (TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "optimiseReplyAndFaultIfPossible", "replyTo epr set to 2004_08 anonymous uri");
                            }
                            object = EndpointReferenceManager.createEndpointReference((AttributedURI)cloneable);
                            object.setNamespace(namespaceData.getNamespace());
                            wSAOutboundProperties.setWsaddressingReplyToEpr((EndpointReference)object);
                        }
                        catch (EndpointReferenceCreationException endpointReferenceCreationException) {
                            if (TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "optimiseReplyAndFaultIfPossible", endpointReferenceCreationException);
                            }
                            break block17;
                        }
                        catch (NamespaceNotSupportedException namespaceNotSupportedException) {
                            if (TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "optimiseReplyAndFaultIfPossible", namespaceNotSupportedException);
                            }
                            break block17;
                        }
                    }
                    if (objectArray.getAddress() == null || "".equals(objectArray.getAddress())) {
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "optimiseReplyAndFaultIfPossible", "replyTo address set to 2004_08 anonymous uri");
                        }
                        objectArray.setAddress(WSAddressingFactory.createAttributedURI(namespaceData.getAnonymousURI()));
                        wSAOutboundProperties.setWsaddressingReplyToEpr((EndpointReference)objectArray);
                    }
                }
            }
            if ((cloneable = (com.ibm.ws.wsaddressing.integration.EndpointReference)wSAOutboundProperties.getWsaddressingFaultToEpr()) != null) {
                object = new ReplyHelper((com.ibm.ws.wsaddressing.integration.EndpointReference)objectArray, (com.ibm.ws.wsaddressing.integration.EndpointReference)cloneable, namespaceData);
                if (messageContext.isOneWay() && cloneable.validate() && cloneable.isAnonymousURI()) {
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "optimiseReplyAndFaultIfPossible", "This is a synchronous fault");
                    }
                    wSAOutboundProperties.unsetWsaddressingFaultToEpr();
                }
            }
        } else {
            Tr.warning(TRACE_COMPONENT, "NamespaceData object for the outbound message was null.");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "optimiseReplyAndFaultIfPossible");
        }
    }

    protected boolean addressingDisabledGlobally() {
        return this.wsAddressingDisabled;
    }

    protected void setAddressingDisabledGlobally(boolean bl) {
        this.wsAddressingDisabled = bl;
    }
}

