/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.EndpointReferenceManager;
import com.ibm.ws.wsaddressing.EndpointReferenceManagerImpl;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.handlers.MessageIDGenerator;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.ws.wsaddressing.namespace.NamespaceData200408;
import com.ibm.ws.wsaddressing.namespace.NamespaceData200508;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.NamespaceNotSupportedException;
import com.ibm.wsspi.wsaddressing.Relationship;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Set;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;

public class WSAOutboundProperties {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.handlers.WSAOutboundProperties";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSAOutboundProperties.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    private EndpointReference _wsaddressingDestinationEpr = null;
    private EndpointReference _wsaddressingFromEpr = null;
    private EndpointReference _wsaddressingReplyToEpr = null;
    private EndpointReference _wsaddressingFaultToEpr = null;
    private Set _wsaddressingRelationshipSet = null;
    private AttributedURI _wsaddressingAction = null;
    private AttributedURI _wsaddressingMessageId = null;
    private MessageContext _messageContext = null;
    private boolean _wsaPropertyExists = false;
    private NamespaceData _namespaceData = null;
    private AttributedURI _wsaddressingDestinationURI = null;
    private boolean _mustUnderstand = false;

    public boolean wsaPropertyExists() {
        return this._wsaPropertyExists;
    }

    public boolean setMessageContext(MessageContext messageContext) throws JAXRPCException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setMessageContextandWSAProperties", messageContext);
        }
        this._messageContext = messageContext;
        if (this._messageContext == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "setMessageContextandWSAProperties", Boolean.FALSE);
            }
            return false;
        }
        this.checkWSAPropertiesExist();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setMessageContextandWSAProperties", new Boolean(this._wsaPropertyExists));
        }
        return this._wsaPropertyExists;
    }

    private void checkWSAPropertiesExist() {
        Object object = this._messageContext.getProperty("com.ibm.websphere.wsaddressing.destinationEPR");
        Object object2 = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.relationshipSet");
        Object object3 = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.messageId");
        Object object4 = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.action");
        Object object5 = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.fromEPR");
        Object object6 = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.faultToEPR");
        Object object7 = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.replyToEPR");
        this._wsaPropertyExists = object != null || object2 != null || object3 != null || object4 != null || object5 != null || object6 != null || object7 != null;
    }

    public void setupWSAProperties() throws JAXRPCException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setupWSAProperties");
        }
        this.setNamespaceData(NamespaceData.addOutboundNamespaceDataToContext(this._messageContext));
        this.instantiateAndValidateReplyToEpr();
        this.instantiateAndValidateFaultToEpr();
        this.instantiateAndValidateFromEpr();
        this.instantiateAndValidateActionAuri();
        this.instantiateAndValidateMessageId();
        this.instantiateAndValidateRelationshipSet();
        this.instantiateAndValidateDestinationEpr();
        this.instantiateAndValidateMustUnderstand();
        if (this._wsaPropertyExists) {
            this.ensureDefaultMAPsOnContext(this._messageContext);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setupWSAProperties");
        }
    }

    private void ensureDefaultMAPsOnContext(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "ensureDefaultMAPsOnContext", messageContext);
        }
        if (this._wsaddressingReplyToEpr != null) {
            messageContext.setProperty("com.ibm.wsspi.wsaddressing.replyToEPR", this._wsaddressingReplyToEpr);
        }
        if (this._wsaddressingDestinationEpr != null) {
            messageContext.setProperty("com.ibm.websphere.wsaddressing.destinationEPR", this._wsaddressingDestinationEpr);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "ensureDefaultMAPsOnContext", messageContext);
        }
    }

    public NamespaceData getNamespaceData() {
        return this._namespaceData;
    }

    private void setNamespaceData(NamespaceData namespaceData) {
        this._namespaceData = namespaceData;
    }

    public EndpointReference getWsaddressingReplyToEpr() {
        return this._wsaddressingReplyToEpr;
    }

    public void setWsaddressingReplyToEpr(EndpointReference endpointReference) {
        this._wsaddressingReplyToEpr = endpointReference;
        if (endpointReference != null) {
            this._messageContext.setProperty("com.ibm.wsspi.wsaddressing.replyToEPR", endpointReference);
        }
    }

    protected void setWsaddressingAction(AttributedURI attributedURI) {
        this._wsaddressingAction = attributedURI;
        if (attributedURI != null) {
            this._messageContext.setProperty("com.ibm.wsspi.wsaddressing.action", attributedURI);
        }
    }

    protected void unsetWsaddressingFaultToEpr() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "unsetWsaddressingFaultToEpr", this._wsaddressingFaultToEpr);
        }
        if (((com.ibm.ws.wsaddressing.integration.EndpointReference)this._wsaddressingFaultToEpr).getReferenceParameters().hasNext()) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "unsetWsaddressingFaultToEpr", "wsaddressingFaultToEpr contains ReferenceParameters.");
            }
            AttributedURI attributedURI = WSAddressingFactory.createAttributedURI(this._namespaceData.getAnonymousURI());
            this._wsaddressingFaultToEpr.setAddress(attributedURI);
        } else {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "unsetWsaddressingFaultToEpr", "wsaddressingFaultToEpr has no ReferenceParameters.");
            }
            this._wsaddressingFaultToEpr = null;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "unsetWsaddressingFaultToEpr", this._wsaddressingFaultToEpr);
        }
    }

    public AttributedURI getWsaddressingAction() {
        return this._wsaddressingAction;
    }

    public EndpointReference getWsaddressingDestinationEpr() {
        return this._wsaddressingDestinationEpr;
    }

    public AttributedURI getWsaddressingDestinationURI() {
        return this._wsaddressingDestinationURI;
    }

    public EndpointReference getWsaddressingFaultToEpr() {
        return this._wsaddressingFaultToEpr;
    }

    public EndpointReference getWsaddressingFromEpr() {
        return this._wsaddressingFromEpr;
    }

    public AttributedURI getWsaddressingMessageId() {
        return this._wsaddressingMessageId;
    }

    public Set getWsaddressingRelationshipSet() {
        return this._wsaddressingRelationshipSet;
    }

    public boolean mustUnderstand() {
        return this._mustUnderstand;
    }

    /*
     * Unable to fully structure code
     */
    private void instantiateAndValidateDestinationEpr() {
        if (WSAOutboundProperties.TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr");
        }
        if ((var1_1 = this._messageContext.getProperty("com.ibm.websphere.wsaddressing.destinationEPR")) == null) {
            var2_2 = (com.ibm.ws.webservices.engine.MessageContext)this._messageContext;
            var3_4 = var2_2.getTargetEndpointAddressAsURL();
            if (WSAOutboundProperties.TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", "WSADDRESSING_DESTINATION_EPR not set.  Attempting to use destination " + var3_4);
            }
            var4_5 = null;
            if (var3_4 != null) {
                try {
                    var4_5 = new URI(var3_4.toString());
                }
                catch (URISyntaxException var5_6) {
                    if (WSAOutboundProperties.TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", "Syntax exception setting WSADDRESSING_DESTINATION_EPR for " + var3_4);
                    }
                    var4_5 = this.getAnonIf200408();
                }
            } else {
                var4_5 = this.getAnonIf200408();
            }
            if (var4_5 != null) {
                this._wsaddressingDestinationURI = WSAddressingFactory.createAttributedURI(var4_5);
                try {
                    this._wsaddressingDestinationEpr = EndpointReferenceManagerImpl.createEndpointReference(this._wsaddressingDestinationURI);
                    if (this._namespaceData == null) ** GOTO lbl36
                    this._wsaddressingDestinationEpr.setNamespace(this._namespaceData.getNamespace());
                }
                catch (EndpointReferenceCreationException var5_7) {
                    if (!WSAOutboundProperties.TRACE_COMPONENT.isDebugEnabled()) ** GOTO lbl36
                    Tr.debug(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", "Unexpected Syntax exception setting WSADDRESSING_DESTINATION_EPR" + this._wsaddressingDestinationEpr);
                }
                catch (NamespaceNotSupportedException var5_8) {
                    if (WSAOutboundProperties.TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", "Unable to set namespace on detinationEPR");
                    }
                    throw new JAXRPCException("WSAddressing Configuration Exception : WSADDRESSING_DESTINATION_EPR namespace not recognized");
                }
            } else if (WSAOutboundProperties.TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", "Allowing null WSADDRESSING_DESTINATION_EPR");
            }
lbl36:
            // 7 sources

            if (WSAOutboundProperties.TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", "instantiateAndValidateDestinationEpr" + var4_5);
            }
            return;
        }
        if (!(var1_1 instanceof EndpointReference)) {
            if (WSAOutboundProperties.TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", "WSADDRESSING_DESTINATION_EPR set by application of type " + var1_1.getClass().getName());
            }
            if (WSAOutboundProperties.TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr");
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : WSADDRESSING_DESTINATION_EPR not of type EndpointReference");
        }
        var2_3 = (com.ibm.ws.wsaddressing.integration.EndpointReference)var1_1;
        if (!var2_3.validate()) {
            if (WSAOutboundProperties.TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", "WSADDRESSING_DESTINATION_EPR is not a valid EndpointReference" + var2_3);
            }
            if (WSAOutboundProperties.TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr");
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : invalid WSADDRESSING_DESTINATION_EPR");
        }
        this._wsaddressingDestinationEpr = var2_3;
        this._wsaddressingDestinationURI = this._wsaddressingDestinationEpr.getAddress();
        this._wsaPropertyExists = true;
        if (this._wsaddressingDestinationURI == null || this._wsaddressingDestinationURI.getURI() == null) {
            if (WSAOutboundProperties.TRACE_COMPONENT.isDebugEnabled()) {
                if (this._wsaddressingDestinationURI == null) {
                    Tr.debug(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", "Destination is null.");
                } else {
                    Tr.debug(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", "Destination URL is null.");
                }
            }
            if (WSAOutboundProperties.TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", null);
            }
            throw new JAXRPCException("WSAddressing Configuration Error: Destination EPR has null URI");
        }
        if (WSAOutboundProperties.TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(WSAOutboundProperties.TRACE_COMPONENT, "instantiateAndValidateDestinationEpr", var2_3);
        }
    }

    private void instantiateAndValidateReplyToEpr() {
        Object object;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "instantiateAndValidateReplyToEpr");
        }
        if ((object = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.replyToEPR")) == null) {
            if (this._namespaceData instanceof NamespaceData200508 && this._messageContext.containsProperty("com.ibm.ws.wsaddressing.RedirectRequired")) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Using 200508 and async response. No ReplyTo set so setting to the none URI");
                }
                try {
                    EndpointReference endpointReference;
                    URI uRI = this._namespaceData.getNoneURI();
                    this._wsaddressingReplyToEpr = endpointReference = EndpointReferenceManager.createEndpointReference(uRI);
                }
                catch (NamespaceNotSupportedException namespaceNotSupportedException) {
                    String string = "Caught a NamespaceNotSupportedException: " + namespaceNotSupportedException.getMessage();
                    Tr.warning(TRACE_COMPONENT, string);
                    FFDCFilter.processException(namespaceNotSupportedException, CLASSNAME, "1:535:1.36.1.2");
                }
                catch (EndpointReferenceCreationException endpointReferenceCreationException) {
                    String string = "Caught a EndpointReferenceCreationException: " + endpointReferenceCreationException.getMessage();
                    Tr.warning(TRACE_COMPONENT, string);
                    FFDCFilter.processException(endpointReferenceCreationException, CLASSNAME, "1:540:1.36.1.2");
                }
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateReplyToEpr", "No ReplyTo EPR found. The None URI may have been added if appropriate.");
            }
            return;
        }
        if (!(object instanceof EndpointReference)) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSADDRESSING_REPLYTO_EPR set by application of type " + object.getClass().getName());
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateReplyToEpr");
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : WSADDRESSING_REPLYTO_EPR not of type EndpointReference");
        }
        com.ibm.ws.wsaddressing.integration.EndpointReference endpointReference = (com.ibm.ws.wsaddressing.integration.EndpointReference)object;
        if (!endpointReference.validate()) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSADDRESSING_REPLYTO_EPR is not a valid EndpointReference", endpointReference);
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateReplyToEpr");
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : invalid WSADDRESSING_REPLYTO_EPR");
        }
        this._wsaddressingReplyToEpr = endpointReference;
        this._wsaPropertyExists = true;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "instantiateAndValidateReplyToEpr", endpointReference);
        }
    }

    private void instantiateAndValidateFaultToEpr() {
        Object object;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "instantiateAndValidateFaultToEpr");
        }
        if ((object = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.faultToEPR")) == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateFaultToEpr", null);
            }
            return;
        }
        if (!(object instanceof EndpointReference)) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSADDRESSING_FAULTTO_EPR set by application of type " + object.getClass().getName());
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateFaultToEpr");
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : WSADDRESSING_FAULTTO_EPR not of type EndpointReference");
        }
        com.ibm.ws.wsaddressing.integration.EndpointReference endpointReference = (com.ibm.ws.wsaddressing.integration.EndpointReference)object;
        if (!endpointReference.validate()) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSADDRESSING_FAULTTO_EPR is not a valid EndpointReference", endpointReference);
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateFaultToEpr");
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : invalid WSADDRESSING_FAULTTO_EPR");
        }
        this._wsaddressingFaultToEpr = endpointReference;
        this._wsaPropertyExists = true;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "instantiateAndValidateFaultToEpr", endpointReference);
        }
    }

    private void instantiateAndValidateFromEpr() {
        Object object;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "instantiateAndValidateFromEpr");
        }
        if ((object = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.fromEPR")) == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateFromEpr", null);
            }
            return;
        }
        if (!(object instanceof EndpointReference)) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSADDRESSING_FROM_EPR set by application of type ", object.getClass().getName());
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateFromEpr", object);
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : WSADDRESSING_FROM_EPR not of type EndpointReference");
        }
        com.ibm.ws.wsaddressing.integration.EndpointReference endpointReference = (com.ibm.ws.wsaddressing.integration.EndpointReference)object;
        if (!endpointReference.validate()) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSADDRESSING_FROM_EPR is not a valid EndpointReference");
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateFromEpr", endpointReference);
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : invalid WSADDRESSING_FROM_EPR");
        }
        this._wsaddressingFromEpr = endpointReference;
        this._wsaPropertyExists = true;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "instantiateAndValidateFromEpr", endpointReference);
        }
    }

    private void instantiateAndValidateActionAuri() {
        Object object;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "instantiateAndValidateActionUri");
        }
        if ((object = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.action")) == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateActionAuri", null);
            }
            return;
        }
        if (!(object instanceof AttributedURI)) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSADDRESSING_ACTION set by application of type ", object.getClass().getName());
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateActionAuri", object);
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : WSADDRESSING_ACTION not of type AttributedURI");
        }
        AttributedURI attributedURI = (AttributedURI)object;
        if (attributedURI.getURI() == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSADDRESSING_ACTION does not contain a URI");
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateActionUri", attributedURI);
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : invalid WSADDRESSING_ACTION");
        }
        this._wsaddressingAction = attributedURI;
        this._wsaPropertyExists = true;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "instantiateAndValidateActionUri", attributedURI);
        }
    }

    private void instantiateAndValidateMessageId() {
        Object object;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "instantiateAndValidateMessageId");
        }
        if ((object = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.messageId")) == null) {
            object = WSAddressingFactory.createAttributedURI(URI.create(MessageIDGenerator.newMessageIDAsString()));
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "instantiateAndValidateMessageId. No messageId - found creating own ", object);
            }
        } else {
            if (!(object instanceof AttributedURI)) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "WSADDRESSING_MESSAGE_ID set by application of type ", object.getClass().getName());
                }
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "instantiateAndValidateMessageId", object);
                }
                throw new JAXRPCException("WSAddressing Configuration Exception : WSADDRESSING_MESSAGE_ID not of type URI");
            }
            this._wsaPropertyExists = true;
        }
        this._wsaddressingMessageId = (AttributedURI)object;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "instantiateAndValidateMessageId", object);
        }
    }

    private void instantiateAndValidateRelationshipSet() {
        Object object;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "instantiateAndValidateRelationshipSet");
        }
        if ((object = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.relationshipSet")) == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateRelationshipSet", null);
            }
            return;
        }
        if (!(object instanceof Set)) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSADDRESSING_RELATIONSHIP_SET set by application not of type Set");
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateRelationshipSet", object);
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : WSADDRESSING_RELATIONSHIP_SET not of type Set");
        }
        this._wsaddressingRelationshipSet = (Set)object;
        Iterator iterator = this._wsaddressingRelationshipSet.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Relationship) continue;
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSADDRESSING_RELATIONSHIP_SET entry set by application not of type Relationship");
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "instantiateAndValidateRelationshipSet", e);
            }
            throw new JAXRPCException("WSAddressing Configuration Exception : WSADDRESSING_RELATIONSHIP_SET entry set by application not of type Relationship");
        }
        this._wsaddressingRelationshipSet = (Set)object;
        this._wsaPropertyExists = true;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "instantiateAndValidateRelationshipSet", object);
        }
    }

    private void instantiateAndValidateMustUnderstand() {
        Object object;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "instantiateAndValidateMustUnderstand", this._mustUnderstand ? "true" : "false");
        }
        if ((object = this._messageContext.getProperty("com.ibm.wsspi.wsaddressing.mustunderstand")) == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "instantiateAndValidateMustUnderstand. No mustUnderstand found");
            }
        } else if (!(object instanceof Boolean)) {
            Tr.warning(TRACE_COMPONENT, "instantiateAndValidateMustUnderstand.  MustUnderstand not of type Boolean");
        } else {
            this._mustUnderstand = (Boolean)object;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "instantiateAndValidateMustUnderstand", this._mustUnderstand ? "true" : "false");
        }
    }

    private URI getAnonIf200408() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getAnonIf200408");
        }
        URI uRI = null;
        if (this._namespaceData instanceof NamespaceData200408) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getAnonIf200408", "Setting WSADDRESSING_DESTINATION_EPR to " + this._namespaceData.getAnonymousURI());
            }
            uRI = this._namespaceData.getAnonymousURI();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAnonIf200408 result[" + uRI + "]");
        }
        return uRI;
    }
}

