/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.EndpointReferenceImpl;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.handlers.ReplyHelper;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.Relationship;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;

public class MessagePivot {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.handlers.MessagePivot";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(MessagePivot.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);

    public MessagePivot() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "MessagePivot");
            Tr.exit(TRACE_COMPONENT, "MessagePivot");
        }
    }

    public MessageContext requestBecomesResponse(ReplyHelper replyHelper, MessageContext messageContext) {
        boolean bl;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "requestBecomesResponse", messageContext);
        }
        messageContext.removeProperty("com.ibm.ws.wsaddressing.NoneURI");
        Object object = messageContext.getProperty("com.ibm.websphere.wsaddressing.destinationEPR");
        if (object != null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Destination override found.", object);
            }
            if (object instanceof EndpointReferenceImpl) {
                EndpointReferenceImpl endpointReferenceImpl = (EndpointReferenceImpl)object;
                if (endpointReferenceImpl.isNoneURI()) {
                    messageContext.removeProperty("com.ibm.ws.wsaddressing.RedirectResponse");
                    messageContext.removeProperty("com.ibm.ws.wsaddressing.RedirectRequired");
                    messageContext.setProperty("com.ibm.ws.wsaddressing.NoneResponse", endpointReferenceImpl);
                    messageContext.setProperty("com.ibm.wsspi.wsaddressing.inbound.ReplyToEPR", endpointReferenceImpl);
                } else {
                    messageContext.setProperty("com.ibm.ws.wsaddressing.RedirectResponse", endpointReferenceImpl);
                }
            }
        }
        boolean bl2 = messageContext.getProperty("com.ibm.ws.wsaddressing.RedirectRequired") != null;
        boolean bl3 = bl = messageContext.getProperty("com.ibm.ws.wsaddressing.RedirectResponse") != null;
        if (bl2 && !bl) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Redirect cancelled because no REDIRECT_RESPONSE destination set.");
            }
            bl2 = false;
            messageContext.removeProperty("com.ibm.ws.wsaddressing.RedirectRequired");
        }
        if (bl2) {
            Object object2 = messageContext.getProperty("com.ibm.ws.wsaddressing.RedirectResponse");
            messageContext.setProperty("com.ibm.websphere.wsaddressing.destinationEPR", object2);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.debug(TRACE_COMPONENT, "requestBecomesResponse", "Used REDIRECT_RESPONSE EndpointReference for destination of response");
            }
            this.updateTargetEndpointAddress(messageContext, object2);
        } else if (messageContext.containsProperty("com.ibm.ws.wsaddressing.NoneResponse")) {
            messageContext.setProperty("com.ibm.ws.wsaddressing.NoneURI", "true");
            Object object3 = messageContext.getProperty("com.ibm.wsspi.wsaddressing.inbound.ReplyToEPR");
            messageContext.setProperty("com.ibm.websphere.wsaddressing.destinationEPR", object3);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.debug(TRACE_COMPONENT, "requestBecomesResponse", "NONE_URI found for ReplyTo EndpointReference for destination of response");
            }
        } else {
            EndpointReference endpointReference = replyHelper.getSyncReplyEPR();
            if (endpointReference != null) {
                messageContext.setProperty("com.ibm.websphere.wsaddressing.destinationEPR", endpointReference);
            } else {
                try {
                    endpointReference = replyHelper.getNamespaceData().createAnonymousEPR();
                    messageContext.setProperty("com.ibm.websphere.wsaddressing.destinationEPR", endpointReference);
                }
                catch (EndpointReferenceCreationException endpointReferenceCreationException) {
                    Object[] objectArray = new Object[]{replyHelper, messageContext};
                    FFDCFilter.processException(endpointReferenceCreationException, "com.ibm.ws.wsaddressing.handlers.MessagePivot.requestBecomesResponse", "1:193:1.31", this, objectArray);
                    if (TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(TRACE_COMPONENT, "requestBecomesResponse");
                    }
                    throw new JAXRPCException(endpointReferenceCreationException);
                }
            }
            Object object4 = messageContext.getProperty("com.ibm.wsspi.wsaddressing.inbound.FaultToEPR");
            if (object4 instanceof EndpointReference) {
                Iterator iterator = ((com.ibm.ws.wsaddressing.integration.EndpointReference)object4).getReferenceParameters();
                if (!iterator.hasNext()) {
                    messageContext.removeProperty("com.ibm.wsspi.wsaddressing.inbound.FaultToEPR");
                    messageContext.removeProperty("com.ibm.wsspi.wsaddressing.faultToEPR");
                }
            } else {
                messageContext.removeProperty("com.ibm.wsspi.wsaddressing.inbound.FaultToEPR");
                messageContext.removeProperty("com.ibm.wsspi.wsaddressing.faultToEPR");
            }
        }
        messageContext.removeProperty("com.ibm.wsspi.wsaddressing.inbound.To");
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "requestBecomesResponse", "Inbound wsa:To removed.");
        }
        messageContext.removeProperty("com.ibm.wsspi.wsaddressing.replyToEPR");
        messageContext.removeProperty("com.ibm.wsspi.wsaddressing.inbound.ReplyToEPR");
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "requestBecomesResponse", "Inbound wsa:Reply removed.");
        }
        messageContext.removeProperty("com.ibm.wsspi.wsaddressing.inbound.Action");
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "requestBecomesResponse", "Inbound wsa:Action removed.");
        }
        messageContext.removeProperty("com.ibm.wsspi.wsaddressing.inbound.RelationshipSet");
        this.inboundMessageIdBecomesReplyRelationship(messageContext);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "requestBecomesResponse", messageContext);
        }
        return messageContext;
    }

    private void updateTargetEndpointAddress(MessageContext messageContext, Object object) {
        com.ibm.ws.wsaddressing.integration.EndpointReference endpointReference;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "updateTargetEndpointAddress", new Object[]{messageContext, object});
        }
        if ((endpointReference = (com.ibm.ws.wsaddressing.integration.EndpointReference)object) != null) {
            AttributedURI attributedURI = endpointReference.getAddress();
            if (attributedURI != null) {
                URI uRI = attributedURI.getURI();
                if (uRI != null) {
                    String string = uRI.toString();
                    if (TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "updateTargetEndpointAddress", "Updated address will be : " + string);
                    }
                    ((com.ibm.ws.webservices.engine.MessageContext)messageContext).setTargetEndpointAddress(string);
                } else if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "updateTargetEndpointAddress", "URI in EndpointReference was null.  Unable to update target address.");
                }
            } else if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.debug(TRACE_COMPONENT, "updateTargetEndpointAddress", "AttributedURI in EndpointReference was null.  Unable to update target address.");
            }
        } else if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "updateTargetEndpointAddress", "EndpointReference was null.  Unable to update target address.");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "updateTargetEndpointAddress");
        }
    }

    public MessageContext requestBecomesFault(ReplyHelper replyHelper, MessageContext messageContext) {
        boolean bl;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "requestBecomesFault", messageContext);
        }
        messageContext.removeProperty("com.ibm.ws.wsaddressing.NoneURI");
        Object object = messageContext.getProperty("com.ibm.websphere.wsaddressing.destinationEPR");
        if (object != null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Destination override found.", object);
            }
            if (object instanceof EndpointReferenceImpl) {
                EndpointReferenceImpl endpointReferenceImpl = (EndpointReferenceImpl)object;
                if (endpointReferenceImpl.isNoneURI()) {
                    messageContext.removeProperty("com.ibm.ws.wsaddressing.RedirectFault");
                    messageContext.removeProperty("com.ibm.ws.wsaddressing.RedirectRequired");
                    messageContext.setProperty("com.ibm.ws.wsaddressing.NoneFault", endpointReferenceImpl);
                    messageContext.setProperty("com.ibm.wsspi.wsaddressing.inbound.ReplyToEPR", endpointReferenceImpl);
                } else {
                    messageContext.setProperty("com.ibm.ws.wsaddressing.RedirectFault", endpointReferenceImpl);
                }
            }
        }
        boolean bl2 = messageContext.getProperty("com.ibm.ws.wsaddressing.RedirectRequired") != null;
        boolean bl3 = bl = messageContext.getProperty("com.ibm.ws.wsaddressing.RedirectFault") != null;
        if (bl2 && !bl) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Redirect cancelled because no REDIRECT_FAULT destination set.");
            }
            bl2 = false;
            messageContext.removeProperty("com.ibm.ws.wsaddressing.RedirectRequired");
        }
        if (bl2) {
            Object object2 = messageContext.getProperty("com.ibm.ws.wsaddressing.RedirectFault");
            messageContext.setProperty("com.ibm.websphere.wsaddressing.destinationEPR", object2);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.debug(TRACE_COMPONENT, "requestBecomesFault", "Used REDIRECT_FAULT EndpointReference for destination of fault");
            }
            this.updateTargetEndpointAddress(messageContext, object2);
        } else if (messageContext.containsProperty("com.ibm.ws.wsaddressing.NoneFault")) {
            messageContext.setProperty("com.ibm.ws.wsaddressing.NoneURI", "true");
            Object object3 = messageContext.getProperty("com.ibm.ws.wsaddressing.NoneFault");
            messageContext.setProperty("com.ibm.websphere.wsaddressing.destinationEPR", object3);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.debug(TRACE_COMPONENT, "requestBecomesFault", "NONE_URI found for FaultTo EndpointReference for destination of fault");
            }
        } else {
            EndpointReference endpointReference = replyHelper.getSyncFaultEPR();
            if (endpointReference != null) {
                messageContext.setProperty("com.ibm.websphere.wsaddressing.destinationEPR", endpointReference);
            } else {
                try {
                    endpointReference = replyHelper.getNamespaceData().createAnonymousEPR();
                    messageContext.setProperty("com.ibm.websphere.wsaddressing.destinationEPR", endpointReference);
                }
                catch (EndpointReferenceCreationException endpointReferenceCreationException) {
                    Object[] objectArray = new Object[]{replyHelper, messageContext};
                    FFDCFilter.processException(endpointReferenceCreationException, "com.ibm.ws.wsaddressing.handlers.MessagePivot.requestBecomesFault", "1:410:1.31", this, objectArray);
                    if (TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(TRACE_COMPONENT, "requestBecomesFault");
                    }
                    throw new JAXRPCException(endpointReferenceCreationException);
                }
            }
        }
        messageContext.removeProperty("com.ibm.wsspi.wsaddressing.inbound.To");
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "requestBecomesFault", "Request wsa:To removed.");
        }
        messageContext.removeProperty("com.ibm.wsspi.wsaddressing.replyToEPR");
        messageContext.removeProperty("com.ibm.wsspi.wsaddressing.inbound.ReplyToEPR");
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "requestBecomesFault", "Inbound wsa:Reply removed.");
        }
        this.inboundMessageIdBecomesReplyRelationship(messageContext);
        messageContext.removeProperty("com.ibm.wsspi.wsaddressing.faultToEPR");
        messageContext.removeProperty("com.ibm.wsspi.wsaddressing.inbound.FaultToEPR");
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "requestBecomesFault", "Inbound wsa:FaultTo removed.");
        }
        messageContext.removeProperty("com.ibm.wsspi.wsaddressing.inbound.Action");
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "requestBecomesFault", "Inbound wsa:Action removed.");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "requestBecomesFault", messageContext);
        }
        return messageContext;
    }

    private void inboundMessageIdBecomesReplyRelationship(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "lastMessageIdBecomesReplyRelationship", messageContext);
        }
        if (!messageContext.containsProperty("com.ibm.wsspi.wsaddressing.relationshipSet")) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.debug(TRACE_COMPONENT, "lastMessageIdBecomesReplyRelationship", "no existing outbound WSADDRESSING_RELATIONSHIP_SET");
            }
            Object var2_2 = null;
            Object var3_3 = null;
            Relationship relationship = null;
            Object object = messageContext.getProperty("com.ibm.wsspi.wsaddressing.inbound.MessageID");
            NamespaceData namespaceData = NamespaceData.getNamespaceDataFromContext(messageContext);
            relationship = object instanceof AttributedURI ? WSAddressingFactory.createRelationship(((AttributedURI)object).getURI()) : WSAddressingFactory.createRelationship(namespaceData.getUnspecifiedMessageURI());
            relationship.setRelationshipType(namespaceData.getReplyRelationshipURI());
            HashSet<Relationship> hashSet = new HashSet<Relationship>();
            hashSet.add(relationship);
            messageContext.setProperty("com.ibm.wsspi.wsaddressing.relationshipSet", hashSet);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.debug(TRACE_COMPONENT, "lastMessageIdBecomesReplyRelationship", relationship);
            }
            messageContext.removeProperty("com.ibm.wsspi.wsaddressing.inbound.MessageID");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "lastMessageIdBecomesReplyRelationship", messageContext);
        }
    }
}

