/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.DestinationUnreachableException;
import com.ibm.ws.wsaddressing.InvalidMultipleElementException;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.UCFRoutingHelper;
import com.ibm.ws.wsaddressing.binders.AttributedURIBinder;
import com.ibm.ws.wsaddressing.binders.EndpointReferenceTypeBinder;
import com.ibm.ws.wsaddressing.binders.RelationshipBinder;
import com.ibm.ws.wsaddressing.integration.EndpointReference;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReferenceManager;
import com.ibm.wsspi.wsaddressing.Relationship;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;

public class MAPReader {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(MAPReader.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.handlers.MAPReader";
    private static final String TO = "To";
    private static final String FROM = "From";
    private static final String FAULTTO = "FaultTo";
    private static final String REPLYTO = "ReplyTo";
    private static final String ACTION = "Action";
    private static final String MESSAGEID = "MessageID";
    private static final String RELATESTO = "RelatesTo";
    private NamespaceData _namespaceData;
    private SOAPHeader _soapHeader;
    private SOAPMessageContext _soapMsgContext;
    private AttributedURI messageIDAURI;
    private AttributedURI actionURI;
    private EndpointReference fromEPR;
    private EndpointReference replyToEPR;
    private EndpointReference faultToEPR;
    private Set relationshipSet;
    private AttributedURI toAddress;
    private static AttributedURIBinder _attributedURIBinder = new AttributedURIBinder();
    private static RelationshipBinder _relationshipBinder = new RelationshipBinder();
    private static EndpointReferenceTypeBinder _endpointReferenceTypeBinder = new EndpointReferenceTypeBinder();
    private ArrayList _relatesToSOAPElements = new ArrayList();
    private HashMap _flagMap = new HashMap();
    private HashMap _singleHeaderMap = new HashMap();
    private boolean _wsaPresent = false;

    public boolean setMessageContext(SOAPMessageContext sOAPMessageContext) throws InvalidMultipleElementException, DestinationUnreachableException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setMessageContext", sOAPMessageContext);
        }
        this._soapMsgContext = sOAPMessageContext;
        SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
        if (sOAPMessage != null) {
            try {
                this._soapHeader = sOAPMessage.getSOAPHeader();
            }
            catch (SOAPException sOAPException) {
                String string = "An Exception occurred retrieving the SOAPHeader: " + sOAPException;
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.warning(TRACE_COMPONENT, string);
                }
                FFDCFilter.processException(sOAPException, CLASSNAME, "1:148:1.19");
            }
        }
        if (this._soapHeader == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Object[] objectArray = new Object[]{"SOAPHeader is null"};
                Tr.exit(TRACE_COMPONENT, "setMessageContext", objectArray);
            }
            return false;
        }
        this.processHeaders();
        boolean bl = this.isWSAPresent();
        if (bl) {
            this.removeHeaders();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setMessageContext", new Boolean(bl));
        }
        return bl;
    }

    public NamespaceData getNamespaceData() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getNamespaceData", this._namespaceData);
        }
        return this._namespaceData;
    }

    public void addPropertiesToContext() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addPropertiesToContext");
        }
        this.messageIDAURI = this.deserializeAURI(this.getMessageIDSOAPElement());
        this.setProperty("com.ibm.wsspi.wsaddressing.inbound.MessageID", this.messageIDAURI);
        this.actionURI = this.deserializeAURI(this.getActionSOAPElement());
        this.setProperty("com.ibm.wsspi.wsaddressing.inbound.Action", this.actionURI);
        this.fromEPR = this.deserializeEPR(this.getFromSOAPElement());
        this.setProperty("com.ibm.wsspi.wsaddressing.inbound.FromEPR", this.fromEPR);
        this.replyToEPR = this.deserializeEPR(this.getReplyToSOAPElement());
        this.setProperty("com.ibm.wsspi.wsaddressing.inbound.ReplyToEPR", this.replyToEPR);
        this.faultToEPR = this.deserializeEPR(this.getFaultToSOAPElement());
        this.setProperty("com.ibm.wsspi.wsaddressing.inbound.FaultToEPR", this.faultToEPR);
        this.relationshipSet = this.buildRelationshipSet();
        this.setProperty("com.ibm.wsspi.wsaddressing.inbound.RelationshipSet", this.relationshipSet);
        this.toAddress = this.deserializeAURI(this.getToSOAPElement());
        this.setProperty("com.ibm.wsspi.wsaddressing.inbound.To", this.toAddress);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addPropertiesToContext");
        }
    }

    private void setProperty(String string, Object object) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] objectArray = new Object[]{string, object};
            Tr.entry(TRACE_COMPONENT, "setProperty");
        }
        if (object != null) {
            this._soapMsgContext.setProperty(string, object);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setProperty");
        }
    }

    private void processHeaders() throws InvalidMultipleElementException, DestinationUnreachableException {
        Object object;
        String string;
        Object object2;
        Object object3;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "processHeaders");
        }
        InvalidMultipleElementException invalidMultipleElementException = null;
        Object object4 = null;
        Iterator iterator = this._soapHeader.getChildElements();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            if (!(object3 instanceof SOAPElement)) continue;
            object2 = (SOAPElement)object3;
            string = object2.getLocalName();
            try {
                if (string == null) continue;
                if (string.equals(TO)) {
                    this.addSingleCardinalityHeader(TO, (SOAPElement)object2);
                    continue;
                }
                if (string.equals(REPLYTO)) {
                    this.addSingleCardinalityHeader(REPLYTO, (SOAPElement)object2);
                    continue;
                }
                if (string.equals(FAULTTO)) {
                    this.addSingleCardinalityHeader(FAULTTO, (SOAPElement)object2);
                    continue;
                }
                if (string.equals(ACTION)) {
                    this.addSingleCardinalityHeader(ACTION, (SOAPElement)object2);
                    continue;
                }
                if (string.equals(FROM)) {
                    this.addSingleCardinalityHeader(FROM, (SOAPElement)object2);
                    continue;
                }
                if (string.equals(MESSAGEID)) {
                    this.addSingleCardinalityHeader(MESSAGEID, (SOAPElement)object2);
                    continue;
                }
                if (string.equals(RELATESTO)) {
                    this.addRelatesToSOAPElement((SOAPElement)object2);
                    continue;
                }
                if (!string.equals("RoutingInformation")) continue;
                object4 = object2;
            }
            catch (InvalidMultipleElementException invalidMultipleElementException2) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Multiple " + string + " headers found.");
                }
                invalidMultipleElementException = invalidMultipleElementException2;
            }
        }
        if (invalidMultipleElementException != null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "processHeaders", "Throwing InvalidMultipleElementException caught earlier: " + invalidMultipleElementException);
            }
            throw invalidMultipleElementException;
        }
        object3 = null;
        if (object4 != null) {
            object2 = object4.getChildElements();
            while (object3 == null && object2.hasNext()) {
                string = object2.next();
                if (!(string instanceof SOAPElement)) continue;
                object = (SOAPElement)((Object)string);
                object3 = UCFRoutingHelper.getClusterIdentityFromSOAPElementText((SOAPElement)object);
            }
        }
        if (object3 != null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Cluster Identity found in reference parameter.");
            }
            try {
                object2 = (ClusterMemberService)WsServiceRegistry.getService(this, ClusterMemberService.class);
                boolean bl = object2.getServerClusterContextListener().validateClusterResidency((Identity)object3);
                if (!bl) {
                    object = "This server is not a member of the cluster identified by the wsaucf:RoutingInformation";
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.warning(TRACE_COMPONENT, (String)object);
                    }
                    throw new DestinationUnreachableException();
                }
            }
            catch (DestinationUnreachableException destinationUnreachableException) {
                throw destinationUnreachableException;
            }
            catch (Exception exception) {
                string = "An Exception occurred attempting to access the ClusterMemberService: " + exception;
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.warning(TRACE_COMPONENT, string);
                }
                FFDCFilter.processException(exception, CLASSNAME, "1:342:1.19");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "processHeaders");
        }
    }

    private void removeHeaders() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "processHeaders");
        }
        Iterator iterator = this.getSingleCardinalitySOAPElementIterator();
        while (iterator.hasNext()) {
            this._soapHeader.removeChild((SOAPElement)iterator.next());
        }
        Iterator iterator2 = this.getRelatesToSOAPElementIterator();
        while (iterator2.hasNext()) {
            this._soapHeader.removeChild((SOAPElement)iterator2.next());
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "processHeaders");
        }
    }

    private boolean correctNamespace(SOAPElement sOAPElement) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "correctNamespace", sOAPElement);
        }
        if (this._namespaceData == null) {
            this._namespaceData = NamespaceData.addInboundNamespaceDataToContext(this._soapHeader, this._soapMsgContext);
        }
        boolean bl = sOAPElement.getNamespaceURI().equals(this._namespaceData.getNamespace());
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "correctNamespace", new Boolean(bl));
        }
        return bl;
    }

    private EndpointReference deserializeEPR(SOAPElement sOAPElement) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "deserializeEPR", sOAPElement);
        }
        EndpointReference endpointReference = null;
        if (sOAPElement != null) {
            try {
                endpointReference = (EndpointReference)_endpointReferenceTypeBinder.deserialize(sOAPElement, null);
            }
            catch (SOAPException sOAPException) {
                String string = "An Exception occurred deserializing an EndpointReference: " + sOAPException;
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.warning(TRACE_COMPONENT, string);
                }
                FFDCFilter.processException(sOAPException, CLASSNAME, "1:411:1.19");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "deserializeEPR", endpointReference);
        }
        return endpointReference;
    }

    private AttributedURI deserializeAURI(SOAPElement sOAPElement) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "deserializeAURI", sOAPElement);
        }
        AttributedURI attributedURI = null;
        if (sOAPElement != null) {
            try {
                attributedURI = (AttributedURI)_attributedURIBinder.deserialize(sOAPElement, null);
            }
            catch (SOAPException sOAPException) {
                String string = "An Exception occurred deserializing an AttributedURI: " + sOAPException;
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.warning(TRACE_COMPONENT, string);
                }
                FFDCFilter.processException(sOAPException, CLASSNAME, "1:438:1.19");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "deserializeAURI", attributedURI);
        }
        return attributedURI;
    }

    private URI deserializeURI(SOAPElement sOAPElement) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "deserializeURI", sOAPElement);
        }
        URI uRI = null;
        if (sOAPElement != null) {
            try {
                String string = sOAPElement.getValue();
                if (string != null) {
                    uRI = new URI(string.trim());
                } else {
                    String string2 = "The MessageID SOAPElement did not contain a MessageID";
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.warning(TRACE_COMPONENT, string2);
                    }
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                String string = "An Exception occurred deserializing an URI: " + uRISyntaxException;
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.warning(TRACE_COMPONENT, string);
                }
                FFDCFilter.processException(uRISyntaxException, CLASSNAME, "1:473:1.19");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "deserializeURI", uRI);
        }
        return uRI;
    }

    private Relationship deserializeRelationship(SOAPElement sOAPElement) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "deserializeRelationship", sOAPElement);
        }
        Relationship relationship = null;
        if (sOAPElement != null) {
            try {
                relationship = (Relationship)_relationshipBinder.deserialize(sOAPElement, this._namespaceData);
            }
            catch (SOAPException sOAPException) {
                String string = "An Exception occurred deserializing a Relationship: " + sOAPException;
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.warning(TRACE_COMPONENT, string);
                }
                FFDCFilter.processException(sOAPException, CLASSNAME, "1:499:1.19");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "deserializeRelationship", relationship);
        }
        return relationship;
    }

    private EndpointReference createEPR(AttributedURI attributedURI) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createEPR", attributedURI);
        }
        EndpointReference endpointReference = null;
        if (attributedURI != null) {
            try {
                endpointReference = (EndpointReference)EndpointReferenceManager.createEndpointReference(attributedURI);
            }
            catch (EndpointReferenceCreationException endpointReferenceCreationException) {
                String string = "An Exception occurred creating and EndpointReference: " + endpointReferenceCreationException;
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.warning(TRACE_COMPONENT, string);
                }
                FFDCFilter.processException(endpointReferenceCreationException, CLASSNAME, "1:526:1.19");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createEPR", endpointReference);
        }
        return endpointReference;
    }

    private Set buildRelationshipSet() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "buildRelationshipSet");
        }
        HashSet<Relationship> hashSet = null;
        Iterator iterator = this.getRelatesToSOAPElementIterator();
        while (iterator.hasNext()) {
            SOAPElement sOAPElement = (SOAPElement)iterator.next();
            Relationship relationship = this.deserializeRelationship(sOAPElement);
            if (hashSet == null) {
                hashSet = new HashSet<Relationship>();
            }
            hashSet.add(relationship);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "buildRelationshipSet", hashSet);
        }
        return hashSet;
    }

    public AttributedURI getActionURI() {
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getActionURI", this.actionURI);
        }
        return this.actionURI;
    }

    public EndpointReference getFaultToEPR() {
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getActionURI", this.actionURI);
        }
        return this.faultToEPR;
    }

    public EndpointReference getFromEPR() {
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getFromEPR", this.fromEPR);
        }
        return this.fromEPR;
    }

    public AttributedURI getMessageIDAURI() {
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getMessageIDURI", this.messageIDAURI);
        }
        return this.messageIDAURI;
    }

    public Set getRelationshipSet() {
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getRelationshipSet", this.relationshipSet);
        }
        return this.relationshipSet;
    }

    public EndpointReference getReplyToEPR() {
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getReplyToEPR", this.replyToEPR);
        }
        return this.replyToEPR;
    }

    public AttributedURI getToAddress() {
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getToEPR", this.toAddress);
        }
        return this.toAddress;
    }

    private void addSingleCardinalityHeader(String string, SOAPElement sOAPElement) throws InvalidMultipleElementException {
        Object object;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            object = new Object[]{string, sOAPElement};
            Tr.exit(TRACE_COMPONENT, "addSingleCardinalityHeader", object);
        }
        if (this.correctNamespace(sOAPElement)) {
            object = this._flagMap.get(string);
            if (object == null) {
                this._wsaPresent = true;
                this._flagMap.put(string, Boolean.TRUE);
                this._singleHeaderMap.put(string, sOAPElement);
            } else {
                String string2 = "Multiple elements found with name: " + string + ". Throwing InvalidMultipleElementException";
                this._singleHeaderMap.remove(string);
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "addSingleCardinalityHeader", string2);
                }
                throw new InvalidMultipleElementException(string2, new QName(this._namespaceData.getNamespace(), string));
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addSingleCardinalityHeader");
        }
    }

    private void addRelatesToSOAPElement(SOAPElement sOAPElement) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addRelatesToSOAPElement", sOAPElement);
        }
        if (this.correctNamespace(sOAPElement)) {
            this._relatesToSOAPElements.add(sOAPElement);
            this._wsaPresent = true;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addRelatesToSOAPElement");
        }
    }

    private boolean isWSAPresent() {
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "isWSAPresent", new Boolean(this._wsaPresent));
        }
        return this._wsaPresent;
    }

    private SOAPElement getActionSOAPElement() {
        SOAPElement sOAPElement = (SOAPElement)this._singleHeaderMap.get(ACTION);
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getActionSOAPElement", sOAPElement);
        }
        return sOAPElement;
    }

    private SOAPElement getFaultToSOAPElement() {
        SOAPElement sOAPElement = (SOAPElement)this._singleHeaderMap.get(FAULTTO);
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getFaultToSOAPElement", sOAPElement);
        }
        return sOAPElement;
    }

    private SOAPElement getFromSOAPElement() {
        SOAPElement sOAPElement = (SOAPElement)this._singleHeaderMap.get(FROM);
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getFromSOAPElement", sOAPElement);
        }
        return sOAPElement;
    }

    private SOAPElement getMessageIDSOAPElement() {
        SOAPElement sOAPElement = (SOAPElement)this._singleHeaderMap.get(MESSAGEID);
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getMessageIDSOAPElement", sOAPElement);
        }
        return sOAPElement;
    }

    private Iterator getRelatesToSOAPElementIterator() {
        Iterator iterator = this._relatesToSOAPElements.iterator();
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getRelatesToSOAPElementIterator", iterator);
        }
        return iterator;
    }

    private Iterator getSingleCardinalitySOAPElementIterator() {
        Iterator iterator = this._singleHeaderMap.values().iterator();
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getSingleCardinalitySOAPElementIterator", iterator);
        }
        return iterator;
    }

    private SOAPElement getReplyToSOAPElement() {
        SOAPElement sOAPElement = (SOAPElement)this._singleHeaderMap.get(REPLYTO);
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getReplyToSOAPElement", sOAPElement);
        }
        return sOAPElement;
    }

    private SOAPElement getToSOAPElement() {
        SOAPElement sOAPElement = (SOAPElement)this._singleHeaderMap.get(TO);
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getToSOAPElement", sOAPElement);
        }
        return sOAPElement;
    }
}

