/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.websphere.wsaddressing.ReferenceParameterCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.wsaddressing.Constants;
import com.ibm.ws.wsaddressing.EndpointReferenceImpl;
import com.ibm.ws.wsaddressing.EndpointReferenceManager;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.binders.EndpointReferenceTypeBinder;
import com.ibm.ws.wsaddressing.integration.EndpointMap;
import com.ibm.ws.wsaddressing.integration.Registry;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.ws.wsaddressing.namespace.NamespaceData200408;
import com.ibm.ws.wsaddressing.urimap.PortURIManager;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.adapter.IdentityMapping;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.Metadata;
import com.ibm.wsspi.wsaddressing.ServiceName;
import com.ibm.wsspi.wsaddressing.URIGenerationException;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.io.Serializable;
import java.net.URI;
import java.rmi.Remote;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Attr;

public class EndpointReferenceManagerImpl
extends EndpointReferenceManager {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.EndpointReferenceManagerImpl";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSAddressingFactory.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);

    public com.ibm.websphere.wsaddressing.EndpointReference createConcreteEndpointReference(QName qName, String string) throws EndpointReferenceCreationException {
        Object object;
        Serializable serializable;
        Object[] objectArray;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            objectArray = new Object[]{qName, string};
            Tr.entry(TRACE_COMPONENT, "createConcreteEndpointReference", objectArray);
        }
        if (qName == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", "Service passed to createEndpointReference was null");
            }
            throw new EndpointReferenceCreationException("Service Name specified was null");
        }
        if (string == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", "Port name passed to createEndpointReference was null");
            }
            throw new EndpointReferenceCreationException("Port name specified was null");
        }
        objectArray = qName.getLocalPart();
        QName qName2 = new QName(qName.getNamespaceURI(), string);
        EndpointMap endpointMap = Registry.getCombinedEndpointMap();
        boolean bl = false;
        URI uRI = null;
        try {
            uRI = PortURIManager.getSOAPAddressForPort((String)objectArray, qName2);
            serializable = endpointMap.getSOAPAddressForPort((String)objectArray, qName2);
            if (uRI == null) {
                uRI = serializable;
                bl = true;
            } else if (serializable != null) {
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", "Unique URI for port could not be found");
                }
                throw new EndpointReferenceCreationException("The desired target endpoint has been deployed with multiple addresses.  Unable to determine a unique address URI for EndpointReference creation.");
            }
        }
        catch (URIGenerationException uRIGenerationException) {
            String string2 = "Check the serviceName and endpointName.  An EndpointReferenceCreationException was thrown. " + uRIGenerationException.getMessage();
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", string2);
            }
            FFDCFilter.processException(uRIGenerationException, CLASSNAME, "1:187:1.46");
            throw new EndpointReferenceCreationException(uRIGenerationException);
        }
        if (uRI == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", "URI for port could not be found");
            }
            throw new EndpointReferenceCreationException("URI for port could not be found");
        }
        serializable = WSAddressingFactory.createAttributedURI(uRI);
        EndpointReferenceImpl endpointReferenceImpl = null;
        if (serializable == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", "AttributedURI is null");
            }
            throw new EndpointReferenceCreationException("AttributedURI is null");
        }
        if (serializable.getURI() == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", "AttributedURI is null");
            }
            throw new EndpointReferenceCreationException("URI in AttributedURI is null");
        }
        try {
            endpointReferenceImpl = (EndpointReferenceImpl)EndpointReferenceManager.createEndpointReference((AttributedURI)serializable);
            if (qName != null) {
                Metadata metadata2 = WSAddressingFactory.createMetadata();
                object = WSAddressingFactory.createServiceName(qName);
                if (string != null) {
                    object.setEndpointName(string);
                }
                metadata2.setServiceName((ServiceName)object);
                endpointReferenceImpl.setMetadata(metadata2);
            }
        }
        catch (EndpointReferenceCreationException endpointReferenceCreationException) {
            String string3 = "Check the serviceName and endpointName.  An EndpointReferenceCreationException was thrown. " + endpointReferenceCreationException.getMessage();
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", string3);
            }
            FFDCFilter.processException(endpointReferenceCreationException, CLASSNAME, "1:247:1.46");
            throw new EndpointReferenceCreationException(endpointReferenceCreationException);
        }
        boolean bl2 = false;
        object = null;
        if (!bl) {
            bl2 = PortURIManager.intermediaryConfigured((String)objectArray, qName2);
            object = PortURIManager.getVirtualHostForPort((String)objectArray, qName2);
        } else {
            bl2 = Registry.getCombinedEndpointMap().intermediaryConfigured((String)objectArray, qName2);
            object = Registry.getCombinedEndpointMap().getVirtualHostForPort((String)objectArray, qName2);
        }
        if (bl2) {
            endpointReferenceImpl.setIntermediaryPresentReferenceParameter();
        }
        endpointReferenceImpl.setVirtualHostName((String)object);
        boolean bl3 = endpointMap.workLoadManaged((String)objectArray, qName2);
        if (bl3) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "createConcreteEndpointReference", "Set wlm details");
            }
            try {
                Server server = (Server)WsServiceRegistry.getService(Server.class, Server.class);
                String string4 = server.getCellName();
                String string5 = server.getClusterName();
                Identity identity = IdentityMapping.getApplicationServerCluster(string4, string5);
                if (identity != null) {
                    endpointReferenceImpl.setRoutingKey(Constants.WLM_ROUTING_KEY, identity);
                }
            }
            catch (Exception exception) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "createConcreteEndpointReference", "Unable to obtain clusterId :" + exception);
                }
                FFDCFilter.processException(exception, CLASSNAME, "1:1.46:297");
            }
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "createConcreteEndpointReference", "No setting of wlm details");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", endpointReferenceImpl);
        }
        return endpointReferenceImpl;
    }

    protected com.ibm.websphere.wsaddressing.EndpointReference createConcreteEndpointReference(QName qName, String string, Remote remote) throws EndpointReferenceCreationException {
        Object[] objectArray;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            objectArray = new Object[]{qName, string, remote};
            Tr.entry(TRACE_COMPONENT, "createConcreteEndpointReference", objectArray);
        }
        objectArray = (Object[])this.createConcreteEndpointReference(qName, string);
        objectArray.setSFSBAffinity(remote);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", objectArray);
        }
        return objectArray;
    }

    public EndpointReference createConcreteEndpointReference(SOAPElement sOAPElement) throws EndpointReferenceCreationException {
        EndpointReference endpointReference = null;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createConcreteEndpointReference", sOAPElement);
        }
        EndpointReferenceTypeBinder endpointReferenceTypeBinder = new EndpointReferenceTypeBinder();
        try {
            endpointReference = (EndpointReference)endpointReferenceTypeBinder.deserialize(sOAPElement, null);
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException(sOAPException, EndpointReferenceManagerImpl.class.getName() + ".EndpointReferenceManagerImpl", "1:370:1.46");
            throw new EndpointReferenceCreationException("SOAPException thrown during de-serialization of EPR", sOAPException);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", endpointReference);
        }
        return endpointReference;
    }

    public String getConcreteReferenceParameterFromMessageContext(QName qName) throws ReferenceParameterCreationException {
        com.ibm.ws.webservices.engine.MessageContext messageContext;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getReferenceParameterFromMessageContext", qName);
        }
        if ((messageContext = com.ibm.ws.webservices.engine.MessageContext.getCurrentThreadsContext()) == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromMessageContext", "Thread Message Context is null. Returning null.");
            }
            return null;
        }
        String string = this.getReferenceParameterFromMessageContextObject(messageContext, qName);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromMessageContext", string);
        }
        return string;
    }

    protected EndpointReference createConcreteEndpointReference(URI uRI) throws EndpointReferenceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createConcreteEndpointReference", uRI);
        }
        if (uRI == null) {
            throw new EndpointReferenceCreationException("Unable to create EndpointReference: Null address passed to method");
        }
        EndpointReference endpointReference = null;
        AttributedURI attributedURI = WSAddressingFactory.createAttributedURI(uRI);
        endpointReference = this.createConcreteEndpointReference(attributedURI);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", endpointReference);
        }
        return endpointReference;
    }

    protected EndpointReference createConcreteEndpointReference(AttributedURI attributedURI) throws EndpointReferenceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createConcreteEndpointReference", attributedURI);
        }
        EndpointReferenceImpl endpointReferenceImpl = null;
        if (attributedURI == null) {
            throw new EndpointReferenceCreationException("Unable to create EndpointReference: Null address passed to method");
        }
        endpointReferenceImpl = new EndpointReferenceImpl(attributedURI);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", endpointReferenceImpl);
        }
        return endpointReferenceImpl;
    }

    protected String getConcreteReferenceParameterFromSpecificMessageContext(MessageContext messageContext, QName qName) throws ReferenceParameterCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getConcreteReferenceParameterFromSpecificMessageContext", new Object[]{messageContext, qName});
        }
        String string = this.getReferenceParameterFromMessageContextObject(messageContext, qName);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getConcreteReferenceParameterFromSpecificMessageContext", string);
        }
        return string;
    }

    protected SOAPElement getConcreteSOAPElementReferenceParameterFromSpecificMessageContext(MessageContext messageContext, QName qName) throws ReferenceParameterCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getConcreteSOAPElementReferenceParameterFromSpecificMessageContext", new Object[]{messageContext, qName});
        }
        SOAPElement sOAPElement = this.getSOAPElementReferenceParameterFromMessageContextObject(messageContext, qName);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getConcreteSOAPElementReferenceParameterFromSpecificMessageContext", sOAPElement);
        }
        return sOAPElement;
    }

    protected SOAPElement getConcreteSOAPElementReferenceParameterFromMessageContext(QName qName) throws ReferenceParameterCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getConcreteSOAPElementReferenceParameterFromMessageContext", new Object[]{qName});
        }
        com.ibm.ws.webservices.engine.MessageContext messageContext = com.ibm.ws.webservices.engine.MessageContext.getCurrentThreadsContext();
        SOAPElement sOAPElement = this.getSOAPElementReferenceParameterFromMessageContextObject(messageContext, qName);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getConcreteSOAPElementReferenceParameterFromMessageContext", sOAPElement);
        }
        return sOAPElement;
    }

    private SOAPElement getSOAPElementReferenceParameterFromMessageContextObject(MessageContext messageContext, QName qName) throws ReferenceParameterCreationException {
        Serializable serializable;
        Object object;
        Object object2;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContextObject", qName);
        }
        if (qName == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContextObject", "ReferenceParameter QName supplied was null. Throwing ReferenceParameterCreationException");
            }
            throw new ReferenceParameterCreationException("ReferenceParameter QName supplied was null.");
        }
        SOAPElement sOAPElement = null;
        if (!(messageContext instanceof SOAPMessageContext)) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContextObject", "MessageContext is not an instance of SOAPMessageContext. Throwing ReferenceParameterCreationException");
            }
            throw new ReferenceParameterCreationException("MessageContext is not an instance of SOAPMessageContext");
        }
        javax.xml.soap.SOAPHeader sOAPHeader = null;
        Name name = null;
        try {
            object2 = (SOAPMessageContext)messageContext;
            object = object2.getMessage();
            sOAPHeader = ((SOAPMessage)object).getSOAPHeader();
            serializable = ((SOAPHeader)sOAPHeader).getSOAPFactory();
            name = ((SOAPFactory)((Object)serializable)).createName(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, EndpointReferenceManagerImpl.class.getName() + ".EndpointReferenceManagerImpl", "1:594:1.46", new Object[]{qName});
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContextObject", "SOAPException caught creating Name object. Throwing ReferenceParameterCreationException");
            }
            throw new ReferenceParameterCreationException(sOAPException);
        }
        object2 = sOAPHeader.getChildElements(name);
        if (object2.hasNext()) {
            object = (SOAPElement)object2.next();
            serializable = NamespaceData.getNamespaceDataFromContext(messageContext);
            boolean bl = serializable instanceof NamespaceData200408;
            Attr attr = null;
            Name name2 = ((NamespaceData)serializable).getwsaIsReferenceParameter();
            if (serializable != null) {
                attr = object.getAttributeNodeNS(name2.getURI(), name2.getLocalName());
            }
            if (bl || attr != null && (attr.getValue().equals("true") || attr.getValue().equals("1"))) {
                Iterator iterator = object.getChildElements();
                if (!iterator.hasNext()) {
                    if (TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContextObject", new Object[]{"No Child Elements", iterator});
                    }
                    return null;
                }
                sOAPElement = (SOAPElement)iterator.next();
                if (iterator.hasNext() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Element with specified QName has multiple children.", qName);
                }
            }
        }
        if (object2.hasNext() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Multiple reference parameters exist with the same name", qName);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContextObject", sOAPElement);
        }
        return sOAPElement;
    }

    private String getReferenceParameterFromMessageContextObject(MessageContext messageContext, QName qName) throws ReferenceParameterCreationException {
        Object object;
        Object object2;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getReferenceParameterFromMessageContextObject", new Object[]{messageContext, qName});
        }
        String string = null;
        if (messageContext == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromMessageContextObject", "MessageContext to be searched for ReferenceParameter is null. Throwing ReferenceParameterCreationException");
            }
            throw new ReferenceParameterCreationException("MessageContext to be searched for ReferenceParameter is null");
        }
        if (!(messageContext instanceof SOAPMessageContext)) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromMessageContextObject", "MessageContext is not an instance of SOAPMessageContext. Throwing ReferenceParameterCreationException");
            }
            throw new ReferenceParameterCreationException("MessageContext is not an instance of SOAPMessageContext");
        }
        if (qName == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromMessageContextObject", "QName for RefgerenceParameter is null. Throwing ReferenceParameterCreationException");
            }
            throw new ReferenceParameterCreationException("QName for RefgerenceParameter is null");
        }
        javax.xml.soap.SOAPHeader sOAPHeader = null;
        SOAPFactory sOAPFactory = null;
        Name name = null;
        try {
            object2 = (SOAPMessageContext)messageContext;
            object = object2.getMessage();
            sOAPHeader = ((SOAPMessage)object).getSOAPHeader();
            sOAPFactory = SOAPFactory.newInstance();
            name = sOAPFactory.createName(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, EndpointReferenceManagerImpl.class.getName() + ".EndpointReferenceManagerImpl", "1:737:1.46", new Object[]{qName});
            throw new ReferenceParameterCreationException(sOAPException);
        }
        object2 = sOAPHeader.getChildElements(name);
        if (object2.hasNext()) {
            object = (SOAPElement)object2.next();
            Name name2 = NamespaceData.getNamespaceDataFromContext(messageContext).getwsaIsReferenceParameter();
            Attr attr = null;
            if (name2 != null) {
                attr = object.getAttributeNodeNS(name2.getURI(), name2.getLocalName());
            }
            if (name2 == null || attr != null && (attr.getValue().equals("true") || attr.getValue().equals("1"))) {
                string = object.getValue();
            }
        }
        if (object2.hasNext() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Multiple reference parameters exist with the same name", qName);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromMessageContextObject", string);
        }
        return string;
    }

    protected URI getConcreteURIForEndpoint(QName qName, String string) throws URIGenerationException {
        Object[] objectArray;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            objectArray = new Object[]{qName, string};
            Tr.entry(TRACE_COMPONENT, "getConcreteURIForEndpoint", objectArray);
        }
        if (qName == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getConcreteURIForEndpoint", "Service passed to getConcreteURIForEndpoint was null");
            }
            throw new URIGenerationException("Service Name specified was null");
        }
        if (string == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getConcreteURIForEndpoint", "Port name passed to getConcreteURIForEndpoint was null");
            }
            throw new URIGenerationException("Port name specified was null");
        }
        objectArray = qName.getLocalPart();
        QName qName2 = new QName(qName.getNamespaceURI(), string);
        URI uRI = Registry.getCombinedEndpointMap().getSOAPAddressForPort(qName.getLocalPart(), new QName(qName.getNamespaceURI(), string));
        URI uRI2 = PortURIManager.getSOAPAddressForPort((String)objectArray, qName2);
        if (uRI2 == null) {
            uRI2 = uRI;
        } else if (uRI != null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createConcreteEndpointReference", "Unique URI for service, endpoint could not be found");
            }
            throw new URIGenerationException("The desired target endpoint has been deployed with multiple addresses.  Unable to determine a unique address URI for EndpointReference creation.");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getConcreteURIForEndpoint", uRI2);
        }
        return uRI2;
    }
}

