/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wlm.threadmanager;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ThreadPool;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class SleeperThreadPool
implements Runnable {
    private static final TraceComponent tc = Tr.register(SleeperThreadPool.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private ThreadPool tPool = null;
    private SortedSet order = new TreeSet();

    public SleeperThreadPool(ThreadPool threadPool) {
        this.tPool = threadPool;
    }

    public int getMinimumPoolSize() {
        return this.tPool.getMinimumPoolSize();
    }

    public void setMinimumPoolSize(int n) {
        this.tPool.setMinimumPoolSize(n);
    }

    public int getMaximumPoolSize() {
        return this.tPool.getMaximumPoolSize();
    }

    public void setMaximumPoolSize(int n) {
        this.tPool.setMaximumPoolSize(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Run(Runnable runnable) {
        SortedSet sortedSet = this.order;
        synchronized (sortedSet) {
            this.order.add(new TimedQueueEntry(runnable, 0L));
            this.order.notifyAll();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SleeperThreadPool TreeSet size is (in Run)" + this.order.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RunInTimeOrder(Runnable runnable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RunInTimeOrder");
        }
        SortedSet sortedSet = this.order;
        synchronized (sortedSet) {
            this.order.add(new TimedQueueEntry(runnable));
            this.order.notifyAll();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SleeperThreadPool TreeSet size is " + this.order.size());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RunInTimeOrder");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RunInTimeOrder(Runnable runnable, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RunInTimeOrder", String.valueOf(n));
        }
        SortedSet sortedSet = this.order;
        synchronized (sortedSet) {
            this.order.add(new TimedQueueEntry(runnable, System.currentTimeMillis() + (long)n));
            this.order.notifyAll();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SleeperThreadPool TreeSet size is " + this.order.size());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RunInTimeOrder");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RunAfterLast(Runnable runnable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RunAfterLast");
        }
        SortedSet sortedSet = this.order;
        synchronized (sortedSet) {
            if (this.order.isEmpty()) {
                this.order.add(new TimedQueueEntry(runnable));
            } else {
                TimedQueueEntry timedQueueEntry = (TimedQueueEntry)this.order.last();
                this.order.add(new TimedQueueEntry(runnable, timedQueueEntry.dTime + 1L));
            }
            this.order.notifyAll();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SleeperThreadPool TreeSet size is " + this.order.size());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RunAfterLast");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RunAfterLast(Runnable runnable, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RunAfterLast", String.valueOf(n));
        }
        SortedSet sortedSet = this.order;
        synchronized (sortedSet) {
            if (this.order.isEmpty()) {
                this.order.add(new TimedQueueEntry(runnable, n));
            } else {
                TimedQueueEntry timedQueueEntry = (TimedQueueEntry)this.order.last();
                this.order.add(new TimedQueueEntry(runnable, timedQueueEntry.dTime + (long)n));
            }
            this.order.notifyAll();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SleeperThreadPool TreeSet size is " + this.order.size());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RunAfterLast");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "run", this.tPool);
        }
        while (true) {
            try {
                while (true) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking for commands to execute", this);
                    }
                    boolean bl = false;
                    TimedQueueEntry timedQueueEntry = null;
                    SortedSet sortedSet = this.order;
                    synchronized (sortedSet) {
                        if (this.order.isEmpty()) {
                            this.order.wait();
                        } else {
                            timedQueueEntry = (TimedQueueEntry)this.order.first();
                            long l = timedQueueEntry.dTime - System.currentTimeMillis();
                            if (l > 0L) {
                                this.order.wait(l);
                            } else {
                                boolean bl2 = this.order.remove(timedQueueEntry);
                                bl = true;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "SleeperThreadPool TreeSet size is " + this.order.size());
                                }
                                if (!bl2) {
                                    FFDCFilter.processException(new IllegalArgumentException("First command was not removed from order tree"), (class$com$ibm$ws$wlm$threadmanager$SleeperThreadPool == null ? SleeperThreadPool.class$("com.ibm.ws.wlm.threadmanager.SleeperThreadPool") : class$com$ibm$ws$wlm$threadmanager$SleeperThreadPool) + "run", "276");
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Unexpected: Command was not removed from the tree set " + timedQueueEntry);
                                        TimedQueueEntry timedQueueEntry2 = null;
                                        Iterator iterator = this.order.iterator();
                                        while (timedQueueEntry2 == null && iterator.hasNext()) {
                                            TimedQueueEntry timedQueueEntry3 = (TimedQueueEntry)iterator.next();
                                            if (timedQueueEntry.compareTo(timedQueueEntry3) <= 0) continue;
                                            timedQueueEntry2 = timedQueueEntry3;
                                        }
                                        if (timedQueueEntry2 == null) {
                                            Tr.debug(tc, "Unexpected: No Corrupted Node Found");
                                        } else {
                                            Tr.debug(tc, "Unexpected: Corruption of SleeperThreadPool - TQE[" + timedQueueEntry2 + ", hashCode=" + timedQueueEntry2.hashCode() + "] < Minimum TQE[" + timedQueueEntry + ", hashCode=" + timedQueueEntry2.hashCode() + "]");
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (!bl || timedQueueEntry == null) continue;
                    this.tPool.execute(timedQueueEntry.command);
                }
            }
            catch (Exception exception) {
                if (!tc.isEventEnabled()) continue;
                Tr.debug(tc, "unexpected exception in thread", exception);
                continue;
            }
            break;
        }
    }

    public final int getLongestSleepTime() {
        if (this.order.isEmpty()) {
            return 0;
        }
        long l = ((TimedQueueEntry)this.order.last()).dTime;
        return (int)(l - System.currentTimeMillis());
    }

    public final int queueLength() {
        return this.order.size();
    }

    public int getNumberOfFreeThread() {
        return this.tPool.getMaximumPoolSize() - this.tPool.getPoolSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inQueue(Runnable runnable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "inQueue", runnable);
        }
        boolean bl = false;
        SortedSet sortedSet = this.order;
        synchronized (sortedSet) {
            Iterator iterator = this.order.iterator();
            while (iterator.hasNext()) {
                TimedQueueEntry timedQueueEntry = (TimedQueueEntry)iterator.next();
                if (!timedQueueEntry.command.equals(runnable)) continue;
                bl = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "inQueue", String.valueOf(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        SortedSet sortedSet = this.order;
        synchronized (sortedSet) {
            stringBuffer.append(this.order);
        }
        return stringBuffer.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.13 ");
        }
    }

    private class TimedQueueEntry
    implements Comparable {
        long dTime;
        Runnable command;

        TimedQueueEntry(Runnable runnable) {
            this(runnable, System.currentTimeMillis());
        }

        TimedQueueEntry(Runnable runnable, long l) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "TimedQueueEntry.<init>", String.valueOf(l) + " : " + runnable);
            }
            this.dTime = l;
            this.command = runnable;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "TimedQueueEntry.<init>");
            }
        }

        public String toString() {
            return "delta sleep time (ms)= " + this.dTime + " : Runnable command=" + this.command;
        }

        public int compareTo(Object object) {
            int n;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "compareTo");
            }
            TimedQueueEntry timedQueueEntry = (TimedQueueEntry)object;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "compareTo", new Object[]{new Long(this.dTime), new Long(timedQueueEntry.dTime)});
            }
            if (this.command.equals(timedQueueEntry.command)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "compareTo", "0");
                }
                return 0;
            }
            long l = this.dTime - timedQueueEntry.dTime;
            if (l == 0L && !this.command.equals(timedQueueEntry.command) && (l = (long)this.command.hashCode() - (long)timedQueueEntry.command.hashCode()) == 0L) {
                l = -1L;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "hashcodes and times are identical.");
                }
            }
            int n2 = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (n = l < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)l);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "compareTo", String.valueOf(n));
            }
            return n;
        }
    }
}

