/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wlm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;

public final class TypeConversion {
    private static final TraceComponent tc = Tr.register(TypeConversion.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final int CONVERSION_CONSTANT = 65536;

    public static int bytesToInt(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = n; i < n + 4; ++i) {
            n2 <<= 8;
            n2 |= byArray[i] & 0xFF;
        }
        return n2;
    }

    public static short bytesToShort(byte[] byArray, int n) {
        short s = 0;
        for (int i = n; i < n + 2; ++i) {
            s = (short)(s << 8);
            s = (short)(s | byArray[i] & 0xFF);
        }
        return s;
    }

    public static long bytesTolong(byte[] byArray, int n) {
        long l = 0L;
        for (int i = n; i < n + 8; ++i) {
            l <<= 8;
            l |= (long)byArray[i] & 0xFFL;
        }
        return l;
    }

    public static char[] bytesToChar(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)byArray[i];
        }
        return cArray;
    }

    public static byte[] charToBytes(char[] cArray) {
        int n = cArray.length;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    public static void intToBytes(int n, byte[] byArray, int n2) {
        for (int i = n2 + 3; i >= n2; --i) {
            byArray[i] = (byte)n;
            n >>= 8;
        }
    }

    public static void shortToBytes(short s, byte[] byArray, int n) {
        for (int i = n + 1; i >= n; --i) {
            byArray[i] = (byte)s;
            s = (short)(s >> 8);
        }
    }

    public static void longToBytes(long l, byte[] byArray, int n) {
        for (int i = n + 7; i >= n; --i) {
            byArray[i] = (byte)l;
            l >>= 8;
        }
    }

    public static int shortToInt(short n) {
        int n2 = n;
        if (n2 < 0) {
            n2 = 65536 + n2;
        }
        return n2;
    }

    public static byte[] doubleToSingleBytes(byte[][] byArray) {
        if (byArray.length == 0) {
            return new byte[0];
        }
        int n = 4;
        for (int i = 0; i < byArray.length; ++i) {
            n += byArray[i].length + 4;
        }
        byte[] byArray2 = new byte[n];
        TypeConversion.intToBytes(byArray.length, byArray2, 0);
        int n2 = 4;
        for (int i = 0; i < byArray.length; ++i) {
            int n3 = byArray[i].length;
            TypeConversion.intToBytes(n3, byArray2, n2);
            System.arraycopy(byArray[i], 0, byArray2, n2 += 4, n3);
            n2 += n3;
        }
        return byArray2;
    }

    public static byte[][] singleToDoubleBytes(byte[] byArray) {
        int n = byArray.length == 0 ? 0 : TypeConversion.bytesToInt(byArray, 0);
        byte[][] byArrayArray = new byte[n][];
        int n2 = 4;
        for (int i = 0; i < n; ++i) {
            int n3 = TypeConversion.bytesToInt(byArray, n2);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2 += 4, byArray2, 0, n3);
            n2 += n3;
            byArrayArray[i] = byArray2;
        }
        return byArrayArray;
    }

    public static byte[] stringsToBytes(String[] stringArray) {
        byte[] byArray = new byte[]{(byte)stringArray.length};
        for (int i = 0; i < stringArray.length; ++i) {
            byte[] byArray2 = stringArray[i].getBytes();
            byte[] byArray3 = new byte[byArray2.length + byArray.length + 4];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            TypeConversion.intToBytes(byArray2.length, byArray3, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length + 4, byArray2.length);
            byArray = byArray3;
        }
        return byArray;
    }

    public static String[] bytesToStrings(byte[] byArray) {
        String[] stringArray = new String[byArray[0]];
        int n = 1;
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = TypeConversion.bytesToInt(byArray, n);
            stringArray[i] = new String(byArray, n += 4, n2);
            n += n2;
        }
        return stringArray;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.8 ");
        }
    }
}

