/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.wsdl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.deploy.CacheDeployUtils;
import com.ibm.ws.websvcs.deploy.CacheRootDirectoryTLS;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.websvcs.utils.WebServicesModuleCache;
import com.ibm.ws.websvcs.utils.WebServicesModuleCacheMgr;
import com.sun.tools.ws.spi.WSToolsObjectFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.jaxws.description.builder.WsdlComposite;
import org.apache.axis2.jaxws.description.builder.WsdlGenerator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASWSDLGenerator
implements Constants,
WsdlGenerator {
    private static final TraceComponent _tc = Tr.register(WASWSDLGenerator.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private String classPath;
    private final String outputDirectory;
    private String localOutputDirectory;
    private String applicationName;
    private String moduleName;
    private ModuleFile moduleFile;
    private WebServicesModuleCache cache;

    public WASWSDLGenerator(String string, String string2, ModuleFile moduleFile) {
        this.outputDirectory = string;
        this.applicationName = string2;
        this.moduleFile = moduleFile;
        this.moduleName = moduleFile.getName();
    }

    @Override
    public WsdlComposite generateWsdl(String string, String string2) throws WebServiceException {
        String string3;
        this.classPath = Axis2Utils.getWsGenClassPath(this.moduleFile);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "For implementation class " + string + " in module " + this.moduleName + " WsGen classpath: " + this.classPath);
        }
        this.localOutputDirectory = (string3 = CacheRootDirectoryTLS.get()) != null ? string3 + string : this.outputDirectory + string;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Output directory for generated WSDL file: " + this.localOutputDirectory);
        }
        String string4 = this.applicationName + File.separator + this.moduleName + File.separator + string;
        this.cache = WebServicesModuleCacheMgr.getModuleCache(string4);
        WsdlComposite wsdlComposite = new WsdlComposite();
        boolean bl = false;
        try {
            block17: {
                String[] stringArray;
                HashMap<String, OMDocument> hashMap;
                HashMap<String, Definition> hashMap2;
                if (this.cache.exists()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Found cached WSDL Definition");
                    }
                    try {
                        this.cache.load();
                        hashMap2 = this.cache.getWsdlDefinitionMap();
                        String string5 = this.cache.getWsdlFileName();
                        hashMap = this.readInSchema();
                        wsdlComposite.setSchemaMap(hashMap);
                        wsdlComposite.setWsdlDefinition(hashMap2);
                        wsdlComposite.setWsdlFileName(string5);
                    }
                    catch (Throwable throwable) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Tried to read WSDL from cache but the following problem was detected: " + throwable.toString());
                        }
                        if ((stringArray = new File(string4)) != null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Deleting invalid WSDL cache for application: " + this.applicationName + " moudle: " + this.moduleName);
                            }
                            if (stringArray.listFiles() != null) {
                                CacheDeployUtils.removeDirectory(stringArray.listFiles());
                            }
                            stringArray.delete();
                        }
                        bl = true;
                    }
                }
                if (!this.cache.exists() || bl) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Generating new WSDL Definition");
                    }
                    this.createOutputDirectory();
                    WSToolsObjectFactory wSToolsObjectFactory = WSToolsObjectFactory.newInstance();
                    stringArray = this.getWsGenArguments(string, string2);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    wSToolsObjectFactory.wsgen(byteArrayOutputStream, stringArray);
                    ((OutputStream)byteArrayOutputStream).close();
                    hashMap2 = this.readInWSDL();
                    if (hashMap2.isEmpty()) {
                        throw new Exception("A WSDL Definition could not be generated for the implementation class: " + string);
                    }
                    hashMap = this.readInSchema();
                    wsdlComposite.setSchemaMap(hashMap);
                    wsdlComposite.setWsdlDefinition(hashMap2);
                    Axis2Utils.deleteTempExtractDir(this.moduleFile);
                    try {
                        this.cache.setWsdlDefinitionMap(hashMap2);
                        this.cache.save();
                    }
                    catch (Throwable throwable) {
                        if (!_tc.isDebugEnabled()) break block17;
                        Tr.debug(_tc, "WSDL was generated but a cache was not written.");
                    }
                }
            }
            return wsdlComposite;
        }
        catch (Throwable throwable) {
            Object[] objectArray = new Object[]{string, throwable};
            String string6 = NLSProvider.getNLS().getFormattedMessage("wsdlGenFail00", objectArray, "Error occurred generating WSDL file for Web service implementation class {0}: {1}");
            Tr.error(_tc, string6);
            throw new WebServiceException(string6, throwable);
        }
    }

    private String[] getWsGenArguments(String string, String string2) throws WebServiceException {
        String[] stringArray = null;
        if (string2 == null || string2.equals("") || string2.equals("http://schemas.xmlsoap.org/wsdl/soap/http") || string2.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Generating WSDL with SOAP 1.1 binding type");
            }
            stringArray = new String[]{"-cp", this.classPath, string, "-keep", "-wsdl:soap1.1", "-d", this.localOutputDirectory};
        } else if (string2.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || string2.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Generating WSDL with SOAP 1.2 binding type");
            }
            stringArray = new String[]{"-cp", this.classPath, string, "-keep", "-extension", "-wsdl:Xsoap1.2", "-d", this.localOutputDirectory};
        } else {
            throw new WebServiceException("The binding " + string2 + " specified by the " + "class " + string + " cannot be used to generate a WSDL. Please choose " + "a supported binding type.");
        }
        return stringArray;
    }

    private HashMap<String, Definition> readInWSDL() throws Exception {
        List<File> list = this.getWSDLFiles();
        HashMap<String, Definition> hashMap = new HashMap<String, Definition>();
        for (File file : list) {
            Object object;
            Object[] objectArray;
            if (file == null) continue;
            try {
                Definition definition;
                block7: {
                    WSDLFactory wSDLFactory = WSDLFactory.newInstance();
                    objectArray = wSDLFactory.newWSDLReader();
                    objectArray.setFeature("javax.wsdl.verbose", false);
                    object = file.toURL().openStream();
                    definition = objectArray.readWSDL(this.localOutputDirectory, new InputSource((InputStream)object));
                    try {
                        definition.setDocumentBaseURI(file.toURI().toString());
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Set base document URI for generated WSDL: " + file.toURI().toString());
                        }
                    }
                    catch (Throwable throwable) {
                        if (!_tc.isDebugEnabled()) break block7;
                        Tr.debug(_tc, "Could not set base document URI for generated WSDL: " + file.getAbsolutePath() + " : " + throwable.toString());
                    }
                }
                hashMap.put(file.getName().toLowerCase(), definition);
            }
            catch (WSDLException wSDLException) {
                objectArray = new Object[]{file.getName(), wSDLException};
                object = NLSProvider.getNLS().getFormattedMessage("createWsdlDefFail00", objectArray, "Error occurred while attempting to create Definition from generated WSDL file {0}: {1}");
                Tr.error(_tc, (String)object);
                throw new Exception((String)object);
            }
            catch (IOException iOException) {
                objectArray = new Object[]{file.getName(), iOException};
                object = NLSProvider.getNLS().getFormattedMessage("createWsdlDefFail00", objectArray, "Error occurred while attempting to create Definition from generated WSDL file {0}: {1}");
                Tr.error(_tc, (String)object);
                throw new Exception((String)object);
            }
        }
        return hashMap;
    }

    private List<File> getWSDLFiles() {
        File file = new File(this.localOutputDirectory);
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                String string = file2.getName();
                if (!string.endsWith(".wsdl")) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Located generated WSDL file: " + string);
                }
                arrayList.add(file2);
            }
        }
        return arrayList;
    }

    private void createOutputDirectory() {
        File file = new File(this.localOutputDirectory);
        if (!file.isDirectory()) {
            file.mkdirs();
        }
    }

    private HashMap<String, OMDocument> readInSchema() throws Exception {
        try {
            HashMap<String, OMDocument> hashMap = new HashMap<String, OMDocument>();
            List<File> list = this.getSchemaFiles();
            for (File file : list) {
                InputStream inputStream = file.toURL().openStream();
                StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(inputStream);
                inputStream.close();
                OMDocument oMDocument = stAXOMBuilder.getDocument();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Read in schema file: " + file.getName());
                }
                hashMap.put(file.getName(), oMDocument);
            }
            return hashMap;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{exception};
            String string = NLSProvider.getNLS().getFormattedMessage("readSchemaFail00", objectArray, "Error occurred while attempting to read generated schema file {0}");
            Tr.error(_tc, string);
            throw new Exception(string);
        }
    }

    private List<File> getSchemaFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = new File(this.localOutputDirectory);
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                String string = file2.getName();
                if (!string.endsWith(".xsd")) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Located generated schema file: " + string);
                }
                arrayList.add(file2);
            }
        }
        return arrayList;
    }
}

