/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.wsdl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.resources.NLSProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.StringTokenizer;
import org.xml.sax.InputSource;

public abstract class BaseWSDLLocator
implements Constants {
    private static TraceComponent _tc = Tr.register(BaseWSDLLocator.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    protected String baseURI;
    protected String lastestImportURI;
    protected InputStream baseInputStream;
    private static final char WSDL_PATH_SEPERATOR_CHAR = '/';
    private static final String WSDL_PATH_SEPERATOR = new Character('/').toString();

    protected abstract InputStream getInputStream(String var1) throws IOException;

    public InputSource getBaseInputSource() {
        return new InputSource(this.baseInputStream);
    }

    public InputSource getImportInputSource(String string, String string2) {
        Object[] objectArray;
        InputStream inputStream;
        Object var3_3;
        block15: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getImportInputSource", new Object[]{string, string2, this});
            }
            var3_3 = null;
            inputStream = null;
            URL uRL = null;
            try {
                if (this.isAbsoluteImport(string2)) {
                    try {
                        uRL = new URL(string2);
                        inputStream = uRL.openStream();
                        this.lastestImportURI = uRL.toExternalForm();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (inputStream == null) {
                        try {
                            objectArray = new URI(string2);
                            uRL = objectArray.toURL();
                            inputStream = uRL.openStream();
                            this.lastestImportURI = uRL.toExternalForm();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (inputStream == null) {
                        try {
                            objectArray = new File(string2);
                            uRL = objectArray.toURL();
                            inputStream = uRL.openStream();
                            this.lastestImportURI = uRL.toExternalForm();
                        }
                        catch (Throwable throwable) {}
                    }
                    break block15;
                }
                objectArray = this.normalizePath(string, string2);
                inputStream = this.getInputStream((String)objectArray);
                this.lastestImportURI = objectArray;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.websvcs.wsdl.BaseWSDLLocator.getImportInputSource", "123", this);
                Object[] objectArray2 = new Object[]{string2, iOException};
                String string3 = NLSProvider.getNLS().getFormattedMessage("resolveWsdlLocFail00", objectArray2, "Error occurred while attempting to resolve the WSDL file {0}: {1}");
                Tr.error(_tc, "resolveWsdlLocFail00", objectArray2);
                throw new RuntimeException(string3);
            }
        }
        if (inputStream == null) {
            objectArray = new Object[]{string2};
            String string4 = NLSProvider.getNLS().getFormattedMessage("fileNotFound00", objectArray, "File {0} could not be found.");
            throw new RuntimeException(string4);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Loaded file: " + string2);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getImportInputSource", var3_3);
        }
        return new InputSource(inputStream);
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public String getLatestImportURI() {
        return this.lastestImportURI;
    }

    protected String convertURI(String string) {
        int n = string.lastIndexOf(47);
        if (n > 0) {
            string = string.substring(0, n + 1);
            return string;
        }
        n = string.lastIndexOf(92);
        if (n > 0) {
            string = string.substring(0, n + 1);
            return string;
        }
        return "";
    }

    protected boolean isAbsoluteImport(String string) {
        boolean bl = false;
        if (string != null) {
            if (string.indexOf(":/") != -1) {
                bl = true;
            } else if (string.indexOf(":\\") != -1) {
                bl = true;
            }
        }
        return bl;
    }

    protected String normalizePath(String string, String string2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "normalizePath");
        }
        String string3 = this.convertURI(string);
        StringBuffer stringBuffer = new StringBuffer(string3);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, WSDL_PATH_SEPERATOR);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "pathFromRoot = " + string3);
            Tr.debug(_tc, "relativeLocation = " + string2);
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("..")) {
                int n = stringBuffer.length() - 1;
                if (stringBuffer.charAt(n) == '/' || stringBuffer.charAt(n) == '\\') {
                    stringBuffer.deleteCharAt(n--);
                }
                while (stringBuffer.charAt(n) != '/' && stringBuffer.charAt(n) != '\\') {
                    stringBuffer.deleteCharAt(n--);
                }
                continue;
            }
            if (string4.equals(".")) continue;
            if (stringBuffer.indexOf(String.valueOf('/')) != -1 && stringBuffer.charAt(stringBuffer.length() - 1) != '/') {
                stringBuffer.append('/');
            } else if (stringBuffer.indexOf("\\") != -1 && stringBuffer.charAt(stringBuffer.length() - 1) != '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(string4);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Built path = " + stringBuffer.toString());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "normalizePath");
        }
        return stringBuffer.toString();
    }
}

