/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.websvcs.utils.WSAnnotatedClassCacheBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.wsdl.Definition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServicesModuleCache
implements Constants {
    private static final TraceComponent tc = Tr.register(WebServicesModuleCache.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private List<WSAnnotatedClassCacheBean> classCacheBeanList = new ArrayList<WSAnnotatedClassCacheBean>();
    private Definition definition;
    private HashMap<String, Definition> wsdlDefMap = new HashMap();
    private String wsdlFileName = new String();
    private String disableCache;
    private String rootDirectory = null;
    private String filename = null;
    private String fullPath = null;
    private File fileObj = null;
    private boolean loadError;

    public WebServicesModuleCache(String string, String string2) {
        this.rootDirectory = string;
        this.filename = string2;
        if (string != null) {
            this.fullPath = this.rootDirectory + this.filename;
            this.fileObj = new File(this.fullPath);
        }
        this.disableCache = null;
        this.loadError = false;
    }

    public boolean exists() {
        if (this.rootDirectory == null || !this.cachingEnabled() || this.loadError) {
            return false;
        }
        File file = new File(this.rootDirectory);
        if (file.isDirectory()) {
            if (this.fileObj.isFile()) {
                File file2 = new File(this.rootDirectory + "installExtract");
                if (file2.isDirectory()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Attempting to delete application extraction location: " + file2.getAbsolutePath());
                    }
                    Axis2Utils.removeDirectory(file2);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void create() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create");
        }
        if (this.rootDirectory != null) {
            File file = new File(this.rootDirectory);
            if (!file.isDirectory()) {
                file.mkdirs();
            }
            if (!this.fileObj.isFile()) {
                try {
                    this.fileObj.createNewFile();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.websvcs.utils.WebServicesModuleCache.create", "120", this);
                    Object[] objectArray = new Object[]{this.fullPath, iOException};
                    String string = NLSProvider.getNLS().getFormattedMessage("createCacheFileFail00", objectArray, "Error occurred while attempting to create cache file {0}: {1}");
                    Tr.error(tc, string);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cache file not created since profile root not located.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "load");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "load");
        }
        if (this.exists() && this.fileObj.length() != 0L) {
            try {
                FileInputStream fileInputStream = new FileInputStream(this.fileObj);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                if (fileInputStream.available() > 0) {
                    this.classCacheBeanList = (List)objectInputStream.readObject();
                    if (fileInputStream.available() > 0) {
                        this.wsdlDefMap = (HashMap)objectInputStream.readObject();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Deserialized WSDL definition map of size: " + this.wsdlDefMap.size());
                        }
                        this.wsdlFileName = (String)objectInputStream.readObject();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Deserialized WSDL Definition for file: " + this.wsdlFileName);
                        }
                    }
                }
                if (tc.isDebugEnabled() && this.classCacheBeanList.size() > 0) {
                    Tr.debug(tc, "Deserialized annotated class list with size: " + this.classCacheBeanList.size());
                }
                fileInputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                FFDCFilter.processException((Throwable)fileNotFoundException, "com.ibm.ws.websvcs.utils.WebServicesModuleCache.load", "177", this);
                Object[] objectArray = new Object[]{this.fullPath, fileNotFoundException};
                String string = NLSProvider.getNLS().getFormattedMessage("loadCacheFileFail00", objectArray, "Error occurred while attempting to load cache file {0}: {1}");
                Tr.error(tc, string);
                this.loadError = true;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.websvcs.utils.WebServicesModuleCache.load", "184", this);
                Object[] objectArray = new Object[]{this.fullPath, iOException};
                String string = NLSProvider.getNLS().getFormattedMessage("loadCacheFileFail00", objectArray, "Error occurred while attempting to load cache file {0}: {1}");
                Tr.error(tc, string);
                this.loadError = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.websvcs.utils.WebServicesModuleCache.load", "191", this);
                Object[] objectArray = new Object[]{this.fullPath, classNotFoundException};
                String string = NLSProvider.getNLS().getFormattedMessage("loadCacheFileFail00", objectArray, "Error occurred while attempting to load cache file {0}: {1}");
                Tr.error(tc, string);
                this.loadError = true;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.utils.WebServicesModuleCache.load", "191", this);
                Object[] objectArray = new Object[]{this.fullPath, exception};
                String string = NLSProvider.getNLS().getFormattedMessage("loadCacheFileFail00", objectArray, "Error occurred while attempting to load cache file {0}: {1}");
                Tr.error(tc, string);
                this.loadError = true;
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "load");
                }
            }
        }
    }

    public List<WSAnnotatedClassCacheBean> getAnnotatedClassList() {
        return this.classCacheBeanList;
    }

    public HashMap<String, Definition> getWsdlDefinitionMap() {
        return this.wsdlDefMap;
    }

    public void setWsdlDefinitionMap(HashMap<String, Definition> hashMap) {
        this.wsdlDefMap = hashMap;
    }

    public String getWsdlFileName() {
        return this.wsdlFileName;
    }

    public void setWsdlFileName(String string) {
        this.wsdlFileName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save");
        }
        if (this.rootDirectory != null && this.cachingEnabled()) {
            try {
                this.create();
                FileOutputStream fileOutputStream = new FileOutputStream(this.fileObj);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(this.classCacheBeanList);
                objectOutputStream.writeObject(this.wsdlDefMap);
                objectOutputStream.writeObject(this.wsdlFileName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cached annotated class list with size: " + this.classCacheBeanList.size());
                }
                if (this.wsdlDefMap != null && this.wsdlDefMap.size() > 0 && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cached WSDL definition map with size: " + this.wsdlDefMap.size());
                }
                fileOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                FFDCFilter.processException((Throwable)fileNotFoundException, "com.ibm.ws.websvcs.utils.WebServicesModuleCache.save", "254", this);
                Object[] objectArray = new Object[]{this.fullPath, fileNotFoundException};
                String string = NLSProvider.getNLS().getFormattedMessage("saveCacheFileFail00", objectArray, "Error occurred while attempting to save cache file {0}: {1}");
                Tr.error(tc, string);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.websvcs.utils.WebServicesModuleCache.save", "261", this);
                Object[] objectArray = new Object[]{this.fullPath, iOException};
                String string = NLSProvider.getNLS().getFormattedMessage("saveCacheFileFail00", objectArray, "Error occurred while attempting to save cache file {0}: {1}");
                Tr.error(tc, string);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.utils.WebServicesModuleCache.save", "261", this);
                Object[] objectArray = new Object[]{this.fullPath, exception};
                String string = NLSProvider.getNLS().getFormattedMessage("saveCacheFileFail00", objectArray, "Error occurred while attempting to save cache file {0}: {1}");
                Tr.error(tc, string);
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "save");
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Not saving cache file since profile root not located");
        }
    }

    private boolean cachingEnabled() {
        if (this.disableCache == null) {
            this.disableCache = System.getProperty("WSFP_DISABLE_CACHE");
            if (this.disableCache == null) {
                this.disableCache = Boolean.FALSE.toString();
            }
        }
        if (this.disableCache.equalsIgnoreCase(Boolean.TRUE.toString())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Metadata caching disabled via system property. Annotation metadata will not be written to, or loaded from cache.");
            }
            return false;
        }
        return true;
    }
}

