/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.Constants;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.axis2.jaxws.utility.JAXWSThreadFactory;

public class WASAxis2Executor
implements Executor,
Constants {
    private static final TraceComponent _tc = Tr.register(WASAxis2Executor.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private Executor theExecutor = null;

    WASAxis2Executor() {
        Exception exception;
        int n;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2Executor");
        }
        int n2 = com.ibm.websphere.webservices.jaxws.Constants.DEFAULT_CORE_THREADS;
        int n3 = com.ibm.websphere.webservices.jaxws.Constants.DEFAULT_MAX_THREADS;
        String string = System.getProperty(com.ibm.websphere.webservices.jaxws.Constants.CORE_THREADS_PROPERTY);
        if (string != null) {
            try {
                n = Integer.parseInt(string);
                if (n > 0) {
                    n2 = n;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Using core threads property value: " + string);
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Invalid value for core threads property:" + string + ". Will use default value of: " + n2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                exception = new Exception("An error occurred while parsing the value of property '" + com.ibm.websphere.webservices.jaxws.Constants.CORE_THREADS_PROPERTY + "': " + string, numberFormatException);
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.utils.WASAxis2Executor.ctor", "71", this);
            }
        }
        if ((string = System.getProperty(com.ibm.websphere.webservices.jaxws.Constants.MAX_THREADS_PROPERTY)) != null) {
            try {
                n = Integer.parseInt(string);
                if (n > 0) {
                    n3 = n;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Using max threads property value: " + string);
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Invalid value for max threads property:" + string + ". Will use default value of: " + n3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                exception = new Exception("An error occurred while parsing the value of property '" + com.ibm.websphere.webservices.jaxws.Constants.MAX_THREADS_PROPERTY + "': " + string, numberFormatException);
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.utils.WASAxis2Executor.ctor", "94", this);
            }
        }
        if (n3 < n2) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Max threads must be greater than or equal to core threads.   Setting max threads to " + n2);
            }
            n3 = n2;
        }
        this.theExecutor = new ThreadPoolExecutor(n2, n3, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new JAXWSThreadFactory());
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Created new Executor instance: " + this.theExecutor.toString());
            Tr.debug(_tc, "core threads: " + n2);
            Tr.debug(_tc, "max threads:  " + n3);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WASAxis2Executor");
        }
    }

    public void execute(Runnable runnable) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "execute, command=" + runnable.toString());
        }
        this.theExecutor.execute(runnable);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "execute");
        }
    }
}

