/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.security.context.Context;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.ThreadContextMigrator;

public class SecurityContextMigrator
implements ThreadContextMigrator {
    private static final TraceComponent tc = Tr.register(SecurityContextMigrator.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public void cleanupContext(MessageContext messageContext) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupContext");
        }
        if (messageContext.getAxisOperation() != null && ("http://www.w3.org/2006/01/wsdl/in-only".equals(string = messageContext.getAxisOperation().getMessageExchangePattern()) || "http://www.w3.org/2004/08/wsdl/in-only".equals(string) || "http://www.w3.org/2006/01/wsdl/in-out".equals(string) || "http://www.w3.org/2004/08/wsdl/in-out".equals(string))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resetting security context on Axis2 MessageContext");
            }
            messageContext.setProperty("com.ibm.wsspi.websphere.security.SecurityContext", null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupContext");
        }
    }

    public void cleanupThread(MessageContext messageContext) {
    }

    public void migrateContextToThread(MessageContext messageContext) throws AxisFault {
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "migrateContextToThread");
            }
            try {
                final ContextManager contextManager = ContextManagerFactory.getInstance();
                if (contextManager.isCellSecurityEnabled()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WebSphere cell security enabled, copying security context from MessageContext to TLS");
                    }
                    if (messageContext.getAxisOperation() == null) break block17;
                    String string = messageContext.getAxisOperation().getMessageExchangePattern();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "MEP: " + string);
                    }
                    if (!"http://www.w3.org/2006/01/wsdl/in-only".equals(string) && !"http://www.w3.org/2004/08/wsdl/in-only".equals(string) && !"http://www.w3.org/2006/01/wsdl/in-out".equals(string) && !"http://www.w3.org/2004/08/wsdl/in-out".equals(string)) break block17;
                    Object object = messageContext.getProperty("com.ibm.wsspi.websphere.security.SecurityContext");
                    if (object != null && object instanceof Context) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Copying security context on MessageContext onto security context in thread local storage.");
                        }
                        final Context context = (Context)object;
                        try {
                            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws WSSecurityException {
                                    Context context2 = contextManager.getSerializableContext();
                                    context2.setCallerSubject(context.getCallerSubject());
                                    context2.setRunAsSubject(context.getRunAsSubject());
                                    context2.setPropagationTokens(context.getPropagationTokens());
                                    context2.setContext();
                                    return null;
                                }
                            });
                            break block17;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            Throwable throwable = privilegedActionException.getCause();
                            AxisFault axisFault = new AxisFault(throwable);
                            throw axisFault;
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Security context was not found on MessageContext and does not need to be copied to thread local storage");
                    }
                    break block17;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WebSphere cell security disabled, will not copy security context from MessageContext to TLS");
                }
            }
            catch (AxisFault axisFault) {
                throw axisFault;
            }
            catch (Throwable throwable) {
                AxisFault axisFault = new AxisFault(throwable);
                throw axisFault;
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "migrateContextToThread");
                }
            }
        }
    }

    public void migrateThreadToContext(MessageContext messageContext) throws AxisFault {
        block22: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "migrateThreadToContext");
            }
            try {
                final ContextManager contextManager = ContextManagerFactory.getInstance();
                if (contextManager.isCellSecurityEnabled()) {
                    String string;
                    Context context;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WebSphere cell security enabled, copying security context from TLS to MessageContext");
                    }
                    try {
                        context = (Context)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws WSSecurityException {
                                return contextManager.getSerializableContext();
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Throwable throwable = privilegedActionException.getCause();
                        AxisFault axisFault = new AxisFault(throwable);
                        throw axisFault;
                    }
                    String string2 = string = messageContext.getAxisOperation() != null ? messageContext.getAxisOperation().getMessageExchangePattern() : null;
                    if ("http://www.w3.org/2006/01/wsdl/out-only".equals(string) || "http://www.w3.org/2004/08/wsdl/out-only".equals(string) || "http://www.w3.org/2006/01/wsdl/out-in".equals(string) || "http://www.w3.org/2004/08/wsdl/out-in".equals(string)) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        final ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Serializing security context object for deep copy");
                        }
                        try {
                            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws IOException, ClassNotFoundException {
                                    objectOutputStream.writeObject(context);
                                    return null;
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            Throwable throwable = privilegedActionException.getCause();
                            AxisFault axisFault = new AxisFault(throwable);
                            throw axisFault;
                        }
                        byte[] byArray = byteArrayOutputStream.toByteArray();
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        final ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                        Context context2 = null;
                        try {
                            context2 = (Context)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws IOException, ClassNotFoundException {
                                    return objectInputStream.readObject();
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            Throwable throwable = privilegedActionException.getCause();
                            AxisFault axisFault = new AxisFault(throwable);
                            throw axisFault;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting deserialized context object on MessageContext");
                        }
                        messageContext.setProperty("com.ibm.wsspi.websphere.security.SecurityContext", context2);
                        break block22;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Did not serialize/deserialize security context");
                    }
                    messageContext.setProperty("com.ibm.wsspi.websphere.security.SecurityContext", context);
                    break block22;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WebSphere cell security disabled, will not copy security context from TLS to MessageContext");
                }
            }
            catch (AxisFault axisFault) {
                throw axisFault;
            }
            catch (IOException iOException) {
                AxisFault axisFault = new AxisFault(iOException);
                throw axisFault;
            }
            catch (Throwable throwable) {
                AxisFault axisFault = new AxisFault(throwable);
                throw axisFault;
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "migrateThreadToContext");
                }
            }
        }
    }
}

