/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webcontainer.component.ComponentUtil;
import com.ibm.ws.websvcs.deploy.CacheRootDirectoryTLS;
import com.ibm.ws.websvcs.metadata.ServerModuleMetaData;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.websvcs.WASAxis2Service;
import java.io.File;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.description.builder.WsdlComposite;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2Utils {
    private static final TraceComponent _tc = Tr.register(Axis2Utils.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final String WSFP_MAIN_JAR = "com.ibm.wsfp.main_1.0.0.jar";
    private static final String WSFP_JAXWS_JAR = "com.ibm.wsfp.jaxws_1.0.0.jar";
    private static final String WSFP_AXIS2_JAR = "com.ibm.wsfp.axis2_1.0.0.jar";
    private static final String WSFP_MAIN_JAR_NEW = "com.ibm.wsfp.main_6.1.0.jar";
    private static final String WSFP_AXIS2_JAR_NEW = "org.apache.axis2_6.1.0.jar";
    private static final String WSFP_JAXWS_JAR_NEW = "com.ibm.jaxws.tools_6.1.0.jar";
    private static final String WSFP_JAXB_JAR = "com.ibm.jaxb.tools_6.1.0.jar";
    private static final String serverRoot = System.getProperty("was.install.root");

    public static void setServiceImplClass(AxisService axisService, String string) throws AxisFault {
        Axis2Utils.setParameter(axisService, "ServiceClass", string);
    }

    public static String getServiceImplClass(AxisService axisService) {
        return (String)Axis2Utils.getParameter(axisService, "ServiceClass");
    }

    public static void setServiceQName(AxisService axisService, QName qName) throws AxisFault {
        Axis2Utils.setParameter(axisService, "WSDL_SERVICE_QNAME", qName);
    }

    public static QName getServiceQName(AxisService axisService) {
        QName qName = (QName)Axis2Utils.getParameter(axisService, "WSDL_SERVICE_QNAME");
        if (qName == null) {
            qName = (QName)Axis2Utils.getParameter(axisService, "WSDL_SERVICE_QNAME");
        }
        return qName;
    }

    public static String getServiceName(AxisService axisService) {
        QName qName = Axis2Utils.getServiceQName(axisService);
        if (qName != null) {
            return qName.getLocalPart();
        }
        return null;
    }

    public static void setPortName(AxisService axisService, String string) throws AxisFault {
        Axis2Utils.setParameter(axisService, "WSDL_PORT", string);
    }

    public static String getPortName(AxisService axisService) {
        return (String)Axis2Utils.getParameter(axisService, "WSDL_PORT");
    }

    public static void setWSDLLocation(AxisService axisService, String string) throws AxisFault {
        Axis2Utils.setParameter(axisService, "WSDL_LOCATION", string);
    }

    public static String getWSDLLocation(AxisService axisService) {
        if ((String)Axis2Utils.getParameter(axisService, "WSDL_LOCATION") != null) {
            return (String)Axis2Utils.getParameter(axisService, "WSDL_LOCATION");
        }
        WsdlComposite wsdlComposite = Axis2Utils.getWsdlComposite(axisService);
        if (wsdlComposite != null) {
            return wsdlComposite.getWsdlFileName();
        }
        return null;
    }

    public static Definition getWSDLDefinition(AxisService axisService) {
        return (Definition)Axis2Utils.getParameter(axisService, "wsdl4jDefinition");
    }

    public static Service getWSDLService(AxisService axisService) {
        Definition definition = Axis2Utils.getWSDLDefinition(axisService);
        QName qName = Axis2Utils.getServiceQName(axisService);
        if (definition != null && qName != null) {
            return definition.getService(qName);
        }
        return null;
    }

    public static Port getWSDLPort(AxisService axisService) {
        Service service = Axis2Utils.getWSDLService(axisService);
        String string = Axis2Utils.getPortName(axisService);
        if (service != null && string != null) {
            return service.getPort(string);
        }
        return null;
    }

    public static void setURLPattern(AxisService axisService, String string) throws AxisFault {
        Axis2Utils.setParameter(axisService, "com.ibm.ws.websvcs.AxisServiceUrlPattern", string);
    }

    public static String getURLPattern(AxisService axisService) {
        return (String)Axis2Utils.getParameter(axisService, "com.ibm.ws.websvcs.AxisServiceUrlPattern");
    }

    public static void setOperationValidated(AxisOperation axisOperation) throws AxisFault {
        Axis2Utils.setParameter(axisOperation, "Validated", "true");
    }

    public static Parameter getOperationValidated(AxisOperation axisOperation) {
        return axisOperation.getParameter("Validated");
    }

    public static void setPolicySet(AxisDescription axisDescription, Object object) throws AxisFault {
        Axis2Utils.setParameter(axisDescription, "WASAxis2PolicySet", object);
    }

    public static Object getPolicySet(AxisDescription axisDescription) {
        return Axis2Utils.getParameter(axisDescription, "WASAxis2PolicySet");
    }

    public static void setApplicationName(AxisConfiguration axisConfiguration, String string) throws AxisFault {
        Axis2Utils.setParameter(axisConfiguration, "ApplicationName", string);
    }

    public static String getApplicationName(AxisConfiguration axisConfiguration) {
        return (String)Axis2Utils.getParameter(axisConfiguration, "ApplicationName");
    }

    public static void setModuleName(AxisConfiguration axisConfiguration, String string) throws AxisFault {
        Axis2Utils.setParameter(axisConfiguration, "ModuleName", string);
    }

    public static String getModuleName(AxisConfiguration axisConfiguration) {
        return (String)Axis2Utils.getParameter(axisConfiguration, "ModuleName");
    }

    public static void setPortComponentName(AxisService axisService, String string) throws AxisFault {
        Axis2Utils.setParameter(axisService, "WSDL_PORTTYPE_NAME", string);
    }

    public static String getPortComponentName(AxisService axisService) {
        return (String)Axis2Utils.getParameter(axisService, "WSDL_PORTTYPE_NAME");
    }

    public static void setConstrainService(AxisService axisService, Boolean bl) throws AxisFault {
        Axis2Utils.setParameter(axisService, "com.ibm.ws.websvcs.contrain_service", bl);
    }

    public static boolean isServiceConstrained(AxisService axisService) {
        Boolean bl = (Boolean)Axis2Utils.getParameter(axisService, "com.ibm.ws.websvcs.contrain_service");
        if (bl == null) {
            return false;
        }
        return bl;
    }

    private static Object getParameter(AxisDescription axisDescription, String string) {
        Parameter parameter = axisDescription.getParameter(string);
        if (parameter != null) {
            return parameter.getValue();
        }
        return null;
    }

    private static void setParameter(AxisDescription axisDescription, String string, Object object) throws AxisFault {
        Parameter parameter = axisDescription.getParameter(string);
        if (parameter != null) {
            parameter.setValue(object);
        } else {
            parameter = new Parameter();
            parameter.setName(string);
            parameter.setValue(object);
            axisDescription.addParameter(parameter);
        }
    }

    public static boolean isThinClientEnv() {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    WASAxis2Service wASAxis2Service = (WASAxis2Service)WsServiceRegistry.getService(new Object(), WASAxis2Service.class);
                    if (wASAxis2Service != null) {
                        return new Boolean(false);
                    }
                    return new Boolean(true);
                }
                catch (Throwable throwable) {
                    return new Boolean(true);
                }
            }
        });
        return bl;
    }

    public static boolean isAbsolutePath(String string) {
        boolean bl = false;
        if (string != null) {
            if (string.indexOf(":/") != -1) {
                bl = true;
            } else if (string.indexOf(":\\") != -1) {
                bl = true;
            }
        }
        return bl;
    }

    public static String getCacheDirectory() {
        StringBuffer stringBuffer = Axis2Utils.getProfileRoot();
        if (stringBuffer != null) {
            stringBuffer = stringBuffer.append("temp").append(File.separator).append("wscache").append(File.separator);
            return stringBuffer.toString();
        }
        return null;
    }

    private static StringBuffer getProfileRoot() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() < 1) {
            string = null;
        } else if ((string = string.trim()) == null || string.length() < 1) {
            string = null;
        }
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            if (stringBuffer.charAt(stringBuffer.length() - 1) != File.separatorChar) {
                stringBuffer.append(File.separator);
            }
            return stringBuffer;
        }
        return null;
    }

    private static String getServerRoot() {
        if (serverRoot != null) {
            return serverRoot + File.separator;
        }
        String string = System.getenv("WAS_HOME");
        return string + File.separator;
    }

    public static String getCellName() {
        Server server = Axis2Utils.getServer();
        return server != null ? server.getCellName() : System.getProperty("local.cell");
    }

    public static String getServerName() {
        return Axis2Utils.getServer() != null ? Axis2Utils.getServer().getName() : "server1";
    }

    private static Server getServer() {
        return (Server)ComponentUtil.getService(Axis2Utils.class, Server.class);
    }

    public static WsdlComposite getWsdlComposite(AxisService axisService) {
        return (WsdlComposite)Axis2Utils.getParameter(axisService, "WSDL_COMPOSITE");
    }

    public static String getWsGenClassPath(ModuleFile moduleFile) {
        String string = Axis2Utils.getSystemClassPath();
        String string2 = Axis2Utils.getApplicationClassPath(moduleFile);
        String string3 = string + string2;
        return string3;
    }

    private static String getSystemClassPath() {
        String string = System.getProperty("WSGEN_SYSTEM_CLASSPATH");
        if (string != null && !"".equals(string)) {
            if (!string.endsWith(File.pathSeparator)) {
                string = string + File.pathSeparator;
            }
            return string;
        }
        string = Axis2Utils.getDefaultSystemClassPath();
        return string;
    }

    private static String getDefaultSystemClassPath() {
        String string = Axis2Utils.getServerRoot() + "plugins" + File.separator + WSFP_MAIN_JAR;
        String string2 = Axis2Utils.getServerRoot() + "plugins" + File.separator + WSFP_JAXWS_JAR;
        String string3 = Axis2Utils.getServerRoot() + "plugins" + File.separator + WSFP_AXIS2_JAR;
        String string4 = Axis2Utils.getServerRoot() + "plugins" + File.separator + WSFP_AXIS2_JAR_NEW;
        String string5 = Axis2Utils.getServerRoot() + "plugins" + File.separator + WSFP_MAIN_JAR_NEW;
        String string6 = Axis2Utils.getServerRoot() + "plugins" + File.separator + WSFP_JAXWS_JAR_NEW;
        String string7 = Axis2Utils.getServerRoot() + "plugins" + File.separator + WSFP_JAXB_JAR;
        String string8 = string + File.pathSeparator + string2 + File.pathSeparator + string3 + File.pathSeparator + string4 + File.pathSeparator + string5 + File.pathSeparator + string6 + File.pathSeparator + string7 + File.pathSeparator;
        return string8;
    }

    private static String getApplicationClassPath(ModuleFile moduleFile) {
        String string = null;
        RuntimeClasspathEntry[] runtimeClasspathEntryArray = moduleFile.getFullRuntimeClassPath();
        if (runtimeClasspathEntryArray != null && runtimeClasspathEntryArray.length > 0) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Using module full runtime classpath for wsgen compilation");
            }
            for (RuntimeClasspathEntry runtimeClasspathEntry : runtimeClasspathEntryArray) {
                String string2 = runtimeClasspathEntry.getAbsolutePath();
                File file = new File(string2);
                if (!file.isFile() && !file.isDirectory()) continue;
                string = string == null ? string2 + File.pathSeparator : string + string2 + File.pathSeparator;
            }
        }
        if (string == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Temporarily extracting module file for wsgen compilation");
            }
            try {
                String exception = Axis2Utils.getTempExtractLoc(moduleFile);
                File file = new File(exception);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Temporary extract root for WsGen " + exception);
                }
                if (!file.isDirectory()) {
                    file.mkdirs();
                }
                moduleFile.extractTo(file.getAbsolutePath(), 0);
                string = file.getAbsolutePath() + File.separator + "WEB-INF/classes";
                string = string + File.pathSeparator + file.getAbsolutePath() + File.separator + "WEB-INF/lib";
                string = Axis2Utils.addJarsToClassPath(file.getAbsolutePath(), string);
                List<String> list = Axis2Utils.getManifestClassPath(moduleFile);
                if (list != null && !list.isEmpty()) {
                    string = Axis2Utils.setupManifestClassPath(moduleFile, list, string, file);
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "No manifest classpath for module: " + moduleFile.getName());
                }
            }
            catch (Exception exception) {
                Tr.warning(_tc, "There was an error trying to extract the module " + moduleFile.getName() + ". WSDL will not be generated for any " + "Web services in this module. This may cause unpredictable " + "results.");
            }
        }
        return string;
    }

    private static String addJarsToClassPath(String string, String string2) {
        String string3 = string + File.separator + "WEB-INF/lib";
        File file = new File(string3);
        if (file != null && file.isDirectory() && file.listFiles() != null && file.listFiles().length > 0) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found non-empty JARs in extracted WEB-INF/lib directory: " + string3);
            }
            for (File file2 : file.listFiles()) {
                String string4 = file2.getAbsolutePath();
                string2 = string2 + File.pathSeparator + string4;
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "After adding JARs to module classpath: " + string2);
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "No JARs found in extracted WEB-INF/lib directory. No entries added to wsgen classpath.");
        }
        return string2;
    }

    private static String setupManifestClassPath(ModuleFile moduleFile, List<String> list, String string, File file) throws Exception {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Found manifest classpath entries for: " + moduleFile.getName());
        }
        if (moduleFile.getEARFile() != null) {
            EARFile eARFile = moduleFile.getEARFile();
            String string2 = file.getAbsolutePath() + File.separator + "ear" + File.separator;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Extracting application: " + eARFile.getName() + " to diretory: " + string2);
            }
            eARFile.extractTo(string2, 0);
            File file2 = new File(string2);
            if (file2.isDirectory()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found extracted ear file location");
                }
                String string3 = file2.getAbsolutePath() + File.separator;
                for (String string4 : list) {
                    File file3;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Checking for classpath entry: " + string3 + string4 + " for module: " + moduleFile.getName());
                    }
                    if (!(file3 = new File(string3 + string4)).exists()) continue;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Found classpath entry: " + file3.getAbsolutePath() + " for moudle: " + moduleFile.getName());
                    }
                    string = string + File.pathSeparator + file3.getAbsolutePath();
                }
            }
            return string;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Found manifest classpath entries but could not find EAR for module: " + moduleFile.getName());
        }
        return string;
    }

    private static List<String> getManifestClassPath(ModuleFile moduleFile) {
        ArrayList<String> arrayList = null;
        ArchiveManifest archiveManifest = moduleFile.getManifest();
        if (archiveManifest != null) {
            String[] stringArray;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Checking manifest classpath for module: " + moduleFile.getName());
            }
            if ((stringArray = archiveManifest.getClassPathTokenized()) != null && stringArray.length > 0) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found entries in manifest classpath for module: " + moduleFile.getName());
                }
                arrayList = new ArrayList<String>();
                for (String string : stringArray) {
                    arrayList.add(string);
                }
                return arrayList;
            }
        }
        return arrayList;
    }

    public static String getApplicationName(ModuleFile moduleFile) {
        String string = null;
        if (moduleFile.getEARFile() != null && moduleFile.getEARFile().getDeploymentDescriptor() != null) {
            string = moduleFile.getEARFile().getDeploymentDescriptor().getDisplayName();
        }
        return string;
    }

    private static String getTempExtractLoc(ModuleFile moduleFile) {
        String string = null;
        String string2 = Axis2Utils.getApplicationName(moduleFile);
        String string3 = CacheRootDirectoryTLS.get();
        if (string3 == null) {
            string3 = Axis2Utils.getCacheDirectory();
        }
        string = string2 != null ? string3 + string2 + File.separator + moduleFile.getName() + File.separator + "module" : string3 + File.separator + moduleFile.getName() + File.separator + "module";
        return string;
    }

    public static void deleteTempExtractDir(ModuleFile moduleFile) {
        File file;
        String string = Axis2Utils.getTempExtractLoc(moduleFile);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Removing temporary module extraction root " + string);
        }
        if ((file = new File(string)).isDirectory()) {
            Axis2Utils.removeDirectory(file);
        } else if (file.isFile()) {
            file.delete();
        }
    }

    public static void deleteExtractedApp(String string, String string2) {
        String string3 = File.separator;
        String string4 = Axis2Utils.getCacheDirectory();
        File file = new File(string4 = string4 + string + string3 + string2 + string3 + "installExtract");
        if (file != null && file.isDirectory()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Deleting temporary application extraction location: " + file.getAbsolutePath());
            }
            Axis2Utils.removeDirectory(file);
        }
    }

    public static void removeDirectory(File file) {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory()) {
                Axis2Utils.removeDirectory(file2);
                continue;
            }
            file2.delete();
        }
        file.delete();
    }

    public static String getApplicationNameFromModule(ModuleFile moduleFile) {
        String string = null;
        if (moduleFile.getEARFile() != null && moduleFile.getEARFile().getDeploymentDescriptor() != null) {
            string = moduleFile.getEARFile().getDeploymentDescriptor().getDisplayName();
        }
        return string;
    }

    public static String getFileContainerPath(org.eclipse.jst.j2ee.commonarchivecore.internal.File file) {
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (file.getLoadingContainer() != null && !file.getLoadingContainer().isEARFile()) {
            arrayList.add(file.getLoadingContainer().getName());
            file = file.getLoadingContainer();
        }
        for (int i = arrayList.size() - 1; i > -1; --i) {
            string = i == arrayList.size() - 1 ? (String)arrayList.get(i) : string + "/" + (String)arrayList.get(i);
        }
        return string;
    }

    public static ServerModuleMetaData getServerModuleMetaData() {
        return (ServerModuleMetaData)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    WASAxis2Service wASAxis2Service = (WASAxis2Service)WsServiceRegistry.getService(new Object(), WASAxis2Service.class);
                    if (wASAxis2Service != null) {
                        return wASAxis2Service.getModuleMetaData();
                    }
                    return null;
                }
                catch (Throwable throwable) {
                    Object[] objectArray = new Object[]{throwable};
                    Tr.error(_tc, "caughtException", objectArray);
                    return null;
                }
            }
        });
    }

    public static synchronized List getAsyncBeansList(ConfigurationContext configurationContext) {
        LinkedList linkedList = (LinkedList)configurationContext.getProperty("com.ibm.ws.websvcs.ASYNC_BEANS_MAP");
        if (linkedList == null) {
            linkedList = new LinkedList();
            configurationContext.setProperty("com.ibm.ws.websvcs.ASYNC_BEANS_MAP", linkedList);
        }
        return linkedList;
    }
}

