/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.security;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfigChangeEvent;
import com.ibm.websphere.ssl.SSLConfigChangeListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.websvcs.transport.channel.WSAddress;
import com.ibm.ws.websvcs.transport.common.JavaUtils;
import com.ibm.ws.websvcs.transport.security.ConfigSSL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;
import org.apache.axis2.AxisFault;

public class WSConfigSSLChangeListener
implements SSLConfigChangeListener {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final TraceComponent _tc = Tr.register(WSConfigSSLChangeListener.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private ConfigSSL cfgSSL = null;
    private boolean isRegistered = true;

    public void stateChanged(SSLConfigChangeEvent sSLConfigChangeEvent) {
        block8: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "WSConfigSSLChangeListener.stateChanged() called...");
            }
            if (sSLConfigChangeEvent != null && this.cfgSSL != null) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "markSSLCfgObjDeleted", this.cfgSSL.getClass().getName());
                }
                this.cfgSSL.deleteNow();
                Vector vector = this.cfgSSL.associatedTargetAddrs();
                WSAddress wSAddress = null;
                try {
                    if (vector != null && !vector.isEmpty()) {
                        for (int i = 0; i < vector.size(); ++i) {
                            wSAddress = (WSAddress)vector.elementAt(i);
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.transport.security.WSConfigSSLChangeListener.stateChanged", "%C", this);
                    if (!_tc.isEventEnabled()) break block8;
                    Tr.event(_tc, "exception01", JavaUtils.stackToString(exception));
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WSConfigSSLChangeListener.stateChanged()");
        }
    }

    public void deRegister() throws AxisFault, PrivilegedActionException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WSConfigSSLChangeListener.deRegister() called..., is registered? " + this.isRegistered);
        }
        if (this.isRegistered) {
            final WSConfigSSLChangeListener wSConfigSSLChangeListener = this;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        JSSEHelper jSSEHelper = JSSEHelper.getInstance();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "De-registering SSL listener: " + wSConfigSSLChangeListener);
                        }
                        jSSEHelper.deregisterSSLConfigChangeListener(wSConfigSSLChangeListener);
                        return null;
                    }
                });
                this.isRegistered = false;
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.webservices.engine.transport.security.WSConfigSSLChangeListener.deRegister", "158", this);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "exception01 ", JavaUtils.stackToString(privilegedActionException));
                }
                throw privilegedActionException;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WSConfigSSLChangeListener.deRegister() called..., is registered? " + this.isRegistered);
        }
    }

    protected void setConfigSSL(ConfigSSL configSSL) {
        this.cfgSSL = configSSL;
    }
}

