/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.security;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.websvcs.Axis2ServiceConfigPlugin;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisService;

public class SSLConfigPlugin
implements Axis2ServiceConfigPlugin,
Constants {
    private static final TraceComponent _tc = Tr.register(SSLConfigPlugin.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public void config(HashMap hashMap) throws AxisFault, DeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SSLConfigPlugin.config()...", hashMap);
        }
        AxisService axisService = (AxisService)hashMap.get("com.ibm.wsspi.websvcs.AxisServiceKey");
        this.checkSSLPolicySets(axisService);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...SSLConfigPlugin.config()");
        }
    }

    private void checkSSLPolicySets(AxisService axisService) throws AxisFault, DeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SSLConfigPlugin.checkSSLPolicySets()...");
        }
        if (axisService != null) {
            Object object;
            Object[] objectArray;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "AxisService found: " + axisService);
            }
            Iterator iterator = axisService.getOperations();
            PolicySetConfiguration policySetConfiguration = null;
            int n = 0;
            int n2 = 0;
            while (iterator.hasNext()) {
                objectArray = (Object[])iterator.next();
                policySetConfiguration = (PolicySetConfiguration)Axis2Utils.getPolicySet((AxisDescription)objectArray);
                object = objectArray.getName().getLocalPart();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "    Policy Set found for operation: " + (String)object);
                }
                if (this.isWASOperation((String)object)) continue;
                if (policySetConfiguration != null) {
                    Properties properties = (Properties)policySetConfiguration.getPolicyTypeConfiguration("SSL_POLICY");
                    Properties properties2 = (Properties)policySetConfiguration.getPolicyTypeBinding("SSL_BINDING");
                    if (properties != null) {
                        ++n;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "    Policy Type found for operation.");
                        }
                    }
                    if (properties2 != null && _tc.isDebugEnabled()) {
                        Tr.debug(_tc, "    Policy Binding found for operation.");
                    }
                }
                ++n2;
            }
            if (n != 0 && n != n2) {
                objectArray = new Object[]{Axis2Utils.getServiceName(axisService)};
                object = NLSProvider.getNLS().getFormattedMessage("invalidOperationsSSL", objectArray, "All operations for service {0} do not have an SSL policy set attached.");
                throw new DeploymentException((String)object);
            }
            if (n != 0) {
                Axis2Utils.setConstrainService(axisService, Boolean.TRUE);
            }
            if ((policySetConfiguration = (PolicySetConfiguration)Axis2Utils.getPolicySet(axisService)) != null) {
                objectArray = (Properties)policySetConfiguration.getPolicyTypeConfiguration("SSL_POLICY");
                object = (Properties)policySetConfiguration.getPolicyTypeBinding("SSL_BINDING");
                if (_tc.isDebugEnabled()) {
                    if (objectArray != null) {
                        Tr.debug(_tc, "    Policy Type found for service.");
                    }
                    if (object != null) {
                        Tr.debug(_tc, "    Policy Binding found for service.");
                    }
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...SSLConfigPlugin.checkSSLPolicySets()");
        }
    }

    private boolean isWASOperation(String string) {
        if (string.startsWith("Sandesha2Operation")) {
            return true;
        }
        return string.startsWith("STSDup") || string.startsWith("STSIn") || string.startsWith("STSOut");
    }
}

