/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.security;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.Config;
import com.ibm.ws.websvcs.transport.ConfigProvider;
import com.ibm.ws.websvcs.transport.channel.DefaultHTTPSTransportClientProperties;
import com.ibm.ws.websvcs.transport.channel.WSAddress;
import com.ibm.ws.websvcs.transport.security.ConfigSSL;
import com.ibm.ws.websvcs.transport.security.JSSEConfigSSL;
import com.ibm.ws.websvcs.transport.security.WASConfigSSL;
import com.ibm.ws.websvcs.transport.security.WSConfigSSLChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;

public class ConfigSSLProvider
implements ConfigProvider {
    private static final TraceComponent _tc = Tr.register(ConfigSSLProvider.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static JSSEHelper _jhlpr = null;
    private static ConfigSSLProvider cfgPvdr = null;
    private static HashMap connInfoTable = null;
    protected static final String emptyString = "";

    private ConfigSSLProvider() {
    }

    public static final synchronized ConfigSSLProvider getInstance(DefaultHTTPSTransportClientProperties defaultHTTPSTransportClientProperties) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ConfigSSLProvider.getInstance()");
        }
        if (cfgPvdr == null) {
            String string = null;
            URL uRL = null;
            _jhlpr = JSSEHelper.getInstance();
            string = defaultHTTPSTransportClientProperties.getSSLClientPropsName();
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "sslClientProps " + string);
            }
            if (string != null && string != emptyString) {
                try {
                    uRL = new URL("file", emptyString, string);
                }
                catch (MalformedURLException malformedURLException) {
                    FFDCFilter.processException(malformedURLException, "com.ibm.ws.websvcs.transport.security.ConfigSSLProvider.getInstance", "93");
                    Object[] objectArray = new Object[]{malformedURLException};
                    String string2 = NLSProvider.getNLS().getFormattedMessage("sslClientPropsFileNotSpec00", objectArray, "The Secure Sockets Layer (SSL) client configuration file, ssl.client.props, is not specified due to the following error: {0}");
                    throw new AxisFault(string2);
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "loadSSLClientProps", uRL.toString());
                }
                _jhlpr.loadClientSSLPropertiesFromURL(uRL.toString(), false);
            }
            cfgPvdr = new ConfigSSLProvider();
            connInfoTable = new HashMap();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ConfigSSLProvider.getInstance()");
        }
        return cfgPvdr;
    }

    public Config getConfig(MessageContext messageContext, WSAddress wSAddress, DefaultHTTPSTransportClientProperties defaultHTTPSTransportClientProperties) throws AxisFault {
        ConfigSSL configSSL = null;
        Properties properties = null;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ConfigSSLProvider.getConfig() : " + wSAddress);
        }
        try {
            boolean bl = false;
            boolean bl2 = false;
            String string = null;
            String string2 = null;
            WSConfigSSLChangeListener wSConfigSSLChangeListener = new WSConfigSSLChangeListener();
            properties = _jhlpr.getSSLPropertiesOnThread();
            if (properties != null) {
                bl = true;
                properties = _jhlpr.getProperties(null, null, wSConfigSSLChangeListener);
                if (_tc.isEventEnabled()) {
                    Object[] objectArray = new Object[]{properties.toString(), wSConfigSSLChangeListener.toString()};
                    Tr.event(_tc, "sslPropertiesProgramSet", objectArray);
                }
                configSSL = new WASConfigSSL();
            } else if (!bl) {
                Object object;
                try {
                    string = defaultHTTPSTransportClientProperties.getSSLConfigurationName();
                    string2 = defaultHTTPSTransportClientProperties.getSSLClientPropsName();
                }
                catch (ClassCastException classCastException) {
                    FFDCFilter.processException((Throwable)classCastException, "com.ibm.ws.webservices.engine.transport.security.getConfigSSL", "%C", this);
                    string = null;
                    string2 = null;
                    throw classCastException;
                }
                if (_tc.isEventEnabled()) {
                    object = new Object[]{string, string2};
                    Tr.event(_tc, "sslConfigFromContext", object);
                }
                if ((properties = _jhlpr.getProperties(string, this.getConnInfo(wSAddress), wSConfigSSLChangeListener)) == null) {
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "sslConfigResolveFailed00");
                    }
                    if ((properties = _jhlpr.getProperties("DefaultSystemProperties", this.getConnInfo(wSAddress), wSConfigSSLChangeListener)) == null) {
                        object = new Object[]{wSAddress.toString()};
                        String string3 = NLSProvider.getNLS().getFormattedMessage("sslConfigResolveFailed01", (Object[])object, "No Secure Sockets Layer (SSL) configuration is available for the {0} endpoint.");
                        throw new AxisFault(string3);
                    }
                }
                if (_tc.isEventEnabled()) {
                    object = new Object[]{properties.toString(), wSConfigSSLChangeListener.toString()};
                    Tr.event(_tc, "sslPropertiesFromJSSEHelper", object);
                }
                if (properties.getProperty("com.ibm.ssl.alias").equalsIgnoreCase("DefaultSystemProperties")) {
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "invokeMethod00 JSSEConfigSSL " + JSSEConfigSSL.class.getName());
                    }
                    configSSL = new JSSEConfigSSL();
                } else {
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "invokeMethod00 WASConfigSSL " + WASConfigSSL.class.getName());
                    }
                    configSSL = new WASConfigSSL();
                    object = string;
                    int n = ((String)object).lastIndexOf("/");
                    if (n != -1) {
                        object = ((String)object).substring(n + 1);
                    }
                    String string4 = properties.getProperty("com.ibm.ssl.alias");
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "The absolute name for configured SSL Configuration alias is: " + (String)object);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "The SSL alias name from JSSEHelper properties is: " + string4);
                    }
                    if (string4.equalsIgnoreCase((String)object)) {
                        bl2 = true;
                    }
                }
            }
            configSSL.putAll((Map)properties);
            configSSL.setlistener(wSConfigSSLChangeListener);
            if (bl) {
                configSSL.setPreConfig(properties);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Saved previous programmatic SSL configuration: " + properties.toString());
                }
            } else {
                configSSL.setPreConfig(null);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "No previous programmatic SSL configuration to be saved.");
                }
            }
            _jhlpr.setSSLPropertiesOnThread(configSSL);
        }
        catch (SSLException sSLException) {
            FFDCFilter.processException((Throwable)sSLException, "com.ibm.ws.webservices.engine.transport.security.getConfigSSL", "%C", this);
            AxisFault.makeFault(sSLException);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ConfigSSLProvider.getConfig()");
        }
        return configSSL;
    }

    private HashMap getConnInfo(WSAddress wSAddress) {
        String string;
        HashMap<String, String> hashMap;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getConnInfo outbound  " + wSAddress.getSchemaInString() + " host : " + wSAddress.getHostname() + " port : " + String.valueOf(wSAddress.getPort()));
        }
        if ((hashMap = (HashMap<String, String>)connInfoTable.get(string = "outbound" + wSAddress.getSchemaInString() + wSAddress.getHostname() + String.valueOf(wSAddress.getPort()))) == null) {
            hashMap = new HashMap<String, String>();
            hashMap.put("com.ibm.ssl.direction", "outbound");
            if (wSAddress.getSchema() == 1 || wSAddress.getSchema() == 2) {
                hashMap.put("com.ibm.ssl.endPointName", "WEBSERVICES_HTTP");
            } else {
                hashMap.put("com.ibm.ssl.endPointName", wSAddress.getSchemaInString());
            }
            hashMap.put("com.ibm.ssl.remoteHost", wSAddress.getHostname());
            hashMap.put("com.ibm.ssl.remotePort", String.valueOf(wSAddress.getPort()));
            connInfoTable.put(string, hashMap);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "sslConnectionInfo " + hashMap.toString());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getConnInfo");
        }
        return hashMap;
    }
}

