/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicyTypeLoader;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class SSLPolicyTypeLoader
implements PolicyTypeLoader {
    private static final TraceComponent _tc = Tr.register(SSLPolicyTypeLoader.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public void init(Map map) throws Exception {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "init");
        }
    }

    public void load(ClassLoader classLoader, VariableExpander variableExpander, InputStream inputStream, PolicySetConfiguration policySetConfiguration) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "load", new Object[]{classLoader, variableExpander, inputStream, policySetConfiguration});
        }
        Properties properties = PolicyTypeFileHelper.readPolicy(inputStream);
        PolicyTypeFileHelper.expandAttributes(properties, variableExpander);
        if (properties != null && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "load", "Got values from Properties object...");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "load", "Setting SSL_POLICY");
        }
        policySetConfiguration.setPolicyTypeConfiguration("SSL_POLICY", properties);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "load", new Object[]{classLoader, variableExpander, inputStream, policySetConfiguration});
        }
    }

    public void destroy() throws Exception {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "destroy");
        }
    }

    public String getType() throws Exception {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getType", "SSLTransport");
        }
        return "SSLTransport";
    }
}

