/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.common.TransportConstants;
import com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper;
import com.ibm.ws.websvcs.transport.policyset.SSLPolicyTypeProvider;
import com.ibm.ws.websvcs.transport.policyset.jaxb.Policy;
import java.io.FileInputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.axis2.AxisFault;

public class PolicyValidation {
    private static PolicyValidation instance = new PolicyValidation();
    private static final TraceComponent _tc = Tr.register(PolicyValidation.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final String CLASSNAME = SSLPolicyTypeProvider.class.getCanonicalName();
    private Policy _policy = null;

    public static PolicyValidation getInstance() {
        return instance;
    }

    public boolean validateFullPolicy(Properties properties) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "PolicyValidation.validateFullPolicy()...");
        }
        if (properties != null && !properties.isEmpty()) {
            for (Object object : properties.keySet()) {
                int n;
                bl = false;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found attribute: " + object);
                }
                for (n = 0; n < TransportConstants.httppolicyElements.length; ++n) {
                    if (!object.toString().contains(TransportConstants.httppolicyElements[n])) continue;
                    bl = true;
                    break;
                }
                n = object.toString().lastIndexOf(58);
                if (object.toString().startsWith("properties_") && n != -1 && (object.toString().substring(n + 1).equals("name") || object.toString().substring(n + 1).equals("value"))) {
                    bl = true;
                }
                if (bl) continue;
                bl2 = true;
                Tr.warning(_tc, "invalidAttr00", object);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "PolicyValidation.validateFullPolicy()... : " + !bl2);
        }
        return !bl2;
    }

    protected boolean loadPolicy(String string) throws AxisFault {
        block7: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "loadPolicy fileName : " + string);
            }
            try {
                final ClassLoader classLoader = PolicyTypeFileHelper.class.getClassLoader();
                FileInputStream fileInputStream = new FileInputStream(string);
                JAXBContext jAXBContext = null;
                try {
                    jAXBContext = (JAXBContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return JAXBContext.newInstance("com.ibm.ws.websvcs.transport.policyset.jaxb", classLoader);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
                Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
                Object object = unmarshaller.unmarshal(fileInputStream);
                this._policy = null;
                if (!(object instanceof Policy)) {
                    Object[] objectArray = new Object[]{string};
                    String string2 = NLSProvider.getNLS().getFormattedMessage("unmarObjNotPolicySet00", objectArray, "The {0} unmarshaled object is not a policy object.");
                    Tr.error(_tc, "unmarObjNotPolicySet00", objectArray);
                    throw new AxisFault(string2);
                }
                this._policy = (Policy)object;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, CLASSNAME, "1:207:1.2");
                if (!_tc.isDebugEnabled()) break block7;
                Tr.debug(_tc, "loadPolicy", "Exception caught during unmarshalling: " + exception);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadPolicy returns true");
        }
        return true;
    }
}

