/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.PasswordUtil;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.transport.common.TransportConstants;
import com.ibm.ws.websvcs.transport.policyset.NamespacePrefixMapperImpl;
import com.ibm.ws.websvcs.transport.policyset.PolicyValidation;
import com.ibm.ws.websvcs.transport.policyset.jaxb.All;
import com.ibm.ws.websvcs.transport.policyset.jaxb.BasicAuth;
import com.ibm.ws.websvcs.transport.policyset.jaxb.CompressRequest;
import com.ibm.ws.websvcs.transport.policyset.jaxb.CompressResponse;
import com.ibm.ws.websvcs.transport.policyset.jaxb.CompressType;
import com.ibm.ws.websvcs.transport.policyset.jaxb.ConfigAlias;
import com.ibm.ws.websvcs.transport.policyset.jaxb.ConfigFile;
import com.ibm.ws.websvcs.transport.policyset.jaxb.ConnectInfo;
import com.ibm.ws.websvcs.transport.policyset.jaxb.CustomProperty;
import com.ibm.ws.websvcs.transport.policyset.jaxb.ExactlyOne;
import com.ibm.ws.websvcs.transport.policyset.jaxb.InResponsewithSSL;
import com.ibm.ws.websvcs.transport.policyset.jaxb.ObjectFactory;
import com.ibm.ws.websvcs.transport.policyset.jaxb.OutAsyncResponseBasicAuth;
import com.ibm.ws.websvcs.transport.policyset.jaxb.OutAsyncResponseProxy;
import com.ibm.ws.websvcs.transport.policyset.jaxb.OutAsyncResponsewithSSL;
import com.ibm.ws.websvcs.transport.policyset.jaxb.OutRequestBasicAuth;
import com.ibm.ws.websvcs.transport.policyset.jaxb.OutRequestProxy;
import com.ibm.ws.websvcs.transport.policyset.jaxb.OutRequestwithSSL;
import com.ibm.ws.websvcs.transport.policyset.jaxb.Policy;
import com.ibm.ws.websvcs.transport.policyset.jaxb.Properties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyTypeFileHelper
implements Constants {
    private static final TraceComponent _tc = Tr.register(PolicyTypeFileHelper.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final String CLASSNAME = PolicyTypeFileHelper.class.getCanonicalName();

    static boolean writePolicyBinding(String string, java.util.Properties properties) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "PolicyTypeFileHelper.writePolicyBinding()...");
        }
        boolean bl = PolicyTypeFileHelper.writePolicy(string, properties);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...PolicyTypeFileHelper.writePolicyBinding().");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean writePolicy(String string, java.util.Properties properties) throws IOException {
        boolean bl;
        block19: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "PolicyTypeFileHelper.writePolicy()...");
            }
            bl = true;
            if (properties != null && _tc.isDebugEnabled()) {
                Tr.debug(_tc, "Properties object not null. Getting values from object.");
            }
            try {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Validating the property objects.");
                }
                bl = PolicyValidation.getInstance().validateFullPolicy(properties);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, CLASSNAME, "1:104:1.2");
                if (_tc.isErrorEnabled()) {
                    Tr.error(_tc, "validatePolicyFail00", exception);
                }
                bl = false;
            }
            if (bl) {
                OutputStream outputStream = null;
                try {
                    Policy policy = PolicyTypeFileHelper.createPolicyObject(properties);
                    File file = new File(string);
                    if (!file.exists()) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "writePolicy", "File does not exist. Will be created: " + string);
                        }
                        bl = false;
                        break block19;
                    }
                    outputStream = new FileOutputStream(file);
                    final ClassLoader classLoader = PolicyTypeFileHelper.class.getClassLoader();
                    JAXBContext jAXBContext = null;
                    try {
                        jAXBContext = (JAXBContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return JAXBContext.newInstance("com.ibm.ws.websvcs.transport.policyset.jaxb", classLoader);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw privilegedActionException.getException();
                    }
                    Marshaller marshaller = jAXBContext.createMarshaller();
                    marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", new NamespacePrefixMapperImpl());
                    marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    marshaller.marshal((Object)policy, outputStream);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, CLASSNAME, "1:104:1.2");
                    if (_tc.isErrorEnabled()) {
                        Tr.error(_tc, "marshallPolicyFail00", exception);
                    }
                    bl = false;
                }
                finally {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...PolicyTypeFileHelper.writePolicy() : " + bl);
        }
        return bl;
    }

    static java.util.Properties readBinding(String string) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "PolicyTypeFileHelper.readBinding()..." + string);
        }
        java.util.Properties properties = PolicyTypeFileHelper.readPolicy(string);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...PolicyTypeFileHelper.readBinding()." + string);
        }
        return properties;
    }

    static java.util.Properties readPolicy(String string) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "PolicyTypeFileHelper.readPolicy()... policyTypePath : " + string);
        }
        List<All> list = PolicyTypeFileHelper.getAlternativesFromFile(string);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "alternatives size : " + list.size());
        }
        java.util.Properties properties = new java.util.Properties();
        All all = list.get(0);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "jax_all : " + all);
        }
        try {
            PolicyTypeFileHelper.populateProperties(properties, all);
        }
        catch (Exception exception) {
            properties = new java.util.Properties();
            throw new IOException("Could not extract all property values.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...PolicyTypeFileHelper.readPolicy(). policyTypePath : " + string);
        }
        return properties;
    }

    static java.util.Properties readBinding(InputStream inputStream) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "PolicyTypeFileHelper.readBinding()..." + inputStream);
        }
        java.util.Properties properties = PolicyTypeFileHelper.readPolicy(inputStream);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...PolicyTypeFileHelper.readBinding()." + inputStream);
        }
        return properties;
    }

    static java.util.Properties readPolicy(InputStream inputStream) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "PolicyTypeFileHelper.readPolicy()... policyIS : " + inputStream);
        }
        java.util.Properties properties = new java.util.Properties();
        List<All> list = PolicyTypeFileHelper.getAlternativesFromStream(inputStream);
        if (list != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "alternatives size : " + list.size());
            }
            All all = list.get(0);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "jax_all : " + all);
            }
            try {
                PolicyTypeFileHelper.populateProperties(properties, all);
            }
            catch (Exception exception) {
                properties = new java.util.Properties();
                throw new IOException("Could not extract all property values.");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...PolicyTypeFileHelper.readPolicy(). policyIS : " + inputStream);
        }
        return properties;
    }

    private static void populateProperties(java.util.Properties properties, All all) throws Exception {
        block24: for (int i = 0; i < TransportConstants.httppolicyElements.length; ++i) {
            switch (i) {
                case 2: {
                    if (all.getChunkTransferEnc() == null) continue block24;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.httppolicyElements[i] + " with " + all.getChunkTransferEnc());
                    }
                    properties.put(TransportConstants.httppolicyElements[i], all.getChunkTransferEnc());
                    continue block24;
                }
                case 9: {
                    if (all.getCompressRequest() == null || all.getCompressRequest().getCompressType() == null || all.getCompressRequest().getCompressType().getName() == null) continue block24;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.httppolicyElements[i] + " with " + all.getCompressRequest());
                    }
                    properties.put("compressRequest:name", all.getCompressRequest().getCompressType().getName());
                    continue block24;
                }
                case 10: {
                    if (all.getCompressResponse() == null || all.getCompressResponse().getCompressType() == null || all.getCompressResponse().getCompressType().getName() == null) continue block24;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.httppolicyElements[i] + " with " + all.getCompressResponse());
                    }
                    properties.put("compressResponse:name", all.getCompressResponse().getCompressType().getName());
                    continue block24;
                }
                case 6: {
                    if (all.getConnectTimeout() == null) continue block24;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.httppolicyElements[i] + " with " + all.getConnectTimeout());
                    }
                    properties.put(TransportConstants.httppolicyElements[i], all.getConnectTimeout());
                    continue block24;
                }
                case 7: {
                    if (all.getPersistConnection() == null) continue block24;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.httppolicyElements[i] + " with " + all.getPersistConnection());
                    }
                    properties.put(TransportConstants.httppolicyElements[i], all.getPersistConnection());
                    continue block24;
                }
                case 15: {
                    if (all.getInResponseSSLenabled() == null) continue block24;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.httppolicyElements[i] + " with " + all.getInResponseSSLenabled());
                    }
                    properties.put(TransportConstants.httppolicyElements[i], all.getInResponseSSLenabled());
                    continue block24;
                }
                case 16: {
                    if (all.getInResponsewithSSL() == null || all.getInResponsewithSSL().getConfigAlias() == null || all.getInResponsewithSSL().getConfigAlias().getName() == null) continue block24;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.httppolicyElements[i] + " with " + "inResponsewithSSL:configAlias" + " : " + all.getInResponsewithSSL().getConfigAlias().getName() + " " + "inResponsewithSSL:configFile" + " : " + all.getInResponsewithSSL().getConfigFile().getPath());
                    }
                    properties.put("inResponsewithSSL:configAlias", all.getInResponsewithSSL().getConfigAlias().getName());
                    properties.put("inResponsewithSSL:configFile", all.getInResponsewithSSL().getConfigFile().getPath());
                    continue block24;
                }
                case 1: {
                    if (all.getMaintainSession() == null) continue block24;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.httppolicyElements[i] + " with " + all.getMaintainSession());
                    }
                    properties.put(TransportConstants.httppolicyElements[i], all.getMaintainSession());
                    continue block24;
                }
                case 8: {
                    if (all.getMessageResendOnce() == null) continue block24;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.httppolicyElements[i] + " with " + all.getMessageResendOnce());
                    }
                    properties.put(TransportConstants.httppolicyElements[i], all.getMessageResendOnce());
                    continue block24;
                }
                case 18: {
                    if (all.getOutAsyncResponseBasicAuth() == null || all.getOutAsyncResponseBasicAuth().getBasicAuth() == null || all.getOutAsyncResponseBasicAuth().getBasicAuth().getUserid() == null) continue block24;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.httppolicyElements[i] + " with " + "outAsyncResponseBasicAuth:userid" + " : " + all.getOutAsyncResponseBasicAuth().getBasicAuth().getUserid() + " " + "outAsyncResponseBasicAuth:password" + " : ********");
                    }
                    properties.put("outAsyncResponseBasicAuth:userid", all.getOutAsyncResponseBasicAuth().getBasicAuth().getUserid());
                    String string = all.getOutAsyncResponseBasicAuth().getBasicAuth().getPassword();
                    if (string != null && !"".equals(string)) {
                        string = PolicyTypeFileHelper.getDecodedPassword(string);
                    }
                    properties.put("outAsyncResponseBasicAuth:password", string);
                    continue block24;
                }
                case 20: {
                    if (all.getOutAsyncResponseProxy() == null || all.getOutAsyncResponseProxy().getBasicAuth() == null || all.getOutAsyncResponseProxy().getBasicAuth().getUserid() == null) continue block24;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.httppolicyElements[i] + " with " + "outAsyncResponseProxy:userid" + " : " + all.getOutAsyncResponseProxy().getBasicAuth().getUserid() + " " + "outAsyncResponseProxy:password" + " : ********" + " " + "outAsyncResponseProxy:host" + " : " + all.getOutAsyncResponseProxy().getConnectInfo().getHost() + " " + "outAsyncResponseProxy:port" + " : " + all.getOutAsyncResponseProxy().getConnectInfo().getPort());
                    }
                    properties.put("outAsyncResponseProxy:userid", all.getOutAsyncResponseProxy().getBasicAuth().getUserid());
                    String string = all.getOutAsyncResponseProxy().getBasicAuth().getPassword();
                    if (string != null && !"".equals(string)) {
                        string = PolicyTypeFileHelper.getDecodedPassword(string);
                    }
                    properties.put("outAsyncResponseProxy:password", string);
                    properties.put("outAsyncResponseProxy:host", all.getOutAsyncResponseProxy().getConnectInfo().getHost());
                    properties.put("outAsyncResponseProxy:port", all.getOutAsyncResponseProxy().getConnectInfo().getPort());
                    continue block24;
                }
                case 13: {
                    if (all.getOutAsyncResponseSSLenabled() == null) continue block24;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.httppolicyElements[i] + " with " + all.getOutAsyncResponseSSLenabled());
                    }
                    properties.put(TransportConstants.httppolicyElements[i], all.getOutAsyncResponseSSLenabled());
                    continue block24;
                }
                case 14: {
                    if (all.getOutAsyncResponsewithSSL() == null || all.getOutAsyncResponsewithSSL().getConfigAlias() == null || all.getOutAsyncResponsewithSSL().getConfigAlias().getName() == null) continue block24;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.httppolicyElements[i] + " with " + "outAsyncResponsewithSSL:configAlias" + " : " + all.getOutAsyncResponsewithSSL().getConfigAlias().getName() + " " + "outAsyncResponsewithSSL:configFile" + " : " + all.getOutAsyncResponsewithSSL().getConfigFile().getPath());
                    }
                    properties.put("outAsyncResponsewithSSL:configAlias", all.getOutAsyncResponsewithSSL().getConfigAlias().getName());
                    properties.put("outAsyncResponsewithSSL:configFile", all.getOutAsyncResponsewithSSL().getConfigFile().getPath());
                    continue block24;
                }
                case 17: {
                    if (all.getOutRequestBasicAuth() == null || all.getOutRequestBasicAuth().getBasicAuth() == null || all.getOutRequestBasicAuth().getBasicAuth().getUserid() == null) continue block24;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.httppolicyElements[i] + " with " + "outRequestBasicAuth:userid" + " : " + all.getOutRequestBasicAuth().getBasicAuth().getUserid() + " " + "outRequestBasicAuth:password" + " : ********");
                    }
                    properties.put("outRequestBasicAuth:userid", all.getOutRequestBasicAuth().getBasicAuth().getUserid());
                    String string = all.getOutRequestBasicAuth().getBasicAuth().getPassword();
                    if (string != null && !"".equals(string)) {
                        string = PolicyTypeFileHelper.getDecodedPassword(string);
                    }
                    properties.put("outRequestBasicAuth:password", string);
                    continue block24;
                }
                case 19: {
                    if (all.getOutRequestProxy() == null || all.getOutRequestProxy().getBasicAuth() == null || all.getOutRequestProxy().getBasicAuth().getUserid() == null) continue block24;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.httppolicyElements[i] + " with " + "outRequestProxy:userid" + " : " + all.getOutRequestProxy().getBasicAuth().getUserid() + " " + "outRequestProxy:password" + " : ********" + " " + "outRequestProxy:host" + " : " + all.getOutRequestProxy().getConnectInfo().getHost() + " " + "outRequestProxy:port" + " : " + all.getOutRequestProxy().getConnectInfo().getPort());
                    }
                    properties.put("outRequestProxy:userid", all.getOutRequestProxy().getBasicAuth().getUserid());
                    String string = all.getOutRequestProxy().getBasicAuth().getPassword();
                    if (string != null && !"".equals(string)) {
                        string = PolicyTypeFileHelper.getDecodedPassword(string);
                    }
                    properties.put("outRequestProxy:password", string);
                    properties.put("outRequestProxy:host", all.getOutRequestProxy().getConnectInfo().getHost());
                    properties.put("outRequestProxy:port", all.getOutRequestProxy().getConnectInfo().getPort());
                    continue block24;
                }
                case 11: {
                    if (all.getOutRequestSSLenabled() == null) continue block24;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.httppolicyElements[i] + " with " + all.getOutRequestSSLenabled());
                    }
                    properties.put(TransportConstants.httppolicyElements[i], all.getOutRequestSSLenabled());
                    continue block24;
                }
                case 12: {
                    if (all.getOutRequestwithSSL() == null || all.getOutRequestwithSSL().getConfigAlias() == null || all.getOutRequestwithSSL().getConfigAlias().getName() == null) continue block24;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.httppolicyElements[i] + " with " + "outRequestwithSSL:configAlias" + " : " + all.getOutRequestwithSSL().getConfigAlias().getName() + " " + "outRequestwithSSL:configFile" + " : " + all.getOutRequestwithSSL().getConfigFile().getPath());
                    }
                    properties.put("outRequestwithSSL:configAlias", all.getOutRequestwithSSL().getConfigAlias().getName());
                    properties.put("outRequestwithSSL:configFile", all.getOutRequestwithSSL().getConfigFile().getPath());
                    continue block24;
                }
                case 0: {
                    if (all.getProtocolVersion() == null) continue block24;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.httppolicyElements[i] + " with " + all.getProtocolVersion());
                    }
                    properties.put(TransportConstants.httppolicyElements[i], all.getProtocolVersion());
                    continue block24;
                }
                case 4: {
                    if (all.getReadTimeout() == null) continue block24;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.httppolicyElements[i] + " with " + all.getReadTimeout());
                    }
                    properties.put(TransportConstants.httppolicyElements[i], all.getReadTimeout());
                    continue block24;
                }
                case 3: {
                    if (all.getSendExpectHeader() == null) continue block24;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.httppolicyElements[i] + " with " + all.getSendExpectHeader());
                    }
                    properties.put(TransportConstants.httppolicyElements[i], all.getSendExpectHeader());
                    continue block24;
                }
                case 5: {
                    if (all.getWriteTimeout() == null) continue block24;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.httppolicyElements[i] + " with " + all.getWriteTimeout());
                    }
                    properties.put(TransportConstants.httppolicyElements[i], all.getWriteTimeout());
                    continue block24;
                }
                case 21: {
                    if (all.getAcceptRedirectedURL() == null) continue block24;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.httppolicyElements[i] + " with " + all.getAcceptRedirectedURL());
                    }
                    properties.put(TransportConstants.httppolicyElements[i], all.getAcceptRedirectedURL());
                }
            }
        }
        if (all.getProperties() != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "readPolicy", "1 Setting custom properties with " + all.getProperties().toString());
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "readPolicy", "2 Setting custom properties with " + all.getProperties().getCustomProperty() + "size : " + all.getProperties().getCustomProperty().size());
            }
            List<CustomProperty> list = all.getProperties().getCustomProperty();
            for (int i = 0; i < list.size(); ++i) {
                CustomProperty customProperty = list.get(i);
                properties.put("properties_" + i + ":" + "name", customProperty.getName());
                properties.put("properties_" + i + ":" + "value", customProperty.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<All> getAlternativesFromFile(String string) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "PolicyTypeFileHelper.getAlternativesFromFile()...");
        }
        List<All> list = new ArrayList<All>();
        InputStream inputStream = null;
        try {
            final ClassLoader classLoader = PolicyTypeFileHelper.class.getClassLoader();
            JAXBContext jAXBContext = null;
            try {
                jAXBContext = (JAXBContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return JAXBContext.newInstance("com.ibm.ws.websvcs.transport.policyset.jaxb", classLoader);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            File file = new File(string);
            if (!file.exists()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getAlternativesFromFile", "File does not exist: " + string);
                }
                List<All> list2 = null;
                return list2;
            }
            inputStream = new FileInputStream(file);
            list = PolicyTypeFileHelper.getAlternativesFromStream(inputStream);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, CLASSNAME, "1:207:1.2");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getAlternativesFromFile", "Exception caught during unmarshalling: " + exception);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...PolicyTypeFileHelper.getAlternativesFromFile()");
        }
        return list;
    }

    private static List<All> getAlternativesFromStream(InputStream inputStream) {
        List<All> list;
        block12: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "PolicyTypeFileHelper.getAlternativesFromStream()...");
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getAlternativesFromStream", "Policy InputStream: " + inputStream);
            }
            if (inputStream == null) {
                return null;
            }
            list = new ArrayList<All>();
            try {
                final ClassLoader classLoader = PolicyTypeFileHelper.class.getClassLoader();
                JAXBContext jAXBContext = null;
                try {
                    jAXBContext = (JAXBContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return JAXBContext.newInstance("com.ibm.ws.websvcs.transport.policyset.jaxb", classLoader);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
                Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
                InputStream inputStream2 = inputStream;
                StreamSource streamSource = new StreamSource(inputStream2);
                JAXBElement<Policy> jAXBElement = unmarshaller.unmarshal(streamSource, Policy.class);
                if (jAXBElement != null) {
                    Policy policy;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "getAlternativesFromStream", "JAXBElement<Policy> unmarshalled: " + jAXBElement);
                    }
                    if ((policy = jAXBElement.getValue()) != null && policy.getExactlyOne() != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "getAlternativesFromStream", "An ExactlyOne element found.");
                        }
                        list = policy.getExactlyOne().getAll();
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, CLASSNAME, "1:207:1.2");
                if (!_tc.isDebugEnabled()) break block12;
                Tr.debug(_tc, "getAlternativesFromStream", "Exception caught during unmarshalling: " + exception);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...PolicyTypeFileHelper.getAlternativesFromStream() " + list.toArray().toString());
        }
        return list;
    }

    private static Policy createPolicyObject(java.util.Properties properties) throws Exception {
        All all;
        Policy policy;
        ExactlyOne exactlyOne;
        block94: {
            String string;
            block93: {
                Object[] objectArray;
                Object object;
                Object object2;
                ObjectFactory objectFactory;
                block92: {
                    Object object3;
                    Object object4;
                    block91: {
                        block90: {
                            String string2;
                            Object object5;
                            block89: {
                                block88: {
                                    Object object6;
                                    Object object7;
                                    block87: {
                                        block86: {
                                            block85: {
                                                block84: {
                                                    block83: {
                                                        block82: {
                                                            Object object8;
                                                            block81: {
                                                                String string3;
                                                                block80: {
                                                                    block79: {
                                                                        block78: {
                                                                            block77: {
                                                                                block76: {
                                                                                    block75: {
                                                                                        block74: {
                                                                                            block73: {
                                                                                                block72: {
                                                                                                    if (_tc.isEntryEnabled()) {
                                                                                                        Tr.entry(_tc, "PolicyTypeFileHelper.createPolicyObject()...");
                                                                                                    }
                                                                                                    objectFactory = new ObjectFactory();
                                                                                                    exactlyOne = objectFactory.createExactlyOne();
                                                                                                    policy = objectFactory.createPolicy();
                                                                                                    policy.setExactlyOne(exactlyOne);
                                                                                                    all = objectFactory.createAll();
                                                                                                    string = properties.getProperty("protocolVersion");
                                                                                                    if (string != null) {
                                                                                                        try {
                                                                                                            all.setProtocolVersion(string);
                                                                                                        }
                                                                                                        catch (ClassCastException classCastException) {
                                                                                                            FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "696");
                                                                                                            if (!_tc.isErrorEnabled()) break block72;
                                                                                                            Tr.error(_tc, "nonStrElemReceived00", "protocolVersion");
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                                if ((string = properties.getProperty("chunkTransferEnc")) != null) {
                                                                                                    try {
                                                                                                        all.setChunkTransferEnc(string);
                                                                                                    }
                                                                                                    catch (ClassCastException classCastException) {
                                                                                                        FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "709");
                                                                                                        if (!_tc.isErrorEnabled()) break block73;
                                                                                                        Tr.error(_tc, "nonStrElemReceived00", "chunkTransferEnc");
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                            if ((string = properties.getProperty("readTimeout")) != null) {
                                                                                                try {
                                                                                                    all.setReadTimeout(string);
                                                                                                }
                                                                                                catch (ClassCastException classCastException) {
                                                                                                    FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "722");
                                                                                                    if (!_tc.isErrorEnabled()) break block74;
                                                                                                    Tr.error(_tc, "nonStrElemReceived00", "readTimeout");
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                        if ((string = properties.getProperty("sendExpectHeader")) != null) {
                                                                                            try {
                                                                                                all.setSendExpectHeader(string);
                                                                                            }
                                                                                            catch (ClassCastException classCastException) {
                                                                                                FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "735");
                                                                                                if (!_tc.isErrorEnabled()) break block75;
                                                                                                Tr.error(_tc, "nonStrElemReceived00", "sendExpectHeader");
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                    if ((string = properties.getProperty("writeTimeout")) != null) {
                                                                                        try {
                                                                                            all.setWriteTimeout(string);
                                                                                        }
                                                                                        catch (ClassCastException classCastException) {
                                                                                            FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "748");
                                                                                            if (!_tc.isErrorEnabled()) break block76;
                                                                                            Tr.error(_tc, "nonStrElemReceived00", "writeTimeout");
                                                                                        }
                                                                                    }
                                                                                }
                                                                                if ((string = properties.getProperty("connectTimeout")) != null) {
                                                                                    try {
                                                                                        all.setConnectTimeout(string);
                                                                                    }
                                                                                    catch (ClassCastException classCastException) {
                                                                                        FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "762");
                                                                                        if (!_tc.isErrorEnabled()) break block77;
                                                                                        Tr.error(_tc, "nonStrElemReceived00", "connectTimeout");
                                                                                    }
                                                                                }
                                                                            }
                                                                            if ((string = properties.getProperty("maintainSession")) != null) {
                                                                                try {
                                                                                    all.setMaintainSession(string);
                                                                                }
                                                                                catch (ClassCastException classCastException) {
                                                                                    FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "776");
                                                                                    if (!_tc.isErrorEnabled()) break block78;
                                                                                    Tr.error(_tc, "nonStrElemReceived00", "maintainSession");
                                                                                }
                                                                            }
                                                                        }
                                                                        if ((string = properties.getProperty("messageResendOnce")) != null) {
                                                                            try {
                                                                                all.setMessageResendOnce(string);
                                                                            }
                                                                            catch (ClassCastException classCastException) {
                                                                                FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "790");
                                                                                if (!_tc.isErrorEnabled()) break block79;
                                                                                Tr.error(_tc, "nonStrElemReceived00", "messageResendOnce");
                                                                            }
                                                                        }
                                                                    }
                                                                    if ((string = properties.getProperty("persistConnection")) != null) {
                                                                        try {
                                                                            all.setPersistConnection(string);
                                                                        }
                                                                        catch (ClassCastException classCastException) {
                                                                            FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "804");
                                                                            if (!_tc.isErrorEnabled()) break block80;
                                                                            Tr.error(_tc, "nonStrElemReceived00", "persistConnection");
                                                                        }
                                                                    }
                                                                }
                                                                if ((string3 = properties.getProperty("compressRequest:name")) != null) {
                                                                    try {
                                                                        object8 = objectFactory.createCompressType();
                                                                        ((CompressType)object8).setName(string3);
                                                                        object7 = objectFactory.createCompressRequest();
                                                                        object7.setCompressType((CompressType)object8);
                                                                        all.setCompressRequest((CompressRequest)object7);
                                                                    }
                                                                    catch (ClassCastException classCastException) {
                                                                        FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "823");
                                                                        if (!_tc.isErrorEnabled()) break block81;
                                                                        object7 = new Object[]{CompressRequest.class.getCanonicalName(), "compressRequest"};
                                                                        Tr.error(_tc, "nonStrElemReceived01", object7);
                                                                    }
                                                                }
                                                            }
                                                            if ((object8 = properties.getProperty("compressResponse:name")) != null) {
                                                                try {
                                                                    object7 = objectFactory.createCompressType();
                                                                    object7.setName((String)object8);
                                                                    object6 = objectFactory.createCompressResponse();
                                                                    object6.setCompressType((CompressType)object7);
                                                                    all.setCompressResponse((CompressResponse)object6);
                                                                }
                                                                catch (ClassCastException classCastException) {
                                                                    FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "841");
                                                                    if (!_tc.isErrorEnabled()) break block82;
                                                                    object6 = new Object[]{CompressResponse.class.getCanonicalName(), "compressResponse"};
                                                                    Tr.error(_tc, "nonStrElemReceived01", object6);
                                                                }
                                                            }
                                                        }
                                                        if ((string = properties.getProperty("inResponseSSLenabled")) != null) {
                                                            try {
                                                                all.setInResponseSSLenabled(string);
                                                            }
                                                            catch (ClassCastException classCastException) {
                                                                FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "855");
                                                                if (!_tc.isErrorEnabled()) break block83;
                                                                Tr.error(_tc, "nonStrElemReceived00", "inResponseSSLenabled");
                                                            }
                                                        }
                                                    }
                                                    object7 = null;
                                                    object6 = null;
                                                    object7 = properties.getProperty("inResponsewithSSL:configAlias");
                                                    object6 = properties.getProperty("inResponsewithSSL:configFile");
                                                    if (object7 != null && object6 != null) {
                                                        try {
                                                            object4 = objectFactory.createConfigAlias();
                                                            ((ConfigAlias)object4).setName((String)object7);
                                                            object3 = objectFactory.createConfigFile();
                                                            ((ConfigFile)object3).setPath((String)object6);
                                                            object5 = objectFactory.createInResponsewithSSL();
                                                            ((InResponsewithSSL)object5).setConfigAlias((ConfigAlias)object4);
                                                            ((InResponsewithSSL)object5).setConfigFile((ConfigFile)object3);
                                                            all.setInResponsewithSSL((InResponsewithSSL)object5);
                                                        }
                                                        catch (ClassCastException classCastException) {
                                                            FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "882");
                                                            if (!_tc.isErrorEnabled()) break block84;
                                                            object3 = new Object[]{InResponsewithSSL.class.getCanonicalName(), "inResponsewithSSL"};
                                                            Tr.error(_tc, "nonStrElemReceived01", object3);
                                                        }
                                                    }
                                                }
                                                if ((string = properties.getProperty("outAsyncResponseSSLenabled")) != null) {
                                                    try {
                                                        all.setOutAsyncResponseSSLenabled(string);
                                                    }
                                                    catch (ClassCastException classCastException) {
                                                        FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "896");
                                                        if (!_tc.isErrorEnabled()) break block85;
                                                        Tr.error(_tc, "nonStrElemReceived00", "outAsyncResponseSSLenabled");
                                                    }
                                                }
                                            }
                                            object7 = null;
                                            object6 = null;
                                            object7 = properties.getProperty("outAsyncResponsewithSSL:configAlias");
                                            object6 = properties.getProperty("outAsyncResponsewithSSL:configFile");
                                            if (object7 != null && object6 != null) {
                                                try {
                                                    object4 = objectFactory.createConfigAlias();
                                                    ((ConfigAlias)object4).setName((String)object7);
                                                    object3 = objectFactory.createConfigFile();
                                                    ((ConfigFile)object3).setPath((String)object6);
                                                    object5 = objectFactory.createOutAsyncResponsewithSSL();
                                                    ((OutAsyncResponsewithSSL)object5).setConfigAlias((ConfigAlias)object4);
                                                    ((OutAsyncResponsewithSSL)object5).setConfigFile((ConfigFile)object3);
                                                    all.setOutAsyncResponsewithSSL((OutAsyncResponsewithSSL)object5);
                                                }
                                                catch (ClassCastException classCastException) {
                                                    FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "922");
                                                    if (!_tc.isErrorEnabled()) break block86;
                                                    object3 = new Object[]{OutAsyncResponsewithSSL.class.getCanonicalName(), "outAsyncResponsewithSSL"};
                                                    Tr.error(_tc, "nonStrElemReceived01", object3);
                                                }
                                            }
                                        }
                                        if ((string = properties.getProperty("outRequestSSLenabled")) != null) {
                                            try {
                                                all.setOutRequestSSLenabled(string);
                                            }
                                            catch (ClassCastException classCastException) {
                                                FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "936");
                                                if (!_tc.isErrorEnabled()) break block87;
                                                Tr.error(_tc, "nonStrElemReceived00", "outRequestSSLenabled");
                                            }
                                        }
                                    }
                                    object7 = null;
                                    object6 = null;
                                    object7 = properties.getProperty("outRequestwithSSL:configAlias");
                                    object6 = properties.getProperty("outRequestwithSSL:configFile");
                                    if (object7 != null && object6 != null) {
                                        try {
                                            object4 = objectFactory.createConfigAlias();
                                            ((ConfigAlias)object4).setName((String)object7);
                                            object3 = objectFactory.createConfigFile();
                                            ((ConfigFile)object3).setPath((String)object6);
                                            object5 = objectFactory.createOutRequestwithSSL();
                                            ((OutRequestwithSSL)object5).setConfigAlias((ConfigAlias)object4);
                                            ((OutRequestwithSSL)object5).setConfigFile((ConfigFile)object3);
                                            all.setOutRequestwithSSL((OutRequestwithSSL)object5);
                                        }
                                        catch (ClassCastException classCastException) {
                                            FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "961");
                                            if (!_tc.isErrorEnabled()) break block88;
                                            object3 = new Object[]{OutRequestwithSSL.class.getCanonicalName(), "outRequestwithSSL"};
                                            Tr.error(_tc, "nonStrElemReceived01", object3);
                                        }
                                    }
                                }
                                object4 = null;
                                object3 = null;
                                object5 = null;
                                string2 = null;
                                object4 = properties.getProperty("outRequestProxy:userid");
                                object3 = properties.getProperty("outRequestProxy:password");
                                object5 = properties.getProperty("outRequestProxy:host");
                                string2 = properties.getProperty("outRequestProxy:port");
                                if (object4 != null && object3 != null && object5 != null && string2 != null) {
                                    try {
                                        object3 = PasswordUtil.encode((String)object3);
                                        object2 = objectFactory.createBasicAuth();
                                        ((BasicAuth)object2).setUserid((String)object4);
                                        ((BasicAuth)object2).setPassword((String)object3);
                                        object = objectFactory.createConnectInfo();
                                        ((ConnectInfo)object).setHost((String)object5);
                                        ((ConnectInfo)object).setPort(string2);
                                        objectArray = objectFactory.createOutRequestProxy();
                                        objectArray.setBasicAuth((BasicAuth)object2);
                                        objectArray.setConnectInfo((ConnectInfo)object);
                                        all.setOutRequestProxy((OutRequestProxy)objectArray);
                                    }
                                    catch (ClassCastException classCastException) {
                                        FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "993");
                                        if (!_tc.isErrorEnabled()) break block89;
                                        object = new Object[]{OutRequestProxy.class.getCanonicalName(), "outRequestProxy"};
                                        Tr.error(_tc, "nonStrElemReceived01", object);
                                    }
                                }
                            }
                            object4 = null;
                            object3 = null;
                            object5 = null;
                            string2 = null;
                            object4 = properties.getProperty("outAsyncResponseProxy:userid");
                            object3 = properties.getProperty("outAsyncResponseProxy:password");
                            object5 = properties.getProperty("outAsyncResponseProxy:host");
                            string2 = properties.getProperty("outAsyncResponseProxy:port");
                            if (object4 != null && object3 != null && object5 != null && string2 != null) {
                                try {
                                    object3 = PasswordUtil.encode((String)object3);
                                    object2 = objectFactory.createBasicAuth();
                                    ((BasicAuth)object2).setUserid((String)object4);
                                    ((BasicAuth)object2).setPassword((String)object3);
                                    object = objectFactory.createConnectInfo();
                                    ((ConnectInfo)object).setHost((String)object5);
                                    ((ConnectInfo)object).setPort(string2);
                                    objectArray = objectFactory.createOutAsyncResponseProxy();
                                    objectArray.setBasicAuth((BasicAuth)object2);
                                    objectArray.setConnectInfo((ConnectInfo)object);
                                    all.setOutAsyncResponseProxy((OutAsyncResponseProxy)objectArray);
                                }
                                catch (ClassCastException classCastException) {
                                    FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "1026");
                                    if (!_tc.isErrorEnabled()) break block90;
                                    object = new Object[]{OutAsyncResponseProxy.class.getCanonicalName(), "outAsyncResponseProxy"};
                                    Tr.error(_tc, "nonStrElemReceived01", object);
                                }
                            }
                        }
                        object4 = null;
                        object3 = null;
                        object4 = properties.getProperty("outAsyncResponseBasicAuth:userid");
                        object3 = properties.getProperty("outAsyncResponseBasicAuth:password");
                        if (object4 != null && object3 != null) {
                            try {
                                object3 = PasswordUtil.encode((String)object3);
                                object2 = objectFactory.createBasicAuth();
                                ((BasicAuth)object2).setUserid((String)object4);
                                ((BasicAuth)object2).setPassword((String)object3);
                                object = objectFactory.createOutAsyncResponseBasicAuth();
                                ((OutAsyncResponseBasicAuth)object).setBasicAuth((BasicAuth)object2);
                                all.setOutAsyncResponseBasicAuth((OutAsyncResponseBasicAuth)object);
                            }
                            catch (ClassCastException classCastException) {
                                FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "1048");
                                if (!_tc.isErrorEnabled()) break block91;
                                object = new Object[]{OutAsyncResponseBasicAuth.class.getCanonicalName(), "outAsyncResponseBasicAuth"};
                                Tr.error(_tc, "nonStrElemReceived01", object);
                            }
                        }
                    }
                    object4 = null;
                    object3 = null;
                    object4 = properties.getProperty("outRequestBasicAuth:userid");
                    object3 = properties.getProperty("outRequestBasicAuth:password");
                    if (object4 != null && object3 != null) {
                        try {
                            object3 = PasswordUtil.encode((String)object3);
                            object2 = objectFactory.createBasicAuth();
                            ((BasicAuth)object2).setUserid((String)object4);
                            ((BasicAuth)object2).setPassword((String)object3);
                            object = objectFactory.createOutRequestBasicAuth();
                            ((OutRequestBasicAuth)object).setBasicAuth((BasicAuth)object2);
                            all.setOutRequestBasicAuth((OutRequestBasicAuth)object);
                        }
                        catch (ClassCastException classCastException) {
                            FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "1070");
                            if (!_tc.isErrorEnabled()) break block92;
                            object = new Object[]{OutRequestBasicAuth.class.getCanonicalName(), "outRequestBasicAuth"};
                            Tr.error(_tc, "nonStrElemReceived01", object);
                        }
                    }
                }
                if ((object2 = PolicyTypeFileHelper.getCustomProperties(properties)).size() > 0) {
                    try {
                        object = objectFactory.createProperties();
                        objectArray = object2.iterator();
                        while (objectArray.hasNext()) {
                            ((Properties)object).getCustomProperty().add((CustomProperty)objectArray.next());
                        }
                        all.setProperties((Properties)object);
                    }
                    catch (ClassCastException classCastException) {
                        FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "1084");
                        if (!_tc.isErrorEnabled()) break block93;
                        objectArray = new Object[]{Properties.class.getCanonicalName(), "properties"};
                        Tr.error(_tc, "nonStrElemReceived01", objectArray);
                    }
                }
            }
            if ((string = properties.getProperty("acceptRedirectedURL")) != null) {
                try {
                    all.setAcceptRedirectedURL(string);
                }
                catch (ClassCastException classCastException) {
                    FFDCFilter.processException(classCastException, "com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper.createPolicyObject", "1099");
                    if (!_tc.isErrorEnabled()) break block94;
                    Tr.error(_tc, "nonStrElemReceived00", "acceptRedirectedURL");
                }
            }
        }
        exactlyOne.getAll().add(all);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...PolicyTypeFileHelper.createPolicyObject()");
        }
        return policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void expandAttributes(java.util.Properties properties, VariableExpander variableExpander) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "expandAttributes");
        }
        if (properties == null || variableExpander == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Properties or expander is null. Not expanding.");
            }
            return;
        }
        try {
            for (String string : properties.keySet()) {
                String string2 = properties.getProperty(string);
                string2 = variableExpander.expand(string2);
                properties.setProperty(string, string2);
            }
        }
        catch (Exception exception) {
            Tr.error(_tc, "caughtException", exception);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "expandAttributes");
            }
        }
    }

    private static List<CustomProperty> getCustomProperties(java.util.Properties properties) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCustomProperties");
        }
        ArrayList<CustomProperty> arrayList = new ArrayList<CustomProperty>();
        for (String string : properties.keySet()) {
            int n = string.lastIndexOf(58);
            if (!string.startsWith("properties") || n == -1 || !string.substring(n + 1).equals("name")) continue;
            String string2 = (String)properties.get(string);
            String string3 = PolicyTypeFileHelper.findCustomPropertyValue(properties, string);
            if (string3 != null && !"".equals(string3)) {
                CustomProperty customProperty = new CustomProperty();
                customProperty.setName(string2);
                customProperty.setValue(string3);
                arrayList.add(customProperty);
            }
            if (!_tc.isDebugEnabled()) continue;
            Tr.debug(_tc, "Obtained custom property name=" + string2 + " value=" + string3);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCustomProperties");
        }
        return arrayList;
    }

    private static String findCustomPropertyValue(java.util.Properties properties, String string) {
        String string2 = string.substring(0, string.lastIndexOf(58) + 1) + "value";
        for (String string3 : properties.keySet()) {
            if (!string2.equals(string3)) continue;
            return (String)properties.get(string2);
        }
        return "";
    }

    public static String maskPasswords(java.util.Properties properties) {
        if (properties == null) {
            return "NONE";
        }
        String string = properties.toString();
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = string.indexOf("password=", n)) >= 0) {
            stringBuffer.append(string.substring(n, n2 += "password=".length()));
            n = n2;
            n2 = string.indexOf(44, n);
            for (int i = 0; i < n2 - n; ++i) {
                stringBuffer.append("*");
            }
            n = n2;
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    private static String getDecodedPassword(String string) throws Exception {
        if (PasswordUtil.getCryptoAlgorithm(string) != null) {
            return PasswordUtil.decode(string);
        }
        return string;
    }
}

