/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.util.Properties;
import org.apache.axis2.description.AxisService;

public class PolicySetUtils
implements Constants {
    private static final TraceComponent _tc = Tr.register(PolicySetUtils.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public static String getOutReqWithSSLConfigAlias(AxisService axisService) {
        Properties properties = PolicySetUtils.getSSLBindings(axisService);
        if (properties == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Binding Props were null.");
            }
            return null;
        }
        return properties.getProperty("outRequestwithSSL:configAlias");
    }

    public static String getOutAsyncRspWithSSLConfigAlias(AxisService axisService) {
        Properties properties = PolicySetUtils.getSSLBindings(axisService);
        if (properties == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Binding Props were null.");
            }
            return null;
        }
        return properties.getProperty("outAsyncResponsewithSSL:configAlias");
    }

    public static String getInAsyncRspWithSSLConfigAlias(AxisService axisService) {
        Properties properties = PolicySetUtils.getSSLBindings(axisService);
        if (properties == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Binding Props were null.");
            }
            return null;
        }
        return properties.getProperty("inResponsewithSSL:configAlias");
    }

    public static String getOutReqWithSSLFile(AxisService axisService) {
        Properties properties = PolicySetUtils.getSSLBindings(axisService);
        if (properties == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Binding Props were null.");
            }
            return null;
        }
        return properties.getProperty("outRequestwithSSL:configFile");
    }

    public static String getOutAsyncRspWithSSLFile(AxisService axisService) {
        Properties properties = PolicySetUtils.getSSLBindings(axisService);
        if (properties == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Binding Props were null.");
            }
            return null;
        }
        return properties.getProperty("outAsyncResponsewithSSL:configFile");
    }

    public static String getInAsyncRspWithSSLFile(AxisService axisService) {
        Properties properties = PolicySetUtils.getSSLBindings(axisService);
        if (properties == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Binding Props were null.");
            }
            return null;
        }
        return properties.getProperty("inResponsewithSSL:configFile");
    }

    public static String getListeningPort(AxisService axisService) {
        Properties properties = PolicySetUtils.getHTTPBindings(axisService);
        if (properties == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Policy Props were null.");
            }
            return null;
        }
        return PolicySetUtils.getCustomBindingValue(properties, "com.ibm.websphere.webservices.http.listenerPort");
    }

    public static String getSecureListeningPort(AxisService axisService) {
        Properties properties = PolicySetUtils.getSSLBindings(axisService);
        if (properties == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Policy Props were null.");
            }
            return null;
        }
        return PolicySetUtils.getCustomBindingValue(properties, "com.ibm.websphere.webservices.https.listenerPort");
    }

    public static boolean isOutReqSSLenabled(AxisService axisService) {
        Properties properties = PolicySetUtils.getSSLPolicy(axisService);
        if (properties == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Policy Props were null.");
            }
            return false;
        }
        String string = properties.getProperty("outRequestSSLenabled");
        return "yes".equalsIgnoreCase(string);
    }

    public static boolean isOutAsyncRspSSLenabled(AxisService axisService) {
        Properties properties = PolicySetUtils.getSSLPolicy(axisService);
        if (properties == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Policy Props were null.");
            }
            return false;
        }
        String string = properties.getProperty("outAsyncResponseSSLenabled");
        return "yes".equalsIgnoreCase(string);
    }

    public static boolean isInAsyncRspSSLenabled(AxisService axisService) {
        Properties properties = PolicySetUtils.getSSLPolicy(axisService);
        if (properties == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Policy Props were null.");
            }
            return false;
        }
        String string = properties.getProperty("inResponseSSLenabled");
        return "yes".equalsIgnoreCase(string);
    }

    public static Properties getSSLBindings(AxisService axisService) {
        if (axisService == null) {
            return null;
        }
        PolicySetConfiguration policySetConfiguration = (PolicySetConfiguration)Axis2Utils.getPolicySet(axisService);
        if (policySetConfiguration == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Policy Set was null.");
            }
            return null;
        }
        return (Properties)policySetConfiguration.getPolicyTypeBinding("SSL_BINDING");
    }

    public static Properties getSSLPolicy(AxisService axisService) {
        if (axisService == null) {
            return null;
        }
        PolicySetConfiguration policySetConfiguration = (PolicySetConfiguration)Axis2Utils.getPolicySet(axisService);
        if (policySetConfiguration == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Policy Set was null.");
            }
            return null;
        }
        return (Properties)policySetConfiguration.getPolicyTypeConfiguration("SSL_POLICY");
    }

    public static Properties getHTTPBindings(AxisService axisService) {
        if (axisService == null) {
            return null;
        }
        PolicySetConfiguration policySetConfiguration = (PolicySetConfiguration)Axis2Utils.getPolicySet(axisService);
        if (policySetConfiguration == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Policy Set was null.");
            }
            return null;
        }
        return (Properties)policySetConfiguration.getPolicyTypeBinding("HTTP_BINDING");
    }

    public static Properties getHTTPPolicy(AxisService axisService) {
        if (axisService == null) {
            return null;
        }
        PolicySetConfiguration policySetConfiguration = (PolicySetConfiguration)Axis2Utils.getPolicySet(axisService);
        if (policySetConfiguration == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Policy Set was null.");
            }
            return null;
        }
        return (Properties)policySetConfiguration.getPolicyTypeConfiguration("HTTP_POLICY");
    }

    public static String getCustomBindingValue(Properties properties, String string) {
        if (properties == null || properties.isEmpty() || string == null) {
            return null;
        }
        for (String string2 : properties.keySet()) {
            if (!string.equalsIgnoreCase(properties.getProperty(string2))) continue;
            String string3 = string2.substring(0, string2.lastIndexOf(58) + 1) + "value";
            return properties.getProperty(string3);
        }
        return null;
    }
}

