/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.policyset.runtime.BindingLoader;
import com.ibm.ws.policyset.runtime.DefaultBinding;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class HttpDefaultBindingLoader
implements BindingLoader {
    private static final TraceComponent _tc = Tr.register(HttpDefaultBindingLoader.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public void init(Map map) throws Exception {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "init");
        }
    }

    public void loadCustom(ClassLoader classLoader, ClassLoader classLoader2, VariableExpander variableExpander, InputStream inputStream, DefaultBinding defaultBinding, PolicySetConfiguration policySetConfiguration) throws Exception {
        Properties properties;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadCustom", new Object[]{classLoader, classLoader2, variableExpander, inputStream, defaultBinding, policySetConfiguration});
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Reading custom binding policy from " + inputStream);
        }
        if ((properties = PolicyTypeFileHelper.readBinding(inputStream)) == null || properties.isEmpty()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Custom binding is not available...reading default binding policy...");
            }
            properties = (Properties)defaultBinding.getDefaultBinding("HTTP_BINDING");
        }
        if (properties != null && !properties.isEmpty() && policySetConfiguration != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting binding properties to PolicySet configuration...");
            }
            PolicyTypeFileHelper.expandAttributes(properties, variableExpander);
            policySetConfiguration.setPolicyTypeBinding("HTTP_BINDING", properties);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadCustom");
        }
    }

    public void loadDefault(ClassLoader classLoader, VariableExpander variableExpander, InputStream inputStream, DefaultBinding defaultBinding) throws Exception {
        Properties properties;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadDefault", new Object[]{classLoader, variableExpander, inputStream, defaultBinding});
        }
        if ((properties = PolicyTypeFileHelper.readBinding(inputStream)) != null && !properties.isEmpty()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Read default binding properties from: " + inputStream);
            }
            PolicyTypeFileHelper.expandAttributes(properties, variableExpander);
            if (defaultBinding != null) {
                defaultBinding.setDefaultBinding("HTTP_BINDING", properties);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadDefault");
        }
    }

    public String getType() throws Exception {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getType", "HTTPTransport");
        }
        return "HTTPTransport";
    }

    public void destroy() throws Exception {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "destroy");
        }
    }
}

