/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.AsyncEPRSet;
import com.ibm.ws.websvcs.transport.AsyncResponseContextMap;
import com.ibm.ws.websvcs.transport.WASTransportListener;
import com.ibm.ws.websvcs.transport.channel.AsyncInRespChannelFactory;
import com.ibm.ws.websvcs.transport.channel.WSChannelManager;
import com.ibm.ws.websvcs.transport.common.JavaUtils;
import com.ibm.ws.websvcs.transport.policyset.PolicySetUtils;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChainGroupException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.InvalidRuntimeStateException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.transport.http.server.HttpFactory;

public class WAShttpAsyncResponseListener
implements WASTransportListener {
    private static final TraceComponent _tc = Tr.register(WAShttpAsyncResponseListener.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static String chanChainName = null;
    private static String[] CHAIN_ARRAY = new String[]{"WS-tcp-inbound", "WS-http-inbound", "async-inResponse-channel"};
    private int runtimeHash = Runtime.getRuntime().hashCode();
    protected static String COLON = ":";
    protected static AsyncResponseContextMap asyncRCMap = null;
    protected static ChannelFramework cf = null;
    protected static boolean chainStarted = false;
    private static String tcpChannelFactoryName = "com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory";
    int port = -1;
    public static int DEFAULT_PORT = 0;
    protected String hostAddress = null;
    protected String contextPath;
    protected ConfigurationContext configContext;
    protected HttpFactory httpFactory;
    private static int DEFAULT_PERSIST_TIMEOUT = 30000;

    public static void printUsage() {
        System.out.println("Usage: WAShttpAsyncResponseListener [options] <repository>");
        System.out.println(" Opts: -? this message");
        System.out.println();
        System.out.println("       -p port to listen on (default is randomly assigned)");
        System.exit(1);
    }

    public static void main(String[] stringArray) throws Exception {
        int n = DEFAULT_PORT;
        try {
            ConfigurationContext configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
            WAShttpAsyncResponseListener wAShttpAsyncResponseListener = new WAShttpAsyncResponseListener(configurationContext, n);
            wAShttpAsyncResponseListener.delayStart(null);
            ListenerManager listenerManager = configurationContext.getListenerManager();
            TransportInDescription transportInDescription = new TransportInDescription(new QName("http"));
            transportInDescription.setReceiver(wAShttpAsyncResponseListener);
            if (listenerManager == null) {
                listenerManager = new ListenerManager();
                listenerManager.init(configurationContext);
            }
            listenerManager.addListener(transportInDescription, true);
            Thread.sleep(3600000L);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.transport.http.client.WAShttpAsyncResponseListener.main", "193");
            throwable.printStackTrace();
            System.out.println("[WAShttpAsyncResponseListener] Shutting down");
        }
    }

    public WAShttpAsyncResponseListener() {
        final WAShttpAsyncResponseListener wAShttpAsyncResponseListener = this;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Runtime.getRuntime().addShutdownHook(new ShutdownThread(wAShttpAsyncResponseListener));
                return null;
            }
        });
    }

    public WAShttpAsyncResponseListener(ConfigurationContext configurationContext, int n) throws AxisFault {
        this(new HttpFactory(configurationContext, n));
        this.configContext = configurationContext;
    }

    public WAShttpAsyncResponseListener(HttpFactory httpFactory) throws AxisFault {
        this.httpFactory = httpFactory;
        this.configContext = httpFactory.getConfigurationContext();
        this.port = httpFactory.getPort();
        TransportInDescription transportInDescription = new TransportInDescription(new QName("http"));
        transportInDescription.setReceiver(this);
        httpFactory.getListenerManager().addListener(transportInDescription, true);
        this.contextPath = this.configContext.getServiceContextPath();
        final WAShttpAsyncResponseListener wAShttpAsyncResponseListener = this;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Runtime.getRuntime().addShutdownHook(new ShutdownThread(wAShttpAsyncResponseListener));
                return null;
            }
        });
    }

    protected void setListeningHost(TransportInDescription transportInDescription) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WAShttpAsyncResponseListener.setListeningHost()...");
        }
        try {
            if (transportInDescription != null) {
                Parameter parameter = transportInDescription.getParameter("port");
                parameter = transportInDescription.getParameter("hostname");
                this.hostAddress = parameter != null ? ((String)parameter.getValue()).trim() : this.httpFactory.getHostAddress();
            }
            if (this.hostAddress == null) {
                this.hostAddress = InetAddress.getLocalHost().getCanonicalHostName();
                if (this.hostAddress == null) {
                    this.hostAddress = "localhost";
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            FFDCFilter.processException((Throwable)unknownHostException, "com.ibm.ws.websvcs.transport.http.client.WAShttpAsyncResponseListener.setListeningHost", "285", this);
            if (_tc.isWarningEnabled()) {
                Tr.warning(_tc, JavaUtils.stackToString(unknownHostException));
            }
            this.hostAddress = "localhost";
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WAShttpAsyncResponseListener.setListeningHost()");
        }
    }

    protected void setListeningPort(TransportInDescription transportInDescription) throws Exception {
        Object[] objectArray;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WAShttpAsyncResponseListener.setListeningPort()...");
        }
        if (transportInDescription != null) {
            objectArray = transportInDescription.getParameter("port");
            if (objectArray != null) {
                this.port = Integer.parseInt((String)objectArray.getValue());
            }
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Port from TransportIn description: " + this.port);
            }
        }
        if (this.port == -1) {
            this.port = 80;
        }
        if (this.port < 0) {
            objectArray = new Object[]{this.port};
            String string = NLSProvider.getNLS().getFormattedMessage("invalidPort00", objectArray, "The port {0} is not valid.");
            throw new AxisFault(string);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WAShttpAsyncResponseListener.setListeningPort()");
        }
    }

    public String chainName() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WAShttpAsyncResponseListener.chainName()...");
        }
        if (chanChainName == null) {
            chanChainName = "WS-tcp-inbound" + COLON + "WS-http-inbound" + COLON + "async-inResponse-channel" + COLON + this.runtimeHash;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WAShttpAsyncResponseListener.chainName()...");
        }
        return chanChainName;
    }

    public synchronized void establishChain(Map map) throws Exception {
        Class<?> clazz;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WAShttpAsyncResponseListener.establishChain()...");
        }
        if (cf.getChannel("WS-tcp-inbound") == null) {
            clazz = null;
            try {
                clazz = Class.forName(tcpChannelFactoryName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.websvcs.transport.http.client.WAShttpAsyncResponseListener.establishChain", "387", this);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "exception01 " + classNotFoundException.getLocalizedMessage());
                }
                tcpChannelFactoryName = "com.ibm.ws.tcp.channel.impl.TCPChannelFactory";
                clazz = Class.forName(tcpChannelFactoryName);
            }
            if (clazz != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Using: " + clazz.toString());
                }
                cf.addChannel("WS-tcp-inbound", clazz, map);
            }
            if (this.port > 0) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Adding TCP inbound channel - WS-tcp-inbound at port " + map.get("port"));
                }
            } else if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Adding TCP inbound channel - WS-tcp-inbound");
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "WS-tcp-inbound channel exists.");
        }
        if (cf.getChannel("WS-http-inbound") == null) {
            clazz = Class.forName("com.ibm.ws.http.channel.inbound.impl.HttpInboundChannelFactory");
            if (clazz != null) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Adding HTTP inbound channel - WS-http-inbound");
                }
                cf.addChannel("WS-http-inbound", clazz, null);
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "WS-http-inbound channel exists.");
        }
        if (cf.getChannel("async-inResponse-channel") == null) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Adding AsyncInResponseChannel inbound channel - async-inResponse-channel");
            }
            cf.addChannel("async-inResponse-channel", AsyncInRespChannelFactory.class, null);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "async-inResponse-channel channel exists.");
        }
        if (cf.getChain(this.chainName()) == null) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Adding Channel Chain - " + this.chainName());
            }
            cf.addChain(this.chainName(), FlowType.INBOUND, CHAIN_ARRAY);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, this.chainName() + " chain exists.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WAShttpAsyncResponseListener.establishChain()");
        }
    }

    public synchronized void init(ConfigurationContext configurationContext, TransportInDescription transportInDescription) throws AxisFault {
        try {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "WAShttpAsyncResponseListener.init()...");
            }
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Received ConfigurationContext: " + configurationContext);
            }
            this.configContext = configurationContext;
            this.contextPath = this.configContext.getServiceContextPath();
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Context path from ConfigurationContext: " + this.contextPath);
            }
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Creating HttpFactory.");
            }
            this.httpFactory = new HttpFactory(this.configContext, this.port);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Setting up ChannelFramework service.");
            }
            this.setListeningPort(transportInDescription);
            this.setListeningHost(transportInDescription);
            if (asyncRCMap == null) {
                asyncRCMap = AsyncResponseContextMap.getInstance();
            }
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Obtained the Async In Response Context Map : " + asyncRCMap);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.client.WAShttpAsyncResponseListener.init", "525", this);
            if (_tc.isErrorEnabled()) {
                Tr.error(_tc, "caughtException", exception);
            }
            throw new AxisFault(exception);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WAShttpAsyncResponseListener.init()");
        }
    }

    public synchronized void delayStart(AxisService axisService) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WAShttpAsyncResponseListener.delayStart()...");
        }
        try {
            if (chainStarted) {
                return;
            }
            if (cf == null) {
                cf = WSChannelManager.getInstance().getChannelFramework();
            }
            String string = String.valueOf(this.port);
            if (System.getProperty("com.ibm.websphere.webservices.http.listenerPort") != null) {
                string = System.getProperty("com.ibm.websphere.webservices.http.listenerPort");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Using port as defined in system props: " + string);
                }
            }
            if (PolicySetUtils.getListeningPort(axisService) != null) {
                string = PolicySetUtils.getListeningPort(axisService);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Using port as defined in policy set: " + string);
                }
            }
            int n = 0;
            String string2 = System.getProperty("httpchannel_persist_timeout");
            if (JavaUtils.hasValue(string2)) {
                n = Integer.parseInt(string2) * 1000;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "httpchannel_persist_timeout (ms) : " + n);
                }
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("port", string);
            hashMap.put("hostname", this.hostAddress);
            if (n > DEFAULT_PERSIST_TIMEOUT) {
                hashMap.put("persistTimeout", n);
            }
            this.establishChain(hashMap);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Starting channel chain: " + this.chainName());
            }
            cf.startChain(this.chainName());
            String string3 = this.chainName();
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Started channel chain: " + this.chainName());
            }
            if (_tc.isEventEnabled()) {
                Object[] objectArray = new Object[]{cf.getListeningHost(string3), cf.getListeningPort(string3)};
                Tr.event(_tc, "assocHostPort00", objectArray);
            }
            chainStarted = true;
            this.port = cf.getListeningPort(string3);
            System.out.println("[WAShttpAsyncResponseListener] listening on port " + this.port);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.client.WAShttpAsyncResponseListener.start", "630", this);
            if (_tc.isErrorEnabled()) {
                Tr.error(_tc, "caughtException", exception);
            }
            throw new AxisFault(exception);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WAShttpAsyncResponseListener.delayStart()...");
        }
    }

    public synchronized void start() throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WAShttpAsyncResponseListener.start()...");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WAShttpAsyncResponseListener.start().");
        }
    }

    public synchronized void stop() throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WAShttpAsyncResponseListener.stop()...");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WAShttpAsyncResponseListener.stop().");
        }
    }

    public EndpointReference getEPRForService(String string, String string2) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WAShttpAsyncResponseListener.getEPRForService()...");
        }
        String string3 = string;
        int n = string.indexOf("/");
        if (n > 0) {
            string3 = string.substring(0, n);
        }
        AxisService axisService = this.configContext.getAxisConfiguration().getService(string3);
        if (!chainStarted) {
            this.delayStart(axisService);
        }
        String string4 = null;
        EndpointReference endpointReference = null;
        try {
            String string5;
            if (string2 != null) {
                string4 = string2;
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "localAddress passed in: " + string4);
                }
            } else {
                boolean bl = false;
                string5 = System.getProperty("com.ibm.websphere.webservices.transportEPRInIPAddr");
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "com.ibm.websphere.webservices.transportEPRInIPAddr: " + string5);
                }
                if (JavaUtils.hasValue(string5) && string5.equalsIgnoreCase("yes")) {
                    bl = true;
                }
                if (bl) {
                    InetAddress inetAddress = InetAddress.getLocalHost();
                    string4 = inetAddress.getHostAddress();
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "localAddress from getLocalHost(): " + string4);
                    }
                    if (string4 == null) {
                        string4 = "127.0.0.1";
                    }
                } else if (chainStarted) {
                    string4 = cf.getListeningHost(this.chainName());
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "localAddress from getListeningHost: " + string4);
                    }
                }
            }
            if (string4 != null) {
                string4 = string4.toLowerCase();
                endpointReference = new EndpointReference("http://" + string4 + ":" + cf.getListeningPort(this.chainName()) + "/" + this.contextPath + "/" + string);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "establishedEPR00", endpointReference.getAddress());
                }
            } else {
                Object[] objectArray = new Object[]{string4};
                string5 = NLSProvider.getNLS().getFormattedMessage("hostAddrNotEst00", objectArray, "The host address {0} has not been established yet. An endpoint reference (EPR) cannot be generated.");
                throw new AxisFault(string5);
            }
            AsyncEPRSet.addEPRtoSet(endpointReference.getAddress());
        }
        catch (ChainException chainException) {
            FFDCFilter.processException((Throwable)chainException, "com.ibm.ws.websvcs.transport.http.client.WAShttpAsyncResponseListener.getEPRForService", "775", this);
            if (_tc.isErrorEnabled()) {
                Tr.error(_tc, "caughtException", chainException);
            }
            throw new AxisFault(chainException);
        }
        catch (UnknownHostException unknownHostException) {
            FFDCFilter.processException((Throwable)unknownHostException, "com.ibm.ws.websvcs.transport.http.client.WAShttpAsyncResponseListener.getEPRForService", "785", this);
            if (_tc.isErrorEnabled()) {
                Tr.error(_tc, "caughtException", unknownHostException);
            }
            throw AxisFault.makeFault(unknownHostException);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WAShttpAsyncResponseListener.getEPRForService().");
        }
        return endpointReference;
    }

    public EndpointReference[] getEPRsForService(String string, String string2) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WAShttpAsyncResponseListener.getEPRsForService()...");
        }
        EndpointReference endpointReference = null;
        endpointReference = this.getEPRForService(string, string2);
        EndpointReference[] endpointReferenceArray = new EndpointReference[]{endpointReference};
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WAShttpAsyncResponseListener.getEPRsForService().");
        }
        return endpointReferenceArray;
    }

    public synchronized void destroy() throws ChannelException, ChainException, ChainGroupException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WAShttpAsyncResponseListener.destroy()...");
        }
        if (cf != null) {
            try {
                if (cf.getChain(this.chainName()) != null) {
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "Destroying Channel Chain: " + this.chainName());
                    }
                    cf.stopChain(this.chainName(), 10000L);
                    try {
                        Thread.sleep(12000L);
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.websvcs.transport.http.client.WAShttpAsyncResponseListener.destroy", "847", this);
                    }
                    cf.destroyChain(this.chainName());
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Closing Channel Framework service: " + cf.toString());
                }
                cf.destroy();
            }
            catch (InvalidRuntimeStateException invalidRuntimeStateException) {
                // empty catch block
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WAShttpAsyncResponseListener.destroy().");
        }
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        return null;
    }

    static class ShutdownThread
    extends Thread {
        private WAShttpAsyncResponseListener listener = null;

        public ShutdownThread(WAShttpAsyncResponseListener wAShttpAsyncResponseListener) {
            this.listener = wAShttpAsyncResponseListener;
        }

        public void run() {
            block5: {
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "WAShttpAsyncResponseListener.ShutdownThread.run()...");
                }
                try {
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "Shutting down listener: " + this.listener);
                    }
                    this.listener.destroy();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.client.WAShttpAsyncResponseListener.run", "892", this);
                    if (!_tc.isErrorEnabled()) break block5;
                    Tr.error(_tc, "caughtException", exception);
                }
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "...WAShttpAsyncResponseListener.ShutdownThread.run()");
            }
        }
    }
}

