/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.resources.NLSProvider;
import java.util.Map;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.spi.migrator.ApplicationContextMigrator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSAppContextMigrator
implements ApplicationContextMigrator {
    private static final TraceComponent _tc = Tr.register(WSAppContextMigrator.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    @Override
    public void migratePropertiesFromMessageContext(Map<String, Object> map, MessageContext messageContext) {
        this.getResponseTransportProperties(map, messageContext);
    }

    @Override
    public void migratePropertiesToMessageContext(Map<String, Object> map, MessageContext messageContext) {
        this.setAsyncTimeout(map, messageContext);
    }

    private void setAsyncTimeout(Map<String, Object> map, MessageContext messageContext) {
        Object object = map.get("com.ibm.websphere.webservices.jaxws.asynctimeout");
        if (object != null) {
            if (object instanceof Long) {
                Long l = (Long)object;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Setting com.ibm.websphere.webservices.jaxws.Constants.ASYNC_TIMEOUT_MILLISECONDS property on Axis2 options to value: " + l);
                }
                messageContext.getAxisMessageContext().getOptions().setTimeOutInMilliSeconds(l);
            } else if (object instanceof Integer) {
                Long l = ((Integer)object).longValue();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Setting com.ibm.websphere.webservices.jaxws.Constants.ASYNC_TIMEOUT_MILLISECONDS property on Axis2 options to value: " + l);
                }
                messageContext.getAxisMessageContext().getOptions().setTimeOutInMilliSeconds(l);
            } else {
                Tr.info(_tc, "Found property com.ibm.websphere.webservices.jaxws.Constants.ASYNC_TIMEOUT_MILLISECONDS but it was not of type Long or of type Integer.");
            }
        }
    }

    private void getResponseTransportProperties(Map<String, Object> map, MessageContext messageContext) {
        try {
            Object object;
            if (messageContext.getAxisMessageContext() == null || messageContext.getAxisMessageContext().getOperationContext() == null) {
                return;
            }
            org.apache.axis2.context.MessageContext messageContext2 = messageContext.getAxisMessageContext().getOperationContext().getMessageContext("Out");
            if (messageContext2 != null && (object = messageContext2.getProperty("com.ibm.websphere.webservices.responseTransportProperties")) != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Setting com.ibm.websphere.webservices.Constants.RESPONSE_TRANSPORT_PROPERTIES on user context: " + object.toString());
                }
                map.put("com.ibm.websphere.webservices.responseTransportProperties", object);
            }
        }
        catch (Throwable throwable) {
            String string = NLSProvider.getNLS().getFormattedMessage("getRTPropsFail00", new Object[]{throwable}, "The following error occurred while attempting to retrieve the com.ibm.websphere.webservices.Constants.RESPONSE_TRANSPORT_PROPERTIES property from the response: {0}");
            Tr.error(_tc, string);
        }
    }
}

