/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.exception.ConfigurationException;
import com.ibm.ws.websvcs.metadata.ServerModuleMetaData;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.trace.MessageTrace;
import com.ibm.ws.websvcs.transport.common.InvocationPatternHelper;
import com.ibm.ws.websvcs.transport.common.JavaUtils;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.security.context.ContextManager;
import com.ibm.wsspi.websvcs.WASAxis2Service;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.jaxws.description.builder.WsdlComposite;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.AxisServlet;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.ListingAgent;
import org.apache.axis2.transport.http.ServletBasedOutTransportInfo;
import org.apache.axis2.wsdl.util.WSDLDefinitionWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASAxis2Servlet
extends AxisServlet
implements Constants {
    private static final TraceComponent _tc = Tr.register(WASAxis2Servlet.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private transient ListingAgent agent;
    private boolean closeReader = true;

    @Override
    public void init() throws ServletException {
        if (this.servletConfig != null) {
            this.init(this.servletConfig);
        }
    }

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "init");
        }
        try {
            ServerModuleMetaData serverModuleMetaData;
            WASAxis2Service wASAxis2Service = (WASAxis2Service)WsServiceRegistry.getService(this, WASAxis2Service.class);
            String string = servletConfig.getServletContext().getServletContextName();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Attempting to get configContext from servlet with context name = " + string);
                Tr.debug(_tc, "WASAxis2Service= " + wASAxis2Service.toString());
            }
            if ((serverModuleMetaData = (ServerModuleMetaData)wASAxis2Service.getModuleMetaData()) == null) {
                throw new ConfigurationException("Could not retrieve server module metadata in Axis servlet for module: " + string);
            }
            this.configContext = serverModuleMetaData.getConfigurationContext();
            if (this.configContext == null) {
                throw new ConfigurationException("Could not retrieve configuration context in Axis servlet for module: " + string);
            }
            this.servletConfig = servletConfig;
            this.axisConfiguration = this.configContext.getAxisConfiguration();
            servletConfig.getServletContext().setAttribute("CONFIGURATION_CONTEXT", this.configContext);
            ListenerManager listenerManager = new ListenerManager();
            listenerManager.init(this.configContext);
            TransportInDescription transportInDescription = new TransportInDescription(new QName("http"));
            transportInDescription.setReceiver(this);
            listenerManager.addListener(transportInDescription, true);
            ListenerManager.defaultConfigurationContext = this.configContext;
            this.agent = new ListingAgent(this.configContext);
            Parameter parameter = this.axisConfiguration.getParameter("axis2.close.reader");
            if (parameter != null) {
                this.closeReader = JavaUtils.isTrueExplicitly(parameter.getValue());
            }
        }
        catch (ConfigurationException configurationException) {
            FFDCFilter.processException((Throwable)configurationException, "com.ibm.ws.websvcs.transport.http.WASAxis2Servlet.init", "149", this);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            configurationException.printStackTrace(printWriter);
            Tr.error(_tc, "The following exception was encountered while attempting to load the ConfigurationContext for the servlet:  " + configurationException.toString() + "\n" + stringWriter.toString());
            throw new ServletException(configurationException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.WASAxis2Servlet.init", "159", this);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            Tr.error(_tc, "The following exception was encountered while attempting to initialize the servlet: " + exception.toString() + "\n" + stringWriter.toString());
            throw new ServletException(exception);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "init");
        }
    }

    @Override
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doGet");
        }
        try {
            AxisService axisService;
            String string = httpServletRequest.getRequestURL().toString();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "requestURL = " + string);
            }
            String string2 = httpServletRequest.getServletPath();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "servletPath = " + string2);
            }
            if ((axisService = this.findServiceForRequestURL(string2)) != null) {
                boolean bl = false;
                boolean bl2 = false;
                String string3 = httpServletRequest.getQueryString();
                bl = string3 != null && string3.equalsIgnoreCase("/wsdl".substring(1));
                bl = bl || string2.endsWith("/wsdl") || string2.endsWith("/wsdl/");
                bl = bl || string.toLowerCase().endsWith(".wsdl");
                bl2 = string.toLowerCase().endsWith(".xsd");
                if (bl2) {
                    this.processXsdRequest(httpServletRequest, httpServletResponse, axisService);
                } else if (bl) {
                    this.processWsdlRequest(httpServletRequest, httpServletResponse, axisService);
                } else {
                    this.reportAvailableServices(httpServletResponse, axisService);
                }
            } else {
                this.reportServiceNotExist(httpServletResponse, httpServletRequest.getRequestURI());
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.WASAxis2Servlet.doGet", "231", this);
            throw new ServletException(exception);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doGet");
            }
        }
    }

    private AxisService findServiceForRequestURL(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "findServiceForRequestURL, servletPath=" + string);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Trying to find Axis Service with URI: " + string);
        }
        AxisService axisService = this.findServiceWithUrlPattern(this.configContext.getAxisConfiguration(), string);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "findServiceForRequestURL, axisService=" + (axisService == null ? "<not found>" : axisService.getName()));
        }
        return axisService;
    }

    private AxisService findServiceWithUrlPattern(AxisConfiguration axisConfiguration, String string) {
        Iterator iterator = axisConfiguration.getServiceGroups();
        while (iterator.hasNext()) {
            AxisServiceGroup axisServiceGroup = (AxisServiceGroup)iterator.next();
            Iterator iterator2 = axisServiceGroup.getServices();
            while (iterator2.hasNext()) {
                AxisService axisService = (AxisService)iterator2.next();
                String string2 = Axis2Utils.getURLPattern(axisService);
                if (string2 == null || !string.equals(string2) && !string.startsWith(string2 + "/") && !string2.equals("/*")) continue;
                return axisService;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processWsdlRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AxisService axisService) throws AxisFault, ServletException, IOException {
        String string = httpServletRequest.getRequestURL().toString();
        String string2 = httpServletRequest.getPathInfo();
        String string3 = Axis2Utils.getURLPattern(axisService);
        if ((string2 == null || string2.equals("") || string2.equals("/")) && !string.toLowerCase().endsWith(".wsdl") || httpServletRequest.getQueryString() != null && httpServletRequest.getQueryString().equals(".wsdl".substring(1))) {
            String string4 = Axis2Utils.getWSDLLocation(axisService);
            if (string4 == null || "".equals(string4)) {
                WsdlComposite wsdlComposite;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Retrieving generated WSDL");
                }
                if ((wsdlComposite = Axis2Utils.getWsdlComposite(axisService)) != null) {
                    string4 = wsdlComposite.getWsdlFileName();
                    string4 = "/wsdl".substring(1) + "/" + string4;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Retrieved generated WSDL: " + string4);
                    }
                } else {
                    this.reportNoWsdl(httpServletResponse);
                }
            } else {
                String string5;
                if (!string.endsWith("/")) {
                    string = string + "/";
                }
                if (string.endsWith(string5 = "/wsdl/")) {
                    string = string.substring(0, string.length() - string5.length() + 1);
                }
            }
            string = string3 != null && string3.equals("/*") ? string + "path/" + string4 : string + string4;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Redirecting WSDL query to actual URL: " + string);
            }
            httpServletResponse.sendRedirect(string);
            return;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieving WSDL file for service " + axisService.getName());
        }
        if (string3 != null) {
            String string6 = httpServletRequest.getRequestURI();
            int n = (string6 = string6.substring(string6.indexOf("/", 1))).indexOf(string3);
            if (n != -1 || string3.equals("/*")) {
                String string7 = null;
                if (string3.equals("/*")) {
                    int n2 = string6.indexOf("path/");
                    if (n2 != -1) {
                        string7 = string6.substring(n2 + "path/".length());
                    }
                } else {
                    string7 = string6.substring(n + string3.length());
                }
                WsdlComposite wsdlComposite = Axis2Utils.getWsdlComposite(axisService);
                if (wsdlComposite != null) {
                    HashMap<String, Definition> hashMap = wsdlComposite.getWsdlDefinitionsMap();
                    if (hashMap != null) {
                        Definition definition;
                        if (string7 == null && string6.indexOf("/") != -1 && string6.lastIndexOf("/") != string6.length()) {
                            string7 = string6.substring(string6.lastIndexOf("/") + 1, string6.length());
                        }
                        if (string7.endsWith("/")) {
                            string7 = string7.substring(0, string7.length() - 1);
                        }
                        if (string7.indexOf("/") != -1 && string7.lastIndexOf("/") != string7.length()) {
                            string7 = string7.substring(string7.lastIndexOf("/") + 1, string7.length());
                        }
                        if ((definition = hashMap.get(string7.toLowerCase())) != null) {
                            try {
                                if (definition instanceof WSDLDefinitionWrapper) {
                                    definition = ((WSDLDefinitionWrapper)definition).getUnwrappedDefinition();
                                }
                                httpServletResponse.setContentType("text/xml");
                                HashMap hashMap2 = this.getPrefixMap(httpServletRequest);
                                HashMap hashMap3 = this.getURLMap(axisService);
                                this.updateEndpointURLS(hashMap2, hashMap3, axisService, definition, httpServletRequest.getScheme());
                                WSDLWriter wSDLWriter = WSDLFactory.newInstance().newWSDLWriter();
                                wSDLWriter.writeWSDL(definition, httpServletResponse.getOutputStream());
                                if (!_tc.isDebugEnabled()) return;
                                Tr.debug(_tc, "Retrieving generated WSDL file: " + string7);
                                return;
                            }
                            catch (Throwable throwable) {
                                Object[] objectArray = new Object[]{string7, throwable};
                                String string8 = NLSProvider.getNLS().getFormattedMessage("wsdlDisplayFail00", objectArray, "The WSDL file {0} could not be displayed: {1}");
                                Tr.error(_tc, string8);
                                throw new ServletException(throwable);
                            }
                        } else {
                            this.reportNoWsdl(httpServletResponse);
                        }
                        return;
                    } else {
                        this.reportNoWsdl(httpServletResponse);
                    }
                    return;
                } else {
                    try {
                        ClassLoader classLoader = axisService.getClassLoader();
                        InputStream inputStream = classLoader.getResourceAsStream(string7);
                        if (inputStream != null) {
                            httpServletResponse.setContentType("text/xml");
                            HashMap hashMap = this.getPrefixMap(httpServletRequest);
                            HashMap hashMap4 = this.getURLMap(axisService);
                            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                            StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(inputStream);
                            this.updateEndpointURLS(stAXOMBuilder.getDocument(), (Map)hashMap, hashMap4, axisService, httpServletRequest.getScheme());
                            stAXOMBuilder.getDocument().serialize(servletOutputStream);
                            if (!_tc.isDebugEnabled()) return;
                            Tr.debug(_tc, "Retrieving WSDL file: " + string7);
                            return;
                        }
                        this.reportNoWsdl(httpServletResponse);
                        return;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.transport.http.WASAxis2Servlet.processWsdlRequest", "406", this);
                        Object[] objectArray = new Object[]{string7, throwable};
                        String string9 = NLSProvider.getNLS().getFormattedMessage("wsdlDisplayFail00", objectArray, "The WSDL file {0} could not be displayed: {1}");
                        Tr.error(_tc, string9);
                        throw new ServletException(throwable);
                    }
                }
            } else {
                this.reportNoWsdl(httpServletResponse);
            }
            return;
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "URL pattern didn't exist for service.");
            }
            this.reportNoWsdl(httpServletResponse);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processXsdRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AxisService axisService) throws ServletException, IOException {
        String string = Axis2Utils.getURLPattern(axisService);
        if (string != null) {
            String string2 = httpServletRequest.getRequestURI();
            int n = (string2 = string2.substring(string2.indexOf("/", 1))).indexOf(string);
            if (n != -1 || string.equals("/*")) {
                String string3 = null;
                if (string.equals("/*")) {
                    int n2 = string2.indexOf("path/");
                    if (n2 != -1) {
                        string3 = string2.substring(n2 + "path/".length());
                    }
                } else {
                    string3 = string2.substring(n + string.length());
                }
                WsdlComposite wsdlComposite = Axis2Utils.getWsdlComposite(axisService);
                if (wsdlComposite != null) {
                    HashMap<String, OMDocument> hashMap = wsdlComposite.getSchemaMap();
                    if (hashMap != null) {
                        String string4 = null;
                        if (string3.indexOf("/") != -1 && string3.lastIndexOf("/") != string3.length()) {
                            string4 = string3.substring(string3.lastIndexOf("/") + 1, string3.length());
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Looking for schema file: " + string4);
                        }
                        try {
                            httpServletResponse.setContentType("text/xml");
                            OMDocument oMDocument = hashMap.get(string4);
                            if (oMDocument != null) {
                                oMDocument.serialize(httpServletResponse.getOutputStream());
                            } else {
                                this.reportNoXsd(httpServletResponse);
                            }
                            if (!_tc.isDebugEnabled()) return;
                            Tr.debug(_tc, "Retrieving generated schema file: " + string3);
                            return;
                        }
                        catch (Throwable throwable) {
                            Object[] objectArray = new Object[]{string4, throwable};
                            String string5 = NLSProvider.getNLS().getFormattedMessage("xsdDisplayFail00", objectArray, "The schema file {0} could not be displayed: {1}");
                            Tr.error(_tc, string5);
                            throw new ServletException(throwable);
                        }
                    } else {
                        this.reportNoXsd(httpServletResponse);
                    }
                    return;
                } else {
                    try {
                        ClassLoader classLoader = axisService.getClassLoader();
                        InputStream inputStream = classLoader.getResourceAsStream(string3);
                        if (inputStream != null) {
                            httpServletResponse.setContentType("text/xml");
                            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                            servletOutputStream.write(this.readBytes(inputStream));
                            servletOutputStream.flush();
                            servletOutputStream.close();
                            if (!_tc.isDebugEnabled()) return;
                            Tr.debug(_tc, "Retrieving schema file: " + string3);
                            return;
                        }
                        this.reportNoXsd(httpServletResponse);
                        return;
                    }
                    catch (Throwable throwable) {
                        Object[] objectArray = new Object[]{string3, throwable};
                        String string6 = NLSProvider.getNLS().getFormattedMessage("xsdDisplayFail00", objectArray, "The schema file {0} could not be displayed: {1}");
                        Tr.error(_tc, string6);
                        throw new ServletException(throwable);
                    }
                }
            } else {
                this.reportNoXsd(httpServletResponse);
            }
            return;
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "URL pattern didn't exist for service.");
            }
            this.reportNoXsd(httpServletResponse);
        }
    }

    private void reportAvailableServices(HttpServletResponse httpServletResponse, AxisService axisService) throws AxisFault, IOException {
        Serializable serializable;
        Object object;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Reporting available Axis2 web services.");
        }
        PrintWriter printWriter = httpServletResponse.getWriter();
        httpServletResponse.setContentType("text/html");
        Definition definition = Axis2Utils.getWSDLDefinition(axisService);
        QName qName = Axis2Utils.getServiceQName(axisService);
        if (definition == null && (object = Axis2Utils.getWsdlComposite(axisService)) != null) {
            serializable = ((WsdlComposite)object).getWsdlDefinitionsMap();
            definition = ((WsdlComposite)object).getRootWsdlDefinition();
        }
        if (definition != null && (object = definition.getServices()) != null && !object.isEmpty() && (serializable = (Service)object.get(qName)) != null) {
            printWriter.println("<h2>" + serializable.getQName().toString() + "</h2>");
        }
        printWriter.println("<h3>Hello! This is an Axis2 Web Service!</h3>");
        printWriter.close();
    }

    private void reportServiceNotExist(HttpServletResponse httpServletResponse, String string) throws IOException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Reporting error that Axis Service object couldn't be found.");
        }
        PrintWriter printWriter = httpServletResponse.getWriter();
        httpServletResponse.setStatus(404);
        httpServletResponse.setContentType("text/html");
        printWriter.println("<h2>Error: Generic Error.</h2>");
        printWriter.println("<p>Could not find Axis2 service for request URI: " + string + ".</p>");
        printWriter.close();
    }

    private void reportNoWsdl(HttpServletResponse httpServletResponse) throws IOException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Reporting that queried WSDL file does not exist.");
        }
        PrintWriter printWriter = httpServletResponse.getWriter();
        httpServletResponse.setStatus(404);
        httpServletResponse.setContentType("text/html");
        printWriter.println("<h2>Error: Generic Error.</h2>");
        printWriter.println("<p>Could not generate WSDL!</p>");
        printWriter.close();
    }

    private void reportNoXsd(HttpServletResponse httpServletResponse) throws IOException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Reporting that queried XSD file does not exist.");
        }
        PrintWriter printWriter = httpServletResponse.getWriter();
        httpServletResponse.setStatus(404);
        httpServletResponse.setContentType("text/html");
        printWriter.println("<h2>Error: Generic Error.</h2>");
        printWriter.println("<p>Could not generate specified XSD file!</p>");
        printWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block49: {
            boolean bl;
            ServletOutputStream servletOutputStream;
            Handler.InvocationResponse invocationResponse;
            MessageContext messageContext;
            block47: {
                block46: {
                    Object object;
                    messageContext = null;
                    invocationResponse = null;
                    servletOutputStream = null;
                    if (_tc.isEntryEnabled()) {
                        Tr.entry(_tc, "doPost");
                    }
                    if (_tc.isDebugEnabled() && httpServletRequest != null) {
                        Tr.debug(_tc, "ServletRequest= " + httpServletRequest.getMethod());
                    }
                    String string = httpServletRequest.getRequestURL().toString();
                    messageContext = this.createAndSetInitialParamsToMsgCtxt(messageContext, httpServletResponse, httpServletRequest, string);
                    String string2 = httpServletRequest.getContentType();
                    messageContext.setProperty("ContentType", string2);
                    servletOutputStream = httpServletResponse.getOutputStream();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Endpoint URL: " + string);
                        Tr.debug(_tc, "Content-Type: " + string2 + " set in MessageContext " + "ContentType");
                    }
                    InputStream inputStream = httpServletRequest.getInputStream();
                    if (MessageTrace.isTraceEnabled()) {
                        Tr.debug(_tc, "Preparing to trace incoming request to server");
                        object = this.extractRequestBytesForTrace(httpServletRequest, inputStream);
                        inputStream = new ByteArrayInputStream((byte[])object);
                        this.traceBytes((byte[])object, string2);
                    }
                    invocationResponse = HTTPTransportUtils.processHTTPPostRequest(messageContext, inputStream, servletOutputStream, httpServletRequest.getContentType(), httpServletRequest.getHeader("SOAPAction"), string);
                    object = null;
                    Boolean bl2 = (Boolean)messageContext.getProperty("HoldResponse");
                    if (Handler.InvocationResponse.SUSPEND.equals(invocationResponse) || bl2 != null && Boolean.TRUE.equals(bl2)) {
                        object = (RequestResponseTransport)messageContext.getProperty("RequestResponseTransportControl");
                        object.awaitResponse();
                    }
                    if (!TransportUtils.isResponseWritten(messageContext) && object != null && object.getStatus() != RequestResponseTransport.RequestResponseTransportStatus.ACKED && object.getStatus() != RequestResponseTransport.RequestResponseTransportStatus.SIGNALLED) {
                        httpServletResponse.setStatus(202);
                    }
                    if (object == null) {
                        object = (RequestResponseTransport)messageContext.getProperty("RequestResponseTransportControl");
                    }
                    if (object == null || !(object instanceof ServletRequestResponseTransport)) break block46;
                    ((ServletRequestResponseTransport)object).handleSessionInfo();
                }
                Object var12_15 = null;
                if (!this.closeReader || Handler.InvocationResponse.SUSPEND.equals(invocationResponse)) break block47;
                try {
                    ((StAXBuilder)messageContext.getEnvelope().getBuilder()).close();
                }
                catch (Exception exception) {
                    if (!_tc.isDebugEnabled()) break block47;
                    Tr.debug(_tc, exception.getMessage());
                }
            }
            boolean bl3 = InvocationPatternHelper.isOneWayInvocation(messageContext);
            boolean bl4 = bl = messageContext.getReplyTo() != null && !messageContext.getReplyTo().hasAnonymousAddress();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "one way : " + bl3 + " async : " + bl);
            }
            if (!bl3 && !bl) {
                TransportUtils.deleteAttachments(messageContext);
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doPost");
            }
            break block49;
            {
                catch (AxisFault axisFault) {
                    boolean bl5;
                    block48: {
                        FFDCFilter.processException((Throwable)axisFault, "com.ibm.ws.websvcs.transport.http.WASAxis2Servlet.doPost", "516", this);
                        if (messageContext != null) {
                            try {
                                if (AddressingHelper.isFaultRedirected(messageContext)) {
                                    httpServletResponse.setStatus(202);
                                } else {
                                    httpServletResponse.setStatus(500);
                                }
                                this.handleFault(messageContext, servletOutputStream, axisFault);
                            }
                            catch (AxisFault axisFault2) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, axisFault.getMessage());
                                }
                            }
                        } else {
                            throw new ServletException(axisFault);
                        }
                        Object var12_16 = null;
                        if (this.closeReader && !Handler.InvocationResponse.SUSPEND.equals(invocationResponse)) {
                            try {
                                ((StAXBuilder)messageContext.getEnvelope().getBuilder()).close();
                            }
                            catch (Exception exception) {
                                if (!_tc.isDebugEnabled()) break block48;
                                Tr.debug(_tc, exception.getMessage());
                            }
                        }
                    }
                    boolean bl6 = InvocationPatternHelper.isOneWayInvocation(messageContext);
                    boolean bl7 = bl5 = messageContext.getReplyTo() != null && !messageContext.getReplyTo().hasAnonymousAddress();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "one way : " + bl6 + " async : " + bl5);
                    }
                    if (!bl6 && !bl5) {
                        TransportUtils.deleteAttachments(messageContext);
                    }
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "doPost");
                    }
                    break block49;
                }
                catch (Throwable throwable) {
                    boolean bl8;
                    block50: {
                        FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.transport.http.WASAxis2Servlet.doPost", "516", this);
                        if (messageContext != null) {
                            try {
                                if (AddressingHelper.isFaultRedirected(messageContext)) {
                                    httpServletResponse.setStatus(202);
                                } else {
                                    httpServletResponse.setStatus(500);
                                }
                                this.handleFault(messageContext, servletOutputStream, new AxisFault(throwable.toString(), throwable));
                            }
                            catch (AxisFault axisFault) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, throwable.getMessage());
                                }
                            }
                        } else {
                            throw new ServletException(throwable);
                        }
                        Object var12_17 = null;
                        if (this.closeReader && !Handler.InvocationResponse.SUSPEND.equals(invocationResponse)) {
                            try {
                                ((StAXBuilder)messageContext.getEnvelope().getBuilder()).close();
                            }
                            catch (Exception exception) {
                                if (!_tc.isDebugEnabled()) break block50;
                                Tr.debug(_tc, exception.getMessage());
                            }
                        }
                    }
                    boolean bl9 = InvocationPatternHelper.isOneWayInvocation(messageContext);
                    boolean bl10 = bl8 = messageContext.getReplyTo() != null && !messageContext.getReplyTo().hasAnonymousAddress();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "one way : " + bl9 + " async : " + bl8);
                    }
                    if (!bl9 && !bl8) {
                        TransportUtils.deleteAttachments(messageContext);
                    }
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "doPost");
                    }
                }
            }
            catch (Throwable throwable) {
                boolean bl11;
                block51: {
                    Object var12_18 = null;
                    if (this.closeReader && !Handler.InvocationResponse.SUSPEND.equals(invocationResponse)) {
                        try {
                            ((StAXBuilder)messageContext.getEnvelope().getBuilder()).close();
                        }
                        catch (Exception exception) {
                            if (!_tc.isDebugEnabled()) break block51;
                            Tr.debug(_tc, exception.getMessage());
                        }
                    }
                }
                boolean bl12 = InvocationPatternHelper.isOneWayInvocation(messageContext);
                boolean bl13 = bl11 = messageContext.getReplyTo() != null && !messageContext.getReplyTo().hasAnonymousAddress();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "one way : " + bl12 + " async : " + bl11);
                }
                if (!bl12 && !bl11) {
                    TransportUtils.deleteAttachments(messageContext);
                }
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doPost");
                }
                throw throwable;
            }
        }
    }

    protected MessageContext createAndSetInitialParamsToMsgCtxt(MessageContext messageContext, HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest, String string) throws AxisFault, WSSecurityException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createAndSetInitialParamsToMsgCtxt");
        }
        messageContext = new MessageContext();
        messageContext.setConfigurationContext(this.configContext);
        messageContext.setTransportIn(this.axisConfiguration.getTransportIn(new QName("http")));
        messageContext.setTransportOut(this.axisConfiguration.getTransportOut(new QName("http")));
        messageContext.setProperty("OutTransportInfo", new ServletBasedOutTransportInfo(httpServletResponse));
        messageContext.setProperty("RequestResponseTransportControl", new ServletRequestResponseTransport(httpServletRequest, httpServletResponse, string));
        messageContext.setProperty("REMOTE_ADDR", httpServletRequest.getRemoteAddr());
        Map map = this.getTransportHeaders(httpServletRequest);
        map.put("Content-Encoding", "");
        map.put(HTTPConstants.HEADER_CONTENT_ENCODING_LOWERCASE, "");
        messageContext.setProperty("TRANSPORT_HEADERS", map);
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            messageContext.setProperty("SessionId", httpSession.getId());
        }
        messageContext.setProperty("TransportInURL", string);
        messageContext.setIncomingTransportName("http");
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, httpServletRequest);
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, httpServletResponse);
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETCONTEXT, this.servletConfig.getServletContext());
        messageContext.setProperty("com.ibm.ws.websvcs.MsgContext_ContextRoot", httpServletRequest.getContextPath());
        messageContext.setProperty("com.ibm.wsspi.websphere.security.SecurityContext", ContextManager.getContext());
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Setting context root on message context: " + httpServletRequest.getContextPath());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createAndSetInitialParamsToMsgCtxt");
        }
        return messageContext;
    }

    private HashMap getPrefixMap(HttpServletRequest httpServletRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort() + httpServletRequest.getContextPath();
        hashMap.put(httpServletRequest.getScheme(), string);
        return hashMap;
    }

    private HashMap getURLMap(AxisService axisService) {
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Definition definition = Axis2Utils.getWSDLDefinition(axisService);
        if (definition == null && (object = Axis2Utils.getWsdlComposite(axisService)) != null) {
            definition = ((WsdlComposite)object).getRootWsdlDefinition();
        }
        if (definition == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getURLMap(): WSDL def was null.");
            }
            return hashMap;
        }
        object = definition.getTargetNamespace();
        Map map = definition.getServices();
        Iterator iterator = map.values().iterator();
        Object[] objectArray = this.getAxisServices();
        if (objectArray.length > 0) {
            while (iterator.hasNext()) {
                Service service = (Service)iterator.next();
                ArrayList<AxisService> arrayList = this.getAxisServicesByQName(service.getQName(), objectArray);
                Map map2 = service.getPorts();
                for (Port port : map2.values()) {
                    String string = this.matchesRequestedAxisService(axisService, service.getQName().toString(), port.getName()) ? Axis2Utils.getURLPattern(axisService) : this.getAxisServiceByPort(arrayList, port.getName());
                    QName qName = new QName((String)object, port.getName());
                    String string2 = service.getQName().toString() + qName.toString() + Axis2Utils.getWSDLLocation(axisService);
                    if (string != null && string.equals("/*")) {
                        string = "/";
                    }
                    hashMap.put(string2, string);
                }
            }
        }
        return hashMap;
    }

    private void updateEndpointURLS(OMDocument oMDocument, Map map, Map map2, AxisService axisService, String string) throws Exception {
        OMElement oMElement = oMDocument.getOMDocumentElement();
        Definition definition = Axis2Utils.getWSDLDefinition(axisService);
        if (definition == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "updateEndpointURLS(): WSDL Def was null.");
            }
            return;
        }
        String string2 = definition.getTargetNamespace();
        Iterator iterator = oMElement.getChildrenWithName(new QName("service"));
        while (iterator.hasNext()) {
            OMElement oMElement2 = (OMElement)iterator.next();
            String string3 = oMElement2.getAttributeValue(new QName("name"));
            QName qName = new QName(string2, string3);
            Iterator iterator2 = oMElement2.getChildrenWithName(new QName("port"));
            while (iterator2.hasNext()) {
                OMElement oMElement3 = (OMElement)iterator2.next();
                this.fixPort(oMElement3, map, map2, string2, qName, Axis2Utils.getWSDLLocation(axisService), string);
            }
        }
    }

    private void fixPort(OMElement oMElement, Map map, Map map2, String string, QName qName, String string2, String string3) throws Exception {
        OMAttribute oMAttribute = oMElement.getAttribute(new QName("name"));
        if (oMAttribute != null) {
            String string4 = oMAttribute.getAttributeValue();
            String string5 = (String)map.get(string3);
            QName qName2 = new QName(string, string4);
            String string6 = qName.toString() + qName2.toString() + string2;
            String string7 = (String)map2.get(string6);
            if (string7 != null && !string7.equals("")) {
                String string8 = string7.equals("IMPLEMENTATION NOT PROVIDED") ? string7 : string5 + string7;
                Iterator iterator = oMElement.getChildrenWithName(new QName("address"));
                while (iterator.hasNext()) {
                    OMElement oMElement2 = (OMElement)iterator.next();
                    OMAttribute oMAttribute2 = oMElement2.getAttribute(new QName("location"));
                    if (oMAttribute2 == null) continue;
                    oMAttribute2.setAttributeValue(string8);
                }
            }
        }
    }

    private byte[] readBytes(InputStream inputStream) throws IOException {
        byte[] byArray;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n = 0;
        int n2 = 0;
        while (n2 >= 0) {
            byArray = new byte[1024];
            n2 = inputStream.read(byArray, 0, 1024);
            if (n2 < 0) continue;
            arrayList.add(byArray);
            arrayList2.add(new Integer(n2));
            n += n2;
        }
        byArray = new byte[n];
        int n3 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            byte[] byArray2 = (byte[])arrayList.get(i);
            int n4 = (Integer)arrayList2.get(i);
            System.arraycopy(byArray2, 0, byArray, n3, n4);
            n3 += n4;
        }
        return byArray;
    }

    private Object[] getAxisServices() {
        HashMap hashMap = this.configContext.getAxisConfiguration().getServices();
        if (!hashMap.isEmpty()) {
            return hashMap.values().toArray();
        }
        return null;
    }

    private ArrayList<AxisService> getAxisServicesByQName(QName qName, Object[] objectArray) {
        ArrayList<AxisService> arrayList = new ArrayList<AxisService>();
        for (int i = 0; i < objectArray.length; ++i) {
            AxisService axisService = (AxisService)objectArray[i];
            QName qName2 = Axis2Utils.getServiceQName(axisService);
            if (!qName2.toString().equals(qName.toString())) continue;
            arrayList.add(axisService);
        }
        return arrayList;
    }

    private String getAxisServiceByPort(ArrayList<AxisService> arrayList, String string) {
        Iterator<AxisService> iterator = arrayList.iterator();
        String string2 = null;
        while (iterator.hasNext()) {
            AxisService axisService = iterator.next();
            String string3 = Axis2Utils.getPortName(axisService);
            if (!string.equals(string3)) continue;
            string2 = Axis2Utils.getURLPattern(axisService);
        }
        if (string2 == null || string2.equals("")) {
            string2 = "IMPLEMENTATION NOT PROVIDED";
        }
        return string2;
    }

    private boolean matchesRequestedAxisService(AxisService axisService, String string, String string2) {
        return Axis2Utils.getServiceQName(axisService).toString().equals(string) && Axis2Utils.getPortName(axisService).equals(string2);
    }

    private void updateEndpointURLS(HashMap hashMap, HashMap hashMap2, AxisService axisService, Definition definition, String string) {
        String string2;
        Port port;
        Service service;
        QName qName = Axis2Utils.getServiceQName(axisService);
        String string3 = (String)hashMap.get(string);
        if (qName != null && (service = definition.getService(qName)) != null && (port = service.getPort(string2 = Axis2Utils.getPortName(axisService))) != null) {
            String string4 = definition.getTargetNamespace();
            QName qName2 = new QName(string4, string2);
            String string5 = qName.toString() + qName2.toString() + Axis2Utils.getWSDLLocation(axisService);
            String string6 = (String)hashMap2.get(string5);
            if (string6 != null && !"".equals(string6)) {
                List list = port.getExtensibilityElements();
                for (ExtensibilityElement extensibilityElement : list) {
                    ExtensibilityElement extensibilityElement2;
                    if (extensibilityElement instanceof SOAPAddress) {
                        extensibilityElement2 = (SOAPAddress)extensibilityElement;
                        extensibilityElement2.setLocationURI(string3 + string6);
                        continue;
                    }
                    if (!(extensibilityElement instanceof SOAP12Address)) continue;
                    extensibilityElement2 = (SOAP12Address)extensibilityElement;
                    extensibilityElement2.setLocationURI(string3 + string6);
                }
            }
        }
    }

    private String getContentType(MessageContext messageContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getContentType");
        }
        OMOutputFormat oMOutputFormat = new OMOutputFormat();
        messageContext.setDoingMTOM(HTTPTransportUtils.doWriteMTOM(messageContext));
        messageContext.setDoingSwA(HTTPTransportUtils.doWriteSwA(messageContext));
        messageContext.setDoingREST(HTTPTransportUtils.isDoingREST(messageContext));
        oMOutputFormat.setSOAP11(messageContext.isSOAP11());
        oMOutputFormat.setDoOptimize(messageContext.isDoingMTOM());
        oMOutputFormat.setDoingSWA(messageContext.isDoingSwA());
        oMOutputFormat.setCharSetEncoding(HTTPTransportUtils.getCharSetEncoding(messageContext));
        Object object = messageContext.getProperty("mimeBoundary");
        if (object != null) {
            oMOutputFormat.setMimeBoundary((String)object);
        }
        String string = oMOutputFormat.getCharSetEncoding();
        String string2 = oMOutputFormat.getContentType();
        if (string != null) {
            string2 = string2 + "; charset=" + string;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getContentType : " + string2);
        }
        return string2;
    }

    private void traceBytes(byte[] byArray, String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "traceBytes");
        }
        if (byArray != null) {
            MessageTrace.log(MessageTrace.INBOUND_HTTP_REQUEST, string, byArray);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "traceBytes");
        }
    }

    private byte[] extractRequestBytesForTrace(HttpServletRequest httpServletRequest, InputStream inputStream) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Start copying HTTP request to trace buffer");
        }
        byte[] byArray = null;
        String string = httpServletRequest.getHeader("Content-Length");
        if (string != null) {
            int n;
            block13: {
                n = 0;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!_tc.isDebugEnabled()) break block13;
                    Tr.debug(_tc, "Incoming request message to server could not be traced due to following error: " + numberFormatException.toString());
                }
            }
            byArray = new byte[n];
            int n2 = n;
            int n3 = 0;
            while (n2 > 0) {
                int n4 = inputStream.read(byArray, n3, n2);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Trace buffer needs " + n2 + " bytes at offset " + n3 + " got " + n4 + " bytes");
                }
                if (n4 < 0) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "End of stream with " + n2 + " bytes still " + "expected");
                    }
                    n2 = 0;
                    continue;
                }
                n2 -= n4;
                n3 += n4;
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Incoming message is using chunking");
            }
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            int n = 0;
            int n5 = 0;
            while (n5 >= 0) {
                byte[] byArray2 = new byte[1024];
                n5 = inputStream.read(byArray2, 0, 1024);
                if (n5 < 0) continue;
                arrayList.add(byArray2);
                arrayList2.add(new Integer(n5));
                n += n5;
            }
            byArray = new byte[n];
            int n6 = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                byte[] byArray3 = (byte[])arrayList.get(i);
                int n7 = (Integer)arrayList2.get(i);
                System.arraycopy(byArray3, 0, byArray, n6, n7);
                n6 += n7;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "Done copying HTTP request to trace buffer");
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceResponse(MessageContext messageContext, String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "traceResponse");
        }
        try {
            SOAPEnvelope sOAPEnvelope = messageContext.getEnvelope();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sOAPEnvelope.serialize(byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            MessageTrace.log(MessageTrace.OUTBOUND_HTTP_RESPONSE, string, byArray);
        }
        catch (Throwable throwable) {
            Tr.debug(_tc, "Response message could not be traced because of the following error: " + throwable.toString());
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "traceResponse");
            }
        }
    }

    class ServletRequestResponseTransport
    implements RequestResponseTransport {
        private HttpServletResponse response;
        private HttpServletRequest request;
        private boolean responseWritten = false;
        private String requestURL = null;
        private boolean handledSessionInfo = false;
        private CountDownLatch responseReadySignal = new CountDownLatch(1);
        private RequestResponseTransport.RequestResponseTransportStatus status = RequestResponseTransport.RequestResponseTransportStatus.WAITING;

        ServletRequestResponseTransport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
            this.request = httpServletRequest;
            this.response = httpServletResponse;
            this.requestURL = string;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ServletRequestResponseTransport ctor...  requestURL=" + string);
            }
        }

        public void acknowledgeMessage(MessageContext messageContext) throws AxisFault {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "acknowledgeMessage");
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Acking one-way request");
            }
            this.response.setContentType("text/xml; charset=" + messageContext.getProperty("CHARACTER_SET_ENCODING"));
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Content type: " + this.response.getContentType());
            }
            if (!TransportUtils.isResponseWritten(messageContext)) {
                this.response.setContentLength(0);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Content length set to 0.");
                }
            }
            this.response.setStatus(202);
            this.response.setHeader("Connection", HTTPConstants.HEADER_CONNECTION_CLOSE);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Set the response header to close connection");
            }
            this.handleSessionInfo();
            try {
                this.response.flushBuffer();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Response flushed");
                }
            }
            catch (IOException iOException) {
                throw new AxisFault("Error sending acknowledgement", iOException);
            }
            this.status = RequestResponseTransport.RequestResponseTransportStatus.ACKED;
            this.responseReadySignal.countDown();
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "acknowledgeMessage");
            }
        }

        public synchronized void handleSessionInfo() {
            if (!this.handledSessionInfo) {
                HttpSession httpSession;
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "handleSessionInfo");
                }
                if ((httpSession = this.request.getSession(false)) != null) {
                    String string;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Detected an HTTP session: " + httpSession.toString());
                    }
                    if (!(string = this.response.encodeURL(this.requestURL)).equals(this.requestURL)) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "original request URL: " + this.requestURL);
                            Tr.debug(_tc, "encoded URL: " + string);
                            Tr.debug(_tc, "Setting encoded URL in HTTP header: Location");
                        }
                        this.response.setHeader("Location", string);
                    }
                }
                this.handledSessionInfo = true;
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "handleSessionInfo");
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "handleSessionInfo called again for this request: " + this.requestURL);
            }
        }

        public void awaitResponse() throws InterruptedException {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ServletRequestResponseTransport.Blocking servlet thread -- awaiting response : " + this.toString());
            }
            this.responseReadySignal.await();
        }

        public void signalResponseReady() {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ServletRequestResponseTransport.Signalling response available : " + this.toString());
            }
            this.status = RequestResponseTransport.RequestResponseTransportStatus.SIGNALLED;
            this.responseReadySignal.countDown();
        }

        public RequestResponseTransport.RequestResponseTransportStatus getStatus() {
            return this.status;
        }

        public boolean isResponseWritten() {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ServletRequestResponseTransport.isResponseWritten() : " + this.responseWritten);
            }
            return this.responseWritten;
        }

        public void setResponseWritten(boolean bl) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ServletRequestResponseTransport.setResponseWritten() : " + bl);
            }
            this.responseWritten = bl;
        }
    }
}

