/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.Config;
import com.ibm.ws.websvcs.transport.channel.DefaultHTTPSTransportClientProperties;
import com.ibm.ws.websvcs.transport.channel.WSAddress;
import com.ibm.ws.websvcs.transport.common.JavaUtils;
import com.ibm.ws.websvcs.transport.security.ConfigSSL;
import com.ibm.ws.websvcs.transport.security.ConfigSSLProvider;
import com.ibm.ws.websvcs.transport.security.WSConfigSSLChangeListener;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;

public class SetupSSLConfiguration {
    private static final TraceComponent _tc = Tr.register(SetupSSLConfiguration.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private MessageContext localmsgContext;

    public SetupSSLConfiguration(MessageContext messageContext) {
        this.localmsgContext = messageContext;
    }

    public void setupEffectiveSSLConfiguration(final WSAddress wSAddress, final DefaultHTTPSTransportClientProperties defaultHTTPSTransportClientProperties) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setupEffectiveSSLConfiguration");
        }
        Config config2 = null;
        try {
            config2 = (Config)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws AxisFault {
                    return ConfigSSLProvider.getInstance(defaultHTTPSTransportClientProperties).getConfig(SetupSSLConfiguration.this.localmsgContext, wSAddress, defaultHTTPSTransportClientProperties);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "%C", this);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(privilegedActionException));
            }
            throw (AxisFault)privilegedActionException.getException();
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Effective SSL configuration: " + (config2 == null ? null : config2.toString()));
        }
        if (config2 == null) {
            Object[] objectArray = new Object[]{wSAddress.toString()};
            String string = NLSProvider.getNLS().getFormattedMessage("sslConfigResolveFailed01", objectArray, "No Secure Sockets Layer (SSL) configuration is available for the {0} endpoint.");
            throw new AxisFault(string);
        }
        wSAddress.setTransportConfiguration(config2);
        config2.addTargetAddress(wSAddress);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setupEffectiveSSLConfiguration");
        }
    }

    public void restoreSSLConfiguration(final WSAddress wSAddress) throws AxisFault, PrivilegedActionException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "restoreSSLConfiguration");
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws AxisFault, PrivilegedActionException {
                    JSSEHelper jSSEHelper = JSSEHelper.getInstance();
                    ConfigSSL configSSL = (ConfigSSL)wSAddress.transportConfiguration();
                    if (configSSL != null) {
                        Properties properties;
                        WSConfigSSLChangeListener wSConfigSSLChangeListener = configSSL.getlistener();
                        if (wSConfigSSLChangeListener != null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "De-registering WSConfigSSLChangeListener: " + wSConfigSSLChangeListener);
                            }
                            wSConfigSSLChangeListener.deRegister();
                        }
                        if ((properties = configSSL.getPreCfg()) != null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Restoring previously saved SSL configuration: " + properties);
                            }
                        } else if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "No previously saved SSL configuration to be restored.");
                        }
                        jSSEHelper.setSSLPropertiesOnThread(properties);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.webservices.engine.transport.http.setupSSL.restoreSSLConfiguration", "1059", this);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(privilegedActionException));
            }
            throw privilegedActionException;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "restoreSSLConfiguration");
        }
    }
}

