/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.websvcs.transport.http.HTTPTransportSender;
import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.MIMEOutputUtils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;

public class SOAPRequestEntity {
    private static final TraceComponent _tc = Tr.register(HTTPTransportSender.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private boolean doingMTOM = false;
    private boolean doingSWA = false;
    private String charSetEnc;
    private OMElement element;
    private MessageContext msgContext;
    private String soapActionString;
    protected OMOutputFormat format = new OMOutputFormat();
    private byte[] bytes;
    private boolean chunked;

    public SOAPRequestEntity(OMElement oMElement, MessageContext messageContext, String string, String string2) {
        this.element = oMElement;
        this.doingMTOM = messageContext.isDoingMTOM();
        this.doingSWA = messageContext.isDoingSwA();
        this.charSetEnc = string;
        this.msgContext = messageContext;
        this.element = oMElement;
        this.soapActionString = string2;
        this.format.setSOAP11(messageContext.isSOAP11());
        this.format.setDoOptimize(messageContext.isDoingMTOM());
        this.format.setCharSetEncoding(this.charSetEnc);
        this.format.setDoingSWA(messageContext.isDoingSwA());
    }

    public byte[] writeBytes() throws AxisFault, XMLStreamException {
        try {
            final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (!this.doingMTOM) {
                if (this.doingSWA) {
                    final StringWriter stringWriter = new StringWriter();
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws XMLStreamException {
                                SOAPRequestEntity.this.element.serializeAndConsume(stringWriter, SOAPRequestEntity.this.format);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw (XMLStreamException)privilegedActionException.getException();
                    }
                    MIMEOutputUtils.writeSOAPWithAttachmentsMessage(stringWriter, byteArrayOutputStream, this.msgContext.getAttachmentMap(), this.format);
                } else {
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws XMLStreamException {
                                SOAPRequestEntity.this.element.serializeAndConsume(byteArrayOutputStream, SOAPRequestEntity.this.format);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw (XMLStreamException)privilegedActionException.getException();
                    }
                }
                return byteArrayOutputStream.toByteArray();
            }
            this.format.setCharSetEncoding(this.charSetEnc);
            this.format.setDoOptimize(true);
            this.element.serializeAndConsume(byteArrayOutputStream, this.format);
            return byteArrayOutputStream.toByteArray();
        }
        catch (XMLStreamException xMLStreamException) {
            FFDCFilter.processException((Throwable)xMLStreamException, "com.ibm.ws.websvcs.transport.http.SOAPRequestEntity.writeBytes", "71", this);
            throw xMLStreamException;
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            FFDCFilter.processException((Throwable)factoryConfigurationError, "com.ibm.ws.websvcs.transport.http.SOAPRequestEntity.writeBytes", "74", this);
            throw factoryConfigurationError;
        }
    }

    public String getContentType() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getContentType");
        }
        String string = this.format.getContentType();
        if (this.charSetEnc != null) {
            string = string + "; charset=" + this.charSetEnc;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getContentType : ", string);
        }
        return string;
    }
}

