/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.transport.http.HTTPCookieManager;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.trace.MessageTrace;
import com.ibm.ws.websvcs.transport.AsyncEPRSet;
import com.ibm.ws.websvcs.transport.AsyncResponseContext;
import com.ibm.ws.websvcs.transport.AsyncResponseContextMap;
import com.ibm.ws.websvcs.transport.TransportClientProperties;
import com.ibm.ws.websvcs.transport.channel.DefaultHTTPSTransportClientProperties;
import com.ibm.ws.websvcs.transport.channel.DefaultHTTPTransportClientProperties;
import com.ibm.ws.websvcs.transport.channel.OutboundConnectionCache;
import com.ibm.ws.websvcs.transport.channel.WSAddress;
import com.ibm.ws.websvcs.transport.channel.WSChannelManager;
import com.ibm.ws.websvcs.transport.channel.WSOutboundCFCallbackImpl;
import com.ibm.ws.websvcs.transport.channel.WSOutboundConnection;
import com.ibm.ws.websvcs.transport.common.Base64;
import com.ibm.ws.websvcs.transport.common.InvocationPatternHelper;
import com.ibm.ws.websvcs.transport.common.JavaUtils;
import com.ibm.ws.websvcs.transport.http.HTTPClientUtils;
import com.ibm.ws.websvcs.transport.http.HTTPConnection;
import com.ibm.ws.websvcs.transport.http.HttpAsyncResponseContext;
import com.ibm.ws.websvcs.transport.http.HttpChannelAddress;
import com.ibm.ws.websvcs.transport.http.HttpEffectiveConfig;
import com.ibm.ws.websvcs.transport.http.OutboundURLTargetResolver;
import com.ibm.ws.websvcs.transport.http.SetupSSLConfiguration;
import com.ibm.ws.websvcs.transport.http.WSHTTPConstants;
import com.ibm.ws.websvcs.transport.security.SecurityDataPrompt;
import com.ibm.ws.websvcs.transport.security.SecurityDataPromptFactory;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.genericbnf.GenericKeys;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.UnsupportedMethodException;
import com.ibm.wsspi.genericbnf.exception.UnsupportedProtocolVersionException;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPConstants;

public class SOAPOverHTTPSender
implements WSOutboundConnection {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final TraceComponent _tc = Tr.register(SOAPOverHTTPSender.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    protected String chainname = null;
    protected OutboundVirtualConnection oConn = null;
    protected HttpOutboundServiceContext httpOutSC = null;
    private WSAddress addrToConnect = null;
    private HttpResponseMessage httpRspMsg = null;
    private HTTPConnection connection = null;
    private OutboundConnectionCache oCache = null;
    private SetupSSLConfiguration setSSLConfig = null;
    private MessageContext msgContext = null;
    private TransportClientProperties tcp = null;
    private WSChannelManager wMgr = null;
    private HttpEffectiveConfig hConfig = null;
    private byte[] os = null;
    private WsByteBuffer[] wbufArrayAsync = null;
    protected OMOutputFormat format = null;
    private String soapActionString = null;
    private boolean is302or401 = false;
    private boolean maintainSession = false;

    public String saveContextToMap(MessageContext messageContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverHTTPSender.saveContextToMap()...");
        }
        String string = null;
        EndpointReference endpointReference = messageContext.getReplyTo();
        if (endpointReference == null) {
            endpointReference = messageContext.getFaultTo();
        }
        if (endpointReference != null) {
            string = endpointReference.getAddress();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Extracted EPR address: " + string);
            }
            if (string != null) {
                AxisService axisService = messageContext.getAxisService();
                ConfigurationContext configurationContext = messageContext.getConfigurationContext();
                AsyncResponseContextMap asyncResponseContextMap = AsyncResponseContextMap.getInstance();
                AsyncResponseContext asyncResponseContext = asyncResponseContextMap.getContext(string);
                if (asyncResponseContext == null) {
                    asyncResponseContext = new HttpAsyncResponseContext(axisService, configurationContext, string);
                    asyncResponseContextMap.putContext(string, asyncResponseContext);
                    if (_tc.isEventEnabled()) {
                        Tr.debug(_tc, "Creating and adding async response context " + asyncResponseContext + " to cache with key: " + string);
                    }
                } else if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Already cached async response context " + asyncResponseContext + " with key: " + string);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...SOAPOverHTTPSender.saveContextToMap()");
        }
        return string;
    }

    public boolean isMessageSent() {
        boolean bl = false;
        if (this.httpOutSC != null) {
            bl = this.httpOutSC.isMessageSent();
        }
        return bl;
    }

    /*
     * Loose catch block
     */
    public void send(MessageContext messageContext) throws Exception {
        block46: {
            Object object3222;
            boolean bl;
            Object object2;
            int n = 0;
            Integer n2 = null;
            boolean bl2 = false;
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "send(): " + this);
            }
            int n3 = ((HttpChannelAddress)this.addrToConnect).getSchema();
            if (n3 == 2) {
                object2 = this.httpOutSC.getSSLContext();
                if (object2 != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "sslConnCntxt " + object2.toString());
                    }
                    if (!(bl = object2.getUseClientMode())) {
                        object2.setUseClientMode(true);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Client mode for ssl connection context: " + object2.getUseClientMode());
                    }
                } else {
                    throw new AxisFault("No SSLConnectionContext from HTTP outbound service context.");
                }
            }
            if ((object2 = messageContext.getProperty("transportNonBlocking")) != null && ((Boolean)object2).booleanValue()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "ASYNC CALL ");
                }
                bl2 = true;
                this.sendSOAPRequestAsync(messageContext);
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "SYNC CALL ");
                }
                bl = true;
                while (bl) {
                    this.sendSOAPRequest();
                    this.receiveSOAPResponse();
                    bl = this.is302or401set(messageContext);
                }
                n2 = (Integer)messageContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                if (n2 != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "httpStatusInResponse00 ", n2.toString());
                    }
                    n = n2;
                }
                if (n != 0) {
                    this.processStatusCode(n);
                } else {
                    String string = NLSProvider.getNLS().getFormattedMessage("httpStatusInResponse01", new Object[0], "No HTTP status has been received for the current HTTP response.");
                    this.connection.disconnect(new AxisFault(string));
                    throw new AxisFault(string);
                }
            }
            Object var10_10 = null;
            try {
                OMXMLParserWrapper oMXMLParserWrapper;
                object3222 = messageContext.getEnvelope();
                if (object3222 != null && (oMXMLParserWrapper = object3222.getBuilder()) != null) {
                    oMXMLParserWrapper.close();
                }
            }
            catch (Throwable object3222) {
                // empty catch block
            }
            try {
                if (!bl2) {
                    if (this.setSSLConfig != null) {
                        this.setSSLConfig.restoreSSLConfiguration(this.addrToConnect);
                        this.setSSLConfig = null;
                    }
                    if (this.connection != null) {
                        if ((InvocationPatternHelper.isOneWayInvocation(messageContext) || InvocationPatternHelper.isTwoWayInvocation(messageContext)) && n == HttpConstants.STATUS_ACCEPTED.getIntCode()) {
                            this.connection.disconnect(null);
                        } else {
                            this.connection.reset();
                        }
                        this.oCache.findGroupAndReturnConnection(this.connection);
                        this.connection = null;
                    }
                }
            }
            catch (Exception object3222) {
                FFDCFilter.processException((Throwable)object3222, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.send", "483", this);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "exception01 " + JavaUtils.stackToString((Throwable)object3222));
                }
                throw object3222;
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "send()");
            }
            break block46;
            {
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.send", "426", this);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(exception));
                    }
                    if (this.connection != null) {
                        this.connection.disconnect(exception);
                    }
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                Object object42222;
                Object var10_11 = null;
                try {
                    OMXMLParserWrapper oMXMLParserWrapper;
                    object42222 = messageContext.getEnvelope();
                    if (object42222 != null && (oMXMLParserWrapper = object42222.getBuilder()) != null) {
                        oMXMLParserWrapper.close();
                    }
                }
                catch (Throwable object42222) {
                    // empty catch block
                }
                try {
                    if (!bl2) {
                        if (this.setSSLConfig != null) {
                            this.setSSLConfig.restoreSSLConfiguration(this.addrToConnect);
                            this.setSSLConfig = null;
                        }
                        if (this.connection != null) {
                            if ((InvocationPatternHelper.isOneWayInvocation(messageContext) || InvocationPatternHelper.isTwoWayInvocation(messageContext)) && n == HttpConstants.STATUS_ACCEPTED.getIntCode()) {
                                this.connection.disconnect(null);
                            } else {
                                this.connection.reset();
                            }
                            this.oCache.findGroupAndReturnConnection(this.connection);
                            this.connection = null;
                        }
                    }
                }
                catch (Exception object42222) {
                    FFDCFilter.processException((Throwable)object42222, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.send", "483", this);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "exception01 " + JavaUtils.stackToString((Throwable)object42222));
                    }
                    throw object42222;
                }
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "send()");
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendSOAPRequest() throws Exception {
        block16: {
            WsByteBuffer[] wsByteBufferArray = null;
            try {
                try {
                    if (_tc.isEntryEnabled()) {
                        Tr.entry(_tc, "sendSOAPRequest(): " + this);
                    }
                    wsByteBufferArray = this.prepareHttpRequestHeaders(this.msgContext);
                    if (this.httpOutSC.getRequest().isExpect100Continue()) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "httpExpect100SC " + String.valueOf(this.addrToConnect));
                        }
                        this.httpOutSC.sendRequestHeaders();
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "wsbytebufferarray : " + wsByteBufferArray.toString());
                    }
                    this.httpOutSC.finishRequestMessage(wsByteBufferArray);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Message sent");
                    }
                    if (MessageTrace.isTraceEnabled()) {
                        String string;
                        String string2 = string = this.format != null ? this.format.getContentType() : null;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Using this contentType for MessageTrace: " + string);
                        }
                        MessageTrace.log(MessageTrace.OUTBOUND_HTTP_REQUEST, string, this.os);
                    }
                    this.connection.setUsedAlready();
                    Object var4_4 = null;
                    this.connection.setLastAccessTime();
                    if (wsByteBufferArray == null) break block16;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.sendSOAPRequest", "554", this);
                    if (!_tc.isDebugEnabled()) throw exception;
                    Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(exception));
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.connection.setLastAccessTime();
                if (wsByteBufferArray != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "releasing wsbytebufferarray");
                    }
                    for (int i = 0; i < wsByteBufferArray.length; ++i) {
                        if (wsByteBufferArray[i] == null) continue;
                        wsByteBufferArray[i].release();
                        wsByteBufferArray[i] = null;
                    }
                }
                if (!_tc.isEntryEnabled()) throw throwable;
                Tr.exit(_tc, "sendSOAPRequest(): " + this);
                throw throwable;
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "releasing wsbytebufferarray");
            }
            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                if (wsByteBufferArray[i] == null) continue;
                wsByteBufferArray[i].release();
                wsByteBufferArray[i] = null;
            }
        }
        if (!_tc.isEntryEnabled()) return;
        Tr.exit(_tc, "sendSOAPRequest(): " + this);
    }

    public WSOutboundCFCallbackImpl sendSOAPRequestAsync(MessageContext messageContext) throws Exception {
        try {
            Object object;
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "sendSOAPRequestAsync(): " + this);
            }
            this.wbufArrayAsync = this.prepareHttpRequestHeaders(messageContext);
            HttpRequestMessage httpRequestMessage = this.httpOutSC.getRequest();
            WSOutboundCFCallbackImpl wSOutboundCFCallbackImpl = new WSOutboundCFCallbackImpl(this, this.addrToConnect);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Created " + wSOutboundCFCallbackImpl + " with " + this.oConn);
            }
            this.httpOutSC.finishRequestMessage(this.wbufArrayAsync, wSOutboundCFCallbackImpl, true);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Message sent");
            }
            if (MessageTrace.isTraceEnabled()) {
                Object object2 = object = this.format != null ? this.format.getContentType() : null;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Using this contentType for MessageTrace: " + (String)object);
                }
                MessageTrace.log(MessageTrace.OUTBOUND_HTTP_REQUEST, (String)object, this.os);
            }
            this.connection.setUsedAlready();
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "sendSOAPRequestAsync(): " + this);
            }
            object = wSOutboundCFCallbackImpl;
            return object;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.sendSOAPRequestAsync", "639", this);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "exception01" + JavaUtils.stackToString(exception));
            }
            throw exception;
        }
        finally {
            this.connection.setLastAccessTime();
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "sendSOAPRequestAsync(): " + this);
            }
        }
    }

    public void releaseBuffer() {
        if (this.wbufArrayAsync != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "releasing wsbytebufferarray");
            }
            for (int i = 0; i < this.wbufArrayAsync.length; ++i) {
                if (this.wbufArrayAsync[i] == null) continue;
                this.wbufArrayAsync[i].release();
                this.wbufArrayAsync[i] = null;
            }
        }
    }

    public void receiveSOAPResponse() throws Exception {
        try {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "receiveSOAPResponse(): " + this);
            }
            this.httpRspMsg = this.httpOutSC.getResponse();
            if (this.httpRspMsg.isIncoming()) {
                HashMap<String, String> hashMap;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                String string = null;
                byte[] byArray = null;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "receiveSOAPResponse message incoming");
                }
                if (this.msgContext.getAxisOperation() != null && (object4 = ((AxisOperation)(object3 = this.msgContext.getAxisOperation())).getMessageExchangePattern()) != null && _tc.isDebugEnabled()) {
                    Tr.debug(_tc, "MEP : " + (String)object4);
                }
                object3 = "iso-8859-1";
                byArray = this.httpRspMsg.getReasonPhraseBytes();
                if (byArray != null) {
                    string = new String(byArray, (String)object3);
                    this.msgContext.setProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE, string);
                }
                if ((object4 = this.httpRspMsg.getStatusCode()) != null) {
                    this.msgContext.setProperty(HTTPConstants.MC_HTTP_STATUS_CODE, new Integer(((StatusCodes)object4).getIntCode()));
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "receiveSOAPResponse HTTPmesssage status code : " + ((StatusCodes)object4).toString());
                    }
                    if (((GenericKeys)object4).equals(HttpConstants.STATUS_FOUND)) {
                        if (this.isHttpRedirectEnabled(this.msgContext) && (byArray = this.httpRspMsg.getHeaderAsByteArray(HttpConstants.HDR_LOCATION)) != null && JavaUtils.hasValue(string = new String(byArray, (String)object3))) {
                            object2 = this.addrToConnect.toString();
                            if (!JavaUtils.hasValue((String)object2)) {
                                object = this.msgContext.getTo();
                                object2 = ((EndpointReference)object).getAddress();
                            }
                            if (!string.equals(object2)) {
                                this.msgContext.setProperty(WSHTTPConstants.TRANS_URL_HTTP_REDIRECTED, string);
                            }
                        }
                    } else if (((GenericKeys)object4).equals(HttpConstants.STATUS_UNAUTHORIZED) && (byArray = this.httpRspMsg.getHeaderAsByteArray(HttpConstants.HDR_WWW_AUTHENTICATE)) != null) {
                        object2 = new StringBuffer(new String(byArray, (String)object3));
                        int n = ((StringBuffer)object2).indexOf("\"") + 1;
                        int n2 = ((StringBuffer)object2).lastIndexOf("\"");
                        if (n2 < 0) {
                            n2 = ((StringBuffer)object2).length();
                        }
                        string = ((StringBuffer)object2).substring(n, n2);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "WWW-Authenticate Value : " + string);
                        }
                        this.msgContext.setProperty("WWW-Authenticate", string);
                    }
                }
                this.processResponseHeader();
                object2 = this.httpOutSC.getResponseBodyBuffers();
                object = null;
                if (object2 != null) {
                    object = WsByteBufferUtils.asByteArray((WsByteBuffer[])object2);
                    if (MessageTrace.isTraceEnabled()) {
                        String string2;
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i = 0; i < ((byte[])object).length; ++i) {
                            stringBuffer.append((char)object[i]);
                        }
                        String string3 = string2 = this.format != null ? this.format.getContentType() : null;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Using this contentType for MessageTrace: " + string2);
                        }
                        MessageTrace.log(MessageTrace.INBOUND_HTTP_RESPONSE, string2, stringBuffer.toString());
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Received message is NULL ");
                }
                ByteArrayInputStream byteArrayInputStream = null;
                if (object != null && ((byte[])object).length != 0) {
                    byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                    if (byteArrayInputStream == null) {
                        throw new AxisFault("canNotBeNull", "InputStream");
                    }
                    if (this.msgContext.getOperationContext() != null) {
                        this.msgContext.getOperationContext().setProperty("TRANSPORT_IN", byteArrayInputStream);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "receiveSOAPResponse received message : " + byteArrayInputStream.toString());
                    }
                } else if (!InvocationPatternHelper.isOneWayInvocation(this.msgContext) && _tc.isDebugEnabled()) {
                    Tr.debug(_tc, "This is not oneway : " + String.valueOf(this.addrToConnect));
                }
                if (object2 != null) {
                    for (int i = 0; i < ((WsByteBuffer[])object2).length; ++i) {
                        if (object2[i] == null) continue;
                        object2[i].release();
                        object2[i] = null;
                    }
                    object = null;
                }
                if ((hashMap = (HashMap<String, String>)this.msgContext.getProperty("com.ibm.websphere.webservices.responseTransportProperties")) == null) {
                    hashMap = new HashMap<String, String>();
                }
                if (hashMap != null) {
                    Iterator<Object> iterator = null;
                    if (hashMap.isEmpty()) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "receiveSOAPResponse(): Empty response header hasmap - returning ALL headers!");
                        }
                        iterator = this.httpRspMsg.getAllHeaders().iterator();
                    } else {
                        iterator = hashMap.keySet().iterator();
                    }
                    String string4 = null;
                    String string5 = null;
                    while (iterator.hasNext()) {
                        StringBuffer stringBuffer;
                        Vector vector;
                        string4 = (String)iterator.next();
                        if (string4 == "Location") {
                            vector = this.httpRspMsg.getHeaderByteArrayValues(string4);
                            stringBuffer = new StringBuffer();
                            if (vector != null && !vector.isEmpty()) {
                                for (byte[] byArray2 : vector) {
                                    stringBuffer.append(new String(byArray2, (String)object3));
                                }
                                string5 = stringBuffer.toString();
                            }
                            if (this.maintainSession && this.msgContext.getServiceContext() != null && JavaUtils.hasValue(string5)) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Setting HTTPConstants.HEADER_LOCATION : " + string5.toString() + " in servicecontext");
                                }
                                this.msgContext.getServiceContext().setProperty("Location", string5);
                            }
                        } else if (string4 == "Cookie" || string4 == "Cookie2") {
                            vector = this.httpRspMsg.getHeaderByteArrayValues(string4);
                            stringBuffer = new StringBuffer();
                            if (vector != null && !vector.isEmpty()) {
                                Iterator iterator2 = vector.iterator();
                                while (iterator2.hasNext()) {
                                    byte[] byArray2;
                                    byArray2 = (byte[])iterator2.next();
                                    if (iterator2.hasNext()) {
                                        stringBuffer.append(new String(byArray2, (String)object3)).append(WSHTTPConstants.HEADER_TOKEN_SEPARATOR);
                                        continue;
                                    }
                                    stringBuffer.append(new String(byArray2, (String)object3));
                                }
                                string5 = stringBuffer.toString();
                            }
                        } else {
                            string5 = this.httpRspMsg.getHeaderAsString(string4);
                        }
                        if (JavaUtils.hasValue(string5)) {
                            hashMap.put(string4, string5);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "receiveSOAPResponse(): Rsp headerKey = " + string4 + ", responseHeader = " + string5);
                            }
                        }
                        string5 = null;
                    }
                }
                this.msgContext.setProperty("com.ibm.websphere.webservices.responseTransportProperties", hashMap);
                this.msgContext.setProperty("TRANSPORT_HEADERS", hashMap);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "responseTransportHeaders is set");
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "invalidHttpResponse " + String.valueOf(this.addrToConnect));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.receiveSOAPResponse", "967", this);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(exception));
            }
            throw exception;
        }
        finally {
            this.connection.setLastAccessTime();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "receiveSOAPResponse(): " + this);
        }
    }

    public String printBytes(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean is302or401set(MessageContext messageContext) throws AxisFault {
        boolean bl;
        block22: {
            block20: {
                block23: {
                    int n;
                    block21: {
                        n = 0;
                        Integer n2 = null;
                        String string = null;
                        bl = true;
                        if (_tc.isEntryEnabled()) {
                            Tr.entry(_tc, "is302or401set: " + this);
                        }
                        n2 = (Integer)messageContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                        string = (String)messageContext.getProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                        if (n2 == null) break block20;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "httpStatusInResponse00 " + n2.toString() + "  " + string);
                        }
                        if ((n = n2.intValue()) != HttpConstants.STATUS_FOUND.getIntCode()) break block21;
                        if (!this.isHttpRedirectEnabled(messageContext)) {
                            bl = false;
                            Object[] objectArray = new Object[]{this.addrToConnect.toString()};
                            String string2 = NLSProvider.getNLS().getFormattedMessage("http302StatusCode", objectArray, "The HTTP response redirected the target resource to a new location: {0}");
                            throw new AxisFault(string2);
                        }
                        string = (String)messageContext.getProperty(WSHTTPConstants.TRANS_URL_HTTP_REDIRECTED);
                        if (JavaUtils.hasValue(string)) {
                            this.connection.reset();
                            URL uRL = null;
                            try {
                                if (this.addrToConnect.getSchema() == 2) {
                                    this.setSSLConfig.restoreSSLConfiguration(this.addrToConnect);
                                }
                                this.connection.disconnect(null);
                                this.oCache.findGroupAndReturnConnection(this.connection);
                                this.connection = null;
                                this.tcp = null;
                                uRL = new URL(string);
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Redirected URL " + uRL.toString());
                                }
                                this.addrToConnect = new HttpChannelAddress(uRL);
                                this.tcp = this.setupTransportClientProperties(uRL, true);
                                this.setupHTTPConnection();
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.is302or401set", "1057", this);
                                throw new AxisFault(exception);
                            }
                        } else {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, WSHTTPConstants.TRANS_URL_HTTP_REDIRECTED + " is not set");
                            }
                            bl = false;
                        }
                        break block22;
                    }
                    if (n != HttpConstants.STATUS_UNAUTHORIZED.getIntCode()) break block23;
                    if (this.wMgr.getRuntime() != 1) {
                        if (this.receivedHTTPBasicAuth()) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "challengeStatus01");
                            }
                            try {
                                this.connection.reset();
                                this.oCache.findGroupAndReturnConnection(this.connection);
                                this.connection = null;
                                this.setupHTTPConnection();
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.is302or401set", "1128", this);
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(exception));
                                }
                                throw AxisFault.makeFault(exception);
                            }
                        } else {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "challengeStatus02");
                            }
                            bl = false;
                        }
                        break block22;
                    } else {
                        bl = false;
                    }
                    break block22;
                }
                bl = false;
                break block22;
            }
            bl = false;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "is302or401set(): " + bl);
        }
        this.is302or401 = bl;
        return bl;
    }

    private boolean receivedHTTPBasicAuth() {
        boolean bl;
        block12: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "receiveHTTPBasicAuth");
            }
            bl = false;
            if (!JavaUtils.hasValue(this.hConfig.getOutRequestUserID(this.msgContext)) && !JavaUtils.hasValue(this.hConfig.getOutRequestPassword(this.msgContext)) || !JavaUtils.hasValue(this.hConfig.getOutAsyncRespUserID(this.msgContext)) && !JavaUtils.hasValue(this.hConfig.getOutAsyncRespPassword(this.msgContext))) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "basicAuthData is NULL");
                }
                String string = System.getProperty("com.ibm.ws.webservices.loginSource");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "com.ibm.ws.webservices.loginSource: " + string);
                }
                try {
                    if (!JavaUtils.hasValue(string) || "prompt".compareToIgnoreCase(string) != 0 && "stdin".compareToIgnoreCase(string) != 0) break block12;
                    SecurityDataPrompt securityDataPrompt = SecurityDataPromptFactory.getPrompt(string);
                    String[] stringArray = null;
                    try {
                        final String string2 = (String)this.msgContext.getProperty("WWW-Authenticate");
                        final SecurityDataPrompt securityDataPrompt2 = securityDataPrompt;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "challengeRealmInfo", string2);
                        }
                        stringArray = (String[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return securityDataPrompt2.launch(string2 == null ? "" : string2);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.receivedHTTPBasicAuth", "1241", this);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Stack " + privilegedActionException.toString());
                        }
                        throw privilegedActionException.getException();
                    }
                    if (stringArray != null && JavaUtils.hasValue(stringArray[0]) && JavaUtils.hasValue(stringArray[1])) {
                        this.msgContext.setProperty("javax.xml.ws.security.auth.username", stringArray[0]);
                        this.msgContext.setProperty("javax.xml.ws.security.auth.password", stringArray[1]);
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.receivedHTTPBasicAuth", "1269", this);
                    Object[] objectArray = new Object[]{exception};
                    Tr.error(_tc, "caughtException", objectArray);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "receiveHTTPBasicAuth : " + bl);
        }
        return bl;
    }

    public boolean isHttpRedirectEnabled(MessageContext messageContext) {
        boolean bl = false;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "isHttpRedirectEnabled() ");
        }
        bl = this.hConfig.redirectURLEnabled(messageContext);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "isHttpRedirectEnabled() : " + bl);
        }
        return bl;
    }

    public String getChannelChainName() {
        return this.chainname;
    }

    public WSAddress getTargetAddress() {
        return this.addrToConnect;
    }

    public void setFormat(OMOutputFormat oMOutputFormat) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Setting the format" + oMOutputFormat);
        }
        this.format = oMOutputFormat;
    }

    public OMOutputFormat getFormat() {
        return this.format;
    }

    public void setSoapAction(String string) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Setting the Soap Action" + string);
        }
        this.soapActionString = string;
    }

    public SetupSSLConfiguration getSSLConfig() {
        return this.setSSLConfig;
    }

    public HTTPConnection getHTTPConnection() {
        return this.connection;
    }

    public OutboundConnectionCache getOutboundConnectionCache() {
        return this.oCache;
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    protected String getHeaderFromResponse(HttpHeaderKeys httpHeaderKeys) throws AxisFault {
        HttpResponseMessage httpResponseMessage;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getHeaderFromResponse()");
        }
        String string = null;
        if (this.oConn != null && this.httpOutSC != null && (httpResponseMessage = this.httpOutSC.getResponse()) != null) {
            string = httpResponseMessage.getHeaderAsString(httpHeaderKeys);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getHeaderFromResponse()");
        }
        this.connection.setLastAccessTime();
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TransportClientProperties setupTransportClientProperties(URL uRL, boolean bl) throws AxisFault {
        DefaultHTTPTransportClientProperties defaultHTTPTransportClientProperties = null;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setupTransportClientProperties : " + uRL.toString() + ", redirect = " + bl);
        }
        try {
            if (uRL.getProtocol().compareToIgnoreCase("http") == 0) {
                this.hConfig = new HttpEffectiveConfig(false, this.msgContext);
                if (this.hConfig.isPolicySetDefined()) {
                    if (InvocationPatternHelper.isAsyncRespSeparateChannel(this.msgContext)) {
                        if (this.hConfig.getOutAsyncResponseSSLEnabled(this.msgContext)) {
                            throw new AxisFault("OutAsyncResponseSSL is set to yes in policyset for the URL : " + uRL.getProtocol());
                        }
                    } else if (this.hConfig.getOutReqSSLEnabled(this.msgContext) && !bl) {
                        throw new AxisFault("Out request Policy Set for SSL is set to true for protocol: " + uRL.getProtocol());
                    }
                }
                defaultHTTPTransportClientProperties = new DefaultHTTPTransportClientProperties(this.msgContext);
            } else if (uRL.getProtocol().compareToIgnoreCase("https") == 0) {
                this.hConfig = new HttpEffectiveConfig(true, this.msgContext);
                defaultHTTPTransportClientProperties = new DefaultHTTPSTransportClientProperties(this.msgContext);
                if (this.msgContext.getReplyTo() != null && _tc.isDebugEnabled()) {
                    Tr.debug(_tc, "replyTo : " + this.msgContext.getReplyTo() + " hasAnonymous : " + this.msgContext.getReplyTo().hasAnonymousAddress());
                }
                if (InvocationPatternHelper.isAsyncRespSeparateChannel(this.msgContext)) {
                    if (this.hConfig.isPolicySetDefined()) {
                        if (!this.hConfig.getOutAsyncResponseSSLEnabled(this.msgContext)) throw new AxisFault("Out Async Response Policyset for SSL is set to false. " + uRL.getProtocol());
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Setting SSL for Asynchronous Response flow...");
                        }
                        String string = this.hConfig.getOutAsyncResponseSSLFile(this.msgContext);
                        if (WSChannelManager.getInstance().getRuntime() == 1) {
                            if (JavaUtils.hasValue(string)) {
                                Tr.warning(_tc, "Running in server. getOutAsyncResponseSSLFile should not be set in Policyset.");
                            }
                            defaultHTTPTransportClientProperties.setSSLConfigurationName(null);
                            defaultHTTPTransportClientProperties.setSSLClientPropsName(null);
                        } else {
                            defaultHTTPTransportClientProperties.setSSLConfigurationName(this.hConfig.getOutAsyncResponseSSLAlias(this.msgContext));
                            defaultHTTPTransportClientProperties.setSSLClientPropsName(this.hConfig.getOutAsyncResponseSSLFile(this.msgContext));
                        }
                    }
                } else if (this.hConfig.isPolicySetDefined()) {
                    if (!this.hConfig.getOutReqSSLEnabled(this.msgContext) && !bl) throw new AxisFault("Out request Policy Set for SSL is set to false for protocol: " + uRL.getProtocol());
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Setting SSL for out request flow...");
                    }
                    String string = this.hConfig.getOutReqSSLFile(this.msgContext);
                    if (WSChannelManager.getInstance().getRuntime() == 1) {
                        if (JavaUtils.hasValue(string)) {
                            Tr.warning(_tc, "Running in server. getOutReqSSLFile should not be set in Policyset.");
                        }
                        defaultHTTPTransportClientProperties.setSSLConfigurationName(null);
                        defaultHTTPTransportClientProperties.setSSLClientPropsName(null);
                    } else {
                        defaultHTTPTransportClientProperties.setSSLConfigurationName(this.hConfig.getOutReqSSLAlias(this.msgContext));
                        defaultHTTPTransportClientProperties.setSSLClientPropsName(this.hConfig.getOutReqSSLFile(this.msgContext));
                    }
                }
            } else {
                Object[] objectArray = new Object[]{uRL.getProtocol()};
                String string = NLSProvider.getNLS().getFormattedMessage("httpUnsupportedSchema", objectArray, "The following schema for HTTP is not supported: {0}");
                throw new AxisFault(string);
            }
            if (InvocationPatternHelper.isAsyncRespSeparateChannel(this.msgContext)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Setting proxy settings for Asynchronous Response flow...");
                }
                defaultHTTPTransportClientProperties.setProxyHost(this.hConfig.getOutAsyncRespProxyHost(this.msgContext));
                defaultHTTPTransportClientProperties.setProxyPort(this.hConfig.getOutAsyncRespProxyPort(this.msgContext));
                defaultHTTPTransportClientProperties.setProxyUser(this.hConfig.getOutAsyncRespProxyUserID(this.msgContext));
                defaultHTTPTransportClientProperties.setProxyPassword(this.hConfig.getOutAsyncRespProxyPassword(this.msgContext));
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Setting proxy settings for out request flow...");
                }
                defaultHTTPTransportClientProperties.setProxyHost(this.hConfig.getOutRequestProxyHost(this.msgContext));
                defaultHTTPTransportClientProperties.setProxyPort(this.hConfig.getOutRequestProxyPort(this.msgContext));
                defaultHTTPTransportClientProperties.setProxyUser(this.hConfig.getOutRequestProxyUserID(this.msgContext));
                defaultHTTPTransportClientProperties.setProxyPassword(this.hConfig.getOutRequestProxyPassword(this.msgContext));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.setupTransportClientProperties", "1517", this);
            throw new AxisFault(exception);
        }
        if (!_tc.isEntryEnabled()) return defaultHTTPTransportClientProperties;
        Tr.exit(_tc, "setupTransportClientProperties");
        return defaultHTTPTransportClientProperties;
    }

    public SOAPOverHTTPSender(MessageContext messageContext) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverHTTPSender: " + messageContext);
        }
        try {
            this.wMgr = WSChannelManager.getInstance();
            this.msgContext = messageContext;
            EndpointReference endpointReference = this.msgContext.getTo();
            URL uRL = new URL(endpointReference.getAddress());
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Target URL " + uRL.toString());
            }
            this.tcp = this.setupTransportClientProperties(uRL, false);
            this.maintainSession = this.hConfig.maintainSessionEnabled(this.msgContext);
            OutboundURLTargetResolver outboundURLTargetResolver = new OutboundURLTargetResolver();
            this.addrToConnect = outboundURLTargetResolver.getOutboundTarget(this.tcp, this.msgContext, this.maintainSession);
            if (this.addrToConnect.getSchema() == 2) {
                this.setSSLConfig = new SetupSSLConfiguration(this.msgContext);
            }
            this.setupHTTPConnection();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.SOAPOverHTTPSender", "1561", this);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "exception01 " + exception.toString());
            }
            throw new AxisFault(exception);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SOAPOverHTTPSender");
        }
    }

    public void setupHTTPConnection() throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setupHTTPConnection " + this.addrToConnect);
        }
        try {
            int n = this.hConfig.getConnectionTimeout(this.msgContext);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Connection timeout: " + n + " ms");
            }
            this.addrToConnect.setConnectTimeout(n);
            if (this.addrToConnect.getSchema() == 2) {
                if (this.setSSLConfig == null) {
                    this.setSSLConfig = new SetupSSLConfiguration(this.msgContext);
                }
                this.setSSLConfig.setupEffectiveSSLConfiguration(this.addrToConnect, (DefaultHTTPSTransportClientProperties)this.tcp);
            }
            this.chainname = this.addrToConnect.keyValueforPool();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "chainname " + this.chainname);
            }
            this.oCache = (OutboundConnectionCache)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return OutboundConnectionCache.getInstance();
                }
            });
            this.connection = this.oCache.findGroupAndGetConnection(this.addrToConnect);
            if (this.connection == null) {
                String string = NLSProvider.getNLS().getFormattedMessage("noHttpObjReturnFromPool00", new Object[0], "No HTTPConnection object was returned from the outbound connection pool.");
                throw new AxisFault(string);
            }
            this.connection.connect();
            this.oConn = this.connection.getConnection();
            this.httpOutSC = (HttpOutboundServiceContext)this.oConn.getChannelAccessor();
        }
        catch (Exception exception) {
            block12: {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.setupHTTPConnection", "1620", this);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "exception01 " + exception.toString());
                }
                try {
                    this.connection = this.oCache.findConnectionAndInvalidate(this.addrToConnect);
                    this.oCache.findGroupAndReturnConnection(this.connection);
                }
                catch (Throwable throwable) {
                    if (!_tc.isDebugEnabled()) break block12;
                    Tr.debug(_tc, "Could not return connection object after failed attempt to connect: " + this.addrToConnect);
                }
            }
            throw new AxisFault(exception);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setupHTTPConnection");
        }
    }

    private static void addValueToOutboundHeader(String string, String string2, HttpRequestMessage httpRequestMessage) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "addValueToOutboundHeader(transportHeaderKey, transportHeaderValue, httpReqMsg): transportHeaderKey = " + string + ", transportHeaderValue = " + string2 + ", httpReqMsg" + httpRequestMessage);
        }
        if (string == null || string.length() <= 0) {
            Tr.error(_tc, "invalidTransHeadKey00");
            return;
        }
        if (string2 == null || string2.length() <= 0) {
            Tr.error(_tc, "invalidTransHeadValue00", string);
            return;
        }
        if (httpRequestMessage == null) {
            Tr.error(_tc, "internal.error", "HTTP Request message is null");
        }
        String string3 = httpRequestMessage.getHeaderAsString(string);
        StringTokenizer stringTokenizer = null;
        if (string3 != null) {
            stringTokenizer = new StringTokenizer(string3, ";");
        }
        if (stringTokenizer != null && stringTokenizer.countTokens() > 0) {
            int n;
            CharSequence charSequence;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ";");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            while (stringTokenizer2 != null && stringTokenizer2.countTokens() > 0) {
                charSequence = stringTokenizer2.nextToken();
                n = ((String)charSequence).indexOf("=");
                String object2 = ((String)charSequence).substring(0, n);
                String string4 = ((String)charSequence).substring(n + 1);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "addValueToOutboundHeader() New tokenName = " + object2 + " , tokenValue" + string4);
                }
                hashMap.put(object2, string4);
            }
            while (stringTokenizer.countTokens() > 0) {
                charSequence = stringTokenizer.nextToken();
                n = ((String)charSequence).indexOf("=");
                String string5 = ((String)charSequence).substring(0, n);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "addValueToOutboundHeader() removing " + string5 + " from new header values if it exists = " + hashMap.containsKey(string5));
                }
                hashMap.remove(string5);
            }
            charSequence = new StringBuffer(httpRequestMessage.getHeaderAsString(string));
            for (Map.Entry entry : hashMap.entrySet()) {
                ((StringBuffer)charSequence).append(";");
                ((StringBuffer)charSequence).append((String)entry.getKey());
                ((StringBuffer)charSequence).append("=");
                ((StringBuffer)charSequence).append((String)entry.getValue());
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "addValueToOutboundHeader() adding request header ;" + (String)entry.getKey() + "=" + (String)entry.getValue());
            }
            httpRequestMessage.setHeader(string, new String((StringBuffer)charSequence));
        } else {
            httpRequestMessage.setHeader(string, string2);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "addValueToOutboundHeader(): Header did not already exist. Adding " + string + " value " + string2);
            }
        }
    }

    private WsByteBuffer[] prepareHttpRequestHeaders(MessageContext messageContext) throws AxisFault, UnsupportedMethodException, UnsupportedProtocolVersionException, MalformedURLException, XMLStreamException {
        boolean bl;
        Object object;
        Object object2;
        String string;
        String string2;
        String string3 = null;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "prepareHttpRequestHeaders(): " + this);
        }
        HttpRequestMessage httpRequestMessage = this.httpOutSC.getRequest();
        String string4 = null;
        int n = this.hConfig.getReadTimeout(this.msgContext);
        this.httpOutSC.setReadTimeout(n);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "syncTimeoutValue " + String.valueOf(n) + " ms for " + this.addrToConnect.getSchemaInString());
        }
        int n2 = this.hConfig.getWriteTimeout(this.msgContext);
        this.httpOutSC.setWriteTimeout(n2);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Write timeout value " + String.valueOf(n2) + " ms for " + this.addrToConnect.getSchemaInString());
        }
        boolean bl2 = true;
        if (!this.msgContext.isSOAP11()) {
            string4 = (String)this.msgContext.getProperty("soap12.webmethod");
        }
        if (string4 == null) {
            string4 = "POST";
        } else {
            bl2 = string4.equals("POST");
        }
        httpRequestMessage.setMethod(string4);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "prepareHttpRequestHeaders() setMethod : " + string4);
        }
        string4 = ((HttpChannelAddress)this.addrToConnect).getTargetEndPoint();
        httpRequestMessage.setRequestURL(string4);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "prepareHttpRequestHeaders() setRequestURL : " + string4);
        }
        if ((string2 = httpRequestMessage.getURLHost()) == null || string2 != null && string2.equals("")) {
            Object[] objectArray = new Object[]{string2, string4};
            String string5 = NLSProvider.getNLS().getFormattedMessage("invalidHttpHost", objectArray, "An incorrect {0} HTTP host value was specified within the URL {1}");
            throw new AxisFault(string5);
        }
        int n3 = httpRequestMessage.getURLPort();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "prepareHttpRequestHeaders() urlPort : " + n3);
        }
        if (n3 <= 0) {
            Object[] objectArray = new Object[]{n3, string4};
            String string6 = NLSProvider.getNLS().getFormattedMessage("invalidHttpPort", objectArray, "An incorrect {0} HTTP port value was specified within the URL {1}");
            throw new AxisFault(string6);
        }
        String string7 = string2 + ":" + n3;
        httpRequestMessage.setHeader((HeaderKeys)HttpConstants.HDR_HOST, string7);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "prepareHttpRequestHeaders() hostHeaderValue : " + string7);
        }
        string4 = this.hConfig.getProtocolVer(this.msgContext) != null ? this.hConfig.getProtocolVer(this.msgContext) : "HTTP/1.1";
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "httpVersion " + string4);
        }
        boolean bl3 = true;
        if (string4 != null) {
            if (string4.equalsIgnoreCase("HTTP/1.1") || string4.equalsIgnoreCase("HTTP/1.0")) {
                httpRequestMessage.setVersion(string4);
                if (string4.equalsIgnoreCase("HTTP/1.0")) {
                    bl3 = false;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "prepareHttpRequestHeaders() setVersion " + string4);
                }
            } else {
                Object[] objectArray = new Object[]{string4};
                String string8 = NLSProvider.getNLS().getFormattedMessage("unsupportedHttpVersion", objectArray, "An unsupported HTTP version is found: {0}");
                throw new AxisFault(string8);
            }
        }
        httpRequestMessage.setVersion(string4);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "addrToConnect " + String.valueOf(this.addrToConnect) + "  httpVersion : " + httpRequestMessage.getVersion());
        }
        String string9 = "application/soap+xml,multipart/related,text/*";
        httpRequestMessage.setHeader((HeaderKeys)HttpConstants.HDR_ACCEPT, string9);
        httpRequestMessage.setHeader((HeaderKeys)HttpConstants.HDR_USER_AGENT, "IBM WebServices/1.0");
        httpRequestMessage.setHeader((HeaderKeys)HttpConstants.HDR_CACHE_CONTROL, "no-cache");
        httpRequestMessage.setHeader((HeaderKeys)HttpConstants.HDR_PRAGMA, "no-cache");
        String string10 = null;
        if (this.soapActionString == null) {
            string10 = "\"\"";
        } else if (this.soapActionString.startsWith("\"") && this.soapActionString.endsWith("\"")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "soapAction already contains double quotes");
            }
            string10 = this.soapActionString;
        } else {
            string10 = "\"" + this.soapActionString + "\"";
        }
        if ("".equals(string10)) {
            httpRequestMessage.setHeader("SOAPAction", "");
        } else {
            httpRequestMessage.setHeader("SOAPAction", string10);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "prepareHttpRequestHeaders() SOAP Action : " + string10);
        }
        StringBuffer stringBuffer = null;
        if (this.addrToConnect.toString().contains("/IBM_WS_SYS_RESPONSESERVLET/") && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "prepareHttpRequestHeaders() epr has Async Servlet so trying to add basic auth info");
        }
        if (InvocationPatternHelper.isAsyncRespSeparateChannel(this.msgContext) || this.addrToConnect.toString().contains("/IBM_WS_SYS_RESPONSESERVLET/")) {
            string = this.hConfig.getOutAsyncRespUserID(this.msgContext);
            object2 = this.hConfig.getOutAsyncRespPassword(this.msgContext);
            if (string != null && object2 != null) {
                stringBuffer = new StringBuffer(string);
                stringBuffer.append(":").append((String)object2);
            }
        } else {
            string = this.hConfig.getOutRequestUserID(this.msgContext);
            object2 = this.hConfig.getOutRequestPassword(this.msgContext);
            if (string != null && object2 != null) {
                stringBuffer = new StringBuffer(string);
                stringBuffer.append(":").append((String)object2);
            }
        }
        if (stringBuffer != null && JavaUtils.hasValue(stringBuffer.toString())) {
            int n4 = stringBuffer.length();
            stringBuffer.replace(0, n4, Base64.encode(stringBuffer.toString().getBytes()));
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "basicAuthData : " + stringBuffer.toString());
            }
            httpRequestMessage.setHeader((HeaderKeys)HttpConstants.HDR_AUTHORIZATION, stringBuffer.insert(0, "Basic ").toString());
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "basicAuthData is NULL");
        }
        if (!this.is302or401) {
            MessageFormatter messageFormatter = TransportUtils.getMessageFormatter(this.msgContext);
            if (messageFormatter == null) {
                object2 = NLSProvider.getNLS().getFormattedMessage("xxxxxx", new Object[0], "Response could not be written to output stream because a message formatter could not be found.");
                throw new AxisFault((String)object2);
            }
            object2 = null;
            object2 = (String)this.msgContext.getProperty("message.character-set-encoding");
            if (object2 != null) {
                this.format.setCharSetEncoding((String)object2);
            }
            string3 = messageFormatter.getContentType(this.msgContext, this.format, this.soapActionString);
            this.format.setAutoCloseWriter(true);
            this.os = messageFormatter.getBytes(this.msgContext, this.format);
        }
        this.maintainSession = this.hConfig.maintainSessionEnabled(this.msgContext);
        if (this.maintainSession) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "prepareHttpRequestHeaders(): maintain session TRUE");
            }
            if (this.msgContext.getServiceContext() != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Setting javax.xml.ws.session.maintain to " + Boolean.TRUE);
                }
                this.msgContext.getServiceContext().setProperty("javax.xml.ws.session.maintain", Boolean.TRUE);
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ServiceContext is null. Not setting the session enabled");
            }
            Object object3 = this.msgContext.getProperty("Cookie");
            if (object3 != null) {
                Object object4;
                Serializable serializable;
                Externalizable externalizable;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Got cookie object : " + object3);
                }
                object2 = null;
                if (object3 instanceof String) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Cookie is of type String");
                    }
                    object2 = (String)object3;
                    externalizable = this.msgContext.getServiceContext();
                    if (externalizable != null) {
                        serializable = null;
                        object4 = ((AbstractContext)((Object)externalizable)).getProperty("Cookie");
                        if (object4 != null && object4 instanceof HTTPCookieManager) {
                            serializable = (HTTPCookieManager)object4;
                        }
                        try {
                            if (serializable == null) {
                                serializable = new HTTPCookieManager((String)object2, null);
                            } else {
                                ((HTTPCookieManager)serializable).setCookies((String)object2, null);
                            }
                        }
                        catch (Exception exception) {
                            throw AxisFault.makeFault(exception);
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "msgContext = " + this.msgContext.toString() + " SessionContext = " + serializable);
                        }
                        ((AbstractContext)((Object)externalizable)).setProperty("Cookie", serializable);
                    }
                } else if (object3 instanceof HTTPCookieManager) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Cookie is of type HTTPCookieManager");
                    }
                    externalizable = this.msgContext.getTo();
                    serializable = new URL(((EndpointReference)externalizable).getAddress());
                    object4 = serializable.getPath();
                    object = serializable.getHost();
                    int n5 = serializable.getPort();
                    boolean bl4 = false;
                    if (this.addrToConnect.getSchema() == 2) {
                        bl4 = true;
                    }
                    object2 = ((HTTPCookieManager)object3).getCookie((String)object4, (String)object, n5, bl4);
                }
                if (object2 != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "prepareHttpRequestHeaders(): Setting Cookie for maintain session = " + (String)object2);
                    }
                    httpRequestMessage.setHeader("Cookie", (String)object2);
                }
            }
        }
        if (((HttpChannelAddress)this.addrToConnect).isProxy() && this.addrToConnect.getSchema() == 1) {
            String string11 = this.tcp.getProxyUser();
            object2 = this.tcp.getProxyPassword();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "httpProxyConfiguration00 Proxy Host : " + this.tcp.getProxyHost() + " Proxy Port : " + this.tcp.getProxyPort() + " Proxy User : " + string11);
            }
            if (JavaUtils.hasValue(string11) && JavaUtils.hasValue((String)object2)) {
                stringBuffer = new StringBuffer(string11);
                stringBuffer.append(":").append((String)object2);
                int n6 = stringBuffer.length();
                stringBuffer.replace(0, n6, Base64.encode(stringBuffer.toString().getBytes()));
                httpRequestMessage.setHeader((HeaderKeys)HttpConstants.HDR_PROXY_AUTHORIZATION, stringBuffer.insert(0, "Basic ").toString());
            }
        }
        if (!(bl = this.hConfig.msgResendOnceEnabled(this.msgContext))) {
            this.httpOutSC.disallowRewrites();
        } else {
            this.httpOutSC.allowRewrites();
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HTTPConstants.HTTP_REQUEST_RESEND : " + bl);
        }
        bl = this.hConfig.persistConnEnabled(this.msgContext);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Persistent Connection : " + bl);
        }
        if (bl) {
            httpRequestMessage.setConnection(HttpConstants.CONN_KEEPALIVE);
        } else {
            httpRequestMessage.setConnection(HttpConstants.CONN_CLOSE);
        }
        object2 = this.msgContext.getReplyTo();
        string4 = null;
        Boolean bl5 = (Boolean)this.msgContext.getProperty("transportNonBlocking");
        if (object2 != null) {
            if (this.msgContext.getTo() != null && !this.msgContext.getTo().hasAnonymousAddress()) {
                if (bl5 != null && bl5.booleanValue()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "In Send Asynchronous Request flow...");
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "In Send Synchronous Request flow...");
                }
                if (AsyncEPRSet.isEPRinSet(((EndpointReference)object2).getAddress())) {
                    string4 = this.saveContextToMap(this.msgContext);
                }
            }
        } else {
            object2 = this.msgContext.getFaultTo();
            if (object2 != null) {
                if (this.msgContext.getTo() != null && !this.msgContext.getTo().hasAnonymousAddress()) {
                    if (bl5 != null && bl5.booleanValue()) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "In Send Asynchronous Fault flow...");
                        }
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "In Send Synchronous Fault flow...");
                    }
                    string4 = this.saveContextToMap(this.msgContext);
                }
            } else if (!this.msgContext.getAxisService().isClientSide()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "In Send Asynchronous Resoponse flow...");
                }
                httpRequestMessage.setConnection(HttpConstants.CONN_CLOSE);
            }
        }
        string4 = null;
        if (bl5 != null && bl5.booleanValue()) {
            if (this.msgContext.getReplyTo() == null) {
                string4 = this.hConfig.responseCompressEnabled(this.msgContext);
            }
        } else {
            string4 = this.hConfig.requestCompressEnabled(this.msgContext);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "com.ibm.websphere.webservices.http.requestContentEncoding = " + string4);
        }
        if (JavaUtils.hasValue(string4)) {
            if (this.httpOutSC.isGZipEncodingSupported() && string4.equalsIgnoreCase(WSHTTPConstants.HEADER_C_ENC_GZIP)) {
                this.httpOutSC.setGZipEncoded(true);
                if (this.httpOutSC.isGZipEncoded()) {
                    httpRequestMessage.setHeader((HeaderKeys)HttpConstants.HDR_ACCEPT_ENCODING, WSHTTPConstants.HEADER_C_ENC_GZIP);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "gzipCompressionEnabled : ", String.valueOf(this.httpOutSC.isGZipEncoded()));
                }
            } else if (this.httpOutSC.isXGZipEncodingSupported() && string4.equalsIgnoreCase(WSHTTPConstants.HEADER_C_ENC_XGZIP)) {
                this.httpOutSC.setXGZipEncoded(true);
                if (this.httpOutSC.isXGZipEncoded()) {
                    httpRequestMessage.setHeader((HeaderKeys)HttpConstants.HDR_ACCEPT_ENCODING, WSHTTPConstants.HEADER_C_ENC_XGZIP);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "xgzipCompressionEnabled : ", String.valueOf(this.httpOutSC.isGZipEncoded()));
                }
            } else if (this.httpOutSC.isZlibEncodingSupported() && string4.equalsIgnoreCase(WSHTTPConstants.HEADER_C_ENC_DEFLATE)) {
                this.httpOutSC.setZlibEncoded(true);
                if (this.httpOutSC.isZlibEncoded()) {
                    httpRequestMessage.setHeader((HeaderKeys)HttpConstants.HDR_ACCEPT_ENCODING, WSHTTPConstants.HEADER_C_ENC_DEFLATE);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "deflateCompressionEnabled : ", String.valueOf(this.httpOutSC.isZlibEncoded()));
                }
            }
        }
        if (!this.httpOutSC.isGZipEncoded() && !this.httpOutSC.isZlibEncoded() && !this.httpOutSC.isXGZipEncoded() && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "noCompression");
        }
        boolean bl6 = this.hConfig.chunkedEncodingEnabled(this.msgContext);
        boolean bl7 = this.hConfig.sendExpectHeaderEnabled(this.msgContext);
        object = (HashMap)this.msgContext.getProperty("com.ibm.websphere.webservices.requestTransportProperties");
        if (object != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "prepareHttpRequestHeaders(): REQUEST_TRANSPORT_PROPERTIES used = " + object);
            }
            for (Map.Entry entry : ((HashMap)object).entrySet()) {
                String string12 = ((String)entry.getKey()).trim();
                if (string12 == null || string12.length() <= 0) {
                    Tr.warning(_tc, "invalidTransHeadKey00");
                    continue;
                }
                String string13 = ((String)entry.getValue()).trim();
                if (string13 == null || string13.length() <= 0) {
                    Tr.warning(_tc, "invalidTransHeadValue00", string12);
                    continue;
                }
                string12.intern();
                if (string12 == HTTPConstants.HEADER_TRANSFER_ENCODING) {
                    if (!bl3 || !string13.equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) continue;
                    bl6 = true;
                    continue;
                }
                if (string12 == "Connection") {
                    if (bl3) {
                        if (string13.equals(HTTPConstants.HEADER_CONNECTION_CLOSE)) {
                            httpRequestMessage.setConnection(HttpConstants.CONN_CLOSE);
                            continue;
                        }
                        if (!string13.equals(HTTPConstants.HEADER_CONNECTION_KEEPALIVE)) continue;
                        httpRequestMessage.setConnection(HttpConstants.CONN_KEEPALIVE);
                        continue;
                    }
                    httpRequestMessage.setConnection(HttpConstants.CONN_CLOSE);
                    continue;
                }
                if (string12 == "Expect") {
                    Integer n7;
                    if (!bl3 || !string13.equalsIgnoreCase("100-continue") || (n7 = (Integer)this.msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE)) != null && n7 == 100) continue;
                    httpRequestMessage.setExpect(HttpConstants.EXPECT_100CONTINUE);
                    bl7 = true;
                    continue;
                }
                if (string12 == "Host") {
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "prepareHttpRequestHeaders(): Processing REQUEST_TRANSPORT_PROPERTIES.  Ignoring header " + string12);
                    continue;
                }
                if (string12 == "Content-Type") {
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "prepareHttpRequestHeaders(): Processing REQUEST_TRANSPORT_PROPERTIES.  Ignoring header " + string12);
                    continue;
                }
                if (string12 == "SOAPAction") {
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "prepareHttpRequestHeaders(): Processing REQUEST_TRANSPORT_PROPERTIES.  Ignoring header " + string12);
                    continue;
                }
                if (string12 == "Content-Length") {
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "prepareHttpRequestHeaders(): Processing REQUEST_TRANSPORT_PROPERTIES.  Ignoring header " + string12);
                    continue;
                }
                if (string12 == "Cookie") {
                    SOAPOverHTTPSender.addValueToOutboundHeader(string12, string13, httpRequestMessage);
                    continue;
                }
                if (string12 == "Cookie2") {
                    SOAPOverHTTPSender.addValueToOutboundHeader(string12, string13, httpRequestMessage);
                    continue;
                }
                if (string12 == "Authorization") {
                    SOAPOverHTTPSender.addValueToOutboundHeader(string12, string13, httpRequestMessage);
                    continue;
                }
                if (string12 == "Proxy-Authorization") {
                    SOAPOverHTTPSender.addValueToOutboundHeader(string12, string13, httpRequestMessage);
                    continue;
                }
                SOAPOverHTTPSender.addValueToOutboundHeader(string12, string13, httpRequestMessage);
            }
        }
        if (bl2) {
            if (string3 == null) {
                MessageFormatter messageFormatter = TransportUtils.getMessageFormatter(this.msgContext);
                if (messageFormatter == null) {
                    String string14 = NLSProvider.getNLS().getFormattedMessage("xxxxxx", new Object[0], "Response could not be written to output stream because a message formatter could not be found.");
                    throw new AxisFault(string14);
                }
                String string15 = null;
                string15 = (String)this.msgContext.getProperty("message.character-set-encoding");
                if (string15 != null) {
                    this.format.setCharSetEncoding(string15);
                }
                string3 = messageFormatter.getContentType(this.msgContext, this.format, this.soapActionString);
            }
            httpRequestMessage.setHeader("Content-Type", string3);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "HTTP Content-Type: " + string3);
            }
            if (bl6) {
                httpRequestMessage.setTransferEncoding(HttpConstants.TRANSFER_ENCODING_CHUNKED);
            }
        }
        WsByteBufferPoolManager wsByteBufferPoolManager = null;
        try {
            wsByteBufferPoolManager = WSChannelManager.getInstance().getWsByteBufferPoolManager();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.prepareHttpRequestHeaders", "2537", this);
            throw new AxisFault(exception);
        }
        WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[]{wsByteBufferPoolManager.allocateDirect(this.os.length)};
        wsByteBufferArray[0].put(this.os);
        wsByteBufferArray[0] = wsByteBufferArray[0].flip();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "prepareHttpRequestHeaders(): " + this);
        }
        return wsByteBufferArray;
    }

    public void processResponseHeader() {
        block29: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "processResponseHeader()");
            }
            try {
                Object object;
                Object object2;
                Object[] objectArray;
                String string;
                Object object32;
                String string2 = "iso-8859-1";
                byte[] byArray = null;
                StringBuffer stringBuffer = new StringBuffer();
                Vector vector = this.httpRspMsg.getHeaderByteArrayValues("Content-Type");
                if (vector != null) {
                    for (Object object32 : vector) {
                        stringBuffer.append(new String((byte[])object32, string2));
                    }
                }
                String string3 = stringBuffer.toString();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Content-Type : " + (String)string3);
                }
                object32 = null;
                if (string3 != null) {
                    string = new String(string3);
                    objectArray = new StringTokenizer(string, ";");
                    object2 = this.msgContext.getOperationContext();
                    if (object2 != null) {
                        object2.setProperty("ContentType", string3);
                    }
                    while (objectArray.hasMoreTokens()) {
                        object = objectArray.nextToken();
                        if (((String)object).equalsIgnoreCase("multipart/related") && object2 != null) {
                            object2.setProperty("MTOM_RECEIVED", string3);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "MTOM_RECEIVED : " + (String)string3);
                            }
                        }
                        if (!((String)object).contains(HTTPConstants.CHAR_SET_ENCODING)) continue;
                        StringTokenizer stringTokenizer = new StringTokenizer((String)object, "=");
                        String string4 = stringTokenizer.nextToken();
                        String string5 = stringTokenizer.nextToken();
                        if (string5 == null) continue;
                        object32 = HTTPClientUtils.getActualCharSet(string5);
                        if (object2 == null) continue;
                        object2.setProperty("CHARACTER_SET_ENCODING", object32);
                        if (!_tc.isDebugEnabled()) continue;
                        Tr.debug(_tc, "CHARACTER_SET_ENCODING : " + (String)object32);
                    }
                }
                byArray = this.httpRspMsg.getHeaderAsByteArray("Content-Location");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Content-Location: " + (byArray == null ? "" : new String(byArray, string2)));
                }
                byArray = this.httpRspMsg.getHeaderAsByteArray(HTTPConstants.HEADER_TRANSFER_ENCODING);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, HTTPConstants.HEADER_TRANSFER_ENCODING + ": " + (byArray == null ? "" : new String(byArray, string2)));
                }
                if (this.maintainSession) {
                    stringBuffer = new StringBuffer();
                    string = null;
                    vector = this.httpRspMsg.getHeaderByteArrayValues("Set-Cookie");
                    if (vector != null && !vector.isEmpty()) {
                        objectArray = vector.iterator();
                        while (objectArray.hasNext()) {
                            object2 = (byte[])objectArray.next();
                            if (objectArray.hasNext()) {
                                stringBuffer.append(new String((byte[])object2, string2)).append(WSHTTPConstants.HEADER_TOKEN_SEPARATOR);
                                continue;
                            }
                            stringBuffer.append(new String((byte[])object2, string2));
                        }
                        string = stringBuffer.toString();
                        if (_tc.isEventEnabled()) {
                            objectArray = new Object[]{"Set-Cookie", string};
                            Tr.event(_tc, "cookieReceived", objectArray);
                        }
                    }
                    objectArray = null;
                    stringBuffer = new StringBuffer();
                    vector = this.httpRspMsg.getHeaderByteArrayValues("Set-Cookie2");
                    if (vector != null && !vector.isEmpty()) {
                        object2 = vector.iterator();
                        while (object2.hasNext()) {
                            object = (byte[])object2.next();
                            if (object2.hasNext()) {
                                stringBuffer.append(new String((byte[])object, string2)).append(WSHTTPConstants.HEADER_TOKEN_SEPARATOR);
                                continue;
                            }
                            stringBuffer.append(new String((byte[])object, string2));
                        }
                        objectArray = stringBuffer.toString();
                        if (_tc.isEventEnabled()) {
                            object2 = new Object[]{"Set-Cookie", objectArray};
                            Tr.event(_tc, "cookieReceived : ", object2);
                        }
                    }
                    if (this.msgContext.getServiceContext() != null && (string != null || objectArray != null)) {
                        object2 = this.msgContext.getServiceContext();
                        object = null;
                        object = (HTTPCookieManager)object2.getProperty("Cookie");
                        if (object == null) {
                            object = new HTTPCookieManager(string, (String)objectArray);
                        } else {
                            ((HTTPCookieManager)object).setCookies(string, (String)objectArray);
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "receiveSOAPResponse(): msgContext = " + this.msgContext.toString() + " SessionContext = " + object);
                        }
                        object2.setProperty("Cookie", object);
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "ServiceContext is null. Not setting the cookies");
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.processResponseHeader", "2730", this);
                if (!_tc.isDebugEnabled()) break block29;
                Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(exception));
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "processResponseHeader()");
        }
    }

    private void processStatusCode(int n) throws Exception {
        String string;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "processStatusCode");
        }
        String string2 = string = null == (string = this.getHeaderFromResponse(HttpConstants.HDR_CONTENT_TYPE)) ? null : string.trim();
        if (n <= 199 || n >= 300) {
            if (string != null && !string.startsWith("text/html") && n > 399 && n < 600 && !this.msgContext.isSOAP11()) {
                if (InvocationPatternHelper.isOneWayInvocation(this.msgContext)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Encountered an error on one-way invocation");
                    }
                    String string3 = (String)this.msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                    AxisFault axisFault = new AxisFault("HTTP ( " + n + " ) " + string3 + " address : " + this.addrToConnect.toString());
                    throw axisFault;
                }
            } else if (string != null && !string.startsWith("text/html") && n > 499 && n < 600 && this.msgContext.isSOAP11()) {
                if (InvocationPatternHelper.isOneWayInvocation(this.msgContext)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Encountered an error on one-way invocation");
                    }
                    String string4 = (String)this.msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                    AxisFault axisFault = new AxisFault("HTTP ( " + n + " ) " + string4 + " address : " + this.addrToConnect.toString());
                    throw axisFault;
                }
            } else {
                if (n == 404) {
                    String string5 = (String)this.msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                    throw new ConnectException("HTTP ( " + n + " ) " + string5 + " address : " + this.addrToConnect.toString());
                }
                String string6 = (String)this.msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                AxisFault axisFault = new AxisFault("HTTP ( " + n + " ) " + string6 + " address : " + this.addrToConnect.toString());
                throw axisFault;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "processStatusCode");
        }
    }
}

