/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.transport.channel.AsyncInResponseConnLink;
import com.ibm.ws.websvcs.transport.http.HttpResponseImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.util.ArrayList;

public class HttpWriteCallback
implements InterChannelCallback {
    private static final TraceComponent _tc = Tr.register(HttpWriteCallback.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private AsyncInResponseConnLink link = null;
    private HttpInboundServiceContext httpInSC = null;
    private HttpResponseImpl response = null;
    private ArrayList writeQueue = new ArrayList();
    private boolean writing = false;
    private boolean doClose = false;

    public void init(AsyncInResponseConnLink asyncInResponseConnLink, HttpInboundServiceContext httpInboundServiceContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "init");
        }
        this.link = asyncInResponseConnLink;
        this.httpInSC = httpInboundServiceContext;
        this.response = this.link.getResponse();
        this.doClose = false;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "init");
        }
    }

    public int getBufferSize() {
        return this.link.getChannel().getBufferSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(VirtualConnection virtualConnection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "complete");
        }
        ArrayList arrayList = this.writeQueue;
        synchronized (arrayList) {
            WsByteBuffer[] wsByteBufferArray;
            if (!this.writeQueue.isEmpty()) {
                wsByteBufferArray = (WsByteBuffer[])this.writeQueue.remove(0);
                this.releaseByteBuffers(wsByteBufferArray);
            }
            if (this.writeQueue.isEmpty()) {
                this.writing = false;
                if (this.doClose) {
                    this.link.close(virtualConnection, null);
                }
            } else {
                wsByteBufferArray = (WsByteBuffer[])this.writeQueue.get(0);
                if (this.doClose && this.writeQueue.isEmpty()) {
                    this.finishBufferAsynch(wsByteBufferArray);
                } else {
                    this.writeBufferAsynch(wsByteBufferArray);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "complete");
        }
    }

    public void error(VirtualConnection virtualConnection, Throwable throwable) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "error");
        }
        Tr.error(_tc, "caughtException7", throwable);
        this.link.close(virtualConnection, null);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishResponse() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "finishResponse");
        }
        ArrayList arrayList = this.writeQueue;
        synchronized (arrayList) {
            this.doClose = true;
            if (this.writeQueue.isEmpty() && !this.response.hasContentBuffered()) {
                this.finishBufferAsynch(null);
            } else if (this.response.hasContentBuffered()) {
                this.response.flushBufferedContent();
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "finishResponse");
        }
    }

    private void releaseByteBuffers(WsByteBuffer[] wsByteBufferArray) {
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            wsByteBufferArray[i].release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBuffer(WsByteBuffer[] wsByteBufferArray) {
        if (wsByteBufferArray != null) {
            ArrayList arrayList = this.writeQueue;
            synchronized (arrayList) {
                if (this.writeQueue.isEmpty() && !this.writing) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Direct write");
                    }
                    this.writeQueue.add(wsByteBufferArray);
                    if (this.doClose) {
                        this.finishBufferAsynch(wsByteBufferArray);
                    } else {
                        this.writeBufferAsynch(wsByteBufferArray);
                    }
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Adding to queue");
                    }
                    this.writeQueue.add(wsByteBufferArray);
                }
            }
        }
    }

    private void writeBufferAsynch(WsByteBuffer[] wsByteBufferArray) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Write");
        }
        this.writing = true;
        try {
            VirtualConnection virtualConnection = this.httpInSC.sendResponseBody(wsByteBufferArray, this, false);
            if (virtualConnection != null) {
                this.complete(virtualConnection);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.HttpWriteCallback.writeBufferAsynch", "233", this);
            exception.printStackTrace();
        }
    }

    private void finishBufferAsynch(WsByteBuffer[] wsByteBufferArray) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Finish");
        }
        this.writing = true;
        try {
            VirtualConnection virtualConnection = null;
            virtualConnection = this.httpInSC.finishResponseMessage(wsByteBufferArray, this, false);
            if (virtualConnection != null) {
                this.complete(virtualConnection);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.HttpWriteCallback.finishBufferAsynch", "258", this);
            exception.printStackTrace();
        }
    }
}

