/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ws.webcontainer.srt.http.HttpDate;
import com.ibm.ws.webcontainer.util.ArrayEnumeration;
import com.ibm.ws.websvcs.transport.TransportRequest;
import com.ibm.ws.websvcs.transport.http.HttpByteBufferInputStream;
import com.ibm.ws.websvcs.transport.http.HttpResponseImpl;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.Cookie;

public class HttpRequestImpl
implements TransportRequest {
    private HttpInboundServiceContext isc = null;
    private HttpRequestMessage httpChannelrequest = null;
    private HttpResponseImpl response = null;
    private String serverName = null;
    private int serverPort = -1;
    private HttpByteBufferInputStream bbIS = null;

    public void init(HttpInboundServiceContext httpInboundServiceContext, ArrayList arrayList, HttpResponseImpl httpResponseImpl) {
        this.isc = httpInboundServiceContext;
        this.response = httpResponseImpl;
        this.httpChannelrequest = this.isc.getRequest();
        this.bbIS = new HttpByteBufferInputStream(arrayList);
    }

    public String getMethod() {
        return this.httpChannelrequest.getMethod();
    }

    public String getRequestURI() {
        return this.httpChannelrequest.getRequestURI();
    }

    public String getRequestPathInfo() {
        String string = this.httpChannelrequest.getRequestURI();
        String string2 = string.substring(string.indexOf("/", 1));
        return string2;
    }

    public String getRequestURLAsString() {
        return this.httpChannelrequest.getRequestURLAsString();
    }

    public String getRemoteUser() {
        return this.httpChannelrequest.getHeaderAsString(HttpConstants.HDR_$WSRU);
    }

    public String getAuthType() {
        return this.httpChannelrequest.getHeaderAsString(HttpConstants.HDR_$WSAT);
    }

    public String getHeader(String string) {
        return this.httpChannelrequest.getHeaderAsString(string);
    }

    public Enumeration getHeaders(String string) {
        Vector vector = this.httpChannelrequest.getHeaderStringValues(string);
        if (vector == null || vector.isEmpty()) {
            return new ArrayEnumeration(null);
        }
        return vector.elements();
    }

    public long getDateHeader(String string) {
        HttpDate httpDate = new HttpDate();
        String string2 = this.httpChannelrequest.getHeaderAsString(string);
        if (string2 == null) {
            return -1L;
        }
        httpDate.parse(string2);
        return httpDate.getTime();
    }

    public int getIntHeader(String string) {
        String string2 = this.httpChannelrequest.getHeaderAsString(string);
        if (string2 == null) {
            return -1;
        }
        return Integer.parseInt(string2);
    }

    public void clearHeaders() {
    }

    public Enumeration getHeaderNames() {
        return this.httpChannelrequest.getAllHeaders().elements();
    }

    public int getContentLength() {
        return this.httpChannelrequest.getContentLength();
    }

    public String getContentType() {
        return this.httpChannelrequest.getHeaderAsString(HttpConstants.HDR_CONTENT_TYPE);
    }

    public String getProtocol() {
        return this.httpChannelrequest.getVersion();
    }

    public String getServerName() {
        if (this.serverName == null) {
            this.serverName = this.httpChannelrequest.getVirtualHost();
            if (this.serverName == null) {
                this.serverName = new String("localhost");
            }
        }
        return this.serverName;
    }

    public int getServerPort() {
        if (this.serverPort == -1) {
            this.serverPort = this.httpChannelrequest.getVirtualPort();
            if (this.serverPort == -1) {
                this.serverPort = 80;
            }
        }
        return this.serverPort;
    }

    public String getRemoteHost() {
        return this.isc.getRemoteAddr().getCanonicalHostName();
    }

    public String getRemoteAddr() {
        return this.isc.getRemoteAddr().getHostAddress();
    }

    public int getRemotePort() {
        return this.isc.getRemotePort();
    }

    public String getScheme() {
        return this.httpChannelrequest.getScheme();
    }

    public InputStream getInputStream() throws IOException {
        return this.bbIS;
    }

    public String getLocalAddr() {
        return this.isc.getLocalAddr().getCanonicalHostName();
    }

    public String getLocalName() {
        return this.isc.getLocalAddr().getHostAddress();
    }

    public int getLocalPort() {
        return this.isc.getLocalPort();
    }

    public boolean isSSL() {
        return this.isc.isSecure();
    }

    public byte[] getSSLSessionID() {
        return null;
    }

    public String getSessionID() {
        return null;
    }

    public HttpResponseImpl getResponse() {
        return this.response;
    }

    public String getCipherSuite() {
        return null;
    }

    public Cookie[] getCookies() {
        List list = this.httpChannelrequest.getAllCookies();
        if (list == null || list.isEmpty()) {
            return null;
        }
        Cookie[] cookieArray = new Cookie[list.size()];
        Cookie[] cookieArray2 = list.toArray(cookieArray);
        return cookieArray;
    }
}

