/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.transport.channel.AsyncInResponseConnLink;
import com.ibm.ws.websvcs.transport.common.JavaUtils;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.exception.BodyCompleteException;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.util.ArrayList;

public class HttpReadCallback
implements InterChannelCallback {
    private static final TraceComponent _tc = Tr.register(HttpReadCallback.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private AsyncInResponseConnLink connlink = null;
    private HttpInboundServiceContext httpInSC = null;
    private VirtualConnection vc = null;
    private ArrayList bodyBuffers = null;
    private boolean haveAllBuffers = false;
    private int requestBytes;

    public void init(AsyncInResponseConnLink asyncInResponseConnLink, HttpInboundServiceContext httpInboundServiceContext, VirtualConnection virtualConnection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpReadCallback.init()...");
        }
        this.connlink = asyncInResponseConnLink;
        this.httpInSC = httpInboundServiceContext;
        this.vc = virtualConnection;
        this.bodyBuffers = new ArrayList();
        this.haveAllBuffers = false;
        this.requestBytes = 0;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpReadCallback.init().");
        }
    }

    public ArrayList getRequestBodyBuffers() {
        return this.bodyBuffers;
    }

    public void readRequest() {
        Object object;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpReadCallback.readRequest()...");
        }
        try {
            while (!this.haveAllBuffers) {
                VirtualConnection virtualConnection = null;
                try {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Calling async getRequestBodyBuffer...");
                    }
                    if ((virtualConnection = this.httpInSC.getRequestBodyBuffer(this, false)) == null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Callback will be used, bailing out now...");
                        }
                        return;
                    }
                }
                catch (BodyCompleteException bodyCompleteException) {
                    FFDCFilter.processException((Throwable)bodyCompleteException, "com.ibm.ws.websvcs.transport.http.HttpReadCallback.readRequest", "113", this);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Caught BodyCompleteException, we're done reading buffers...");
                    }
                    this.haveAllBuffers = true;
                    continue;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.HttpReadCallback.readRequest", "125", this);
                    this.haveAllBuffers = true;
                    String[] stringArray = new String[]{exception.toString()};
                    String string = JavaUtils.stackToString(exception);
                    Tr.error(_tc, "caughtException2", exception);
                    throw new RuntimeException(string, exception);
                }
                try {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Calling synchronous getRequestBodyBuffer...");
                    }
                    if ((object = this.httpInSC.getRequestBodyBuffer()) == null) {
                        this.haveAllBuffers = true;
                        if (!_tc.isDebugEnabled()) continue;
                        Tr.debug(_tc, "getRequestBodyBuffer() returned null, we're done!");
                        continue;
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Read in a buffer of length " + object.remaining() + " bytes.");
                    }
                    this.bodyBuffers.add(object);
                    this.requestBytes += object.remaining();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.HttpReadCallback.readRequest", "172", this);
                    String[] stringArray = new String[]{exception.toString()};
                    String string = JavaUtils.stackToString(exception);
                    Tr.error(_tc, "caughtException3", exception);
                    throw new RuntimeException(string, exception);
                }
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "We now have " + this.bodyBuffers.size() + " buffer(s) (" + this.requestBytes + " bytes) to process.");
            }
            this.connlink.requestReady(this.vc);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.websvcs.transport.http.HttpReadCallback.readRequest", "200", this);
            object = new String[]{throwable.toString()};
            String string = JavaUtils.stackToString(throwable);
            Tr.error(_tc, "caughtException", throwable);
            throw new RuntimeException(string, throwable);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "...HttpReadCallback.readRequest()");
            }
        }
    }

    public void complete(VirtualConnection virtualConnection) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpReadCallback.complete()...");
        }
        this.readRequest();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpReadCallback.complete().");
        }
    }

    public void error(VirtualConnection virtualConnection, Throwable throwable) {
        Tr.error(_tc, "caughtException7", throwable);
        this.connlink.close(virtualConnection, (Exception)throwable);
    }
}

