/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.websvcs.transport.common.ConfigFromJAX_WS;
import com.ibm.ws.websvcs.transport.common.JavaUtils;
import com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper;
import com.ibm.ws.websvcs.transport.policyset.jaxb.CustomProperty;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.Parameter;

public class HttpEffectiveConfig
extends ConfigFromJAX_WS {
    private static final TraceComponent _tc = Tr.register(HttpEffectiveConfig.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final int defaultConnTimeout = 60;
    private static final int defaultWriteTimeout = 300;
    private static final int defaultReadTimeout = 300;
    private Properties policy = null;
    protected static final String emptyString = "";

    public HttpEffectiveConfig(boolean bl, MessageContext messageContext) {
        super(bl);
        this.policy = this.extractEffectivePolicy(messageContext);
    }

    public boolean isPolicySetDefined() {
        return this.policy != null && !this.policy.isEmpty();
    }

    private Properties extractEffectivePolicy(MessageContext messageContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpEffectiveConfig.extractEffectivePolicy()... ");
        }
        Properties properties = null;
        try {
            Object object;
            Serializable serializable;
            Object object2;
            PolicySetConfiguration policySetConfiguration = null;
            AxisOperation axisOperation = messageContext.getAxisOperation();
            if (axisOperation != null && (policySetConfiguration = (PolicySetConfiguration)Axis2Utils.getPolicySet(axisOperation)) != null) {
                object2 = (Properties)policySetConfiguration.getPolicyTypeConfiguration("HTTP_POLICY");
                serializable = (Properties)policySetConfiguration.getPolicyTypeBinding("HTTP_BINDING");
                if (_tc.isDebugEnabled()) {
                    object = PolicyTypeFileHelper.maskPasswords((Properties)serializable);
                    Tr.debug(_tc, "HTTP Policy Type " + object2 + " HTTP Policy Binding " + (String)object + " found for operation " + axisOperation + "'.");
                }
                if (object2 != null && !((Properties)object2).isEmpty()) {
                    properties = new Properties();
                    properties.putAll((Map<?, ?>)object2);
                    if (serializable != null && !((Properties)serializable).isEmpty()) {
                        properties.putAll((Map<?, ?>)((Object)serializable));
                    }
                }
                object2 = (Properties)policySetConfiguration.getPolicyTypeConfiguration("SSL_POLICY");
                serializable = (Properties)policySetConfiguration.getPolicyTypeBinding("SSL_BINDING");
                if (_tc.isDebugEnabled()) {
                    object = PolicyTypeFileHelper.maskPasswords((Properties)serializable);
                    Tr.debug(_tc, "SSL Policy Type " + object2 + " SSL Policy Binding " + (String)object + " found for operation " + axisOperation + "'.");
                }
                if (object2 != null && !((Properties)object2).isEmpty()) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.putAll((Map<?, ?>)object2);
                    if (serializable != null && !((Properties)serializable).isEmpty()) {
                        properties.putAll((Map<?, ?>)((Object)serializable));
                    }
                }
            }
            if (properties == null && (object2 = messageContext.getAxisService()) != null && (serializable = ((AxisDescription)object2).getParameter("WASAxis2PolicySet")) != null && ((Parameter)serializable).getValue() != null && (policySetConfiguration = (PolicySetConfiguration)((Parameter)serializable).getValue()) != null) {
                String string;
                object = (Properties)policySetConfiguration.getPolicyTypeConfiguration("HTTP_POLICY");
                Properties properties2 = (Properties)policySetConfiguration.getPolicyTypeBinding("HTTP_BINDING");
                if (_tc.isDebugEnabled()) {
                    string = PolicyTypeFileHelper.maskPasswords(properties2);
                    Tr.debug(_tc, "HTTP Policy Type " + object + " HTTP Policy Binding " + string + " found for service " + object2 + "'.");
                }
                if (object != null && !((Properties)object).isEmpty()) {
                    properties = new Properties();
                    properties.putAll((Map<?, ?>)object);
                    if (properties2 != null && !properties2.isEmpty()) {
                        properties.putAll((Map<?, ?>)properties2);
                    }
                }
                object = (Properties)policySetConfiguration.getPolicyTypeConfiguration("SSL_POLICY");
                properties2 = (Properties)policySetConfiguration.getPolicyTypeBinding("SSL_BINDING");
                if (_tc.isDebugEnabled()) {
                    string = PolicyTypeFileHelper.maskPasswords(properties2);
                    Tr.debug(_tc, "SSL Policy Type " + object + " SSL Policy Binding " + string + " found for service " + object2 + "'.");
                }
                if (object != null && !((Properties)object).isEmpty()) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.putAll((Map<?, ?>)object);
                    if (properties2 != null && !properties2.isEmpty()) {
                        properties.putAll((Map<?, ?>)properties2);
                    }
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.HttpEffectiveConfig.extractEffectivePolicy", "210", this);
            Tr.error(_tc, JavaUtils.stackToString(exception));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpEffectiveConfig.extractEffectivePolicy()");
        }
        return properties;
    }

    public int getConnectionTimeout(MessageContext messageContext) {
        int n = 60;
        String string = null;
        if (this.isPolicySetDefined()) {
            string = this.policy.getProperty("connectTimeout");
        }
        try {
            if (!JavaUtils.hasValue(string)) {
                n = super.getConnectionTimeout(messageContext);
            } else {
                n = Integer.parseInt(string);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "...HttpEffectiveConfig.getConnectionTimeout() : " + n);
                }
            }
            if (n <= 0) {
                n = 60;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "...HttpEffectiveConfig.getConnectionTimeout() setting to default : " + n);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ws.websvcs.transport.http.HttpEffectiveConfig.getConnectionTimeout", "267", this);
            n = 60;
        }
        return n * 1000;
    }

    public int getWriteTimeout(MessageContext messageContext) {
        int n = 0;
        String string = null;
        if (this.isPolicySetDefined()) {
            string = this.policy.getProperty("writeTimeout");
        }
        try {
            if (!JavaUtils.hasValue(string)) {
                n = super.getWriteTimeout(messageContext);
            } else {
                n = Integer.parseInt(string);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "...HttpEffectiveConfig.getWriteTimeout() : " + n);
                }
            }
            if (n <= 0) {
                n = 300;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "...HttpEffectiveConfig.getWriteTimeout() setting to default : " + n);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ws.websvcs.transport.http.HttpEffectiveConfig.getWriteTimeout", "326", this);
            n = 300;
        }
        return n * 1000;
    }

    public int getReadTimeout(MessageContext messageContext) {
        int n = 0;
        String string = null;
        if (this.isPolicySetDefined()) {
            string = this.policy.getProperty("readTimeout");
        }
        try {
            if (!JavaUtils.hasValue(string)) {
                n = super.getReadTimeout(messageContext);
            } else {
                n = Integer.parseInt(string);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "...HttpEffectiveConfig.getReadTimeout() : " + n);
                }
            }
            if (n <= 0) {
                n = 300;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "...HttpEffectiveConfig.getReadTimeout() setting to default : " + n);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ws.websvcs.transport.http.HttpEffectiveConfig.getReadTimeout", "386", this);
            n = 300;
        }
        return n * 1000;
    }

    public String getProtocolVer(MessageContext messageContext) {
        String string = "HTTP/1.1";
        String string2 = null;
        if (this.isPolicySetDefined()) {
            string2 = this.policy.getProperty("protocolVersion");
        }
        if (!JavaUtils.hasValue(string2)) {
            string = super.getProtocolVer(messageContext);
        } else {
            string = string2;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "HttpEffectiveConfig.getProtocolVer() : " + string);
            }
        }
        if (!JavaUtils.hasValue(string)) {
            string = "HTTP/1.1";
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "HttpEffectiveConfig.getProtocolVer() setting to : " + string);
            }
        }
        return string;
    }

    public boolean maintainSessionEnabled(MessageContext messageContext) {
        boolean bl = false;
        String string = null;
        if (this.isPolicySetDefined()) {
            string = this.policy.getProperty("maintainSession");
        }
        if (!JavaUtils.hasValue(string)) {
            bl = super.maintainSessionEnabled(messageContext);
        } else if (string.equalsIgnoreCase("yes")) {
            bl = true;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "HttpEffectiveConfig.maintainSessionEnabled :  " + bl);
            }
        }
        return bl;
    }

    public boolean chunkedEncodingEnabled(MessageContext messageContext) {
        boolean bl = false;
        String string = null;
        if (this.isPolicySetDefined()) {
            string = this.policy.getProperty("chunkTransferEnc");
        }
        if (!JavaUtils.hasValue(string)) {
            bl = super.chunkedEncodingEnabled(messageContext);
        } else if (string.equalsIgnoreCase("yes")) {
            bl = true;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "...HttpEffectiveConfig.chunkedEncodingEnabled() : " + bl);
            }
        }
        return bl;
    }

    public boolean sendExpectHeaderEnabled(MessageContext messageContext) {
        boolean bl = false;
        String string = null;
        if (this.isPolicySetDefined()) {
            string = this.policy.getProperty("sendExpectHeader");
        }
        if (!JavaUtils.hasValue(string)) {
            bl = super.sendExpectHeaderEnabled(messageContext);
        } else if (string.equalsIgnoreCase("yes")) {
            bl = true;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "...HttpEffectiveConfig.sendExpectHeaderEnabled() : " + bl);
            }
        }
        return bl;
    }

    public boolean persistConnEnabled(MessageContext messageContext) {
        boolean bl = true;
        String string = null;
        if (this.isPolicySetDefined()) {
            string = this.policy.getProperty("persistConnection");
        }
        if (!JavaUtils.hasValue(string)) {
            bl = super.persistConnEnabled(messageContext);
        } else if (string.equalsIgnoreCase("no")) {
            bl = false;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "...HttpEffectiveConfig.persistConnEnabled() : " + bl);
            }
        }
        return bl;
    }

    public boolean msgResendOnceEnabled(MessageContext messageContext) {
        boolean bl = false;
        String string = null;
        if (this.isPolicySetDefined()) {
            string = this.policy.getProperty("messageResendOnce");
        }
        if (!JavaUtils.hasValue(string)) {
            bl = super.msgResendOnceEnabled(messageContext);
        } else if (string.equalsIgnoreCase("yes")) {
            bl = true;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "...HttpEffectiveConfig.msgResendOnceEnabled() : " + bl);
            }
        }
        return bl;
    }

    public String requestCompressEnabled(MessageContext messageContext) {
        String string = null;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("compressRequest:name");
        }
        if (!JavaUtils.hasValue(string)) {
            string = super.requestCompressEnabled(messageContext);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "...HttpEffectiveConfig.requestCompressEnabled() : " + string);
        }
        return string;
    }

    public String responseCompressEnabled(MessageContext messageContext) {
        String string = null;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("compressResponse:name");
        }
        if (!JavaUtils.hasValue(string)) {
            string = super.responseCompressEnabled(messageContext);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "...HttpEffectiveConfig.responseCompressEnabled() : " + string);
        }
        return string;
    }

    public String getOutRequestPassword(MessageContext messageContext) {
        String string = null;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("outRequestBasicAuth:password");
        }
        if (!JavaUtils.hasValue(string)) {
            string = super.getOutRequestPassword(messageContext);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutRequestPassword()... : " + (JavaUtils.hasValue(string) ? "******" : emptyString));
        }
        if (string == null) {
            string = emptyString;
        }
        return string;
    }

    public String getOutRequestUserID(MessageContext messageContext) {
        String string = null;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("outRequestBasicAuth:userid");
        }
        if (!JavaUtils.hasValue(string)) {
            string = super.getOutRequestUserID(messageContext);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutRequestUserID()... : " + string);
        }
        return string;
    }

    public String getOutAsyncRespPassword(MessageContext messageContext) {
        String string = null;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("outAsyncResponseBasicAuth:password");
        }
        if (!JavaUtils.hasValue(string)) {
            string = super.getOutAsyncRespPassword(messageContext);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutAsyncRespPassword()... : " + (JavaUtils.hasValue(string) ? "******" : emptyString));
        }
        if (string == null) {
            string = emptyString;
        }
        return string;
    }

    public String getOutAsyncRespUserID(MessageContext messageContext) {
        String string = null;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("outAsyncResponseBasicAuth:userid");
        }
        if (!JavaUtils.hasValue(string)) {
            string = super.getOutAsyncRespUserID(messageContext);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutAsyncRespUserID()... : " + string);
        }
        return string;
    }

    public String getOutRequestProxyPassword(MessageContext messageContext) {
        String string = null;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("outRequestProxy:password");
        }
        if (!JavaUtils.hasValue(string)) {
            string = super.getOutRequestProxyPassword(messageContext);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutRequestProxyPassword()... : " + (JavaUtils.hasValue(string) ? "******" : emptyString));
        }
        return string;
    }

    public String getOutRequestProxyUserID(MessageContext messageContext) {
        String string = null;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("outRequestProxy:userid");
        }
        if (!JavaUtils.hasValue(string)) {
            string = super.getOutRequestProxyUserID(messageContext);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutRequestProxyUserID()... " + string);
        }
        return string;
    }

    public String getOutAsyncRespProxyPassword(MessageContext messageContext) {
        String string = null;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("outAsyncResponseProxy:password");
        }
        if (!JavaUtils.hasValue(string)) {
            string = super.getOutAsyncRespProxyPassword(messageContext);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutAsyncRespProxyPassword()... : " + (JavaUtils.hasValue(string) ? "******" : emptyString));
        }
        return string;
    }

    public String getOutAsyncRespProxyUserID(MessageContext messageContext) {
        String string = null;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("outAsyncResponseProxy:userid");
        }
        if (!JavaUtils.hasValue(string)) {
            string = super.getOutAsyncRespProxyUserID(messageContext);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutAsyncRespProxyUserID()... : " + string);
        }
        return string;
    }

    public String getOutRequestProxyHost(MessageContext messageContext) {
        String string = null;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("outRequestProxy:host");
        }
        if (!JavaUtils.hasValue(string)) {
            string = super.getOutRequestProxyHost(messageContext);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutRequestProxyHost()... : " + string);
        }
        return string;
    }

    public String getOutRequestProxyPort(MessageContext messageContext) {
        String string = null;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("outRequestProxy:port");
        }
        if (!JavaUtils.hasValue(string)) {
            string = super.getOutRequestProxyPort(messageContext);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutRequestProxyPort()... : " + string);
        }
        return string;
    }

    public String getOutAsyncRespProxyHost(MessageContext messageContext) {
        String string = null;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("outAsyncResponseProxy:host");
        }
        if (!JavaUtils.hasValue(string)) {
            string = super.getOutAsyncRespProxyHost(messageContext);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutAsyncRespProxyHost()... : " + string);
        }
        return string;
    }

    public String getOutAsyncRespProxyPort(MessageContext messageContext) {
        String string = null;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("outAsyncResponseProxy:port");
        }
        if (!JavaUtils.hasValue(string)) {
            string = super.getOutAsyncRespProxyPort(messageContext);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutAsyncRespProxyPort()... : " + string);
        }
        return string;
    }

    public boolean redirectURLEnabled(MessageContext messageContext) {
        boolean bl = false;
        String string = null;
        if (this.isPolicySetDefined()) {
            string = this.policy.getProperty("acceptRedirectedURL");
        }
        if (!JavaUtils.hasValue(string)) {
            bl = super.redirectURLEnabled(messageContext);
        } else if (string.equalsIgnoreCase("yes")) {
            bl = true;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "...HttpEffectiveConfig.redirectURLEnabled() : " + bl);
            }
        }
        return bl;
    }

    public boolean getOutReqSSLEnabled(MessageContext messageContext) {
        String string = null;
        boolean bl = false;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("outRequestSSLenabled");
        }
        if (JavaUtils.hasValue(string) && string.equalsIgnoreCase("yes")) {
            bl = true;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutReqSSLEnabled()... : " + bl);
        }
        return bl;
    }

    public String getOutReqSSLAlias(MessageContext messageContext) {
        String string = null;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("outRequestwithSSL:configAlias");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutReqSSLAlias()... : " + string);
        }
        return string;
    }

    public String getOutReqSSLFile(MessageContext messageContext) {
        String string = null;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("outRequestwithSSL:configFile");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutReqSSLFile()... : " + string);
        }
        return string;
    }

    public boolean getOutAsyncResponseSSLEnabled(MessageContext messageContext) {
        String string = null;
        boolean bl = false;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("outAsyncResponseSSLenabled");
        }
        if (JavaUtils.hasValue(string) && string.equalsIgnoreCase("yes")) {
            bl = true;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutAsyncResponseSSLEnabled()... : " + bl);
        }
        return bl;
    }

    public String getOutAsyncResponseSSLAlias(MessageContext messageContext) {
        String string = null;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("outAsyncResponsewithSSL:configAlias");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutAsyncResponseSSLAlias()... : " + string);
        }
        return string;
    }

    public String getOutAsyncResponseSSLFile(MessageContext messageContext) {
        String string = null;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("outAsyncResponsewithSSL:configFile");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutAsyncResponseSSLFile()... : " + string);
        }
        return string;
    }

    public boolean getInAsyncResponseSSLEnabled(MessageContext messageContext) {
        String string = null;
        boolean bl = false;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("inResponseSSLenabled");
        }
        if (JavaUtils.hasValue(string) && string.equalsIgnoreCase("yes")) {
            bl = true;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getInAsyncResponseSSLEnabled()... : " + bl);
        }
        return bl;
    }

    public String getInAsyncResponseSSLAlias(MessageContext messageContext) {
        String string = null;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("inResponsewithSSL:configAlias");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.inResponseSSLAlias()... : " + string);
        }
        return string;
    }

    public String getInAsyncResponseSSLFile(MessageContext messageContext) {
        String string = null;
        if (this.isPolicySetDefined()) {
            string = (String)this.policy.get("inResponsewithSSL:configFile");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.inResponseSSLFile()... : " + string);
        }
        return string;
    }

    public String getCustomProperty(MessageContext messageContext, String string) {
        com.ibm.ws.websvcs.transport.policyset.jaxb.Properties properties;
        String string2 = null;
        if (this.isPolicySetDefined() && (properties = (com.ibm.ws.websvcs.transport.policyset.jaxb.Properties)this.policy.get("properties")) != null) {
            List<CustomProperty> list = properties.getCustomProperty();
            for (CustomProperty customProperty : list) {
                if (!string.equals(customProperty.getName())) continue;
                string2 = customProperty.getValue();
                break;
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "...HttpEffectiveConfig.getCustomProperty() : " + string2);
        }
        return string2;
    }
}

