/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.TransportClientProperties;
import com.ibm.ws.websvcs.transport.channel.WSAddress;
import com.ibm.ws.websvcs.transport.common.JavaUtils;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.axis2.AxisFault;

public class HttpChannelAddress
extends WSAddress {
    private static final TraceComponent _tc = Tr.register(HttpChannelAddress.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private InetSocketAddress isAddr = null;
    private String targetEndpoint = null;
    private String endpointHost = null;
    private int endpointPort = -1;
    private String targetURIPath = null;
    private String targetHost = null;
    private int targetPort = -1;
    private TransportClientProperties _tcp = null;
    private boolean forProxy = false;
    private URI _uri = null;
    private static final String PROXY_AUTH_INFO = "PROXY_TARGET_USER_PASS";
    private static final String PROXY_HOST_INFO = "PROXY_TARGET_HOST_PORT";
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final String DEFAULT_HTTPS_PORT_STRING = "443";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final String DEFAULT_HTTP_PORT_STRING = "80";
    public static final String HTTPCHAN_MATCH_LOG_PROP = "com.ibm.ws.webservices.match.log";

    public HttpChannelAddress(URL uRL) throws URISyntaxException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpChannelAddress url " + uRL.toString());
        }
        if (uRL != null) {
            this.targetEndpoint = uRL.toString();
            this.endpointHost = uRL.getHost();
            this.endpointPort = uRL.getPort();
            URI uRI = new URI(this.targetEndpoint);
            this.targetURIPath = uRI.getPath();
            this.targetHost = uRL.getHost();
            this.targetPort = uRL.getPort();
            if (uRL.getProtocol().compareToIgnoreCase("https") == 0) {
                this.schemaType = 2;
                if (this.targetPort == -1) {
                    this.targetPort = 443;
                }
            } else if (uRL.getProtocol().compareToIgnoreCase("http") == 0) {
                this.schemaType = 1;
                if (this.targetPort == -1) {
                    this.targetPort = 80;
                }
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "connHost " + this.targetHost + " connPort " + this.targetPort);
            }
            this.isAddr = new InetSocketAddress(this.targetHost, this.targetPort);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "HttpChannelAddress url " + uRL.toString());
            }
        }
    }

    public HttpChannelAddress(URL uRL, TransportClientProperties transportClientProperties) throws URISyntaxException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpChannelAddress url " + uRL.toString());
        }
        if (uRL != null && transportClientProperties != null) {
            this.targetEndpoint = uRL.toString();
            this.endpointHost = uRL.getHost();
            this.endpointPort = uRL.getPort();
            this.targetHost = transportClientProperties.getProxyHost();
            this.targetPort = Integer.valueOf(transportClientProperties.getProxyPort());
            if (uRL.getProtocol().compareToIgnoreCase("https") == 0) {
                this.schemaType = 2;
                if (this.targetPort == -1) {
                    this.targetPort = 443;
                }
            } else if (uRL.getProtocol().compareToIgnoreCase("http") == 0) {
                this.schemaType = 1;
                if (this.targetPort == -1) {
                    this.targetPort = 80;
                }
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Proxy connHost " + this.targetHost + " Proxy connPort " + this.targetPort);
            }
            this.isAddr = new InetSocketAddress(this.targetHost, this.targetPort);
            URI uRI = new URI(this.getSchemaInString() + "://" + this.targetHost + ":" + this.targetPort);
            this.targetURIPath = uRI.getPath();
            this._tcp = transportClientProperties;
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "HttpChannelAddress url " + uRL.toString());
            }
        }
        this.forProxy = true;
    }

    public String getOutboundChainName() {
        if (this.getSchema() == 1) {
            return "HttpOutboundChain";
        }
        return "HttpsOutboundChain";
    }

    public HashMap infoForTunneling() throws MalformedURLException {
        HashMap<String, byte[]> hashMap = null;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "infoForTunneling ");
        }
        if (this.forProxy && this._tcp != null) {
            String string = this._tcp.getProxyUser();
            String string2 = this._tcp.getProxyPassword();
            URL uRL = new URL(this.targetEndpoint);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "targetEndpoint " + this.targetEndpoint);
            }
            String string3 = uRL.getHost();
            String string4 = String.valueOf(uRL.getPort());
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "connHost " + string3 + " connPort " + string4);
            }
            if (JavaUtils.hasValue(string3) && JavaUtils.hasValue(string4)) {
                hashMap = new HashMap<String, byte[]>();
                if (Integer.valueOf(string4) == -1 && this.schemaType == 1) {
                    string4 = DEFAULT_HTTP_PORT_STRING;
                }
                if (Integer.valueOf(string4) == -1 && this.schemaType == 2) {
                    string4 = DEFAULT_HTTPS_PORT_STRING;
                }
                hashMap.put(PROXY_HOST_INFO, (string3 + ":" + string4).getBytes());
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "hM " + hashMap);
                }
                if (JavaUtils.hasValue(string) && JavaUtils.hasValue(string2)) {
                    hashMap.put(PROXY_AUTH_INFO, XMLUtils.base64encode((string + ":" + string2).getBytes()).getBytes());
                }
            }
            if (_tc.isDebugEnabled()) {
                String string5 = null;
                string5 = this.schemaType == 1 ? "HTTP" : "HTTPS";
                String string6 = "Configured " + string5 + " proxy information. " + string5 + " Proxy Hostname: " + this.targetHost + " Proxy Port: " + String.valueOf(this.targetPort) + " Proxy Username: " + string + " Proxy Password: " + (JavaUtils.hasValue(string2) ? "******" : "");
                Tr.debug(_tc, string6);
                Tr.debug(_tc, "Target endpoint host: " + string3 + ", Target endpoint port: " + string4);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "infoForTunneling ");
        }
        return hashMap;
    }

    public boolean isForwardProxy() {
        return this.forProxy;
    }

    public boolean isProxy() {
        return this.forProxy;
    }

    public String keyValueforPool() {
        if (this.keyforPool == null) {
            if (this.getSchema() == 2) {
                if (!this.isProxy()) {
                    this.keyforPool = this.getOutboundChainName() + ":" + this.getHostname() + ":" + this.getPort() + ":" + this.cfg.hashCode();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "keyValueforPool.keyforPool (!this.isProxy()): " + this.keyforPool);
                    }
                } else {
                    this.keyforPool = this.getOutboundChainName() + ":" + this.getHostname() + ":" + this.getPort() + ":" + this.cfg.hashCode() + ":" + this.endpointHost + ":" + this.endpointPort;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "keyValueforPool.keyforPool (this.isProxy()): " + this.keyforPool);
                    }
                }
            } else {
                this.keyforPool = this.getOutboundChainName() + ":" + this.getHostname() + ":" + this.getPort();
            }
            if (this.isInProcess()) {
                this.keyforPool = "LOCAL:" + this.keyforPool;
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "keyValueforPool.keyforPool (final): " + this.keyforPool);
        }
        return this.keyforPool;
    }

    public InetSocketAddress getLocalAddress() {
        return null;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.isAddr;
    }

    public String getHostname() {
        return this.targetHost;
    }

    public URI getURI() throws URISyntaxException {
        if (this._uri == null && JavaUtils.hasValue(this.targetEndpoint)) {
            this._uri = new URI(this.targetEndpoint);
        }
        return this._uri;
    }

    public String getURIPath() throws URISyntaxException {
        if (this.targetURIPath == null && this.getURI() != null) {
            this.targetURIPath = this.getURI().getPath();
        }
        return this.targetURIPath;
    }

    public int getPort() {
        return this.targetPort;
    }

    public String toString() {
        if (this.forProxy) {
            return this.getSchemaInString() + "://" + this.getHostname() + ":" + String.valueOf(this.getPort());
        }
        return this.targetEndpoint;
    }

    public boolean equals(Object object) {
        HttpChannelAddress httpChannelAddress = (HttpChannelAddress)object;
        if (!this.targetHost.equals(httpChannelAddress.getHostname())) {
            return false;
        }
        if (this.targetPort != httpChannelAddress.getPort()) {
            return false;
        }
        try {
            if (!this.targetURIPath.equals(httpChannelAddress.getURIPath())) {
                return false;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            FFDCFilter.processException((Throwable)uRISyntaxException, "com.ibm.ws.websvcs.transport.http.HttpChannelAddress.equals", "530", this);
            return false;
        }
        return this.targetEndpoint.equals(httpChannelAddress.getTargetEndPoint());
    }

    public String getTargetEndPoint() {
        return this.targetEndpoint;
    }

    public void updateTargetURL(String string) {
        this.targetEndpoint = string;
    }

    public void setConnectTimeout(int n) {
        this.connTimeout = n;
    }

    public static WSAddress getProxyAddress(URL uRL, TransportClientProperties transportClientProperties) throws MalformedURLException, URISyntaxException, AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpChannelAddress::getProxyAddress(" + uRL + ", " + transportClientProperties);
        }
        HttpChannelAddress httpChannelAddress = null;
        if (HttpChannelAddress.hostIsInNonProxyList(uRL.getHost(), transportClientProperties.getNonProxyHosts())) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, uRL.getHost() + " is in the non proxy hosts list");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "HttpChannelAddress::getProxyAddress: " + httpChannelAddress);
            }
            return httpChannelAddress;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, uRL.getHost() + " is NOT in the non proxy hosts list");
        }
        if (uRL.getProtocol().equalsIgnoreCase("https")) {
            if (JavaUtils.hasValue(transportClientProperties.getProxyHost()) && JavaUtils.hasValue(transportClientProperties.getProxyPort())) {
                httpChannelAddress = new HttpChannelAddress(uRL, transportClientProperties);
            }
        } else if (uRL.getProtocol().equalsIgnoreCase("http")) {
            if (JavaUtils.hasValue(transportClientProperties.getProxyHost()) && JavaUtils.hasValue(transportClientProperties.getProxyPort())) {
                httpChannelAddress = new HttpChannelAddress(uRL, transportClientProperties);
            }
        } else {
            Object[] objectArray = new Object[]{uRL.getProtocol()};
            String string = NLSProvider.getNLS().getFormattedMessage("httpUnsupportedSchema", objectArray, "The following schema for HTTP is not supported: {0}");
            throw new AxisFault(string);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HttpChannelAddress::getProxyAddress: " + httpChannelAddress);
        }
        return httpChannelAddress;
    }

    private static boolean hostIsInNonProxyList(String string, String string2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpChannelAddress::hostIsInNonProxyList: " + string + " " + string2);
        }
        if (string2 == null || string == null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "HttpChannelAddress::hostIsInNonProxyList: false");
            }
            return false;
        }
        boolean bl = false;
        if (_tc.isDebugEnabled()) {
            String string3 = System.getProperty(HTTPCHAN_MATCH_LOG_PROP);
            if ("true".equals(string3)) {
                bl = true;
            } else {
                Tr.debug(_tc, "To trace the flow of the HttpChannelAddress.match() method, set the com.ibm.ws.webservices.match.log=true JVM System property.");
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|\"");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (!HttpChannelAddress.match(string4, string, false, bl)) continue;
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "HttpChannelAddress::hostIsInNonProxyList: match: host: " + string + ", pattern: " + string4);
            }
            return true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HttpChannelAddress::hostIsInNonProxyList: Host not in nonProxyHosts list");
        }
        return false;
    }

    private static boolean match(String string, String string2, boolean bl, boolean bl2) {
        char c;
        int n;
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n2 = 0;
        int n3 = cArray.length - 1;
        int n4 = 0;
        int n5 = cArray2.length - 1;
        boolean bl3 = false;
        if (bl2 && _tc.isEntryEnabled()) {
            Tr.entry(_tc, "match: pattern=" + string + " str=" + string2 + " isCaseSensitive=" + bl);
        }
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] != '*') continue;
            bl3 = true;
            break;
        }
        if (!bl3) {
            if (n3 != n5) {
                if (bl2 && _tc.isEntryEnabled()) {
                    Tr.exit(_tc, "match: Returning false. Pattern and string are not the same size");
                }
                return false;
            }
            for (n = 0; n <= n3; ++n) {
                char c2 = cArray[n];
                if (bl && c2 != cArray2[n]) {
                    if (bl2 && _tc.isEntryEnabled()) {
                        Tr.exit(_tc, "match: Returning false. Case sensitive character mismatch");
                    }
                    return false;
                }
                if (bl || Character.toUpperCase(c2) == Character.toUpperCase(cArray2[n])) continue;
                if (bl2 && _tc.isEntryEnabled()) {
                    Tr.exit(_tc, "match: Returning false. Case insensitive character mismatch");
                }
                return false;
            }
            if (bl2 && _tc.isEntryEnabled()) {
                Tr.exit(_tc, "match: Returning true.  Pattern matches.");
            }
            return true;
        }
        if (n3 == 0) {
            if (bl2 && _tc.isEntryEnabled()) {
                Tr.exit(_tc, "match: Returning true.  Pattern contains only star.");
            }
            return true;
        }
        if (bl2 && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "match: Processing chars before first star");
        }
        while ((c = cArray[n2]) != '*' && n4 <= n5) {
            if (bl && c != cArray2[n4]) {
                if (bl2 && _tc.isEntryEnabled()) {
                    Tr.exit(_tc, "match: Returning false. Case sensitive character mismatch with chars before first star.");
                }
                return false;
            }
            if (!bl && Character.toUpperCase(c) != Character.toUpperCase(cArray2[n4])) {
                if (bl2 && _tc.isEntryEnabled()) {
                    Tr.exit(_tc, "match: Returning false. Case insensitive character mismatch with chars before first star.");
                }
                return false;
            }
            ++n2;
            ++n4;
        }
        if (n4 > n5) {
            for (n = n2; n <= n3; ++n) {
                if (cArray[n] == '*') continue;
                if (bl2 && _tc.isEntryEnabled()) {
                    Tr.exit(_tc, "match: Returning false. All characters in the string are used, non-stars left in pattern (1).");
                }
                return false;
            }
            if (bl2 && _tc.isEntryEnabled()) {
                Tr.exit(_tc, "match: Returning true. All characters in the string are used, only-stars left in pattern (1).");
            }
            return true;
        }
        if (bl2 && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "match: Processing chars after last star");
        }
        while ((c = cArray[n3]) != '*' && n4 <= n5) {
            if (bl && c != cArray2[n5]) {
                if (bl2 && _tc.isEntryEnabled()) {
                    Tr.exit(_tc, "match: Returning false. Case sensitive character mismatch with chars after last star.");
                }
                return false;
            }
            if (!bl && Character.toUpperCase(c) != Character.toUpperCase(cArray2[n5])) {
                if (bl2 && _tc.isEntryEnabled()) {
                    Tr.exit(_tc, "match: Returning false. Case insensitive character mismatch with chars after last star.");
                }
                return false;
            }
            --n3;
            --n5;
        }
        if (n4 > n5) {
            for (n = n2; n <= n3; ++n) {
                if (cArray[n] == '*') continue;
                if (bl2 && _tc.isEntryEnabled()) {
                    Tr.exit(_tc, "match: Returning false. All characters in the string are used, non-stars left in pattern (2).");
                }
                return false;
            }
            if (bl2 && _tc.isEntryEnabled()) {
                Tr.exit(_tc, "match: Returning true. All characters in the string are used, only-stars left in pattern (2).");
            }
            return true;
        }
        if (bl2 && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "match: Processing between stars");
        }
        while (n2 != n3 && n4 <= n5) {
            int n6;
            n = -1;
            for (n6 = n2 + 1; n6 <= n3; ++n6) {
                if (cArray[n6] != '*') continue;
                n = n6;
                break;
            }
            if (n == n2 + 1) {
                ++n2;
                continue;
            }
            n6 = n - n2 - 1;
            int n7 = n5 - n4 + 1;
            int n8 = -1;
            block8: for (int i = 0; i <= n7 - n6; ++i) {
                for (int j = 0; j < n6; ++j) {
                    c = cArray[n2 + j + 1];
                    if (bl && c != cArray2[n4 + i + j] || !bl && Character.toUpperCase(c) != Character.toUpperCase(cArray2[n4 + i + j])) continue block8;
                }
                n8 = n4 + i;
                break;
            }
            if (n8 == -1) {
                if (bl2 && _tc.isEntryEnabled()) {
                    Tr.exit(_tc, "match: Returning false");
                }
                return false;
            }
            n2 = n;
            n4 = n8 + n6;
        }
        for (n = n2; n <= n3; ++n) {
            if (cArray[n] == '*') continue;
            if (bl2 && _tc.isEntryEnabled()) {
                Tr.exit(_tc, "match: Returning false. All characters in the string are used, non-stars left in pattern (3).");
            }
            return false;
        }
        if (bl2 && _tc.isEntryEnabled()) {
            Tr.exit(_tc, "match: Returning true. All characters in the string are used, only-stars left in pattern (3).");
        }
        return true;
    }
}

