/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.websvcs.transport.http.HttpWriteCallback;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.io.IOException;
import java.io.OutputStream;

public class HttpByteBufferOutputStream
extends OutputStream {
    private static final TraceComponent _tc = Tr.register(HttpByteBufferOutputStream.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private HttpInboundServiceContext httpInSC;
    private HttpWriteCallback writeCB;
    private boolean flushToWire;
    private WsByteBuffer[] bufferToWrite;
    private int totalBuffered;

    public HttpByteBufferOutputStream(HttpInboundServiceContext httpInboundServiceContext, HttpWriteCallback httpWriteCallback) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpByteBufferOutputStream ctor...");
        }
        this.httpInSC = httpInboundServiceContext;
        this.writeCB = httpWriteCallback;
        this.flushToWire = true;
        this.bufferToWrite = null;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpByteBufferOutputStream ctor");
        }
    }

    public void write(int n) throws IOException {
        WsByteBuffer wsByteBuffer = WsByteBufferPoolManagerImpl.getRef().allocateDirect(1);
        wsByteBuffer.put((byte)n);
        wsByteBuffer.flip();
        this.addBufferToWriteBuffer(wsByteBuffer);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        WsByteBuffer wsByteBuffer = WsByteBufferPoolManagerImpl.getRef().allocateDirect(n2);
        wsByteBuffer.put(byArray, n, n2);
        wsByteBuffer.flip();
        this.addBufferToWriteBuffer(wsByteBuffer);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public final void print(char[] cArray, int n, int n2) throws IOException {
        WsByteBuffer wsByteBuffer = WsByteBufferPoolManagerImpl.getRef().allocateDirect(n2);
        wsByteBuffer.putChar(cArray, n, n2);
        wsByteBuffer.flip();
        this.addBufferToWriteBuffer(wsByteBuffer);
    }

    public final void print(char c) throws IOException {
        this.write(c);
    }

    public final void print(char[] cArray) throws IOException {
        this.print(cArray, 0, cArray.length);
    }

    public final void print(String string) throws IOException {
        this.print(string, 0, string.length());
    }

    public final void print(String string, int n, int n2) throws IOException {
        byte[] byArray = string.getBytes();
        this.write(byArray, n, n2);
    }

    public final void print(boolean bl) throws IOException {
        this.print(String.valueOf(bl));
    }

    public final void print(int n) throws IOException {
        String string = Integer.toString(n);
        this.print(string);
    }

    public final void print(long l) throws IOException {
        String string = Long.toString(l);
        this.print(string);
    }

    public final void print(float f) throws IOException {
        String string = Float.toString(f);
        this.print(string);
    }

    public final void print(double d) throws IOException {
        this.print(String.valueOf(d));
    }

    public final void print(Object object) throws IOException {
        this.print(object.toString());
    }

    public void setFlushMode(boolean bl) {
        this.flushToWire = bl;
    }

    public void flush() {
        this.flushWriteBuffer();
    }

    public void flushWriteBuffer() {
        if (this.hasContentBuffered()) {
            this.writeCB.writeBuffer(this.bufferToWrite);
            this.resetBuffer();
        }
    }

    public boolean hasContentBuffered() {
        return this.bufferToWrite != null;
    }

    private void addBufferToWriteBuffer(WsByteBuffer wsByteBuffer) {
        this.totalBuffered += wsByteBuffer.remaining();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Adding buffer to write --> " + wsByteBuffer.remaining() + " buffered --> " + this.totalBuffered);
        }
        if (this.bufferToWrite == null) {
            this.bufferToWrite = new WsByteBuffer[1];
            this.bufferToWrite[0] = wsByteBuffer;
        } else {
            WsByteBuffer[] wsByteBufferArray = this.bufferToWrite;
            this.bufferToWrite = new WsByteBuffer[wsByteBufferArray.length + 1];
            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                this.bufferToWrite[i] = wsByteBufferArray[i];
            }
            this.bufferToWrite[wsByteBufferArray.length] = wsByteBuffer;
        }
        if (this.flushToWire) {
            this.writeCB.writeBuffer(this.bufferToWrite);
            this.resetBuffer();
        }
        if (this.totalBuffered > this.writeCB.getBufferSize()) {
            this.writeCB.writeBuffer(this.bufferToWrite);
            this.resetBuffer();
        }
    }

    private void resetBuffer() {
        this.bufferToWrite = null;
        this.totalBuffered = 0;
    }
}

