/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.trace.MessageTrace;
import com.ibm.ws.websvcs.transport.AsyncResponseContext;
import com.ibm.ws.websvcs.transport.TransportRequest;
import com.ibm.ws.websvcs.transport.TransportResponse;
import com.ibm.wsspi.http.channel.HttpConstants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.util.UUIDGenerator;

public class HttpAsyncResponseContext
extends AsyncResponseContext {
    private static final TraceComponent _tc = Tr.register(HttpAsyncResponseContext.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public HttpAsyncResponseContext(AxisService axisService, ConfigurationContext configurationContext, String string) {
        this.axisService = axisService;
        this.confContext = configurationContext;
        this.hashKey = string;
    }

    public void handleRequest(TransportRequest transportRequest, TransportResponse transportResponse) throws Exception {
        byte[] byArray;
        InputStream inputStream;
        String string;
        String string2;
        MessageContext messageContext;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpAsyncResponseContext.handleRequest()...");
        }
        Object var3_3 = null;
        if (this.confContext != null) {
            boolean bl = false;
            messageContext = new MessageContext();
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Setting up message context...");
            }
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Setting incoming transport...");
            }
            messageContext.setIncomingTransportName("http");
            TransportOutDescription transportOutDescription = this.confContext.getAxisConfiguration().getTransportOut(new QName("http"));
            TransportInDescription transportInDescription = this.confContext.getAxisConfiguration().getTransportIn(new QName("http"));
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Adding configuration context...");
            }
            messageContext.setConfigurationContext(this.confContext);
            messageContext.setTransportIn(transportInDescription);
            messageContext.setTransportOut(transportOutDescription);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Setting service group context id...");
            }
            messageContext.setServiceGroupContextId(UUIDGenerator.getUUID());
            messageContext.setServerSide(true);
            messageContext.setProperty("TransportInURL", transportRequest.getRequestURLAsString());
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Setting up HTTP header hashMap...");
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Enumeration enumeration = transportRequest.getHeaderNames();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                hashMap.put(string2, transportRequest.getHeader(string2));
            }
            messageContext.setProperty("TRANSPORT_HEADERS", hashMap);
            messageContext.setProperty("TRANSPORT_OUT", transportResponse.getOutputStream());
            messageContext.setProperty("OutTransportInfo", transportResponse.getOutputStream());
            string2 = transportRequest.getContentType();
            string = transportRequest.getHeader(HttpConstants.HDR_SOAPACTION.toString());
            if (this.axisService != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "AxisService set on msg context.");
                }
                messageContext.setAxisService(this.axisService);
            }
            Thread.currentThread().setContextClassLoader(this.getClassLoader());
            inputStream = transportRequest.getInputStream();
            byArray = this.extractRequestBytesForTrace(transportRequest, inputStream);
            if (MessageTrace.isTraceEnabled()) {
                this.traceBytes(byArray, string2);
            }
        } else {
            Object[] objectArray = new Object[]{this.confContext};
            String string3 = NLSProvider.getNLS().getFormattedMessage("invokeMsgCxtFail", objectArray, "The {0} Configuration Context object could not be found.");
            throw new Exception(string3);
        }
        inputStream = new ByteArrayInputStream(byArray);
        HTTPTransportUtils.processHTTPPostRequest(messageContext, inputStream, transportResponse.getOutputStream(), string2, string, transportRequest.getRequestURI());
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpAsyncResponseContext.handleRequest()");
        }
    }

    private void traceBytes(byte[] byArray, String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "traceBytes");
        }
        if (byArray != null) {
            MessageTrace.log(MessageTrace.INBOUND_HTTP_RESPONSE, string, byArray);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "traceBytes");
        }
    }

    private byte[] extractRequestBytesForTrace(TransportRequest transportRequest, InputStream inputStream) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Start copying HTTP request to trace buffer");
        }
        byte[] byArray = null;
        String string = transportRequest.getHeader("Content-Length");
        if (string != null) {
            int n;
            block13: {
                n = 0;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!_tc.isDebugEnabled()) break block13;
                    Tr.debug(_tc, "Incoming request message to server could not be traced due to following error: " + numberFormatException.toString());
                }
            }
            byArray = new byte[n];
            int n2 = n;
            int n3 = 0;
            while (n2 > 0) {
                int n4 = inputStream.read(byArray, n3, n2);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Trace buffer needs " + n2 + " bytes at offset " + n3 + " got " + n4 + " bytes");
                }
                if (n4 < 0) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "End of stream with " + n2 + " bytes still " + "expected");
                    }
                    n2 = 0;
                    continue;
                }
                n2 -= n4;
                n3 += n4;
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Incoming message is using chunking");
            }
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            int n = 0;
            int n5 = 0;
            while (n5 >= 0) {
                byte[] byArray2 = new byte[1024];
                n5 = inputStream.read(byArray2, 0, 1024);
                if (n5 < 0) continue;
                arrayList.add(byArray2);
                arrayList2.add(new Integer(n5));
                n += n5;
            }
            byArray = new byte[n];
            int n6 = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                byte[] byArray3 = (byte[])arrayList.get(i);
                int n7 = (Integer)arrayList2.get(i);
                System.arraycopy(byArray3, 0, byArray, n6, n7);
                n6 += n7;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "Done copying HTTP request to trace buffer");
        }
        return byArray;
    }
}

