/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.trace.MessageTrace;
import com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.websvcs.utils.LowFlushFilter;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.ServletBasedOutTransportInfo;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.httpclient.NameValuePair;

public class HTTPTransportSender
extends AbstractHandler
implements TransportSender {
    protected String httpVersion = "HTTP/1.1";
    private boolean chunked = false;
    int soTimeout = 60000;
    int connectionTimeout = 60000;
    private static final TraceComponent _tc = Tr.register(HTTPTransportSender.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public void cleanup(MessageContext messageContext) throws AxisFault {
    }

    public void init(ConfigurationContext configurationContext, TransportOutDescription transportOutDescription) throws AxisFault {
        Parameter parameter;
        Parameter parameter2 = transportOutDescription.getParameter("PROTOCOL");
        if (parameter2 != null) {
            if ("HTTP/1.1".equals(parameter2.getValue())) {
                this.httpVersion = "HTTP/1.1";
                parameter = transportOutDescription.getParameter(HTTPConstants.HEADER_TRANSFER_ENCODING);
                if (parameter != null && HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED.equals(parameter.getValue())) {
                    this.chunked = true;
                }
            } else if ("HTTP/1.0".equals(parameter2.getValue())) {
                this.httpVersion = "HTTP/1.0";
            } else {
                Object[] objectArray = new Object[]{"PROTOCOL"};
                String string = NLSProvider.getNLS().getFormattedMessage("httpParameter00", objectArray, "The {0} parameter can have values of only HTTP/1.0 or HTTP/1.1");
                throw new AxisFault(string);
            }
        }
        try {
            parameter = transportOutDescription.getParameter("SO_TIMEOUT");
            Parameter parameter3 = transportOutDescription.getParameter("CONNECTION_TIMEOUT");
            if (parameter != null) {
                this.soTimeout = Integer.parseInt((String)parameter.getValue());
            }
            if (parameter3 != null) {
                this.connectionTimeout = Integer.parseInt((String)parameter3.getValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ws.websvcs.transport.http.HTTPTransportSender.init", "178", this);
        }
    }

    public void stop() {
    }

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "invoke msgContext : ", messageContext);
        }
        try {
            Object object;
            Externalizable externalizable;
            TransportOutDescription transportOutDescription;
            Object object2;
            OMOutputFormat oMOutputFormat = new OMOutputFormat();
            messageContext.setDoingMTOM(HTTPTransportUtils.doWriteMTOM(messageContext));
            messageContext.setDoingSwA(HTTPTransportUtils.doWriteSwA(messageContext));
            messageContext.setDoingREST(HTTPTransportUtils.isDoingREST(messageContext));
            oMOutputFormat.setSOAP11(messageContext.isSOAP11());
            oMOutputFormat.setDoOptimize(messageContext.isDoingMTOM());
            oMOutputFormat.setDoingSWA(messageContext.isDoingSwA());
            oMOutputFormat.setCharSetEncoding(HTTPTransportUtils.getCharSetEncoding(messageContext));
            if (messageContext.isDoingREST()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "This is a rest message.");
                }
                if ((object2 = (String)messageContext.getProperty("ContentType")) != null && ((String)object2).length() > 0) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Setting content type on the OMOutputFormat to: " + (String)object2);
                    }
                    oMOutputFormat.setContentType((String)object2);
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Processing rest message but could not find content type on MessageContext");
                }
            }
            if ((object2 = messageContext.getProperty("mimeBoundary")) != null) {
                oMOutputFormat.setMimeBoundary((String)object2);
            }
            if ((transportOutDescription = messageContext.getConfigurationContext().getAxisConfiguration().getTransportOut(new QName("http"))) != null) {
                externalizable = transportOutDescription.getParameter("OmitSOAP12Action");
                object = null;
                if (externalizable != null) {
                    object = ((Parameter)externalizable).getValue();
                }
                if (object != null && JavaUtils.isTrueExplicitly(object) && !messageContext.isSOAP11()) {
                    messageContext.setProperty("disableSoapAction", Boolean.TRUE);
                }
            }
            externalizable = null;
            if (messageContext.getTo() != null && !messageContext.getTo().hasAnonymousAddress()) {
                externalizable = messageContext.getTo();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "epr : " + ((EndpointReference)externalizable).toString());
                }
            } else {
                object = (String)messageContext.getProperty("TransportURL");
                if (object != null) {
                    externalizable = new EndpointReference((String)object);
                    messageContext.setTo((EndpointReference)externalizable);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "transportURL : ", object);
                    }
                }
            }
            if (externalizable != null) {
                if (!((EndpointReference)externalizable).getAddress().equals("http://www.w3.org/2005/08/addressing/none")) {
                    if (MessageTrace.isTraceEnabled()) {
                        this.traceResponse(messageContext, oMOutputFormat);
                    }
                    SOAPOverHTTPSender sOAPOverHTTPSender = new SOAPOverHTTPSender(messageContext);
                    sOAPOverHTTPSender.setFormat(oMOutputFormat);
                    sOAPOverHTTPSender.setSoapAction(HTTPTransportSender.findSOAPAction(messageContext));
                    sOAPOverHTTPSender.send(messageContext);
                }
            } else if (messageContext.getProperty("TRANSPORT_OUT") != null) {
                this.sendUsingOutputStream(messageContext, oMOutputFormat);
            } else {
                object = NLSProvider.getNLS().getFormattedMessage("nullTOTransportOut00", new Object[0], "Both the TransportOut and property MessageContext.TRANSPORT_OUT values are null.");
                throw new AxisFault((String)object);
            }
            TransportUtils.setResponseWritten(messageContext, true);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.HTTPTransportSender.invoke", "315", this);
            throw new AxisFault(exception);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "invoke");
            }
            TransportUtils.deleteAttachments(messageContext);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void sendUsingOutputStream(MessageContext messageContext, OMOutputFormat oMOutputFormat) throws AxisFault, XMLStreamException, IOException {
        Object object2;
        OutputStream outputStream;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "sendUsingOutputStream");
        }
        if ((outputStream = (OutputStream)messageContext.getProperty("TRANSPORT_OUT")) != null && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "outputStream : " + outputStream.toString());
        }
        OutTransportInfo outTransportInfo = (OutTransportInfo)messageContext.getProperty("OutTransportInfo");
        ServletBasedOutTransportInfo servletBasedOutTransportInfo = null;
        if (outTransportInfo != null && outTransportInfo instanceof ServletBasedOutTransportInfo) {
            servletBasedOutTransportInfo = (ServletBasedOutTransportInfo)outTransportInfo;
            List list = (List)messageContext.getProperty("HTTP_HEADERS");
            if (list != null) {
                for (Object object2 : list) {
                    if (object2 == null) continue;
                    servletBasedOutTransportInfo.addHeader(((NameValuePair)object2).getName(), ((NameValuePair)object2).getValue());
                }
            }
        }
        boolean bl = this.isDoingCompression(messageContext);
        oMOutputFormat.setAutoCloseWriter(true);
        MessageFormatter messageFormatter = TransportUtils.getMessageFormatter(messageContext);
        if (messageFormatter == null) {
            object2 = NLSProvider.getNLS().getFormattedMessage("xxxxxx", new Object[0], "Response could not be written to output stream because a message formatter could not be found.");
            throw new AxisFault((String)object2);
        }
        if (outTransportInfo != null) {
            outTransportInfo.setContentType(messageFormatter.getContentType(messageContext, oMOutputFormat, HTTPTransportSender.findSOAPAction(messageContext)));
        }
        if (MessageTrace.isTraceEnabled()) {
            this.traceResponse(messageContext, oMOutputFormat);
        }
        object2 = new LowFlushFilter(outputStream);
        messageFormatter.writeTo(messageContext, oMOutputFormat, (OutputStream)object2, false);
        try {
            OMXMLParserWrapper oMXMLParserWrapper;
            SOAPEnvelope sOAPEnvelope = messageContext.getEnvelope();
            if (sOAPEnvelope != null && (oMXMLParserWrapper = sOAPEnvelope.getBuilder()) != null) {
                oMXMLParserWrapper.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "sendUsingOutputStream");
        }
    }

    private boolean isDoingCompression(MessageContext messageContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "checkForCompression");
        }
        if (messageContext.getAxisOperation() == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "No HTTP Policy Set. Returning.");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "checkForCompression");
            }
            return false;
        }
        PolicySetConfiguration policySetConfiguration = (PolicySetConfiguration)Axis2Utils.getPolicySet(messageContext.getAxisOperation());
        Properties properties = (Properties)policySetConfiguration.getPolicyTypeConfiguration("HTTP_POLICY");
        if (properties == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "No HTTP Policy Set. Returning.");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "checkForCompression");
            }
            return false;
        }
        String string = properties.getProperty("compressResponse:name");
        if (string == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Compression was null. Returning.");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "checkForCompression");
            }
            return false;
        }
        if (!(messageContext.getProperty("OutTransportInfo") instanceof ServletBasedOutTransportInfo)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "TransportInfo not servlet based. Returning.");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "checkForCompression");
            }
            return false;
        }
        boolean bl = false;
        ServletBasedOutTransportInfo servletBasedOutTransportInfo = (ServletBasedOutTransportInfo)messageContext.getProperty("OutTransportInfo");
        String string2 = com.ibm.ws.webservices.engine.transport.http.HTTPConstants.HEADER_CF_WSZIP;
        String string3 = com.ibm.ws.webservices.engine.transport.http.HTTPConstants.HEADER_C_ENC_GZIP;
        String string4 = com.ibm.ws.webservices.engine.transport.http.HTTPConstants.HEADER_C_ENC_XGZIP;
        String string5 = com.ibm.ws.webservices.engine.transport.http.HTTPConstants.HEADER_C_ENC_DEFLATE;
        if (string3.equalsIgnoreCase(string)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "GZIP compression used.");
            }
            servletBasedOutTransportInfo.addHeader(string2, string3);
            bl = true;
        } else if (string4.equalsIgnoreCase(string)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "X-GZIP compression used.");
            }
            servletBasedOutTransportInfo.addHeader(string2, string4);
            bl = true;
        } else if (string5.equalsIgnoreCase(string)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Deflate compression used.");
            }
            servletBasedOutTransportInfo.addHeader(string2, string5);
            bl = true;
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "No compression.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "checkForCompression");
        }
        return bl;
    }

    private static String findSOAPAction(MessageContext messageContext) {
        String string = null;
        Object object = messageContext.getOptions().getProperty("disableSoapAction");
        if (!(JavaUtils.isTrueExplicitly(object) || (string = messageContext.getSoapAction()) != null && string.length() != 0)) {
            string = messageContext.getWSAAction();
            if (messageContext.getAxisOperation() != null && (string == null || string.length() == 0)) {
                string = messageContext.getAxisOperation().getInputAction();
            }
        }
        if (string == null) {
            string = "\"\"";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceResponse(MessageContext messageContext, OMOutputFormat oMOutputFormat) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "traceResponse");
        }
        try {
            String string;
            SOAPEnvelope sOAPEnvelope = messageContext.getEnvelope();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sOAPEnvelope.serialize(byteArrayOutputStream, oMOutputFormat);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            String string2 = string = messageContext.getAxisOperation() != null ? messageContext.getAxisOperation().getMessageExchangePattern() : null;
            if ("http://www.w3.org/2006/01/wsdl/out-in".equals(string) || "http://www.w3.org/2004/08/wsdl/out-in".equals(string) || "http://www.w3.org/2006/01/wsdl/out-only".equals(string) || "http://www.w3.org/2004/08/wsdl/out-only".equals(string)) {
                MessageTrace.log(MessageTrace.OUTBOUND_HTTP_REQUEST, oMOutputFormat.getContentType(), byArray);
            } else {
                MessageTrace.log(MessageTrace.OUTBOUND_HTTP_RESPONSE, oMOutputFormat.getContentType(), byArray);
            }
        }
        catch (Throwable throwable) {
            Tr.debug(_tc, "Response message could not be traced because of the following error: " + throwable.toString());
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "traceResponse");
            }
        }
    }
}

