/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.channel.WSAddress;
import com.ibm.ws.websvcs.transport.common.JavaUtils;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import org.apache.axis2.AxisFault;

public class HTTPConnection {
    private static final TraceComponent _tc = Tr.register(HTTPConnection.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    protected String chainname = null;
    protected OutboundVirtualConnection oConn = null;
    protected HttpOutboundServiceContext httpOutSC = null;
    private WSAddress addrToConnect = null;
    protected long lastAccessTime = 0L;
    protected boolean usedAlready = false;
    protected boolean toBeClosed = false;
    private long createTime = System.currentTimeMillis();

    public long lifetime() {
        return System.currentTimeMillis() - this.createTime;
    }

    public void updateConnectionCfg(Object object, Object object2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateConnectionCfg()");
        }
        if (this.oConn != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "updateOCCObject " + String.valueOf(object));
            }
            this.oConn.getStateMap().put(object, object2);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "channelframework01 null OutboundVirtualConnection.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateConnectionCfg()");
        }
    }

    public void updateEndpoint(WSAddress wSAddress) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateEndpoint()");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "updateEndpoint00 " + this.addrToConnect.toString() + wSAddress.toString());
        }
        this.addrToConnect = wSAddress;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateEndpoint()");
        }
    }

    public boolean hasbeenUsed() {
        return this.usedAlready;
    }

    public void setUsedAlready() {
        if (!this.usedAlready) {
            this.usedAlready = true;
        }
    }

    public void connect() throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "connect() of: " + this);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "connectingAddr " + String.valueOf(this.addrToConnect));
        }
        try {
            if (!this.toBeClosed && this.httpOutSC == null) {
                this.oConn.connect(this.addrToConnect);
                this.httpOutSC = (HttpOutboundServiceContext)this.oConn.getChannelAccessor();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "newConnection " + String.valueOf(this.oConn));
                }
            } else if (!this.toBeClosed && this.httpOutSC != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "connectedAddr " + String.valueOf(this.addrToConnect));
                    Tr.debug(_tc, "reuseConnection " + String.valueOf(this.oConn));
                }
            } else {
                Object[] objectArray = new Object[]{String.valueOf(this.oConn)};
                String string = NLSProvider.getNLS().getFormattedMessage("closedOCobject00", objectArray, "A connection is attempted with an outbound connection object that is already marked to be closed: {0}");
                throw new AxisFault(string);
            }
            this.lastAccessTime = System.currentTimeMillis();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.websvcs.transport.http.HTTPConnection.connect", "213", this);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(exception));
            }
            throw exception;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "connect() of: " + this);
        }
    }

    public void disconnect(Exception exception) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "disconnect() of: " + this);
        }
        if (!this.toBeClosed) {
            this.markToBeClosed();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "disconnectAddr " + String.valueOf(this.addrToConnect) + this.toString());
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "disconnectedAddr " + String.valueOf(this.addrToConnect) + this.toString());
        }
        if (exception != null) {
            this.release(exception);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "disconnect() of: " + this);
        }
        this.lastAccessTime = System.currentTimeMillis();
    }

    public void reset() {
        boolean bl;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "reset() of: " + this);
        }
        boolean bl2 = bl = this.httpOutSC == null ? false : this.httpOutSC.isPersistent();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "resetConnection " + String.valueOf(this.addrToConnect) + String.valueOf(bl));
        }
        if (!this.toBeClosed) {
            if (bl) {
                this.httpOutSC.clear();
                this.lastAccessTime = System.currentTimeMillis();
            } else {
                this.disconnect(null);
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "disconnectedAddr " + String.valueOf(this.addrToConnect) + this.toString());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "reset() of: " + this);
        }
    }

    public boolean isClosed() {
        return this.toBeClosed;
    }

    public long timeFromLastAccess() {
        return System.currentTimeMillis() - this.lastAccessTime;
    }

    public synchronized void markToBeClosed() {
        this.toBeClosed = true;
    }

    public synchronized void release(Exception exception) {
        boolean bl;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "release() of: " + this);
        }
        if (exception != null && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "releaseOCobjectEx " + String.valueOf(exception) + String.valueOf(this.oConn) + String.valueOf(this.httpOutSC));
        }
        boolean bl2 = bl = this.httpOutSC != null;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "connAlreadyEst " + bl);
        }
        if (bl) {
            this.httpOutSC.clear();
            this.httpOutSC = null;
        }
        if (this.oConn != null) {
            if (bl) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Closing connection ");
                }
                this.oConn.close(exception);
            }
            this.oConn = null;
        }
        this.lastAccessTime = 0L;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "release() of: " + this);
        }
    }

    public void setLastAccessTime() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public OutboundVirtualConnection getConnection() {
        return this.oConn;
    }

    public WSAddress getTargetAddress() {
        return this.addrToConnect;
    }

    public HTTPConnection(OutboundVirtualConnection outboundVirtualConnection, WSAddress wSAddress, String string) {
        this.addrToConnect = wSAddress;
        this.oConn = outboundVirtualConnection;
        this.lastAccessTime = System.currentTimeMillis();
        this.chainname = string;
    }
}

